/*
 * Decompiled with CFR 0.152.
 */
package android.opengl.alt;

import android.content.Context;
import android.opengl.GLDebugHelper;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import java.io.Writer;
import java.util.ArrayList;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;
import javax.microedition.khronos.opengles.GL;
import javax.microedition.khronos.opengles.GL10;
import net.daum.android.map.MapBuildSettings;
import net.daum.mf.map.common.MapThreadScheduling;
import net.daum.mf.map.common.MapThreadSettings;
import net.daum.mf.map.n.api.NativeThread;

public class GLSurfaceView
extends SurfaceView
implements SurfaceHolder.Callback {
    private static final boolean LOG_THREADS = false;
    public static final int RENDERMODE_WHEN_DIRTY = 0;
    public static final int RENDERMODE_CONTINUOUSLY = 1;
    public static final int DEBUG_CHECK_GL_ERROR = 1;
    public static final int DEBUG_LOG_GL_CALLS = 2;
    private static final GLThreadManager sGLThreadManager = new GLThreadManager();
    private boolean mSizeChanged = true;
    private GLThread mGLThread;
    private EGLConfigChooser mEGLConfigChooser;
    private EGLContextFactory mEGLContextFactory;
    private EGLWindowSurfaceFactory mEGLWindowSurfaceFactory;
    private GLWrapper mGLWrapper;
    private int mDebugFlags;

    public GLSurfaceView(Context context) {
        super(context);
        this.init();
    }

    public GLSurfaceView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public GLSurfaceView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    private void init() {
        SurfaceHolder holder = this.getHolder();
        holder.addCallback((SurfaceHolder.Callback)this);
    }

    public void setGLWrapper(GLWrapper glWrapper) {
        this.mGLWrapper = glWrapper;
    }

    public void setDebugFlags(int debugFlags) {
        this.mDebugFlags = debugFlags;
    }

    public int getDebugFlags() {
        return this.mDebugFlags;
    }

    public void setRenderer(Renderer renderer) {
        this.checkRenderThreadState();
        if (this.mEGLWindowSurfaceFactory == null) {
            this.mEGLWindowSurfaceFactory = new DefaultWindowSurfaceFactory();
        }
        if (this.mEGLConfigChooser == null) {
            this.mEGLConfigChooser = new DaumMapsEGLConfigChooser(true, this.mEGLWindowSurfaceFactory, this.getHolder());
        }
        if (this.mEGLContextFactory == null) {
            this.mEGLContextFactory = new DefaultContextFactory();
        }
        this.mGLThread = new GLThread(renderer);
        this.mGLThread.start();
    }

    public void setEGLContextFactory(EGLContextFactory factory) {
        this.checkRenderThreadState();
        this.mEGLContextFactory = factory;
    }

    public void setEGLWindowSurfaceFactory(EGLWindowSurfaceFactory factory) {
        this.checkRenderThreadState();
        this.mEGLWindowSurfaceFactory = factory;
    }

    public void setEGLConfigChooser(EGLConfigChooser configChooser) {
        this.checkRenderThreadState();
        this.mEGLConfigChooser = configChooser;
    }

    public void setEGLConfigChooser(boolean needDepth) {
        this.setEGLConfigChooser(new DaumMapsEGLConfigChooser(needDepth, this.mEGLWindowSurfaceFactory, this.getHolder()));
    }

    public void setEGLConfigChooser(int redSize, int greenSize, int blueSize, int alphaSize, int depthSize, int stencilSize) {
        if (Build.VERSION.SDK_INT < 16) {
            this.setEGLConfigChooser(new ComponentSizeChooser(5, 6, 5, 0, 16, 8));
        } else {
            this.setEGLConfigChooser(new ComponentSizeChooser(8, 8, 8, 8, 16, 8));
        }
    }

    public void setRenderMode(int renderMode) {
        this.mGLThread.setRenderMode(renderMode);
    }

    public int getRenderMode() {
        return this.mGLThread.getRenderMode();
    }

    public void requestRender() {
        this.mGLThread.requestRender();
    }

    public void surfaceCreated(SurfaceHolder holder) {
        this.mGLThread.surfaceCreated();
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        this.mGLThread.surfaceDestroyed();
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int w, int h) {
        this.mGLThread.onWindowResize(w, h);
    }

    public void onPause() {
        this.mGLThread.onPause();
    }

    public void onResume() {
        this.mGLThread.onResume();
    }

    public void queueEvent(Runnable r) {
        this.mGLThread.queueEvent(r);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mGLThread.requestExitAndWait();
    }

    private void checkRenderThreadState() {
        if (this.mGLThread != null) {
            throw new IllegalStateException("setRenderer has already been called for this instance.");
        }
    }

    private static class GLThreadManager {
        private GLThread mEglOwner;

        private GLThreadManager() {
        }

        public synchronized void threadExiting(GLThread thread) {
            thread.mDone = true;
            if (this.mEglOwner == thread) {
                this.mEglOwner = null;
            }
            this.notifyAll();
        }

        public synchronized boolean tryAcquireEglSurface(GLThread thread) {
            if (this.mEglOwner == thread || this.mEglOwner == null) {
                this.mEglOwner = thread;
                this.notifyAll();
                return true;
            }
            return false;
        }

        public synchronized void releaseEglSurface(GLThread thread) {
            if (this.mEglOwner == thread) {
                this.mEglOwner = null;
            }
            this.notifyAll();
        }
    }

    static class LogWriter
    extends Writer {
        private StringBuilder mBuilder = new StringBuilder();

        LogWriter() {
        }

        @Override
        public void close() {
            this.flushBuilder();
        }

        @Override
        public void flush() {
            this.flushBuilder();
        }

        @Override
        public void write(char[] buf, int offset, int count) {
            for (int i = 0; i < count; ++i) {
                char c = buf[offset + i];
                if (c == '\n') {
                    this.flushBuilder();
                    continue;
                }
                this.mBuilder.append(c);
            }
        }

        private void flushBuilder() {
            if (this.mBuilder.length() > 0) {
                if (!MapBuildSettings.getInstance().isDistribution()) {
                    Log.d((String)GLSurfaceView.class.getName(), (String)this.mBuilder.toString());
                }
                this.mBuilder.delete(0, this.mBuilder.length());
            }
        }
    }

    class GLThread
    extends NativeThread {
        public boolean isSurfaceInited;
        private boolean mDone = false;
        private boolean mPaused;
        private boolean mHasSurface;
        private boolean mWaitingForSurface;
        private boolean mHaveEgl;
        private int mWidth = 0;
        private int mHeight = 0;
        private int mRenderMode = 1;
        private boolean mRequestRender = true;
        private boolean mEventsWaiting;
        private Renderer mRenderer;
        private ArrayList<Runnable> mEventQueue = new ArrayList();
        private EglHelper mEglHelper;

        GLThread(Renderer renderer) {
            this.mRenderer = renderer;
            this.isSurfaceInited = false;
        }

        @Override
        protected void nativeRun() {
            this.setName("GLThread " + this.getId());
            Thread.currentThread().setPriority(MapThreadSettings.getGlPriority());
            try {
                this.guardedRun();
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                sGLThreadManager.threadExiting(this);
            }
        }

        private void stopEglLocked() {
            if (this.mHaveEgl) {
                this.mHaveEgl = false;
                this.mEglHelper.destroySurface();
                this.mEglHelper.finish();
                sGLThreadManager.releaseEglSurface(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void guardedRun() throws InterruptedException {
            this.mEglHelper = new EglHelper();
            EglHelperWrapper eglHelperWrapper = Build.VERSION.SDK_INT > 4 ? new EglHelperWrapperEclair(this.mEglHelper) : new EglHelperWrapperDonut(this.mEglHelper);
            GL10 gl = null;
            try {
                boolean tellRendererSurfaceCreated = true;
                boolean tellRendererSurfaceChanged = true;
                boolean tellRendererToResumeEngine = false;
                while (!this.isDone()) {
                    boolean hasSurface;
                    int w = 0;
                    int h = 0;
                    boolean changed = false;
                    boolean needStart = false;
                    boolean eventsWaiting = false;
                    boolean bl = hasSurface = this.mEglHelper.mEglSurface != null;
                    if (hasSurface) {
                        Runnable r;
                        while ((r = this.getEvent()) != null) {
                            r.run();
                        }
                    }
                    GLThreadManager gLThreadManager = sGLThreadManager;
                    synchronized (gLThreadManager) {
                        while (true) {
                            boolean onBeforeFinishedCalled;
                            if (this.mPaused) {
                                onBeforeFinishedCalled = false;
                                if (this.mHaveEgl || this.mHasSurface) {
                                    this.mRenderer.onBeforeFinished(gl);
                                    onBeforeFinishedCalled = true;
                                    tellRendererToResumeEngine = true;
                                    GLSurfaceView.this.mSizeChanged = true;
                                }
                                this.stopEglLocked();
                                if (onBeforeFinishedCalled) {
                                    this.mRenderer.onAfterFinished(gl);
                                }
                            }
                            if (!GLSurfaceView.this.mSizeChanged && this.mHasSurface && this.isSurfaceInited && MapThreadScheduling.needToWait() && !this.mEventsWaiting) {
                                while (MapThreadScheduling.isWaiting()) {
                                    Thread.sleep(6L);
                                }
                            } else {
                                Thread.sleep(2L);
                            }
                            if (!this.mHasSurface) {
                                if (!this.mWaitingForSurface) {
                                    onBeforeFinishedCalled = false;
                                    if (this.mHaveEgl || this.mHasSurface) {
                                        this.mRenderer.onBeforeFinished(gl);
                                        onBeforeFinishedCalled = true;
                                        tellRendererToResumeEngine = true;
                                    }
                                    this.stopEglLocked();
                                    if (onBeforeFinishedCalled) {
                                        this.mRenderer.onAfterFinished(gl);
                                    }
                                    this.mWaitingForSurface = true;
                                    sGLThreadManager.notifyAll();
                                }
                            } else if (!this.mHaveEgl && sGLThreadManager.tryAcquireEglSurface(this)) {
                                this.mHaveEgl = true;
                                this.mEglHelper.start();
                                this.mRequestRender = true;
                                needStart = true;
                            }
                            if (this.mDone) {
                                return;
                            }
                            if (this.mEventsWaiting) {
                                eventsWaiting = true;
                                this.mEventsWaiting = false;
                                break;
                            }
                            if (!this.mPaused && this.mHasSurface && this.mHaveEgl && this.mWidth > 0 && this.mHeight > 0 && (this.mRequestRender || this.mRenderMode == 1)) {
                                changed = GLSurfaceView.this.mSizeChanged;
                                w = this.mWidth;
                                h = this.mHeight;
                                GLSurfaceView.this.mSizeChanged = false;
                                this.mRequestRender = false;
                                if (!this.mHasSurface || !this.mWaitingForSurface) break;
                                changed = true;
                                this.mWaitingForSurface = false;
                                sGLThreadManager.notifyAll();
                                break;
                            }
                            sGLThreadManager.wait(10L);
                            this.mRenderer.onLoopWhenPaused(gl);
                        }
                        if (eventsWaiting) continue;
                    }
                    if (needStart) {
                        tellRendererSurfaceCreated = true;
                        changed = true;
                    }
                    if (changed) {
                        gl = eglHelperWrapper.createSurface(gl, GLSurfaceView.this.getHolder());
                        if (tellRendererToResumeEngine) {
                            tellRendererSurfaceCreated = true;
                        }
                        tellRendererSurfaceChanged = true;
                        this.isSurfaceInited = true;
                    }
                    if (tellRendererSurfaceCreated) {
                        this.mRenderer.onSurfaceCreated(gl, this.mEglHelper.mEglConfig);
                        tellRendererSurfaceCreated = false;
                        tellRendererToResumeEngine = false;
                    }
                    if (tellRendererSurfaceChanged) {
                        this.mRenderer.onSurfaceChanged(gl, w, h);
                        tellRendererSurfaceChanged = false;
                    }
                    if (w <= 0 || h <= 0) continue;
                    this.mRenderer.onDrawFrame(gl);
                    if (!this.mRenderer.needsSwap(gl)) continue;
                    eglHelperWrapper.beforeSwap(gl);
                    this.mEglHelper.swap();
                    this.mRenderer.didSwap(gl);
                }
                return;
            }
            finally {
                GLThreadManager gLThreadManager = sGLThreadManager;
                synchronized (gLThreadManager) {
                    this.mRenderer.onBeforeFinished(gl);
                    this.stopEglLocked();
                    this.mRenderer.onAfterFinished(gl);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isDone() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                return this.mDone;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setRenderMode(int renderMode) {
            if (0 > renderMode || renderMode > 1) {
                throw new IllegalArgumentException("renderMode");
            }
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mRenderMode = renderMode;
                if (renderMode == 1) {
                    sGLThreadManager.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getRenderMode() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                return this.mRenderMode;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requestRender() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mRequestRender = true;
                sGLThreadManager.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void surfaceCreated() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mHasSurface = true;
                sGLThreadManager.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void surfaceDestroyed() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mHasSurface = false;
                sGLThreadManager.notifyAll();
                while (!this.mWaitingForSurface && this.isAlive() && !this.mDone) {
                    try {
                        sGLThreadManager.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onPause() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mPaused = true;
                sGLThreadManager.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onResume() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mPaused = false;
                this.mRequestRender = true;
                sGLThreadManager.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onWindowResize(int w, int h) {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mWidth = w;
                this.mHeight = h;
                GLSurfaceView.this.mSizeChanged = true;
                sGLThreadManager.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requestExitAndWait() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mDone = true;
                sGLThreadManager.notifyAll();
            }
            try {
                this.join();
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void queueEvent(Runnable r) {
            GLThread gLThread = this;
            synchronized (gLThread) {
                this.mEventQueue.add(r);
                GLThreadManager gLThreadManager = sGLThreadManager;
                synchronized (gLThreadManager) {
                    this.mEventsWaiting = true;
                    sGLThreadManager.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Runnable getEvent() {
            GLThread gLThread = this;
            synchronized (gLThread) {
                if (this.mEventQueue.size() > 0) {
                    return this.mEventQueue.remove(0);
                }
            }
            return null;
        }
    }

    private class EglHelperWrapperEclair
    implements EglHelperWrapper {
        private EglHelper _eglHelper = null;

        public EglHelperWrapperEclair(EglHelper eglHelper) {
            this._eglHelper = eglHelper;
        }

        @Override
        public GL10 createSurface(GL10 gl, SurfaceHolder holder) {
            if (this._eglHelper.mEglSurface == null) {
                return (GL10)this._eglHelper.createSurface(GLSurfaceView.this.getHolder());
            }
            return gl;
        }

        @Override
        public void beforeSwap(GL10 gl) {
        }
    }

    private class EglHelperWrapperDonut
    implements EglHelperWrapper {
        private EglHelper _eglHelper = null;

        public EglHelperWrapperDonut(EglHelper eglHelper) {
            this._eglHelper = eglHelper;
        }

        @Override
        public GL10 createSurface(GL10 gl, SurfaceHolder holder) {
            return (GL10)this._eglHelper.createSurface(GLSurfaceView.this.getHolder());
        }

        @Override
        public void beforeSwap(GL10 gl) {
            gl.glFinish();
        }
    }

    static interface EglHelperWrapper {
        public GL10 createSurface(GL10 var1, SurfaceHolder var2);

        public void beforeSwap(GL10 var1);
    }

    private class EglHelper {
        EGL10 mEgl;
        EGLDisplay mEglDisplay;
        EGLSurface mEglSurface;
        EGLConfig mEglConfig;
        EGLContext mEglContext;

        public void start() {
            this.mEgl = (EGL10)EGLContext.getEGL();
            this.mEglDisplay = this.mEgl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
            int[] version = new int[2];
            this.mEgl.eglInitialize(this.mEglDisplay, version);
            this.mEglConfig = GLSurfaceView.this.mEGLConfigChooser.chooseConfig(this.mEgl, this.mEglDisplay);
            this.mEglContext = GLSurfaceView.this.mEGLContextFactory.createContext(this.mEgl, this.mEglDisplay, this.mEglConfig);
            if (this.mEglContext == null || this.mEglContext == EGL10.EGL_NO_CONTEXT) {
                throw new RuntimeException("createContext failed");
            }
            this.mEglSurface = null;
        }

        public GL createSurface(SurfaceHolder holder) {
            if (this.mEglSurface != null && this.mEglSurface != EGL10.EGL_NO_SURFACE) {
                this.mEgl.eglMakeCurrent(this.mEglDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
                GLSurfaceView.this.mEGLWindowSurfaceFactory.destroySurface(this.mEgl, this.mEglDisplay, this.mEglSurface);
            }
            this.mEglSurface = GLSurfaceView.this.mEGLWindowSurfaceFactory.createWindowSurface(this.mEgl, this.mEglDisplay, this.mEglConfig, holder);
            if (this.mEglSurface == null || this.mEglSurface == EGL10.EGL_NO_SURFACE) {
                throw new RuntimeException("createWindowSurface failed");
            }
            if (!this.mEgl.eglMakeCurrent(this.mEglDisplay, this.mEglSurface, this.mEglSurface, this.mEglContext)) {
                throw new RuntimeException("eglMakeCurrent failed.");
            }
            GL gl = this.mEglContext.getGL();
            if (GLSurfaceView.this.mGLWrapper != null) {
                gl = GLSurfaceView.this.mGLWrapper.wrap(gl);
            }
            if ((GLSurfaceView.this.mDebugFlags & 3) != 0) {
                int configFlags = 0;
                LogWriter log = null;
                if ((GLSurfaceView.this.mDebugFlags & 1) != 0) {
                    // empty if block
                }
                if ((GLSurfaceView.this.mDebugFlags & 2) != 0) {
                    log = new LogWriter();
                }
                gl = GLDebugHelper.wrap((GL)gl, (int)configFlags, (Writer)log);
            }
            return gl;
        }

        public boolean swap() {
            this.mEgl.eglSwapBuffers(this.mEglDisplay, this.mEglSurface);
            return this.mEgl.eglGetError() != 12302;
        }

        public void destroySurface() {
            if (this.mEglSurface != null && this.mEglSurface != EGL10.EGL_NO_SURFACE) {
                this.mEgl.eglMakeCurrent(this.mEglDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
                GLSurfaceView.this.mEGLWindowSurfaceFactory.destroySurface(this.mEgl, this.mEglDisplay, this.mEglSurface);
                this.mEglSurface = null;
            }
        }

        public void finish() {
            if (this.mEglContext != null) {
                GLSurfaceView.this.mEGLContextFactory.destroyContext(this.mEgl, this.mEglDisplay, this.mEglContext);
                this.mEglContext = null;
            }
            if (this.mEglDisplay != null) {
                this.mEgl.eglTerminate(this.mEglDisplay);
                this.mEglDisplay = null;
            }
        }
    }

    private static class DaumMapsEGLConfigChooser
    extends SimpleEGLConfigChooser {
        private int[] mValue2 = new int[1];
        private EGLWindowSurfaceFactory _windowSurfaceFactory;
        private SurfaceHolder _holder;

        public DaumMapsEGLConfigChooser(boolean withDepthBuffer, EGLWindowSurfaceFactory windowSurfaceFactory, SurfaceHolder holder) {
            super(withDepthBuffer);
            this._windowSurfaceFactory = windowSurfaceFactory;
            this._holder = holder;
        }

        @Override
        public EGLConfig chooseConfig(EGL10 egl, EGLDisplay display, EGLConfig[] configs) {
            EGLConfig closestConfig = null;
            EGLConfig lastClosestConfig = null;
            int closestDistance = 1000;
            for (EGLConfig config : configs) {
                int d = this.findConfigAttrib(egl, display, config, 12325, 0);
                int s = this.findConfigAttrib(egl, display, config, 12326, 0);
                int r = this.findConfigAttrib(egl, display, config, 12324, 0);
                int g = this.findConfigAttrib(egl, display, config, 12323, 0);
                int b = this.findConfigAttrib(egl, display, config, 12322, 0);
                int a = this.findConfigAttrib(egl, display, config, 12321, 0);
                int distance = Math.abs(r - this.mRedSize) + Math.abs(g - this.mGreenSize) + Math.abs(b - this.mBlueSize) + Math.abs(a - this.mAlphaSize) + Math.abs(d - this.mDepthSize) + Math.abs(s - this.mStencilSize);
                if (distance >= closestDistance) continue;
                boolean configSucceeded = this.testConfiguration(egl, display, config);
                if (configSucceeded) {
                    closestDistance = distance;
                    closestConfig = config;
                    continue;
                }
                lastClosestConfig = config;
            }
            if (closestConfig == null) {
                closestConfig = lastClosestConfig;
            }
            return closestConfig;
        }

        private int findConfigAttrib(EGL10 egl, EGLDisplay display, EGLConfig config, int attribute, int defaultValue) {
            if (egl.eglGetConfigAttrib(display, config, attribute, this.mValue2)) {
                return this.mValue2[0];
            }
            return defaultValue;
        }

        private boolean testConfiguration(EGL10 egl, EGLDisplay display, EGLConfig config) {
            EGLSurface eglSurface = null;
            if (!MapBuildSettings.getInstance().isDistribution()) {
                Log.d((String)GLSurfaceView.class.getName(), (String)("Test Creating Surface " + eglSurface));
            }
            try {
                eglSurface = this._windowSurfaceFactory.createWindowSurface(egl, display, config, this._holder);
            }
            catch (IllegalArgumentException e) {
                if (!MapBuildSettings.getInstance().isDistribution()) {
                    Log.d((String)GLSurfaceView.class.getName(), (String)("IllegalArgumentException Creating Surface " + eglSurface));
                }
                eglSurface = null;
            }
            if (eglSurface == null || eglSurface == EGL10.EGL_NO_SURFACE) {
                return false;
            }
            if (!MapBuildSettings.getInstance().isDistribution()) {
                Log.d((String)GLSurfaceView.class.getName(), (String)("Destroying Surface " + eglSurface));
            }
            this._windowSurfaceFactory.destroySurface(egl, display, eglSurface);
            return true;
        }
    }

    private static class SimpleEGLConfigChooser
    extends ComponentSizeChooser {
        public SimpleEGLConfigChooser(boolean withDepthBuffer) {
            super(4, 4, 4, 0, withDepthBuffer ? 16 : 0, 8);
            this.mRedSize = 5;
            this.mGreenSize = 6;
            this.mBlueSize = 5;
        }
    }

    private static class ComponentSizeChooser
    extends BaseConfigChooser {
        private int[] mValue = new int[1];
        protected int mRedSize;
        protected int mGreenSize;
        protected int mBlueSize;
        protected int mAlphaSize;
        protected int mDepthSize;
        protected int mStencilSize;

        public ComponentSizeChooser(int redSize, int greenSize, int blueSize, int alphaSize, int depthSize, int stencilSize) {
            super(new int[]{12324, redSize, 12323, greenSize, 12322, blueSize, 12321, alphaSize, 12325, depthSize, 12326, stencilSize, 12344});
            this.mRedSize = redSize;
            this.mGreenSize = greenSize;
            this.mBlueSize = blueSize;
            this.mAlphaSize = alphaSize;
            this.mDepthSize = depthSize;
            this.mStencilSize = stencilSize;
        }

        @Override
        public EGLConfig chooseConfig(EGL10 egl, EGLDisplay display) {
            EGLConfig[] configs;
            int[] num_config = new int[1];
            if (!egl.eglChooseConfig(display, this.mConfigSpec, null, 0, num_config)) {
                throw new IllegalArgumentException("eglChooseConfig failed");
            }
            int numConfigs = num_config[0];
            if (numConfigs <= 0) {
                this.mStencilSize = 0;
                if (!egl.eglChooseConfig(display, this.mConfigSpec, null, 0, num_config)) {
                    throw new IllegalArgumentException("eglChooseConfig failed");
                }
                numConfigs = num_config[0];
                if (numConfigs <= 0) {
                    throw new IllegalArgumentException("No configs match configSpec");
                }
            }
            if (!egl.eglChooseConfig(display, this.mConfigSpec, configs = new EGLConfig[numConfigs], numConfigs, num_config)) {
                throw new IllegalArgumentException("eglChooseConfig#2 failed");
            }
            EGLConfig config = this.chooseConfig(egl, display, configs);
            if (config == null) {
                throw new IllegalArgumentException("No config chosen");
            }
            return config;
        }

        @Override
        public EGLConfig chooseConfig(EGL10 egl, EGLDisplay display, EGLConfig[] configs) {
            EGLConfig closestConfig = null;
            int closestDistance = 1000;
            for (EGLConfig config : configs) {
                int d = this.findConfigAttrib(egl, display, config, 12325, 0);
                int s = this.findConfigAttrib(egl, display, config, 12326, 0);
                if (d < this.mDepthSize || s < this.mStencilSize) continue;
                int r = this.findConfigAttrib(egl, display, config, 12324, 0);
                int g = this.findConfigAttrib(egl, display, config, 12323, 0);
                int b = this.findConfigAttrib(egl, display, config, 12322, 0);
                int a = this.findConfigAttrib(egl, display, config, 12321, 0);
                int distance = Math.abs(r - this.mRedSize) + Math.abs(g - this.mGreenSize) + Math.abs(b - this.mBlueSize) + Math.abs(a - this.mAlphaSize);
                if (distance >= closestDistance) continue;
                closestDistance = distance;
                closestConfig = config;
            }
            return closestConfig;
        }

        private int findConfigAttrib(EGL10 egl, EGLDisplay display, EGLConfig config, int attribute, int defaultValue) {
            if (egl.eglGetConfigAttrib(display, config, attribute, this.mValue)) {
                return this.mValue[0];
            }
            return defaultValue;
        }
    }

    private static abstract class BaseConfigChooser
    implements EGLConfigChooser {
        protected int[] mConfigSpec;

        public BaseConfigChooser(int[] configSpec) {
            this.mConfigSpec = configSpec;
        }

        @Override
        public EGLConfig chooseConfig(EGL10 egl, EGLDisplay display) {
            int[] num_config = new int[1];
            egl.eglChooseConfig(display, this.mConfigSpec, null, 0, num_config);
            int numConfigs = num_config[0];
            if (numConfigs <= 0) {
                this.mConfigSpec[11] = 0;
                egl.eglChooseConfig(display, this.mConfigSpec, null, 0, num_config);
                numConfigs = num_config[0];
                if (numConfigs <= 0) {
                    throw new IllegalArgumentException("No configs match configSpec");
                }
            }
            EGLConfig[] configs = new EGLConfig[numConfigs];
            egl.eglChooseConfig(display, this.mConfigSpec, configs, numConfigs, num_config);
            EGLConfig config = this.chooseConfig(egl, display, configs);
            if (config == null) {
                throw new IllegalArgumentException("No config chosen");
            }
            return config;
        }

        abstract EGLConfig chooseConfig(EGL10 var1, EGLDisplay var2, EGLConfig[] var3);
    }

    public static interface EGLConfigChooser {
        public EGLConfig chooseConfig(EGL10 var1, EGLDisplay var2);
    }

    private static class DefaultWindowSurfaceFactory
    implements EGLWindowSurfaceFactory {
        private DefaultWindowSurfaceFactory() {
        }

        @Override
        public EGLSurface createWindowSurface(EGL10 egl, EGLDisplay display, EGLConfig config, Object nativeWindow) {
            return egl.eglCreateWindowSurface(display, config, nativeWindow, null);
        }

        @Override
        public void destroySurface(EGL10 egl, EGLDisplay display, EGLSurface surface) {
            egl.eglDestroySurface(display, surface);
        }
    }

    public static interface EGLWindowSurfaceFactory {
        public EGLSurface createWindowSurface(EGL10 var1, EGLDisplay var2, EGLConfig var3, Object var4);

        public void destroySurface(EGL10 var1, EGLDisplay var2, EGLSurface var3);
    }

    private static class DefaultContextFactory
    implements EGLContextFactory {
        private DefaultContextFactory() {
        }

        @Override
        public EGLContext createContext(EGL10 egl, EGLDisplay display, EGLConfig config) {
            return egl.eglCreateContext(display, config, EGL10.EGL_NO_CONTEXT, null);
        }

        @Override
        public void destroyContext(EGL10 egl, EGLDisplay display, EGLContext context) {
            egl.eglDestroyContext(display, context);
        }
    }

    public static interface EGLContextFactory {
        public EGLContext createContext(EGL10 var1, EGLDisplay var2, EGLConfig var3);

        public void destroyContext(EGL10 var1, EGLDisplay var2, EGLContext var3);
    }

    public static interface Renderer {
        public void onSurfaceCreated(GL10 var1, EGLConfig var2);

        public void onSurfaceChanged(GL10 var1, int var2, int var3);

        public void onDrawFrame(GL10 var1);

        public void onBeforeFinished(GL10 var1);

        public void onAfterFinished(GL10 var1);

        public void onLoopWhenPaused(GL10 var1);

        public boolean needsSwap(GL10 var1);

        public void didSwap(GL10 var1);
    }

    public static interface GLWrapper {
        public GL wrap(GL var1);
    }
}

