/*
 * Decompiled with CFR 0.152.
 */
package net.daum.android.map.coord;

import android.util.Log;
import net.daum.android.map.coord.MapCoord;
import net.daum.android.map.coord.MapCoordConstants;
import net.daum.mf.map.n.api.NativeMapCoordConverter;

public class MapCoordLatLng {
    private static final String LOG_TAG = "MapCoordLatLng";
    protected int _type;
    protected double _latitude;
    protected double _longitude;
    public static final MapCoordLatLng WGS84_UNDEFINED = new MapCoordLatLng(-1.0E7, -1.0E7, 4);

    public MapCoordLatLng() {
        this._latitude = -1.0E7;
        this._longitude = -1.0E7;
        this._type = 4;
    }

    public MapCoordLatLng(double lat, double lng) {
        this._latitude = lat;
        this._longitude = lng;
        this._type = 4;
    }

    public MapCoordLatLng(double lat, double lng, int type) {
        this._latitude = lat;
        this._longitude = lng;
        this._type = type;
    }

    public int getType() {
        return this._type;
    }

    public double getLatitude() {
        return this._latitude;
    }

    public double getLongitude() {
        return this._longitude;
    }

    public boolean isUndefined() {
        return this._latitude == -1.0E7 && this._longitude == -1.0E7;
    }

    public MapCoord toMainCoord() {
        if (MapCoordConstants.MAP_MAIN_COORD_TYPE == 2) {
            return this.toWcong();
        }
        return this.toCong();
    }

    private void error(int toType) {
        Log.e((String)LOG_TAG, (String)("cannot convert " + this._type + " => " + toType + ""));
    }

    private MapCoord toMapCoord(MapCoordLatLng cCoord) {
        return new MapCoord(cCoord.getLongitude(), cCoord.getLatitude(), cCoord.getType());
    }

    public MapCoord toCong() {
        if (this.isUndefined()) {
            return MapCoord.CONG_UNDEFINED;
        }
        NativeMapCoordConverter converter = new NativeMapCoordConverter();
        MapCoord newCoord = null;
        switch (this._type) {
            case 4: {
                newCoord = converter.convertMapCoord(this.toMapCoord(this), 1);
                break;
            }
            default: {
                this.error(1);
            }
        }
        return newCoord;
    }

    public MapCoord toWcong() {
        if (this.isUndefined()) {
            return MapCoord.WCONG_UNDEFINED;
        }
        NativeMapCoordConverter converter = new NativeMapCoordConverter();
        MapCoord newCoord = null;
        switch (this._type) {
            case 4: {
                newCoord = converter.convertMapCoord(this.toMapCoord(this), 2);
                break;
            }
            default: {
                this.error(2);
            }
        }
        return newCoord;
    }
}

