/*
 * Decompiled with CFR 0.152.
 */
package net.daum.android.map.geocoding;

import android.content.Context;
import com.kakao.util.maps.helper.SystemInfo;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import net.daum.mf.map.api.MapPoint;
import net.daum.mf.map.common.net.WebClient;
import net.daum.mf.map.n.api.internal.NativeMapBuildSettings;
import org.json.JSONArray;
import org.json.JSONObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserFactory;

public class ReverseGeoCodingWebService {
    private static final String TAG = "ReverseGeoCodingWebService";
    private static final String HEADER_NAME_X_APPID = "x-appid";
    private static final String HEADER_NAME_X_PLATFORM = "x-platform";
    private static final String HEADER_VALUE_X_PLATFORM_ANDROID = "android";
    private WebClient httpClient;
    private boolean canceled = false;
    private ReverseGeoCodingResultListener resultListener;
    private String apiKey;
    private String packageName;
    private MapPoint mapPoint;
    private ResultFormat resultFormat = ResultFormat.Simple;

    public ReverseGeoCodingWebService(String apiKey, String packageName, MapPoint mapPoint, ReverseGeoCodingResultListener resultListener) {
        this.resultListener = resultListener;
        this.apiKey = apiKey;
        this.packageName = packageName;
        this.mapPoint = mapPoint;
    }

    public ReverseGeoCodingWebService(String apiKey, String packageName, MapPoint mapPoint, ResultFormat resultFormat, ReverseGeoCodingResultListener resultListener) {
        this.resultListener = resultListener;
        this.apiKey = apiKey;
        this.packageName = packageName;
        this.mapPoint = mapPoint;
        this.resultFormat = resultFormat;
    }

    private String _makeFullAddressRequestUrl() {
        String urlPattern = "http://pg.daum.net/congsoa/pointsearch/getPointAllAddress.service?x=%f&y=%f&inputCoordSystem=WCONGNAMUL&output=json&service=and_internal_open_api";
        MapPoint.PlainCoordinate coord = this.mapPoint.getMapPointWCONGCoord();
        String requestUrl = String.format(Locale.US, urlPattern, coord.x, coord.y);
        return requestUrl;
    }

    private String _makeSimpleAddressRequestUrl() {
        String urlPattern = "https://dapi.kakao.com/v2/local/geo/coord2address.json?x=%f&y=%f&input_coord=WCONGNAMUL";
        MapPoint.PlainCoordinate coord = this.mapPoint.getMapPointWCONGCoord();
        String requestUrl = String.format(Locale.US, urlPattern, coord.x, coord.y);
        return requestUrl;
    }

    private String _makeSimpleAddressRequestUrlInternal() {
        String urlPattern = "http://rapi.daum.net/regioncode/getHCode.json?x=%f&y=%f&format=normal&inputCoordSystem=WCONGNAMUL&outputCoordSystem=WCONGNAMUL&service=and_internal_open_api";
        MapPoint.PlainCoordinate coord = this.mapPoint.getMapPointWCONGCoord();
        String requestUrl = String.format(Locale.US, urlPattern, coord.x, coord.y);
        return requestUrl;
    }

    private String convertInputStreamToString(InputStream inputStream) {
        StringBuffer out = new StringBuffer();
        byte[] b = new byte[4096];
        try {
            int n;
            while ((n = inputStream.read(b)) != -1) {
                out.append(new String(b, 0, n));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return out.toString();
    }

    private String _parseFullAddressResultJson(InputStream contentStream) throws Exception {
        JSONObject json = new JSONObject(this.convertInputStreamToString(contentStream));
        JSONObject old = json.getJSONObject("old");
        if (old == null) {
            return null;
        }
        String name = old.getString("name");
        String ho = old.getString("ho");
        if (name == null) {
            return null;
        }
        if (ho != null && ho.equals("0") && name.endsWith("-0")) {
            name = name.substring(0, name.length() - 2);
        }
        return name;
    }

    private String _parseSimpleAddressResultXML(InputStream contentStream) throws Exception {
        String resultString = null;
        XmlPullParserFactory parserCreator = XmlPullParserFactory.newInstance();
        XmlPullParser parser = parserCreator.newPullParser();
        parser.setInput(contentStream, "utf-8");
        int parserEvent = parser.getEventType();
        while (parserEvent != 1) {
            switch (parserEvent) {
                case 2: {
                    String tag = parser.getName();
                    if (tag.compareTo("rcode") == 0) {
                        String name1 = parser.getAttributeValue(null, "name1");
                        String name2 = parser.getAttributeValue(null, "name2");
                        String name3 = parser.getAttributeValue(null, "name3");
                        StringBuilder strBuilder = new StringBuilder(30);
                        strBuilder.append(name1);
                        if (name2 != null) {
                            strBuilder.append(' ');
                            strBuilder.append(name2);
                        }
                        if (name3 != null) {
                            strBuilder.append(' ');
                            strBuilder.append(name3);
                        }
                        resultString = strBuilder.toString();
                        break;
                    }
                    if (tag.compareTo("apierror") != 0) break;
                    throw new Exception("apierror");
                }
            }
            parserEvent = parser.next();
        }
        return resultString;
    }

    private String _parseSimpleAddressResultJSON(InputStream contentStream) throws Exception {
        String resultString = null;
        try {
            JSONObject addressObj;
            JSONObject addressDocument;
            JSONObject json = new JSONObject(this.convertInputStreamToString(contentStream));
            JSONArray document = json.getJSONArray("documents");
            if (document.length() > 0 && (addressDocument = (JSONObject)document.get(0)) != null && (addressObj = addressDocument.getJSONObject("address")) != null) {
                resultString = addressObj.getString("address_name");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return resultString;
    }

    private String _parseSimpleAddressIternalResultJson(InputStream contentStream) throws Exception {
        JSONObject json = new JSONObject(this.convertInputStreamToString(contentStream));
        String fullName = json.getString("fullName");
        return fullName;
    }

    private String getRequestUrl() {
        String requestUrl = this.resultFormat == ResultFormat.Simple ? (NativeMapBuildSettings.isOpenAPIMapLibraryBuild() ? this._makeSimpleAddressRequestUrl() : this._makeSimpleAddressRequestUrlInternal()) : this._makeFullAddressRequestUrl();
        return requestUrl;
    }

    private String getResultString() {
        String resultString = null;
        try {
            InputStream stream = this.httpClient.openContentStream();
            resultString = this.resultFormat == ResultFormat.Simple ? (NativeMapBuildSettings.isOpenAPIMapLibraryBuild() ? this._parseSimpleAddressResultJSON(stream) : this._parseSimpleAddressIternalResultJson(stream)) : this._parseFullAddressResultJson(stream);
        }
        catch (Exception e) {
            return null;
        }
        return resultString;
    }

    public String requestReverseGeoCodingServiceSync() {
        this.httpClient = new WebClient();
        String requestUrl = this.getRequestUrl();
        boolean ok = false;
        if (NativeMapBuildSettings.isOpenAPIMapLibraryBuild()) {
            HashMap<String, String> header = new HashMap<String, String>();
            header.put(HEADER_NAME_X_APPID, this.packageName);
            header.put(HEADER_NAME_X_PLATFORM, HEADER_VALUE_X_PLATFORM_ANDROID);
            ok = this.httpClient.requestGetWithHeader(requestUrl, header);
        } else {
            ok = this.httpClient.requestGet(requestUrl);
        }
        if (!ok) {
            return null;
        }
        String resultString = this.getResultString();
        return resultString;
    }

    public void requestReverseGeoCodingService() {
        this.canceled = false;
        Thread t = new Thread(){

            @Override
            public void run() {
                if (ReverseGeoCodingWebService.this.resultFormat == ResultFormat.Simple) {
                    ReverseGeoCodingWebService.this.httpClient = new WebClient();
                    boolean ok = false;
                    String requestUrl = ReverseGeoCodingWebService.this.getRequestUrl();
                    if (NativeMapBuildSettings.isOpenAPIMapLibraryBuild()) {
                        HashMap<String, String> header = new HashMap<String, String>();
                        SystemInfo.initialize(ReverseGeoCodingWebService.this.resultListener.getContext());
                        String KA = SystemInfo.getKAHeader();
                        header.put("Authorization", "KakaoAK " + ReverseGeoCodingWebService.this.apiKey);
                        header.put("KA", KA);
                        ok = ReverseGeoCodingWebService.this.httpClient.requestGetWithHeader(requestUrl, header);
                    } else {
                        ok = ReverseGeoCodingWebService.this.httpClient.requestGet(requestUrl);
                    }
                    if (!ok && !ReverseGeoCodingWebService.this.canceled && ReverseGeoCodingWebService.this.resultListener != null) {
                        ReverseGeoCodingWebService.this.resultListener.onFailedToFindAddress();
                        return;
                    }
                    if (!ReverseGeoCodingWebService.this.canceled && ReverseGeoCodingWebService.this.resultListener != null) {
                        String resultString = ReverseGeoCodingWebService.this.getResultString();
                        if (resultString == null) {
                            ReverseGeoCodingWebService.this.resultListener.onFailedToFindAddress();
                            return;
                        }
                        ReverseGeoCodingWebService.this.resultListener.onAddressFound(resultString);
                        return;
                    }
                    if (!ReverseGeoCodingWebService.this.canceled && ReverseGeoCodingWebService.this.resultListener != null) {
                        ReverseGeoCodingWebService.this.resultListener.onFailedToFindAddress();
                        return;
                    }
                } else {
                    boolean error = false;
                    ReverseGeoCodingWebService.this.httpClient = new WebClient();
                    String requestUrl = ReverseGeoCodingWebService.this.getRequestUrl();
                    if (!ReverseGeoCodingWebService.this.httpClient.requestGet(requestUrl)) {
                        error = true;
                    }
                    if (!ReverseGeoCodingWebService.this.canceled && ReverseGeoCodingWebService.this.resultListener != null) {
                        String resultString = ReverseGeoCodingWebService.this.getResultString();
                        if (resultString == null || resultString.length() == 0) {
                            error = true;
                        } else {
                            ReverseGeoCodingWebService.this.resultListener.onAddressFound(resultString);
                        }
                    }
                    if (error) {
                        ReverseGeoCodingWebService.this.resultFormat = ResultFormat.Simple;
                        ReverseGeoCodingWebService.this.requestReverseGeoCodingService();
                    }
                }
            }
        };
        t.start();
    }

    public void cancelRequest() {
        this.canceled = true;
        if (this.httpClient != null) {
            this.httpClient.cancel();
        }
    }

    public static enum ResultFormat {
        Simple,
        Full;

    }

    public static interface ReverseGeoCodingResultListener {
        public void onAddressFound(String var1);

        public void onFailedToFindAddress();

        public Context getContext();
    }
}

