/*
 * Decompiled with CFR 0.152.
 */
package net.daum.android.map.openapi.auth;

import android.content.Context;
import com.kakao.util.maps.helper.SystemInfo;
import com.kakao.util.maps.helper.Utility;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import net.daum.mf.map.common.net.WebClient;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserFactory;

public class OpenAPIKeyAuthenticationWebService {
    private String apiKey;
    private String KA;
    private String appId;
    private String appVersion;
    private static String openAPILibraryVersion = "1.3.1.0";
    private WebClient httpClient;
    private WeakReference<OpenAPIKeyAuthenticationResultListener> resultListener;
    private static int INVALID_RESULT_CODE = -99999;
    private int resultCode = INVALID_RESULT_CODE;
    private String resultMessage;
    private String imageTileVersion;
    private String hybridTileVersion;
    private String roadViewTileVersion;

    public OpenAPIKeyAuthenticationWebService(Context ctxt, String apiKey, String appId, String appVersion, OpenAPIKeyAuthenticationResultListener resultListener) {
        this.appId = appId;
        this.appVersion = appVersion;
        this.resultListener = new WeakReference<OpenAPIKeyAuthenticationResultListener>(resultListener);
        if (ctxt != null) {
            String appKey = Utility.getMetadata(ctxt, "com.kakao.sdk.AppKey");
            this.apiKey = appKey == null || appKey.length() == 0 ? apiKey : appKey;
            SystemInfo.initialize(ctxt);
            this.KA = SystemInfo.getKAHeader();
        } else {
            this.apiKey = apiKey;
        }
    }

    private void _parseResultXML(InputStream contentStream) throws Exception {
        XmlPullParserFactory parserCreator = XmlPullParserFactory.newInstance();
        XmlPullParser parser = parserCreator.newPullParser();
        parser.setInput(contentStream, "utf-8");
        int parserEvent = parser.getEventType();
        boolean inCode = false;
        boolean inMessage = false;
        boolean inMapTileVersion = false;
        boolean inMapTileVersionImage = false;
        boolean inMapTileVersionHybrid = false;
        boolean inMapTileVersionRoadView = false;
        while (parserEvent != 1) {
            switch (parserEvent) {
                case 4: {
                    if (!inMapTileVersion) break;
                    if (inMapTileVersionImage) {
                        this.imageTileVersion = parser.getText().trim();
                        break;
                    }
                    if (inMapTileVersionHybrid) {
                        this.hybridTileVersion = parser.getText().trim();
                        break;
                    }
                    if (!inMapTileVersionRoadView) break;
                    this.roadViewTileVersion = parser.getText().trim();
                    break;
                }
                case 3: {
                    String tag = parser.getName();
                    if (tag.compareTo("mapTileVersion") == 0) {
                        inMapTileVersion = false;
                        break;
                    }
                    if (!inMapTileVersion) break;
                    if (tag.compareTo("i") == 0) {
                        inMapTileVersionImage = false;
                        break;
                    }
                    if (tag.compareTo("h") == 0) {
                        inMapTileVersionHybrid = false;
                        break;
                    }
                    if (tag.compareTo("t") != 0) break;
                    inMapTileVersionRoadView = false;
                    break;
                }
                case 2: {
                    String tag = parser.getName();
                    if (tag.compareTo("mapTileVersion") == 0) {
                        inMapTileVersion = true;
                        break;
                    }
                    if (!inMapTileVersion) break;
                    if (tag.compareTo("i") == 0) {
                        inMapTileVersionImage = true;
                        break;
                    }
                    if (tag.compareTo("h") == 0) {
                        inMapTileVersionHybrid = true;
                        break;
                    }
                    if (tag.compareTo("t") != 0) break;
                    inMapTileVersionRoadView = true;
                }
            }
            parserEvent = parser.next();
        }
    }

    public void requestOpenAPIKeyAuthenticationService() {
        if (this.apiKey == null || this.apiKey.length() == 0) {
            if (this.resultListener != null && this.resultListener.get() != null) {
                ((OpenAPIKeyAuthenticationResultListener)this.resultListener.get()).onAuthenticationErrorOccured();
                ((OpenAPIKeyAuthenticationResultListener)this.resultListener.get()).onAuthenticationResultReceived(-101, "API Key\ub97c \uc124\uc815\ud558\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.", null, null, null);
            }
            return;
        }
        Thread t = new Thread(){

            @Override
            public void run() {
                OpenAPIKeyAuthenticationWebService.this.httpClient = new WebClient();
                HashMap<String, String> header = new HashMap<String, String>();
                header.put("Authorization", "KakaoAK " + OpenAPIKeyAuthenticationWebService.this.apiKey);
                header.put("KA", OpenAPIKeyAuthenticationWebService.this.KA);
                String requestUrl = String.format("https://dapi.kakao.com/v2/maps/auth.xml", new Object[0]);
                if (!OpenAPIKeyAuthenticationWebService.this.httpClient.requestGetWithHeader(requestUrl, header)) {
                    if (OpenAPIKeyAuthenticationWebService.this.resultListener != null && OpenAPIKeyAuthenticationWebService.this.resultListener.get() != null) {
                        ((OpenAPIKeyAuthenticationResultListener)OpenAPIKeyAuthenticationWebService.this.resultListener.get()).onAuthenticationErrorOccured();
                    }
                    return;
                }
                if (OpenAPIKeyAuthenticationWebService.this.resultListener != null && OpenAPIKeyAuthenticationWebService.this.resultListener.get() != null) {
                    try {
                        InputStream xmlStream = OpenAPIKeyAuthenticationWebService.this.httpClient.openContentStream();
                        OpenAPIKeyAuthenticationWebService.this.resultCode = OpenAPIKeyAuthenticationWebService.this.httpClient.getStatusCode();
                        OpenAPIKeyAuthenticationWebService.this.resultMessage = null;
                        OpenAPIKeyAuthenticationWebService.this._parseResultXML(xmlStream);
                    }
                    catch (Exception e) {
                        ((OpenAPIKeyAuthenticationResultListener)OpenAPIKeyAuthenticationWebService.this.resultListener.get()).onAuthenticationErrorOccured();
                    }
                    if (OpenAPIKeyAuthenticationWebService.this.resultCode != 200) {
                        ((OpenAPIKeyAuthenticationResultListener)OpenAPIKeyAuthenticationWebService.this.resultListener.get()).onAuthenticationErrorOccured();
                    }
                    ((OpenAPIKeyAuthenticationResultListener)OpenAPIKeyAuthenticationWebService.this.resultListener.get()).onAuthenticationResultReceived(OpenAPIKeyAuthenticationWebService.this.resultCode, OpenAPIKeyAuthenticationWebService.this.resultMessage, OpenAPIKeyAuthenticationWebService.this.imageTileVersion, OpenAPIKeyAuthenticationWebService.this.hybridTileVersion, OpenAPIKeyAuthenticationWebService.this.roadViewTileVersion);
                }
            }
        };
        t.start();
    }

    public static interface OpenAPIKeyAuthenticationResultListener {
        public void onAuthenticationResultReceived(int var1, String var2, String var3, String var4, String var5);

        public void onAuthenticationErrorOccured();
    }
}

