/*
 * Decompiled with CFR 0.152.
 */
package net.daum.android.map.util;

import android.content.Context;
import android.content.SharedPreferences;

public class PersistentKeyValueStore {
    public static final String SETTING_KEY_LAST_IMAGE_TILE_VERSION = "daummap.lib.settings.tile.image.lastVersion";
    public static final String SETTING_KEY_LAST_HYBRID_TILE_VERSION = "daummap.lib.settings.tile.hybrid.lastVersion";
    public static final String SETTING_KEY_LAST_ROADVIEW_TILE_VERSION = "daummap.lib.settings.tile.roadview.lastVersion";
    private Context context;

    public PersistentKeyValueStore(Context context) {
        this.context = context;
    }

    private SharedPreferences getSharedPreferences() {
        return this.context.getSharedPreferences("Preference", 0);
    }

    public void put(String key, String value) {
        SharedPreferences.Editor editor = this.getSharedPreferences().edit();
        editor.putString(key, value);
        editor.commit();
    }

    public void put(String key, boolean value) {
        SharedPreferences.Editor editor = this.getSharedPreferences().edit();
        editor.putBoolean(key, value);
        editor.commit();
    }

    public void put(String key, long value) {
        SharedPreferences.Editor editor = this.getSharedPreferences().edit();
        editor.putLong(key, value);
        editor.commit();
    }

    public void put(String key, int value) {
        SharedPreferences.Editor editor = this.getSharedPreferences().edit();
        editor.putInt(key, value);
        editor.commit();
    }

    public void put(String key, float value) {
        SharedPreferences.Editor editor = this.getSharedPreferences().edit();
        editor.putFloat(key, value);
        editor.commit();
    }

    public String getString(String key) {
        return this.getString(key, null);
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public long getLong(String key) {
        return this.getLong(key, 0L);
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public float getFloat(String key) {
        return this.getFloat(key, 0.0f);
    }

    public String getString(String key, String def) {
        SharedPreferences shared_preference = this.getSharedPreferences();
        return shared_preference.getString(key, def);
    }

    public boolean getBoolean(String key, boolean def) {
        SharedPreferences shared_preference = this.getSharedPreferences();
        return shared_preference.getBoolean(key, def);
    }

    public long getLong(String key, long def) {
        SharedPreferences shared_preference = this.getSharedPreferences();
        return shared_preference.getLong(key, def);
    }

    public int getInt(String key, int def) {
        SharedPreferences shared_preference = this.getSharedPreferences();
        return shared_preference.getInt(key, def);
    }

    public float getFloat(String key, float def) {
        SharedPreferences shared_preference = this.getSharedPreferences();
        return shared_preference.getFloat(key, def);
    }

    public void setLastImageTileVersion(String ver) {
        this.put(SETTING_KEY_LAST_IMAGE_TILE_VERSION, ver);
    }

    public String getLastImageTileVersion() {
        return this.getString(SETTING_KEY_LAST_IMAGE_TILE_VERSION);
    }

    public void setLastHybridTileVersion(String ver) {
        this.put(SETTING_KEY_LAST_HYBRID_TILE_VERSION, ver);
    }

    public String getLastHybridTileVersion() {
        return this.getString(SETTING_KEY_LAST_HYBRID_TILE_VERSION);
    }

    public void setLastRoadViewTileVersion(String ver) {
        this.put(SETTING_KEY_LAST_ROADVIEW_TILE_VERSION, ver);
    }

    public String getLastRoadViewTileVersion() {
        return this.getString(SETTING_KEY_LAST_ROADVIEW_TILE_VERSION);
    }
}

