/*
 * Decompiled with CFR 0.152.
 */
package net.daum.mf.map.n.api;

import android.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.GZIPInputStream;
import net.daum.android.map.MapBuildSettings;
import net.daum.mf.map.common.MapThreadSettings;
import net.daum.mf.map.common.net.HeaderItem;
import net.daum.mf.map.n.api.NativeMapLibraryLoader;
import net.daum.mf.map.task.MapTaskManager;

public class NativeBaseNetConnection {
    private static final String TAG = "NativeBaseNetConnection";
    public long delegate;
    protected String url;
    protected AtomicBoolean aborted = new AtomicBoolean(false);
    protected HttpURLConnection httpConnection = null;
    protected AtomicInteger _state = new AtomicInteger();
    protected ConcurrentLinkedQueue<NetBuffer> bufferQueue = new ConcurrentLinkedQueue();
    public static final int NETCONNECTION4_STATE_READY = 0;
    public static final int NETCONNECTION4_STATE_CONNECTED = 1;
    public static final int NETCONNECTION4_STATE_READING = 2;
    public static final int NETCONNECTION4_STATE_FINISHED = 3;
    public static final int NETCONNECTION4_STATE_CANCELED = 4;
    private boolean retry = false;

    public NativeBaseNetConnection() {
        this.setState(0);
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean start() {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                block14: {
                    try {
                        Thread.currentThread().setPriority(MapThreadSettings.getNetworkConnectionPriority());
                    }
                    catch (Exception e) {
                        if (e == null) break block14;
                        Log.e((String)NativeBaseNetConnection.class.getName(), (String)("" + e.getMessage() + ",url=" + NativeBaseNetConnection.this.url));
                    }
                }
                try {
                    URI uri = URI.create(NativeBaseNetConnection.this.url);
                    NativeBaseNetConnection.this.httpConnection = (HttpURLConnection)new URL(uri.toASCIIString()).openConnection();
                    NativeBaseNetConnection.this.httpConnection.setRequestProperty("Accept-Encoding", "gzip");
                    NativeBaseNetConnection.this.httpConnection.setRequestProperty("User-Agent", NativeBaseNetConnection.this.getUserAgent());
                    NativeBaseNetConnection.this.httpConnection.connect();
                    if (NativeBaseNetConnection.this.getState() == 4) {
                        return;
                    }
                    NativeBaseNetConnection.this.setState(1);
                    NativeBaseNetConnection.this.notifyFinishConnection();
                }
                catch (SocketException e) {
                    if (!NativeBaseNetConnection.this.retry) {
                        NativeBaseNetConnection.this.retry = true;
                        NativeBaseNetConnection.this.start();
                    } else {
                        if (e != null) {
                            Log.e((String)NativeBaseNetConnection.class.getName(), (String)("" + e.getMessage() + ",url=" + NativeBaseNetConnection.this.url));
                        }
                        NativeBaseNetConnection.this.notifyFinishConnection(null);
                    }
                }
                catch (InterruptedIOException e) {
                    if (e != null) {
                        Log.e((String)NativeBaseNetConnection.class.getName(), (String)("" + e.getMessage() + ",url=" + NativeBaseNetConnection.this.url));
                    }
                    NativeBaseNetConnection.this.notifyFinishConnection(null);
                }
                catch (AssertionError e) {
                    if (e != null) {
                        Log.e((String)NativeBaseNetConnection.class.getName(), (String)("" + ((Throwable)((Object)e)).getMessage() + ",url=" + NativeBaseNetConnection.this.url));
                    }
                    NativeBaseNetConnection.this.notifyFinishConnection(null);
                }
                catch (Exception e) {
                    if (e != null) {
                        Log.e((String)NativeBaseNetConnection.class.getName(), (String)("" + e.getMessage() + ",url=" + NativeBaseNetConnection.this.url));
                    }
                    NativeBaseNetConnection.this.notifyFinishConnection(null);
                }
            }
        };
        MapTaskManager.getInstance().execute(task);
        return true;
    }

    public void cancel() {
        if (this.httpConnection != null) {
            this.setState(4);
            this.aborted.set(true);
            this.httpConnection.disconnect();
        }
    }

    public void setState(int state) {
        this._state.set(state);
    }

    public int getState() {
        return this._state.get();
    }

    void queueResponseHeader(final int statusCode, final HeaderItem[] httpResponse) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                if (!NativeBaseNetConnection.this.aborted.get()) {
                    NativeBaseNetConnection.this.onResponseHeader(statusCode, httpResponse);
                }
            }
        };
        this.queueTask(task);
    }

    void queueNetworkData(byte[] data, int size) {
        NetBuffer b = new NetBuffer(data, size);
        this.bufferQueue.add(b);
    }

    void queueFinish(final int statusCode) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                if (!NativeBaseNetConnection.this.aborted.get()) {
                    NativeBaseNetConnection.this.onFinishConnection(statusCode);
                }
            }
        };
        this.queueTask(task);
    }

    private static boolean isSuccessStatusCode(int statusCode) {
        return statusCode >= 200 && statusCode < 300;
    }

    public InputStream openContentStream(HttpURLConnection conn) throws IllegalStateException, IOException {
        return NativeBaseNetConnection.isSuccessStatusCode(conn.getResponseCode()) ? conn.getInputStream() : conn.getErrorStream();
    }

    public HeaderItem[] getHeaderItems(HttpURLConnection conn) {
        Map<String, List<String>> headers = conn.getHeaderFields();
        if (headers == null) {
            return null;
        }
        if (headers.size() == 0) {
            return null;
        }
        HeaderItem[] result = new HeaderItem[headers.size()];
        int i = 0;
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            try {
                result[i] = new HeaderItem();
                String name = entry.getKey();
                if (name != null) {
                    result[i].name = name;
                    List<String> valueList = entry.getValue();
                    StringBuilder sb = new StringBuilder();
                    for (String v : valueList) {
                        if (sb.length() > 0) {
                            sb.append(" ");
                        }
                        sb.append(v);
                    }
                    result[i].value = sb.toString();
                }
                ++i;
            }
            catch (Exception e) {
                Log.e((String)NativeBaseNetConnection.class.getName(), (String)("getHeaderItems caused exception key= " + result[i].name + " value= " + result[i].value));
            }
        }
        return result;
    }

    private void notifyFinishConnection() {
        this.notifyFinishConnection(this.httpConnection);
    }

    private void notifyFinishConnection(HttpURLConnection conn) {
        block11: {
            if (conn == null) {
                this.queueFinish(-1);
            } else {
                InputStream contentStream = null;
                try {
                    contentStream = this.openContentStream(conn);
                    final int statusCode = conn.getResponseCode();
                    HeaderItem[] httpResponse = this.getHeaderItems(conn);
                    this.queueResponseHeader(statusCode, httpResponse);
                    HeaderItem contentEncoding = null;
                    for (HeaderItem header : httpResponse) {
                        if (header == null) {
                            Log.w((String)NativeBaseNetConnection.class.getName(), (String)"HeaderItem header : httpResponse is null");
                            continue;
                        }
                        if (!header.getName().equalsIgnoreCase("Content-Encoding")) continue;
                        contentEncoding = header;
                        break;
                    }
                    if (contentEncoding != null && contentEncoding.getValue().equalsIgnoreCase("gzip")) {
                        contentStream = new GZIPInputStream(contentStream);
                    }
                    this.setState(2);
                    Runnable loopTask = new Runnable(){

                        protected void rerun() {
                            NativeBaseNetConnection.this.queueTask(this);
                        }

                        @Override
                        public void run() {
                            int state = NativeBaseNetConnection.this.getState();
                            if (state == 2 || NativeBaseNetConnection.this.bufferQueue.size() > 0) {
                                NetBuffer b = NativeBaseNetConnection.this.bufferQueue.peek();
                                if (b != null) {
                                    int processed = NativeBaseNetConnection.this.onNetworkDataAsync(b._buffer, b._dataSize, b._processedBytes, b._dataSize + 1);
                                    if (processed == -1) {
                                        NativeBaseNetConnection.this.bufferQueue.clear();
                                        if (!MapBuildSettings.getInstance().isDistribution()) {
                                            Log.i((String)NativeBaseNetConnection.class.getName(), (String)"NETCONNECTION4 processed == -1");
                                        }
                                        return;
                                    }
                                    if (processed < b._dataSize) {
                                        b._processedBytes = processed;
                                    } else if (processed == b._dataSize) {
                                        NativeBaseNetConnection.this.bufferQueue.remove();
                                    }
                                }
                                this.rerun();
                            } else if (state == 3) {
                                NativeBaseNetConnection.this.queueFinish(statusCode);
                            } else if (state == 4) {
                                NativeBaseNetConnection.this.queueFinish(statusCode);
                            }
                        }
                    };
                    this.queueTask(loopTask);
                    try {
                        byte[] data = this.readFromInputStream(contentStream, conn.getContentLength());
                        if (data != null) {
                            this.queueNetworkData(data, data.length);
                            this.setState(3);
                        } else {
                            this.setState(4);
                        }
                        contentStream.close();
                    }
                    catch (IOException e) {
                        Log.e((String)TAG, null, (Throwable)e);
                        Log.e((String)TAG, (String)("url=" + this.url));
                    }
                }
                catch (Exception e) {
                    if (e == null) break block11;
                    Log.e((String)NativeBaseNetConnection.class.getName(), (String)("" + e.getMessage() + ",url=" + this.url));
                }
            }
        }
    }

    private byte[] readFromInputStream(InputStream inputStream, long contentLength) throws IOException {
        int contentLengthInt = 0;
        try {
            contentLengthInt = this.safeLongToInt(contentLength);
        }
        catch (IllegalArgumentException e) {
            Log.d((String)TAG, (String)"", (Throwable)e);
        }
        int bufferSize = contentLengthInt > 0 ? contentLengthInt : 32;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(bufferSize);
        ReadableByteChannel inputChannel = Channels.newChannel(inputStream);
        WritableByteChannel outputChannel = Channels.newChannel(byteArrayOutputStream);
        this.fastChannelCopy(inputChannel, outputChannel);
        byte[] data = byteArrayOutputStream.toByteArray();
        try {
            byteArrayOutputStream.close();
        }
        catch (IOException e) {
            Log.d((String)TAG, (String)"", (Throwable)e);
        }
        try {
            inputChannel.close();
        }
        catch (IOException e) {
            Log.d((String)TAG, (String)"", (Throwable)e);
        }
        try {
            outputChannel.close();
        }
        catch (IOException e) {
            Log.d((String)TAG, (String)"", (Throwable)e);
        }
        return data;
    }

    private void fastChannelCopy(ReadableByteChannel inputChannel, WritableByteChannel outputChannel) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(16384);
        while (inputChannel.read(buffer) != -1) {
            buffer.flip();
            outputChannel.write(buffer);
            buffer.compact();
        }
        buffer.flip();
        while (buffer.hasRemaining()) {
            outputChannel.write(buffer);
        }
    }

    private int safeLongToInt(long l) throws IllegalArgumentException {
        if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(l + " cannot be cast to int without changing its value.");
        }
        return (int)l;
    }

    protected void queueTask(Runnable task) {
    }

    protected String getUserAgent() {
        return "";
    }

    protected native void onResponseHeader(int var1, HeaderItem[] var2);

    protected native int onNetworkDataAsync(byte[] var1, int var2, int var3, int var4);

    protected native void onFinishConnection(int var1);

    static {
        NativeMapLibraryLoader.loadLibrary();
    }

    private static final class NetBuffer {
        public int _processedBytes = 0;
        public int _dataSize;
        public byte[] _buffer;

        public NetBuffer(byte[] buffer, int dataSize) {
            this._dataSize = dataSize;
            this._buffer = buffer;
        }
    }
}

