/*
 * Decompiled with CFR 0.152.
 */
package net.daum.mf.map.n.api;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import net.daum.android.map.MapBuildSettings;
import net.daum.mf.map.n.api.NativeMapEngineContext;
import net.daum.mf.map.n.api.NativeMapLibraryLoader;

public class NativeImage {
    private Bitmap bitmap;
    private int contentWidth;
    private int contentHeight;
    private int textColorA;
    private int textColorR;
    private int textColorG;
    private int textColorB;
    static final int TOP_LEFT = 10;
    static final int TOP_CENTER = 11;
    static final int TOP_RIGHT = 12;
    static final int MIDDLE_LEFT = 20;
    static final int MIDDLE_CENTER = 21;
    static final int MIDDLE_RIGHT = 22;
    static final int BOTTOM_LEFT = 30;
    static final int BOTTOM_CENTER = 31;
    static final int BOTTOM_RIGHT = 32;
    public static int RESOURCE_ERROR;
    public static int RESOURCE_CLASS_PATH;
    public static int RESOURCE_ABSOLUTE_PATH;

    public NativeImage(Bitmap bitmap) {
        this.bitmap = bitmap;
    }

    public int getWidth() {
        if (this.bitmap == null) {
            return 0;
        }
        return this.bitmap.getWidth();
    }

    public int getHeight() {
        if (this.bitmap == null) {
            return 0;
        }
        return this.bitmap.getHeight();
    }

    public int getContentWidth() {
        return this.contentWidth;
    }

    public void setContentWidth(int contentWidth) {
        this.contentWidth = contentWidth;
    }

    public int getContentHeight() {
        return this.contentHeight;
    }

    public void setContentHeight(int contentHeight) {
        this.contentHeight = contentHeight;
    }

    public int getPixelLengthInBytes() {
        if (this.bitmap == null) {
            return 0;
        }
        if (this.bitmap.hasAlpha()) {
            return 4;
        }
        return 3;
    }

    public int readTo(int[] target, int targetSize) {
        int height;
        if (this.bitmap == null || target == null) {
            if (!MapBuildSettings.getInstance().isDistribution()) {
                Log.e((String)NativeImage.class.getName(), (String)"bitmap == null || target == null");
            }
            return 0;
        }
        int width = this.bitmap.getWidth();
        int size = width * (height = this.bitmap.getHeight());
        if (size > targetSize && !MapBuildSettings.getInstance().isDistribution()) {
            Log.e((String)NativeImage.class.getName(), (String)("not enough targetSize=" + targetSize));
        }
        try {
            this.bitmap.getPixels(target, 0, width, 0, 0, width, height);
        }
        catch (Exception e) {
            Log.e((String)NativeImage.class.getName(), (String)("" + e.getMessage()));
            return 0;
        }
        return size;
    }

    public static NativeImage newNativeImage(ByteBuffer dataBuffer, int length, String name, float targetScale) {
        byte[] data = null;
        boolean hasArray = false;
        try {
            hasArray = dataBuffer.hasArray();
        }
        catch (UnsupportedOperationException e) {
            hasArray = false;
        }
        catch (Exception e) {
            hasArray = false;
        }
        if (hasArray) {
            data = dataBuffer.array();
        } else {
            data = new byte[length];
            dataBuffer.get(data);
        }
        Bitmap bitmap = null;
        try {
            BitmapFactory.Options opts = new BitmapFactory.Options();
            if (targetScale > 0.0f && targetScale != 1.0f) {
                opts.inDensity = 160;
                opts.inTargetDensity = Math.round(160.0f * targetScale);
            }
            bitmap = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)length, (BitmapFactory.Options)opts);
        }
        catch (Exception e) {
            Log.e((String)NativeImage.class.getName(), (String)("" + e.getMessage()));
        }
        if (bitmap == null) {
            return null;
        }
        return new NativeImage(bitmap);
    }

    public void setTextColor(int a, int r, int g, int b) {
        this.textColorA = a;
        this.textColorR = r;
        this.textColorG = g;
        this.textColorB = b;
    }

    public int getTextColorA() {
        return this.textColorA;
    }

    public int getTextColorR() {
        return this.textColorR;
    }

    public int getTextColorG() {
        return this.textColorG;
    }

    public int getTextColorB() {
        return this.textColorB;
    }

    public static RectF sizeWithFont(String text, int fontSize, float maxWidth) {
        TextPaint textPaint = new TextPaint();
        textPaint.setStyle(Paint.Style.FILL);
        textPaint.setTextSize((float)fontSize);
        textPaint.setTextAlign(Paint.Align.LEFT);
        textPaint.setAntiAlias(true);
        textPaint.setARGB(255, 0, 0, 0);
        StaticLayout sl = new StaticLayout((CharSequence)text, textPaint, (int)maxWidth, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, false);
        int height = sl.getHeight();
        int width = sl.getWidth();
        return new RectF(0.0f, 0.0f, (float)width, (float)height);
    }

    public static NativeImage newNativeImageWithText_SingleLine(String text, int frameWidth, int frameHeight, float maxWidth, float maxHeight, int color, int fontSize, int textAlignment) {
        if (text == null) {
            return null;
        }
        if (!MapBuildSettings.getInstance().isDistribution()) {
            Log.i((String)NativeImage.class.getName(), (String)String.format("newNativeImageWithText(%s, %d, %d)", text, frameWidth, frameHeight));
        }
        TextPaint textPaint = new TextPaint();
        textPaint.setStyle(Paint.Style.FILL);
        textPaint.setTextSize((float)fontSize);
        textPaint.setTextAlign(Paint.Align.LEFT);
        textPaint.setAntiAlias(true);
        Paint.FontMetrics fm = textPaint.getFontMetrics();
        Rect textRect = new Rect();
        textPaint.setARGB(Color.alpha((int)color), Color.red((int)color), Color.green((int)color), Color.blue((int)color));
        CharSequence ellipsisText = TextUtils.ellipsize((CharSequence)text, (TextPaint)textPaint, (float)maxWidth, (TextUtils.TruncateAt)TextUtils.TruncateAt.END);
        String ellipsisString = ellipsisText.toString();
        textPaint.getTextBounds(ellipsisString, 0, ellipsisString.length(), textRect);
        int textWidth = textRect.right - textRect.left;
        int textHeight = textRect.bottom - textRect.top;
        Bitmap bitmap = null;
        try {
            bitmap = Bitmap.createBitmap((int)frameWidth, (int)frameHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        catch (Exception e) {
            Log.e((String)NativeImage.class.getName(), (String)("" + e.getMessage()));
        }
        if (bitmap == null) {
            return null;
        }
        Canvas canvas = new Canvas(bitmap);
        canvas.drawARGB(255, 255, 0, 0);
        float x = maxWidth / 2.0f - (float)textWidth / 2.0f;
        float y = (float)(textHeight / 2) - (fm.ascent + fm.descent) / 2.0f;
        NativeImage image = new NativeImage(bitmap);
        canvas.drawText(ellipsisText.toString(), x, y + 1.0f, (Paint)textPaint);
        image.setContentWidth(textWidth);
        image.setContentHeight(textHeight);
        return image;
    }

    private static Layout createWorkingLayout(String workingText, int width, TextPaint paint) {
        return new StaticLayout((CharSequence)workingText, paint, width, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, false);
    }

    public static NativeImage newNativeImageWithText(String text, int frameWidth, int frameHeight, float maxWidth, float maxHeight, int color, int fontSize, int textAlignment) {
        if (text == null) {
            return null;
        }
        String ellipsisText = null;
        TextPaint textPaint = new TextPaint();
        Layout.Alignment layoutAlignment = Layout.Alignment.ALIGN_NORMAL;
        if (textAlignment == 21) {
            layoutAlignment = Layout.Alignment.ALIGN_CENTER;
        }
        textPaint.setStyle(Paint.Style.FILL);
        textPaint.setTextSize((float)fontSize);
        textPaint.setTextAlign(Paint.Align.LEFT);
        textPaint.setAntiAlias(true);
        textPaint.setARGB(Color.alpha((int)color), Color.red((int)color), Color.green((int)color), Color.blue((int)color));
        StaticLayout sl = new StaticLayout((CharSequence)text, textPaint, (int)maxWidth, layoutAlignment, 1.0f, 0.0f, false);
        int numberOfLines = sl.getLineCount();
        int height = sl.getHeight();
        int width = sl.getWidth();
        if (!MapBuildSettings.getInstance().isDistribution()) {
            Log.d((String)NativeImage.class.getName(), (String)String.format(">>>> newNativeImageWithText2(%s, %d, %d) / %d lines width= %d height=%d", text, frameWidth, frameHeight, numberOfLines, width, height));
        }
        String ELLIPSIS = "...";
        boolean truncate = false;
        if (numberOfLines == 1) {
            Rect textRect = new Rect();
            textPaint.getTextBounds(text, 0, text.length(), textRect);
            width = textRect.width();
            height = textRect.height();
        } else if ((int)maxHeight < height) {
            int maxLines = numberOfLines - 1;
            String workingText = text;
            Layout layout = NativeImage.createWorkingLayout(workingText, (int)maxWidth, textPaint);
            if (layout.getLineCount() > maxLines) {
                int lastSpace;
                workingText = text.substring(0, layout.getLineEnd(maxLines - 1)).trim();
                while (NativeImage.createWorkingLayout(workingText + "...", (int)maxWidth, textPaint).getLineCount() > maxLines && (lastSpace = workingText.lastIndexOf(32)) != -1) {
                    workingText = workingText.substring(0, lastSpace);
                }
                workingText = workingText + "...";
                truncate = true;
                ellipsisText = workingText;
            }
        }
        if (!truncate) {
            ellipsisText = text;
        }
        Bitmap bitmap = null;
        try {
            bitmap = Bitmap.createBitmap((int)frameWidth, (int)frameHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        catch (Exception e) {
            Log.e((String)NativeImage.class.getName(), (String)("" + e.getMessage()));
        }
        if (bitmap == null) {
            return null;
        }
        Canvas canvas = new Canvas(bitmap);
        canvas.drawARGB(0, 0, 0, 0);
        NativeImage image = new NativeImage(bitmap);
        StaticLayout sl2 = new StaticLayout((CharSequence)ellipsisText, textPaint, (int)maxWidth, layoutAlignment, 1.0f, 0.0f, false);
        sl2.draw(canvas);
        int finalHeight = (int)maxHeight < height ? (int)maxHeight : height;
        image.setContentWidth(width);
        image.setContentHeight(finalHeight + 2);
        return image;
    }

    public static NativeImage newNativeImage(String path, float targetScale) {
        Resources res = NativeMapEngineContext.getInstance().getApplicationContext().getResources();
        int id = NativeImage.getResourceIdFromPath(path);
        if (id == RESOURCE_CLASS_PATH || id == RESOURCE_ABSOLUTE_PATH) {
            return NativeImage.newNativeInternalImage(path, targetScale, id);
        }
        if (id < 0) {
            return null;
        }
        Bitmap bitmap = null;
        try {
            BitmapFactory.Options opts = new BitmapFactory.Options();
            if (targetScale > 0.0f && targetScale != 1.0f) {
                opts.inDensity = 160;
                opts.inTargetDensity = Math.round(160.0f * targetScale);
            }
            bitmap = BitmapFactory.decodeResource((Resources)res, (int)id, (BitmapFactory.Options)opts);
        }
        catch (Exception e) {
            Log.e((String)NativeImage.class.getName(), (String)("" + e.getMessage()));
        }
        if (bitmap == null) {
            return null;
        }
        return new NativeImage(bitmap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static NativeImage newNativeInternalImage(String fullPath, float targetScale, int type) {
        Bitmap bitmap = null;
        InputStream is = null;
        try {
            File file;
            int startPos = fullPath.indexOf(":") + 1;
            String path = fullPath.substring(startPos);
            if (type == RESOURCE_CLASS_PATH) {
                is = NativeMapEngineContext.getInstance().getClass().getResourceAsStream(path);
            } else if (type == RESOURCE_ABSOLUTE_PATH && (file = new File(path)).exists()) {
                is = new FileInputStream(file);
            }
            if (is == null) {
                file = null;
                return file;
            }
            BitmapFactory.Options opts = new BitmapFactory.Options();
            if (targetScale > 0.0f && targetScale != 1.0f) {
                opts.inDensity = 160;
                opts.inTargetDensity = Math.round(160.0f * targetScale);
            }
            bitmap = BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)opts);
        }
        catch (Exception e) {
            Log.e((String)NativeImage.class.getName(), (String)("" + e.getMessage()));
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (bitmap == null) {
            return null;
        }
        return new NativeImage(bitmap);
    }

    public Bitmap getBitmap() {
        return this.bitmap;
    }

    private static int getResourceIdFromPath(String path) {
        if (path == null) {
            return RESOURCE_ERROR;
        }
        String fullName = path.trim();
        int len = fullName.length();
        int cPos = fullName.indexOf(":");
        if (cPos < 0) {
            if (!MapBuildSettings.getInstance().isDistribution()) {
                Log.e((String)NativeImage.class.getName(), (String)("not resId format: '" + fullName + "'"));
            }
            return RESOURCE_ERROR;
        }
        String schemaString = fullName.substring(0, cPos);
        int idStartPos = cPos + 1;
        if (idStartPos >= len) {
            if (!MapBuildSettings.getInstance().isDistribution()) {
                Log.e((String)NativeImage.class.getName(), (String)("not resId format: '" + fullName + "'"));
            }
            return RESOURCE_ERROR;
        }
        if (schemaString.equals("res")) {
            String idString = fullName.substring(idStartPos);
            int id = RESOURCE_ERROR;
            try {
                id = Integer.parseInt(idString, 10);
            }
            catch (Throwable tr) {
                Log.e((String)NativeImage.class.getName(), (String)("cannot parse int : '" + idString + "'"));
            }
            return id;
        }
        if (schemaString.equals("classPath")) {
            return RESOURCE_CLASS_PATH;
        }
        if (schemaString.equals("absolutePath")) {
            return RESOURCE_ABSOLUTE_PATH;
        }
        return RESOURCE_ERROR;
    }

    static {
        NativeMapLibraryLoader.loadLibrary();
        RESOURCE_ERROR = -1;
        RESOURCE_CLASS_PATH = -2;
        RESOURCE_ABSOLUTE_PATH = -3;
    }
}

