package kr.co.compcareworker.Fragment.Enterprise.Memo;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;

import java.util.HashMap;

import kr.co.compcareworker.Activity.FragmentActivity;
import kr.co.compcareworker.Data.ArrayItem;
import kr.co.compcareworker.Data.ArrayItem_;
import kr.co.compcareworker.Data.Memo.MemoData;
import kr.co.compcareworker.R;
import kr.co.compcareworker.Util.Api.ApiClient;

@SuppressLint("ValidFragment")
public class Memo_Fragment extends Fragment {
    private Handler handler, hdr;
    String pt_idx;
    FragmentActivity fa;

    ArrayItem_<MemoData> items;

    /**
     * 상단정보
     */
    TextView tv_act_plan_detail_name, tv_act_plan_detail_office, tv_act_plan_detail_representative,
            tv_act_plan_detail_corporate_number,
            tv_act_plan_detail_address,
            tv_act_plan_detail_responsibility,
            tv_act_plan_detail_phone;

    /**
     * 메모
     */
    EditText et_act_memo_memo;

    /**
     * 프로그래스바
     */
    ProgressBar progress;

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        fa = (FragmentActivity) getActivity();
    }

    @Override
    public void onDetach() {
        super.onDetach();
        fa = null;
    }

    @SuppressLint("ValidFragment")
    public Memo_Fragment(Handler handler) {
        this.handler = handler;
    }

    public Memo_Fragment() {
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View v = inflater.inflate(R.layout.frag_memo, container, false);

        /** 상단정보*/
        tv_act_plan_detail_name = v.findViewById(R.id.tv_act_plan_detail_name);
        tv_act_plan_detail_office = v.findViewById(R.id.tv_act_plan_detail_office);
        tv_act_plan_detail_representative = v.findViewById(R.id.tv_act_plan_detail_representative);
        tv_act_plan_detail_corporate_number = v.findViewById(R.id.tv_act_plan_detail_corporate_number);
        tv_act_plan_detail_address = v.findViewById(R.id.tv_act_plan_detail_address);
        tv_act_plan_detail_responsibility = v.findViewById(R.id.tv_act_plan_detail_responsibility);
        tv_act_plan_detail_phone = v.findViewById(R.id.tv_act_plan_detail_phone);

        /** 메모*/
        et_act_memo_memo = v.findViewById(R.id.et_act_memo_memo);

        /** 프로그래스바*/
        progress = v.findViewById(R.id.progress);

        pt_idx = fa.enterpriseItem.getArrayitem().getPtIdx();

        init_Handler();
        init_Listener();

        Get_Contents();

        return v;
    }

    void Get_Contents() {
        progress.setVisibility(View.VISIBLE);
        HashMap<String, String> data = new HashMap<>();
        data.put("ag_idx", fa.userItem.getArrayitem().getAgIdx());
        data.put("pt_idx", pt_idx);
        new ApiClient(data, "proc_partner_view", hdr);
    }

    void Set_Contents() {
        tv_act_plan_detail_name.setText(items.getArrayitem().getPtName());
        tv_act_plan_detail_office.setText("");
        tv_act_plan_detail_representative.setText(items.getArrayitem().getPtCeo());
        tv_act_plan_detail_corporate_number.setText(items.getArrayitem().getPtCode());
        tv_act_plan_detail_address.setText(items.getArrayitem().getPtAddr());
        tv_act_plan_detail_responsibility.setText(items.getArrayitem().getPtMan());
        tv_act_plan_detail_phone.setText(items.getArrayitem().getPtHp());

        et_act_memo_memo.setText(items.getArrayitem().getPtMemo());
        progress.setVisibility(View.GONE);
    }

    void init_Handler() {
        hdr = new Handler() {
            @Override
            public void handleMessage(Message msg) {
                super.handleMessage(msg);

                if (msg.what == -1) {
                    Toast.makeText(getContext(), msg.obj.toString().replace("\"", ""), Toast.LENGTH_SHORT).show();

                } else if (msg.what == 1) {
                    String url = msg.getData().getString("url");
                    if (url.equals("proc_partner_view")) {
                        JsonElement element = new JsonParser().parse(msg.obj.toString());
                        JsonObject result_item = element.getAsJsonObject();
                        items = new Gson().fromJson(result_item, new TypeToken<ArrayItem_<MemoData>>() {
                        }.getType());

                        if (items.isSuccess()) {
                            Set_Contents();
                        } else {
                            Toast.makeText(getContext(), items.getMessage(), Toast.LENGTH_LONG).show();
                            getActivity().finish();
                        }
                    } else if (url.equals("proc_memo_write")) {
                        JsonElement element = new JsonParser().parse(msg.obj.toString());
                        JsonObject result_item = element.getAsJsonObject();
                        ArrayItem<MemoData> res_item = new Gson().fromJson(result_item, new TypeToken<ArrayItem<MemoData>>() {
                        }.getType());

                        Toast.makeText(getContext(), res_item.getMessage(), Toast.LENGTH_LONG).show();
                        if (res_item.isSuccess()) {
                            et_act_memo_memo.setEnabled(false);
                            fa.Set_Text();
                            Get_Contents();
                        }
                    }
                }
            }
        };
    }

    private void init_Listener() {

    }

    public void Modify_Memo(String s) {
        if (s.equals("수정")) {
            et_act_memo_memo.setEnabled(true);
            et_act_memo_memo.setFocusable(true);
            fa.Set_Text();
        } else if (s.equals("완료")) {
            HashMap<String, String> data = new HashMap<>();
            data.put("ag_idx", fa.userItem.getArrayitem().getAgIdx());
            data.put("pt_idx", pt_idx);
            data.put("pt_memo", et_act_memo_memo.getText().toString());
            new ApiClient(data, "proc_memo_write", hdr);
        }
    }
}
