package kr.co.compcareworker.Fragment.Machine;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ProgressBar;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;

import java.util.ArrayList;
import java.util.HashMap;

import kr.co.compcareworker.Activity.FragmentActivity;
import kr.co.compcareworker.Data.ArrayItem_;
import kr.co.compcareworker.Data.Company.Machine.MachineItem;
import kr.co.compcareworker.R;
import kr.co.compcareworker.Util.Adapter.PlanImageRecyclerAdapter;
import kr.co.compcareworker.Util.Api.ApiClient;
import kr.co.compcareworker.Util.Common;

@SuppressLint("ValidFragment")
public class Machine_Option_Fragment extends Fragment {

    private Handler handler;
    private FragmentActivity fa;

    private TextView option_airlineTV, option_pd_nameTV, option_pd_specTV, option_running_timeTV, option_cycle_timeTV, option_cycle_yearTV,
            option_macTV, option_set_dateTV, option_make_dateTV, option_qrTV, option_qr_use_dateTV, option_mc_delTV, option_closeTV, option_mc_lotTV;
    private RadioGroup option_remoteRG, option_operationRG, option_modeRG;
    private RadioButton option_remote_yRBtn, option_remote_nRBtn, option_ydRBtn, option_inverterRBtn, option_ecoRBtn, option_normalRBtn, option_speedRBtn;
    private RecyclerView option_photoRV;
    private String mc_idx;
    private ArrayItem_<MachineItem> machine_item;
    private Context context;
    private PlanImageRecyclerAdapter photo_adapter;
    private ArrayList<String> arr = new ArrayList<>();
    ProgressBar optionPB;

    @SuppressLint("ValidFragment")
    public Machine_Option_Fragment(Handler handler, String mc_idx) {
        this.handler = handler;
        this.mc_idx = mc_idx;
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        fa = (FragmentActivity) getActivity();
    }

    @Override
    public void onDetach() {
        super.onDetach();
        fa = null;
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View v = inflater.inflate(R.layout.frag_machine_option, container, false);

        option_airlineTV = v.findViewById(R.id.option_airlineTV);
        option_pd_nameTV = v.findViewById(R.id.option_pd_nameTV);
        option_pd_specTV = v.findViewById(R.id.option_pd_specTV);
        option_running_timeTV = v.findViewById(R.id.option_running_timeTV);
        option_cycle_timeTV = v.findViewById(R.id.option_cycle_timeTV);
        option_cycle_yearTV = v.findViewById(R.id.option_cycle_yearTV);
        option_macTV = v.findViewById(R.id.option_macTV);
        option_remoteRG = v.findViewById(R.id.option_remoteRG);
        option_remote_nRBtn = v.findViewById(R.id.option_remote_nRBtn);
        option_remote_yRBtn = v.findViewById(R.id.option_remote_yRBtn);
        option_operationRG = v.findViewById(R.id.option_operationRG);
        option_ydRBtn = v.findViewById(R.id.option_ydRBtn);
        option_inverterRBtn = v.findViewById(R.id.option_inverterRBtn);
        option_modeRG = v.findViewById(R.id.option_modeRG);
        option_ecoRBtn = v.findViewById(R.id.option_ecoRBtn);
        option_normalRBtn = v.findViewById(R.id.option_normalRBtn);
        option_speedRBtn = v.findViewById(R.id.option_speedRBtn);
        option_set_dateTV = v.findViewById(R.id.option_set_dateTV);

        option_mc_lotTV = v.findViewById(R.id.option_mc_lotTV);
        option_make_dateTV = v.findViewById(R.id.option_make_dateTV);
        option_mc_delTV = v.findViewById(R.id.option_mc_delTV);
        option_qrTV = v.findViewById(R.id.option_qrTV);
        option_qr_use_dateTV = v.findViewById(R.id.option_qr_use_dateTV);
        option_photoRV = v.findViewById(R.id.option_photoRV);
        option_closeTV = v.findViewById(R.id.option_closeTV);

        context = getActivity().getBaseContext();

        int px = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 6f, getContext().getResources().getDisplayMetrics());
        int itemHeight = (Common.getInstance().getWidth(getActivity())) - (option_photoRV.getPaddingLeft() + option_photoRV.getPaddingRight() - px * 2) / 3;

        option_photoRV.setLayoutManager(new GridLayoutManager(getContext(), 3));
        photo_adapter = new PlanImageRecyclerAdapter(getContext(), itemHeight);
        option_photoRV.setAdapter(photo_adapter);

        init_Listener();
        init_Handler();
        Get_Machine();

        return v;
    }

    void Get_Machine() {
        HashMap<String, String> data = new HashMap<>();
        data.put("mc_idx", mc_idx);
        new ApiClient(data, "proc_admin_get_machine", handler);
    }

    void Set_Content() {

        option_airlineTV.setText(Common.getInstance().isNull(machine_item.getArrayitem().getMcAirline()).toString());
        option_pd_nameTV.setText(Common.getInstance().isNull(machine_item.getArrayitem().getPdName()).toString());
        option_pd_specTV.setText(Common.getInstance().isNull(machine_item.getArrayitem().getProductData().getPdSpec()).toString());
        option_running_timeTV.setText(Common.getInstance().isNullToZero(machine_item.getArrayitem().getMcRunningtimeTotal()));
        option_cycle_timeTV.setText(Common.getInstance().isNullToZero(machine_item.getArrayitem().getMcCycle()));
        option_cycle_yearTV.setText(Common.getInstance().isNullToZero(machine_item.getArrayitem().getMcCycleYear()));

        if (machine_item.getArrayitem().getMcRemoteYn() != null && machine_item.getArrayitem().getMcRemoteYn().equals("Y")) {
            option_remote_yRBtn.setChecked(true);
        } else {
            option_remote_nRBtn.setChecked(true);
        }

        if (machine_item.getArrayitem().getMcInverterYn() != null && machine_item.getArrayitem().getMcInverterYn().equals("Y")) {
            option_inverterRBtn.setChecked(true);
        } else {
            option_ydRBtn.setChecked(true);
        }

        if (machine_item.getArrayitem().getMcInverterMode() != null && machine_item.getArrayitem().getMcInverterMode().equals("1")) {
            option_ecoRBtn.setChecked(true);

        } else if (machine_item.getArrayitem().getMcInverterMode() != null && machine_item.getArrayitem().getMcInverterMode().equals("2")) {
            option_speedRBtn.setChecked(true);

        } else {
            option_normalRBtn.setChecked(true);
        }

        option_macTV.setText(Common.getInstance().isNull(machine_item.getArrayitem().getMcIotMac()).toString());

        option_set_dateTV.setText(Common.getInstance().isNull(machine_item.getArrayitem().getMcSetdt()).toString());
        option_make_dateTV.setText(Common.getInstance().isNull(machine_item.getArrayitem().getMcMakedt()).toString());
        option_qrTV.setText(Common.getInstance().isNull(machine_item.getArrayitem().getQrCode()).toString());
        option_qr_use_dateTV.setText(Common.getInstance().isNull(machine_item.getArrayitem().getQrUseDt()).toString());
        option_mc_delTV.setText(Common.getInstance().isNull(machine_item.getArrayitem().getMcDeldt()).toString());
        option_mc_lotTV.setText(Common.getInstance().isNull(machine_item.getArrayitem().getMcLot()).toString());

        //사진 초기화
        if (machine_item.getArrayitem().getMachinePhoto() != null) {
            String manager_uri = "https://www.compcare.co.kr/uploads/machine/";
            for (int i = 0; i < machine_item.getArrayitem().getMachinePhoto().size(); i++) {
                arr.add(manager_uri + machine_item.getArrayitem().getMachinePhoto().get(i).getPfiFilename());
            }
            photo_adapter.addItem(arr);
        }
    }

    void init_Listener() {

        option_closeTV.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                getActivity().finish();
            }
        });
    }

    void init_Handler() {
        handler = new Handler() {
            @Override
            public void handleMessage(Message msg) {
                super.handleMessage(msg);
                String url = msg.getData().getString("url");

                if (msg.what == 1) {

                    if (url.equals("proc_admin_get_machine")) {
                        JsonElement element = new JsonParser().parse(msg.obj.toString());
                        JsonObject result_item = element.getAsJsonObject();
                        machine_item = new Gson().fromJson(result_item, new TypeToken<ArrayItem_<MachineItem>>() {
                        }.getType());

                        if (machine_item.isSuccess()) {
                            Set_Content();

                        } else {
                            Toast.makeText(getContext(), result_item.get("resultItem").getAsJsonObject().get("message").getAsString(), Toast.LENGTH_SHORT).show();
                        }
                    }

                } else if (msg.what == -1){
                    Toast.makeText(getContext(), msg.obj.toString(), Toast.LENGTH_SHORT).show();
                }
            }
        };
    }
}
