package kr.co.compcareworker.Util.Adapter;

import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

import kr.co.compcareworker.Activity.FragmentActivity;
import kr.co.compcareworker.Data.EstimateList.EstimateListData;
import kr.co.compcareworker.R;
import kr.co.compcareworker.Util.Common;

public class EstListRecyclerAdapter extends RecyclerView.Adapter<EstListRecyclerAdapter.ItemViewHolder> {
    Context context;
    Handler handler;

    // adapter에 들어갈 list 입니다.
    private ArrayList<EstimateListData> items = new ArrayList<>();

    public EstListRecyclerAdapter(Context context, Handler handler) {
        this.context = context;
        this.handler = handler;
    }

    @NonNull
    @Override
    public EstListRecyclerAdapter.ItemViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        // LayoutInflater를 이용하여 전 단계에서 만들었던 item.xml을 inflate 시킵니다.
        // return 인자는 ViewHolder 입니다.
        View view = LayoutInflater.from(parent.getContext()).inflate(R.layout.item_deal_list, parent, false);
        return new EstListRecyclerAdapter.ItemViewHolder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull EstListRecyclerAdapter.ItemViewHolder holder, final int position) {
        // Item을 하나, 하나 보여주는(bind 되는) 함수입니다.
        holder.onBind(items.get(position));
        holder.itemView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent intent = new Intent(context, FragmentActivity.class);
                intent.putExtra("title", "견적서");
                intent.putExtra("type", "estimate_list_detail");
                intent.putExtra("value1", items.get(position).getEsIdx());
                context.startActivity(intent);
            }
        });
    }

    @Override
    public int getItemCount() {
        // RecyclerView의 총 개수 입니다.
        return items.size();
    }

    public void addItem(ArrayList<EstimateListData> data) {
        // 외부에서 item을 추가시킬 함수입니다.
        items.clear();
        items.addAll(data);
        notifyDataSetChanged();
    }

    public void clearItem() {
        items.clear();
        notifyDataSetChanged();
    }

    // RecyclerView의 핵심인 ViewHolder 입니다.
    // 여기서 subView를 setting 해줍니다.
    class ItemViewHolder extends RecyclerView.ViewHolder {
        TextView dt, name, product, price;

        ItemViewHolder(View itemView) {
            super(itemView);
            dt = itemView.findViewById(R.id.dt);
            name = itemView.findViewById(R.id.name);
            product = itemView.findViewById(R.id.product);
            price = itemView.findViewById(R.id.price);
        }

        void onBind(EstimateListData data) {
            if (data.getInsDt() != null) {
                try {
                    SimpleDateFormat beforeSDF = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                    Date beforeDate = beforeSDF.parse(data.getInsDt());
                    SimpleDateFormat afterSDF = new SimpleDateFormat("yyyy-MM-dd");
                    String afterDate = afterSDF.format(beforeDate);
                    dt.setText(afterDate);
                } catch (Exception e) {
                    dt.setText(data.getInsDt().split(" ")[0]);
                }
            }

            name.setText(data.getCuName() + " - " + data.getCpName() + " - " + data.getCpAirline());
            product.setText(data.getItemStr());
            price.setText(Common.getInstance().moneyFormatToWon(Integer.parseInt(data.getEsPrice())) + "원");

        }
    }
}
