package kr.co.compcareworker.Util.Adapter;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import java.util.ArrayList;

import kr.co.compcareworker.Data.Company.ManagerList.ManagerData;
import kr.co.compcareworker.R;
import kr.co.compcareworker.Util.MyOnItemClick;

public class ManagerListRecyclerAdapter extends RecyclerView.Adapter<ManagerListRecyclerAdapter.ItemViewHolder> {

    Context context;
    Handler handler;
    Bundle bundle;
    MyOnItemClick callback;

    // adapter에 들어갈 list
    private ArrayList<ManagerData> items = new ArrayList<>();

    public ManagerListRecyclerAdapter(Context context, Handler handler, MyOnItemClick listener) {
        this.context = context;
        this.handler = handler;
        this.callback = listener;
    }

    @NonNull
    @Override
    public ManagerListRecyclerAdapter.ItemViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int i) {

        View v = LayoutInflater.from(viewGroup.getContext()).inflate(R.layout.item_manager, viewGroup, false);

        return new ManagerListRecyclerAdapter.ItemViewHolder(v);
    }

    @Override
    public void onBindViewHolder(@NonNull ManagerListRecyclerAdapter.ItemViewHolder itemViewHolder, int position) {

        itemViewHolder.onBind(items.get(position));

        itemViewHolder.manager_modifyBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                bundle = new Bundle();

                bundle.putString("ptm_idx", items.get(position).getPtmIdx());
                bundle.putString("department", items.get(position).getPtmDepartment());
                bundle.putString("position", items.get(position).getPtmPosition());
                bundle.putString("name", items.get(position).getPtmName());
                bundle.putString("phone", items.get(position).getPtmPhone());
                bundle.putString("email", items.get(position).getPtmEmail());
                bundle.putString("photo", items.get(position).getPtmPhoto());

                callback.onClick(bundle);
            }
        });

        ImageView manager_callIV = itemViewHolder.manager_callIV;
        manager_callIV.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                if (items.get(position).getPtmPhone() == null) {
                    Toast.makeText(context, "전화번호가 없습니다.", Toast.LENGTH_LONG).show();
                    return;
                }

                AlertDialog.Builder dialogBuilder = new AlertDialog.Builder(context);
                dialogBuilder.setTitle("콤프케어 작업자");
                dialogBuilder.setMessage("전화연결 하시겠습니까?");
                dialogBuilder.setPositiveButton("확인", new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int i) {
                        try {
                            Uri uri = Uri.parse("tel:" + items.get(position).getPtmPhone());
                            context.startActivity(new Intent("android.intent.action.DIAL", uri));
                            dialog.dismiss();
                        } catch (Exception e) {
                            Toast.makeText(context, "전화번호 형식이 올바르지 않습니다.", Toast.LENGTH_LONG).show();
                        }
                    }
                }).setNegativeButton("취소", new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int i) {
                        dialog.dismiss();
                    }
                });
                dialogBuilder.show();
            }
        });
    }

    @Override
    public long getItemId(int position) {
        return super.getItemId(position);
    }

    @Override
    public int getItemCount() {
        return items.size();
    }

    public void addItem(ArrayList<ManagerData> data) {

        // 외부에서 item을 추가시킬 함수입니다.
        items.clear();
        items.addAll(data);
        notifyDataSetChanged();
    }

    public void clearItem() {
        items.clear();
        notifyDataSetChanged();
    }

    // RecyclerView의 핵심인 ViewHolder 입니다.
    // 여기서 subView를 setting 해줍니다.
    class ItemViewHolder extends RecyclerView.ViewHolder {
        TextView manager_positionTV, manager_nameTV, manager_telTV;
        ImageView manager_callIV;
        Button manager_modifyBtn;

        ItemViewHolder(View itemView) {
            super(itemView);

            manager_positionTV = itemView.findViewById(R.id.manager_positionTV);
            manager_nameTV = itemView.findViewById(R.id.manager_nameTV);
            manager_telTV = itemView.findViewById(R.id.manager_telTV);
            manager_callIV = itemView.findViewById(R.id.manager_callIV);
            manager_modifyBtn = itemView.findViewById(R.id.manager_modifyBtn);

        }

        void onBind(ManagerData data) {

            manager_positionTV.setText(data.getPtmPosition());
            manager_nameTV.setText(data.getPtmName());
            manager_telTV.setText(data.getPtmPhone());

        }
    }
}
