package kr.co.compcareworker.Util.Adapter;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import java.util.ArrayList;

import kr.co.compcareworker.Data.Company.Machine.MachineItem;
import kr.co.compcareworker.R;

public class ProdQRListRecyclerAdapter extends RecyclerView.Adapter<ProdQRListRecyclerAdapter.ItemViewHolder> {
    Context context;
    Handler handler;

    public String mc_idx;

    // adapter에 들어갈 list 입니다.
    private ArrayList<MachineItem> items = new ArrayList<>();

    public ProdQRListRecyclerAdapter(Context context, Handler handler) {
        this.context = context;
        this.handler = handler;
    }

    @NonNull
    @Override
    public ProdQRListRecyclerAdapter.ItemViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        // LayoutInflater를 이용하여 전 단계에서 만들었던 item.xml을 inflate 시킵니다.
        // return 인자는 ViewHolder 입니다.
        View view = LayoutInflater.from(parent.getContext()).inflate(R.layout.item_prod_qr, parent, false);
        return new ProdQRListRecyclerAdapter.ItemViewHolder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull ProdQRListRecyclerAdapter.ItemViewHolder holder, final int position) {
        // Item을 하나, 하나 보여주는(bind 되는) 함수입니다.
        holder.onBind(items.get(position));
    }

    @Override
    public int getItemCount() {
        // RecyclerView의 총 개수 입니다.
        return items.size();
    }

    public void addItem(ArrayList<MachineItem> data) {
        // 외부에서 item을 추가시킬 함수입니다.
        items.clear();
        items.addAll(data);
        notifyDataSetChanged();
    }

    public void clearItem() {
        items.clear();
        notifyDataSetChanged();
    }

    // RecyclerView의 핵심인 ViewHolder 입니다.
    // 여기서 subView를 setting 해줍니다.
    class ItemViewHolder extends RecyclerView.ViewHolder {
        ImageView plus, qr;
        TextView name;
        String mc_index;

        ItemViewHolder(View itemView) {
            super(itemView);
            plus = itemView.findViewById(R.id.plus);
            qr = itemView.findViewById(R.id.qr);
            name = itemView.findViewById(R.id.name);

            plus.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    mc_idx = mc_index;
                    Message msg = new Message();
                    msg.what = 1;
                    handler.sendMessage(msg);
                }
            });
        }

        void onBind(MachineItem data) {
            name.setText(data.getProductData().getPdName());
            if (data.getQrCode() != null) {
                qr.setVisibility(View.VISIBLE);
            }

            mc_index = data.getMcIdx();
        }
    }
}
