package kr.co.compcareworker.Util.Adapter;

import android.content.Context;
import android.net.Uri;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.squareup.picasso.Picasso;

import java.util.ArrayList;

import kr.co.compcareworker.R;

public class ShootingRecyclerAdapter extends RecyclerView.Adapter<ShootingRecyclerAdapter.ItemViewHolder> {
    Context context;
    Handler handler;
    int itemHeight;

    // adapter에 들어갈 list 입니다.
    public ArrayList<String> items = new ArrayList<>();
    public ArrayList<String> dataImgNo = new ArrayList<>();
    private ArrayList<String> deleteArray = null;

    public View.OnClickListener itemClick;

    public ShootingRecyclerAdapter(Context context, Handler handler, int itemHeight) {
        this.context = context;
        this.handler = handler;
        this.itemHeight = itemHeight;
    }

    public ShootingRecyclerAdapter(Context context, Handler handler) {
        this.context = context;
        this.handler = handler;
        this.itemHeight = itemHeight;
    }

    @NonNull
    @Override
    public ShootingRecyclerAdapter.ItemViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        // LayoutInflater를 이용하여 전 단계에서 만들었던 item.xml을 inflate 시킵니다.
        // return 인자는 ViewHolder 입니다.
        View view = LayoutInflater.from(parent.getContext()).inflate(R.layout.item_shooting, parent, false);
        return new ShootingRecyclerAdapter.ItemViewHolder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull ShootingRecyclerAdapter.ItemViewHolder holder, final int position) {
        // Item을 하나, 하나 보여주는(bind 되는) 함수입니다.
        if (deleteArray == null) {
            deleteArray = new ArrayList<>();
        }

        holder.itemView.setTag(position);
        holder.itemView.setOnClickListener(itemClick);

        String item = items.get(position);
        holder.iv_item_shooting_image.getLayoutParams().height = itemHeight / 3;
        Picasso picasso = new Picasso.Builder(context).listener(new Picasso.Listener() {
            @Override
            public void onImageLoadFailed(Picasso picasso, Uri uri, Exception exception) {
                exception.printStackTrace();
            }
        }).build();
        picasso.load(item).into(holder.iv_item_shooting_image);
    }

    @Override
    public int getItemCount() {
        // RecyclerView의 총 개수 입니다.
        return items.size();
    }

    public void addItem(ArrayList<String> data) {
        // 외부에서 item을 추가시킬 함수입니다.
        items.clear();
        items.addAll(data);
        notifyDataSetChanged();
    }

    public void addMoreItem(ArrayList<String> data) {
        // 외부에서 item을 추가시킬 함수입니다.
        items.addAll(data);
        notifyDataSetChanged();
    }

    public void removeItem(int position) {
        items.remove(position);
        if (dataImgNo.size() > position) {
            dataImgNo.remove(position);
        }
        notifyDataSetChanged();
    }

    // RecyclerView의 핵심인 ViewHolder 입니다.
    // 여기서 subView를 setting 해줍니다.
    class ItemViewHolder extends RecyclerView.ViewHolder {
        ImageView iv_item_shooting_image;

        ItemViewHolder(View itemView) {
            super(itemView);
            iv_item_shooting_image = itemView.findViewById(R.id.iv_item_shooting_image);
        }

        void onBind(String data) {

        }
    }


}
