package kr.co.compcareworker.Util.Adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.RecyclerView;

import java.util.ArrayList;

import kr.co.compcareworker.Data.Company.Machine.AlMachineDatum;
import kr.co.compcareworker.Data.Company.Machine.MachineItem;
import kr.co.compcareworker.R;

public class SubProdListAdapter extends RecyclerView.Adapter<SubProdListAdapter.ItemViewHolder> {

    // adapter에 들어갈 list 입니다.
    private ArrayList<AlMachineDatum> items = new ArrayList<>();
    private Context context;

    private SubProdListAdapter.resetListener resetListener;

    public interface resetListener {
        void onClick(MachineItem data);
    }

    private SubProdListAdapter.enterpriseListener enterpriseListener;

    public interface enterpriseListener {
        void onClick(MachineItem data);
    }

        public SubProdListAdapter(Context context, SubProdListAdapter.resetListener resetListener, SubProdListAdapter.enterpriseListener enterpriseListener) {
        this.resetListener = resetListener;
        this.enterpriseListener = enterpriseListener;
        this.context = context;
    }

    @NonNull
    @Override
    public SubProdListAdapter.ItemViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from(parent.getContext()).inflate(R.layout.item_subprod_list_detail, parent, false);
        return new SubProdListAdapter.ItemViewHolder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull SubProdListAdapter.ItemViewHolder holder, int position) {
        holder.onBind(items.get(position));
        holder.adapter.addAll(items.get(position).getMachineItemsDetail());
//        holder.subprod_item_detailRV.addItemDecoration(new DividerItemDecoration(context, DividerItemDecoration.VERTICAL));

    }

    public void addAll(ArrayList<AlMachineDatum> lst) {
        items.clear();
        items.addAll(lst);
        notifyDataSetChanged();
    }

    public void addItemMore(ArrayList<AlMachineDatum> lst) {
        items.addAll(lst);
        notifyItemRangeChanged(0, items.size());
    }

    public void clearItem() {
        items.clear();
        notifyDataSetChanged();
    }

    @Override
    public int getItemCount() {
        // RecyclerView의 총 개수 입니다.
        return items.size();
    }

    // RecyclerView의 핵심인 ViewHolder 입니다.
    // 여기서 subView를 setting 해줍니다.
    class ItemViewHolder extends RecyclerView.ViewHolder {
        TextView sub_airlineTV;
        RecyclerView subprod_item_detailRV;
        SubProdListDetailAdapter adapter;

        ItemViewHolder(View itemView) {
            super(itemView);
            sub_airlineTV = itemView.findViewById(R.id.sub_airlineTV);
            subprod_item_detailRV = itemView.findViewById(R.id.subprod_item_detailRV);
            adapter = new SubProdListDetailAdapter(new SubProdListDetailAdapter.resetListener() {
                @Override
                public void onClick(MachineItem data) {
                    resetListener.onClick(data);
                }
            });
            subprod_item_detailRV.setAdapter(adapter);
        }

        void onBind(AlMachineDatum data) {
            sub_airlineTV.setText(data.getMcAirline());
        }
    }
}
