package kr.co.compcareworker.Util.Api;

import java.util.HashMap;
import java.util.Map;

import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.http.FieldMap;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.Multipart;
import retrofit2.http.POST;
import retrofit2.http.Part;
import retrofit2.http.PartMap;
import retrofit2.http.Url;

public interface ApiInterface {
    //Url(구분자) 만 주고받기
    @POST
    Call<ResponseBody> seturl(@Url String url);

    //글만 있는 형태
    @FormUrlEncoded
    @POST
    Call<ResponseBody> setdata(@Url String url, @FieldMap HashMap<String, String> data);

    //글만 있는 형태
    @FormUrlEncoded
    @POST
    Call<ResponseBody> setdata_obj(@Url String url, @FieldMap HashMap<String, Object> data);

    @Multipart
    @POST
    Call<ResponseBody> setfiles(
            @Url String url,
            @PartMap Map<String, RequestBody> data,
            @Part MultipartBody.Part[] params);

    @Multipart
    @POST
    Call<ResponseBody> setfile(
            @Url String url,
            @PartMap Map<String, RequestBody> data,
            @Part MultipartBody.Part params);

}
