package kr.co.compcareworker.Util.CustomView;

import android.content.Context;
import android.graphics.Canvas;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;

import kr.co.compcareworker.R;

public class CustomProgress extends View {
    Context context;

    LinearLayout view, pointWidth;
    ProgressBar progress;
    TextView minValue, maxValue;

    public CustomProgress(Context context) {
        super(context);
        this.context = context;
        LayoutInflater inflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        view = (LinearLayout) inflater.inflate(R.layout.custom_progress, null);
        pointWidth = view.findViewById(R.id.pointWidth);
        progress = view.findViewById(R.id.progress);
        minValue = view.findViewById(R.id.minValue);
        maxValue = view.findViewById(R.id.maxValue);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
    }

    public int getValue() {
        return progress.getProgress();
    }

    public void setValue(int value) {
        progress.setProgress(value);
        int w = view.getWidth();
        int point = w / 100 * value;
        LinearLayout.LayoutParams params = (LinearLayout.LayoutParams) pointWidth.getLayoutParams();
        params.width = point;
    }

    public void setMinValue(int value) {
        minValue.setText(value + "");
    }

    public int getMinValue() {
        try {
            return Integer.parseInt(minValue.getText().toString());
        } catch (Exception e) {
            return 0;
        }
    }

    public void setMaxValue(int value) {
        maxValue.setText(value + "");
    }

    public int getMaxValue() {
        try {
            return Integer.parseInt(maxValue.getText().toString());
        } catch (Exception e) {
            return 0;
        }
    }
}
