package kr.co.compcareworker.Util.CustomView;

import android.app.Dialog;
import android.content.Context;
import android.graphics.Color;
import android.graphics.Point;
import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.Log;
import android.view.Display;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.Window;
import android.widget.EditText;
import android.widget.ScrollView;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;

import java.util.ArrayList;
import java.util.HashMap;

import kr.co.compcareworker.Data.ArrayItem;
import kr.co.compcareworker.Data.Lately.LatelyData;
import kr.co.compcareworker.MyApplication;
import kr.co.compcareworker.R;
import kr.co.compcareworker.Util.Api.ApiClient;

public class PartnerMemoDialog extends Dialog {

    Handler hdr;
    EditText dlg_partner_memoET;
    String partner_memo, pt_name, pt_idx;
    TextView dlg_partner_nameTV, dlg_partner_modifyTV;

    private PartnerMemoDialog.PartnerMemoDialogListener partnerMemoDialogListener;

    public interface PartnerMemoDialogListener {
        void clickBtn();
    }

    public PartnerMemoDialog(@NonNull Context context, String pt_name, String partner_memo, String pt_idx, PartnerMemoDialogListener partnerMemoDialogListener) {
        super(context);
        this.pt_name = pt_name;
        this.partner_memo = partner_memo;
        this.pt_idx = pt_idx;
        this.partnerMemoDialogListener = partnerMemoDialogListener;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.dlg_partner_memo);
        getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
        Display display = getWindow().getWindowManager().getDefaultDisplay();
        Point size = new Point();
        display.getSize(size);

        Window thisWindow = this.getWindow();

        int x = (int) (size.x * 0.9f);
        int y = (int) (size.y * 0.7f);

        thisWindow.setLayout(x, y);

        dlg_partner_memoET = findViewById(R.id.dlg_partner_memoET);
        dlg_partner_nameTV = findViewById(R.id.dlg_partner_nameTV);
        dlg_partner_modifyTV = findViewById(R.id.dlg_partner_modifyTV);

        init_Handler();
        Set_Contents();
    }

    void Set_Contents() {

        if (!TextUtils.isEmpty(partner_memo)) {

            dlg_partner_memoET.setText(partner_memo);
        }

        dlg_partner_nameTV.setText(pt_name);

        dlg_partner_modifyTV.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                HashMap<String, String> data = new HashMap<>();
                data.put("pt_idx", pt_idx);
                data.put("pt_memo", dlg_partner_memoET.getText().toString());
                Log.d("데이터확인@@@", data.toString());
                new ApiClient(data, "proc_partner_memo_modify", hdr);
            }
        });
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        MyApplication.finishMonitoring = false;
        partnerMemoDialogListener.clickBtn();
        dismiss();
        return true;
    }

    @Override
    public void onBackPressed() {
        super.onBackPressed();
        MyApplication.finishMonitoring = false;
        partnerMemoDialogListener.clickBtn();
        dismiss();
    }

    void init_Handler() {

        hdr = new Handler() {
            @Override
            public void handleMessage(Message msg) {
                super.handleMessage(msg);

                if (msg.what == -1) {
                    Toast.makeText(getContext(), msg.obj.toString().replace("\"", ""), Toast.LENGTH_SHORT).show();

                } else if (msg.what == 1) {
                    String url = msg.getData().getString("url");

                    if (url != null) {
                        if (url.equals("proc_partner_memo_modify")) {

                            JsonElement element = new JsonParser().parse(msg.obj.toString());
                            JsonObject result_item = element.getAsJsonObject();

                            if (result_item.get("resultItem").getAsJsonObject().get("result").getAsString().equals("Y")) {

                                Toast.makeText(getContext(), result_item.get("resultItem").getAsJsonObject().get("message").getAsString(), Toast.LENGTH_SHORT).show();
                                partnerMemoDialogListener.clickBtn();
                                MyApplication.finishMonitoring = false;
                                dismiss();

                            } else {
                                Toast.makeText(getContext(), result_item.get("resultItem").getAsJsonObject().get("message").getAsString(), Toast.LENGTH_SHORT).show();
                                partnerMemoDialogListener.clickBtn();
                                MyApplication.finishMonitoring = false;
                                dismiss();
                            }

                        }
                    }
                }
            }
        };

    }
}
