package kr.co.compcareworker.Fragment.Enterprise.Deal_Est_List;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;

import kr.co.compcareworker.Activity.FragmentActivity;
import kr.co.compcareworker.R;
import kr.co.compcareworker.Util.Common;

@SuppressLint("ValidFragment")
public class WebImg_Fragment extends Fragment {
    private Handler handler, hdr;

    FragmentActivity fa;

    WebView webView;
    String type, webIdx, ptIdx, cpIdx;

    String webInvoiceUrl = "sell/invoice/preview/";
    String webEstimateUrl = "sell/estimate/preview/";
    String web_Url = "?mode=1&app_mode=Y";

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        fa = (FragmentActivity) getActivity();
    }

    @Override
    public void onDetach() {
        super.onDetach();
        fa = null;
    }

    @SuppressLint("ValidFragment")
    public WebImg_Fragment(Handler handler, String type, String webIdx) {
        this.handler = handler;
        this.type = type;
        this.webIdx = webIdx;
    }

    public WebImg_Fragment(Handler handler, String type, String ptIdx, String cpIdx) {
        this.handler = handler;
        this.type = type;
        this.ptIdx = ptIdx;
        this.cpIdx = cpIdx;
    }

    public WebImg_Fragment() {
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View v = inflater.inflate(R.layout.frag_webimg, container, false);

        webView = v.findViewById(R.id.webView);

        Set_Contents();

        return v;
    }

    void Set_Contents() {
        String url = "";
        if (type.equals("deal_list_detail")) {
            url = Common.getInstance().getBaseUrl(fa.userItem.getArrayitem().getAgency().getMbId()) + webInvoiceUrl;
        } else if (type.equals("estimate_list_detail")) {
            url = Common.getInstance().getBaseUrl(fa.userItem.getArrayitem().getAgency().getMbId()) + webEstimateUrl;
        }

        Log.d("1234", url + webIdx + web_Url);

        WebSettings settings = webView.getSettings();
        settings.setBuiltInZoomControls(true);
        settings.setSupportZoom(true);
        settings.setUseWideViewPort(true);
        webView.setInitialScale(1);

        webView.setWebViewClient(new WebViewClient() {
            @Override
            public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
                view.loadUrl(request.toString());
                return true;
            }
        });

        webView.setWebChromeClient(new WebChromeClient() {
            @Override
            public void onProgressChanged(WebView view, int newProgress) {
                super.onProgressChanged(view, newProgress);
            }
        });

        webView.loadUrl(url + webIdx + web_Url);

    }
}
