package kr.co.compcareworker.Fragment.Machine;

import android.annotation.SuppressLint;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.RecyclerView;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;

import org.w3c.dom.Text;

import java.util.Arrays;
import java.util.HashMap;

import kr.co.compcareworker.Activity.FragmentActivity;
import kr.co.compcareworker.Data.ArrayItem;
import kr.co.compcareworker.Data.Company.Machine.AlarmData;
import kr.co.compcareworker.Data.PlanDetail.InvoiceData;
import kr.co.compcareworker.MyApplication;
import kr.co.compcareworker.R;
import kr.co.compcareworker.Util.Adapter.AlarmListAdapter;
import kr.co.compcareworker.Util.Adapter.InvoiceListAdapter;
import kr.co.compcareworker.Util.Api.ApiClient;
import kr.co.compcareworker.Util.Common;
import kr.co.compcareworker.Util.Firebase.MyFirebaseMessagingService;

public class Invoice_List_Fragment extends Fragment {

    private FragmentActivity fa;
    private Handler hdr;
    private String cp_idx;
    private TextView invoice_pt_nameTV, invoice_cp_nameTV, invoice_total_priceTV, none_listTV;
    private RecyclerView invoice_listRV;
    private ProgressBar invoice_listPB;
    private InvoiceListAdapter adapter;

    @SuppressLint("ValidFragment")
    public Invoice_List_Fragment(Handler handler, String cp_idx) {
        this.hdr = handler;
        this.cp_idx = cp_idx;
    }

    @Override
    public void onDetach() {
        super.onDetach();
        fa = null;
        MyFirebaseMessagingService.alarmListFragment = null;
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        fa = (FragmentActivity) getActivity();
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {

        View v = inflater.inflate(R.layout.frag_invoice_list, container, false);

        invoice_pt_nameTV = v.findViewById(R.id.invoice_pt_nameTV);
        invoice_cp_nameTV = v.findViewById(R.id.invoice_cp_nameTV);
        invoice_total_priceTV = v.findViewById(R.id.invoice_total_priceTV);
        invoice_listRV = v.findViewById(R.id.invoice_listRV);
        invoice_listPB = v.findViewById(R.id.invoice_listPB);
        none_listTV = v.findViewById(R.id.none_listTV);

        adapter = new InvoiceListAdapter(getContext(), hdr);
        invoice_listRV.setAdapter(adapter);

        init_Handler();
        Get_Contents();

        return v;
    }

    void Get_Contents() {
        invoice_listPB.setVisibility(View.VISIBLE);

        HashMap<String, String> data = new HashMap<>();
        data.put("ag_idx", fa.userItem.getArrayitem().getAgIdx());
        data.put("cp_idx", cp_idx);
        new ApiClient(data, "proc_get_invoice_list", hdr);
    }

    void init_Handler() {
        hdr = new Handler() {
            @Override
            public void handleMessage(Message msg) {
                super.handleMessage(msg);

                String url = msg.getData().getString("url");

                if (msg.what == 1) {

                    if (url.equals("proc_get_invoice_list")) {
                        JsonElement element = new JsonParser().parse(msg.obj.toString());
                        JsonObject result_item = element.getAsJsonObject();
                        ArrayItem<InvoiceData> items = new Gson().fromJson(result_item, new TypeToken<ArrayItem<InvoiceData>>() {
                        }.getType());

                        if (items.isSuccess()) {
                            invoice_listRV.setItemViewCacheSize(items.size());
                            invoice_pt_nameTV.setText(items.get(0).getCuName());
                            invoice_cp_nameTV.setText("["+items.get(0).getCpName()+"]");
                            adapter.addItem(items.getArrayitem());

                            int total = 0;
                            for(int i=0; i<items.size(); i++) {
                                total += Integer.parseInt(items.get(i).getItemSupply());
                            }
                            invoice_total_priceTV.setText("총 매출 : "+Common.getInstance().moneyFormatToWon(total) + "원");

                        } else {
                            none_listTV.setVisibility(View.VISIBLE);
                            adapter.clearItem();
                        }
                    }

                } else if (msg.what == -1) {
                    Toast.makeText(getContext(), msg.obj.toString().replace("\"", ""), Toast.LENGTH_SHORT).show();
                }
                invoice_listPB.setVisibility(View.GONE);
            }
        };
    }
}

