package kr.co.compcareworker.Util.Adapter;

import android.content.Context;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

import kr.co.compcareworker.Data.EstimateList.EstimateListData;
import kr.co.compcareworker.R;
import kr.co.compcareworker.Util.Common;

public class EstimateRecyclerAdapter extends RecyclerView.Adapter<EstimateRecyclerAdapter.ItemViewHolder> {
    Context context;
    Handler handler;

    // adapter에 들어갈 list 입니다.
    private ArrayList<EstimateListData> items = new ArrayList<>();

    private EstimateRecyclerAdapter.EstimateListener estimateListener;

    public interface EstimateListener {
        void clickBtn(String es_idx);
    }

    public EstimateRecyclerAdapter(Context context, Handler handler, EstimateRecyclerAdapter.EstimateListener estimateListener) {
        this.context = context;
        this.handler = handler;
        this.estimateListener = estimateListener;
    }

    @NonNull
    @Override
    public EstimateRecyclerAdapter.ItemViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        // LayoutInflater를 이용하여 전 단계에서 만들었던 item.xml을 inflate 시킵니다.
        // return 인자는 ViewHolder 입니다.
        View view = LayoutInflater.from(parent.getContext()).inflate(R.layout.item_estimate, parent, false);
        return new EstimateRecyclerAdapter.ItemViewHolder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull EstimateRecyclerAdapter.ItemViewHolder holder, final int position) {
        // Item을 하나, 하나 보여주는(bind 되는) 함수입니다.
        holder.onBind(items.get(position));
        holder.itemView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
//                Intent intent = new Intent(context, FragmentActivity.class);
//                intent.putExtra("title", "견적서");
//                intent.putExtra("type", "estimate_list_detail");
//                intent.putExtra("value1", items.get(position).getEsIdx());
//                context.startActivity(intent);
                estimateListener.clickBtn(items.get(position).getEsIdx());
            }
        });
    }

    @Override
    public int getItemCount() {
        // RecyclerView의 총 개수 입니다.
        return items.size();
    }

    public void addItem(ArrayList<EstimateListData> data) {
        // 외부에서 item을 추가시킬 함수입니다.
        items.clear();
        items.addAll(data);
        notifyDataSetChanged();
    }

    public void clearItem() {
        items.clear();
        notifyDataSetChanged();
    }

    // RecyclerView의 핵심인 ViewHolder 입니다.
    // 여기서 subView를 setting 해줍니다.
    class ItemViewHolder extends RecyclerView.ViewHolder {
        TextView item_estimate_numTV, item_estimate_nameTV, item_estimate_sumTV, item_estimate_dateTV;

        ItemViewHolder(View itemView) {
            super(itemView);
            item_estimate_numTV = itemView.findViewById(R.id.item_estimate_numTV);
            item_estimate_nameTV = itemView.findViewById(R.id.item_estimate_nameTV);
            item_estimate_sumTV = itemView.findViewById(R.id.item_estimate_sumTV);
            item_estimate_dateTV = itemView.findViewById(R.id.item_estimate_dateTV);
        }

        void onBind(EstimateListData data) {
            if (data.getInsDt() != null) {
                try {
                    SimpleDateFormat beforeSDF = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                    Date beforeDate = beforeSDF.parse(data.getInsDt());
                    SimpleDateFormat afterSDF = new SimpleDateFormat("yyyy-MM-dd");
                    String afterDate = afterSDF.format(beforeDate);
                    item_estimate_dateTV.setText(afterDate);
                } catch (Exception e) {
                    item_estimate_dateTV.setText(data.getInsDt().split(" ")[0]);
                }
            }

            item_estimate_numTV.setText(data.getEsCode());
            item_estimate_nameTV.setText(data.getItemStr());

            String money = Common.getInstance().moneyFormatToWon(Integer.parseInt(data.getEsPrice()));
            item_estimate_sumTV.setText(money);
        }
    }
}
