package kr.co.compcareworker.Util.Adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;

import androidx.annotation.NonNull;
import androidx.viewpager.widget.PagerAdapter;

import com.squareup.picasso.Picasso;

import java.util.ArrayList;

import kr.co.compcareworker.R;


public class ImageAdapter extends PagerAdapter {

    ArrayList<String> images = new ArrayList<>();
    private LayoutInflater inflater;
    private Context context;

    public ImageAdapter(Context context, ArrayList<String> images) {
        this.context = context;
        this.images = images;
    }

    public void addItem(ArrayList<String> item) {
        images.clear();
        images.addAll(item);
        notifyDataSetChanged();
    }

    @Override
    public int getCount() {
        return images.size();
    }

    @Override
    public boolean isViewFromObject(@NonNull View view, @NonNull Object o) {
        return view == o;
    }

    @NonNull
    @Override
    public Object instantiateItem(@NonNull ViewGroup container, int position) {
        inflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        View v = inflater.inflate(R.layout.slider, container, false);
        ImageView iv = v.findViewById(R.id.img);

        if (images.get(position).equals("")) {
            iv.setImageResource(R.drawable.no_img);
        } else {
            Picasso.with(context).load(images.get(position)).into(iv);
        }

        container.addView(v);
        return v;
    }

    @Override
    public void destroyItem(@NonNull ViewGroup container, int position, @NonNull Object object) {
        container.invalidate();
    }
}
