package kr.co.compcareworker.Util.Adapter;

import android.content.Context;
import android.content.Intent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import java.net.URLEncoder;
import java.util.ArrayList;

import kr.co.compcareworker.Activity.WebviewAct;
import kr.co.compcareworker.Data.Company.Machine.MachineItem;
import kr.co.compcareworker.R;

public class MachineSubListRecyclerAdapter extends RecyclerView.Adapter<MachineSubListRecyclerAdapter.ItemViewHolder> {
    Context context;

    String agency_id, user_id;
    Boolean b = true;

    // adapter에 들어갈 list 입니다.
    private ArrayList<MachineItem> items = new ArrayList<>();

    public MachineSubListRecyclerAdapter(Context context, String agency_id, String user_id) {
        this.context = context;
        this.agency_id = agency_id;
        this.user_id = user_id;
    }

    public MachineSubListRecyclerAdapter(Context context, String agency_id, String user_id, Boolean b) {
        this.context = context;
        this.agency_id = agency_id;
        this.user_id = user_id;
        this.b = b;
    }

    @NonNull
    @Override
    public MachineSubListRecyclerAdapter.ItemViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        // LayoutInflater를 이용하여 전 단계에서 만들었던 item.xml을 inflate 시킵니다.
        // return 인자는 ViewHolder 입니다.
        View view = LayoutInflater.from(parent.getContext()).inflate(R.layout.item_machine_item_sub, parent, false);
        return new MachineSubListRecyclerAdapter.ItemViewHolder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull MachineSubListRecyclerAdapter.ItemViewHolder holder, final int position) {
        // Item을 하나, 하나 보여주는(bind 되는) 함수입니다.
        holder.onBind(items.get(position));
    }

    @Override
    public int getItemCount() {
        // RecyclerView의 총 개수 입니다.
        return items.size();
    }

    public void addItem(ArrayList<MachineItem> data) {
        // 외부에서 item을 추가시킬 함수입니다.
        items.clear();
        items.addAll(data);
        notifyDataSetChanged();
    }

    public void clearItem() {
        items.clear();
        notifyDataSetChanged();
    }

    // RecyclerView의 핵심인 ViewHolder 입니다.
    // 여기서 subView를 setting 해줍니다.
    class ItemViewHolder extends RecyclerView.ViewHolder {
        ImageView qr;
        TextView expend, name;
        LinearLayout imgFrame;
        String pt_idx, cp_idx, mc_idx;

        ItemViewHolder(View itemView) {
            super(itemView);
            expend = itemView.findViewById(R.id.expend);
            qr = itemView.findViewById(R.id.qr);
            name = itemView.findViewById(R.id.name);
            imgFrame = itemView.findViewById(R.id.imgFrame);
            if (!b) {
                imgFrame.setVisibility(View.GONE);
            }

            expend.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    String incodeUrl = URLEncoder.encode("https://" + agency_id + ".compcare.co.kr/setting/serial/write_machine/" + mc_idx + "?cp_idx=" + cp_idx + "&pt_idx=" + pt_idx);
                    Intent intent = new Intent(context, WebviewAct.class);
                    intent.putExtra("title", "보유기종 관리");
                    intent.putExtra("url", "https://" + agency_id + ".compcare.co.kr/api/web/" + user_id + "/?url=" + incodeUrl);
                    context.startActivity(intent);
                }
            });
        }

        void onBind(MachineItem data) {
            name.setText(data.getProductData().getPdName());
            if (data.getQrCode() != null) {
                qr.setVisibility(View.VISIBLE);
            }

            pt_idx = data.getPtIdx();
            cp_idx = data.getCpIdx();
            mc_idx = data.getMcIdx();
        }
    }
}
