package kr.co.compcareworker.Util.Adapter;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import java.text.ParseException;
import java.util.ArrayList;

import kr.co.compcareworker.Data.Company.Machine.MachineItem;
import kr.co.compcareworker.Data.Company.Machine.Product.MonitoringData;
import kr.co.compcareworker.R;
import kr.co.compcareworker.Util.Common;
import kr.co.compcareworker.Util.ConvertTimeZone;

public class MonitoringAdapter extends RecyclerView.Adapter<MonitoringAdapter.ItemViewHolder> {

    Context context;
    String type, chart_type;
    MachineItem machineItem;

    private ArrayList<MonitoringData> items = new ArrayList<>();

    public MonitoringAdapter(Context context, String type, String chart_type, MachineItem machineItem) {
        this.context = context;
        this.type = type;
        this.chart_type = chart_type;
        this.machineItem = machineItem;
    }

    @NonNull
    @Override
    public MonitoringAdapter.ItemViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int i) {
        View v = LayoutInflater.from(viewGroup.getContext()).inflate(R.layout.item_monitoring, viewGroup, false);
        return new MonitoringAdapter.ItemViewHolder(v);
    }

    @Override
    public void onBindViewHolder(@NonNull MonitoringAdapter.ItemViewHolder itemViewHolder, int position) {
        try {
            itemViewHolder.onBind(items.get(position));
        } catch (ParseException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getItemCount() {
        return items.size();
    }

    public void addItems(ArrayList<MonitoringData> data) {

        items.clear();
        items.addAll(data);
        notifyDataSetChanged();
    }

    class ItemViewHolder extends RecyclerView.ViewHolder {

        TextView monitor_dateTV, monitor_valueTV;
        ImageView monitor_conditionIV;
        LinearLayout monitorLL;

        ItemViewHolder(View itemView) {
            super(itemView);

            monitor_dateTV = itemView.findViewById(R.id.monitor_dateTV);
            monitor_valueTV = itemView.findViewById(R.id.monitor_valueTV);
            monitor_conditionIV = itemView.findViewById(R.id.monitor_conditionIV);
            monitorLL = itemView.findViewById(R.id.monitorLL);
        }

        void onBind(MonitoringData data) throws ParseException {

            ConvertTimeZone timeZone = new ConvertTimeZone();
            String time = "";

            if (TextUtils.isEmpty(type) || (type.equals("day"))) {
                time = timeZone.convertKoreaTimeS(data.getTime());

            } else if (type.equals("week") || type.equals("month")) {
                time = timeZone.convertKoreaTimeD(data.getTime());
            }

            String set_data;
            String value = "";
            String max_value = "";
            String unit = "";
            String up = null;
            String down = null;

            switch (chart_type) {

                case "power_consumption":
                    if (data.getPowerConsumption() != null) {
                        String consumption = Common.getInstance().isNullToZero(data.getPowerConsumption());
                        float val = Float.parseFloat(Common.getInstance().valueConvert1(consumption));

                        if (val > 1000) {
                            value = (int) (val / 1000) + "";
                        } else {
                            value = "0";
                        }
                        unit = " kW";
                    } else {
                        value = "0";
                    }

                    max_value = "100";
                    up = "100000";
                    down = "100000";
                    break;

                case "current1":
                    if (data.getCurrent1() != null && !data.getCurrent1().equals("0")) {
                        value = Common.getInstance().valueConvert(data.getCurrent1());
                        unit = " A";

                    } else {
                        value = null;
                        unit = "";
                    }

                    if (machineItem.getMcCurrent1Max() != null && !machineItem.getMcCurrent1Max().equals("0")) {
                        max_value = machineItem.getMcCurrent1Max();

                    } else {
                        max_value = "75";
                    }

                    up = machineItem.getMcCurrent1Up();
                    down = machineItem.getMcCurrent1Down();

                    break;

                case "current2":
                    if (data.getCurrent2() != null && !data.getCurrent2().equals("0")) {
                        value = Common.getInstance().valueConvert(data.getCurrent2());
                        unit = " A";

                    } else {
                        value = null;
                        unit = "";
                    }

                    if (machineItem.getMcCurrent2Max() != null && !machineItem.getMcCurrent2Max().equals("0")) {
                        max_value = machineItem.getMcCurrent2Max();

                    } else {
                        max_value = "75";
                    }

                    up = machineItem.getMcCurrent2Up();
                    down = machineItem.getMcCurrent2Down();
                    break;

                case "current3":
                    if (data.getCurrent3() != null && !data.getCurrent3().equals("0")) {
                        value = Common.getInstance().valueConvert(data.getCurrent3());
                        unit = " A";

                    } else {
                        value = null;
                        unit = "";
                    }

                    if (machineItem.getMcCurrent3Max() != null && !machineItem.getMcCurrent3Max().equals("0")) {
                        max_value = machineItem.getMcCurrent3Max();

                    } else {
                        max_value = "75";
                    }

                    up = machineItem.getMcCurrent3Up();
                    down = machineItem.getMcCurrent3Down();
                    break;

                case "temperaturePt":
                    if (data.getTempPt100() != null && !data.getTempPt100().equals("0")) {
                        value = Common.getInstance().valueConvert(data.getTempPt100());
                        unit = " ℃";

                    } else {
                        value = null;
                        unit = "";
                    }

                    if (machineItem.getMcTempPtMax() != null && !machineItem.getMcTempPtMax().equals("0")) {
                        max_value = machineItem.getMcTempPtMax();

                    } else {
                        max_value = "120";
                    }

                    up = machineItem.getMcTempPtUp();
                    down = machineItem.getMcTempPtDown();
                    break;

                case "temperatureNtc":
                    if (data.getTempNtc() != null && !data.getTempNtc().equals("0")) {
                        value = Common.getInstance().valueConvert(data.getTempNtc());
                        unit = " ℃";

                    } else {
                        value = null;
                        unit = "";
                    }
                    if (machineItem.getMcTempNtcMax() != null && !machineItem.getMcTempNtcMax().equals("0")) {
                        max_value = machineItem.getMcTempNtcMax();

                    } else {
                        max_value = "120";
                    }

                    up = machineItem.getMcTempNtcUp();
                    down = machineItem.getMcTempNtcDown();
                    break;

                case "temperatureNtc2":
                    if (data.getTempNtc2() != null && !data.getTempNtc2().equals("0")) {
                        value = Common.getInstance().valueConvert(data.getTempNtc2());
                        unit = " ℃";

                    } else {
                        value = null;
                        unit = "";
                    }
                    if (machineItem.getMcTempNtc2Max() != null && !machineItem.getMcTempNtc2Max().equals("0")) {
                        max_value = machineItem.getMcTempNtc2Max();

                    } else {
                        max_value = "120";
                    }

                    up = machineItem.getMcTempNtc2Up();
                    down = machineItem.getMcTempNtc2Down();
                    break;

                case "pressure1":
                    if (data.getPressure1() != null && !data.getPressure1().equals("0")) {
                        value = Common.getInstance().valueConvert1(data.getPressure1());
                        unit = " Bar";

                    } else {
                        value = null;
                        unit = "";
                    }

                    if (machineItem.getMcPressure1Max() != null && !machineItem.getMcPressure1Max().equals("0")) {
                        max_value = machineItem.getMcPressure1Max();

                    } else {
                        max_value = "10";
                    }

                    up = machineItem.getMcPressure1Up();
                    down = machineItem.getMcPressure1Down();
                    break;

                case "pressure2":
                    if (data.getPressure2() != null && !data.getPressure2().equals("0")) {
                        value = Common.getInstance().valueConvert1(data.getPressure2());
                        unit = " Bar";

                    } else {
                        value = null;
                        unit = "";
                    }

                    if (machineItem.getMcPressure2Max() != null && !machineItem.getMcPressure2Max().equals("0")) {
                        max_value = machineItem.getMcPressure2Max();

                    } else {
                        max_value = "10";
                    }

                    up = machineItem.getMcPressure2Up();
                    down = machineItem.getMcPressure2Down();
                    break;

                case "pressure3":
                    if (data.getPressure3() != null && !data.getPressure3().equals("0")) {
                        value = Common.getInstance().valueConvert1(data.getPressure3());
                        unit = " Bar";

                    } else {
                        value = null;
                        unit = "";
                    }

                    if (machineItem.getMcPressure2Max() != null && !machineItem.getMcPressure2Max().equals("0")) {
                        max_value = machineItem.getMcPressure2Max();

                    } else {
                        max_value = "10";
                    }

                    up = machineItem.getMcPressure3Up();
                    down = machineItem.getMcPressure3Down();
                    break;

                default:
                    value = null;
                    max_value = "0";
            }

            set_data = "[" + value + unit + "]";

            if (value != null && max_value != null && !chart_type.equals("power_consumption")) {
                Common.getInstance().condition_status(monitor_conditionIV, value, max_value, chart_type, up, down);
            }

            monitor_dateTV.setText(time);
            monitor_valueTV.setText(set_data);

        }
    }
}
