package kr.co.compcareworker.Util.Adapter;

import android.app.Activity;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import java.util.ArrayList;

import kr.co.compcareworker.Data.MainViewList.OldProdData;
import kr.co.compcareworker.R;


public class OldProdRecyclerAdapter extends RecyclerView.Adapter<OldProdRecyclerAdapter.ItemViewHolder> {

    private Activity activity;
    Handler handler;
    // adapter에 들어갈 list 입니다.
    private ArrayList<OldProdData> items = new ArrayList<>();

    private OnLoadMoreListener onLoadMoreListener;

    public interface OnLoadMoreListener {
        void onLoadMore(int position);
    }

    private OldProdRecyclerAdapter.OnClickListener onClickListener;

    public interface OnClickListener {
        void onClick(String x, String y);
    }

    public OldProdRecyclerAdapter(Activity activity, Handler handler, OnLoadMoreListener onLoadMoreListener, OldProdRecyclerAdapter.OnClickListener onClickListener) {
        this.onLoadMoreListener = onLoadMoreListener;
        this.onClickListener = onClickListener;
        this.activity = activity;
        this.handler = handler;
    }

    @NonNull
    @Override
    public ItemViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from(parent.getContext()).inflate(R.layout.item_oldprod_list, parent, false);
        return new OldProdRecyclerAdapter.ItemViewHolder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull OldProdRecyclerAdapter.ItemViewHolder holder, int position) {
        holder.onBind(items.get(position));

        if (position == getItemCount() - 1) {
            if (onLoadMoreListener != null) {
                onLoadMoreListener.onLoadMore(position);
            }
        }

        holder.itemView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onClickListener.onClick(items.get(position).getCpMapx(), items.get(position).getCpMapy());
            }
        });
    }

    public void addAll(ArrayList<OldProdData> lst) {
        items.clear();
        items.addAll(lst);
        notifyDataSetChanged();
    }

    public void addItemMore(ArrayList<OldProdData> lst) {
        items.addAll(lst);
        notifyItemRangeChanged(0, items.size());
    }

    public void clearItem() {
        items.clear();
        notifyDataSetChanged();
    }

    @Override
    public int getItemCount() {
        // RecyclerView의 총 개수 입니다.
        return items.size();
    }

    // RecyclerView의 핵심인 ViewHolder 입니다.
    // 여기서 subView를 setting 해줍니다.
    class ItemViewHolder extends RecyclerView.ViewHolder {
        TextView name, dt, setDt, status, mcName;
        String cp_idx;

        ItemViewHolder(View itemView) {
            super(itemView);
            name = itemView.findViewById(R.id.name);
            dt = itemView.findViewById(R.id.dt);
            setDt = itemView.findViewById(R.id.setDt);
            status = itemView.findViewById(R.id.status);
            mcName = itemView.findViewById(R.id.mcName);

//            itemView.setOnClickListener(new View.OnClickListener() {
//                @Override
//                public void onClick(View v) {
////                    Intent intent = new Intent(activity, FragmentActivity.class);
////                    intent.putExtra("title", "설치장소 정보");
////                    intent.putExtra("type", "enterprise");
////                    intent.putExtra("value1", cp_idx);
////                    activity.startActivity(intent);
////                    activity.finish();
//                }
//            });
        }

        void onBind(OldProdData data) {
            name.setText(data.getPtName());
            dt.setText(data.getMcMakedt());

            if (data.getMcSetdt() != null) {
                setDt.setText(data.getMcSetdt().toString());
            } else {
                setDt.setText("-");
            }
            status.setText(data.getWaitStr());
            mcName.setText(data.getPdName());
            cp_idx = data.getCpIdx();
        }
    }
}
