package kr.co.compcareworker.Util.Adapter;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.net.Uri;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.LinearLayout;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.bumptech.glide.Glide;
import com.ortiz.touchview.TouchImageView;
import com.squareup.picasso.Picasso;

import java.util.ArrayList;
import java.util.Objects;

import kr.co.compcareworker.Data.ImageList.FileDatum;
import kr.co.compcareworker.R;

public class ServiceImageGridAdapter extends RecyclerView.Adapter<ServiceImageGridAdapter.ItemViewHolder> {

    ArrayList<FileDatum> items = new ArrayList<>();
    Context context;

    public ServiceImageGridAdapter(Context context) {
        this.context = context;
    }

    @NonNull
    @Override
    public ServiceImageGridAdapter.ItemViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int i) {

        View view = LayoutInflater.from(viewGroup.getContext()).inflate(R.layout.item_service_image_grid, viewGroup, false);

        return new ServiceImageGridAdapter.ItemViewHolder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull ServiceImageGridAdapter.ItemViewHolder itemViewHolder, @SuppressLint("RecyclerView") int position) {

        itemViewHolder.onBind(items.get(position));

        DisplayMetrics displayMetrics = new DisplayMetrics();
        ((Activity) itemViewHolder.itemView.getContext()).getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);

        int deviceWidth = displayMetrics.widthPixels - 130;  // 핸드폰의 가로 해상도를 구함.

        deviceWidth = deviceWidth / 5;
        int deviceHeight = deviceWidth;

        itemViewHolder.itemView.getLayoutParams().width = deviceWidth;
        itemViewHolder.itemView.getLayoutParams().height = deviceHeight;
        itemViewHolder.itemView.requestLayout(); // 변경 사항 적용

        itemViewHolder.serviceIV.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                AlertDialog.Builder dialogBuilder = new AlertDialog.Builder(context, R.style.Transparent);
                AlertDialog dig = dialogBuilder.create();
                dig.getWindow().addFlags(WindowManager.LayoutParams.FLAG_BLUR_BEHIND);

                View view = LayoutInflater.from(context).inflate(R.layout.dlg_image, null);
                TouchImageView iv = view.findViewById(R.id.imageview);
                dig.setView(view);

                Glide.with(Objects.requireNonNull(context)).load(Uri.parse(items.get(position).getUrl())).into(iv);
                dig.show();

                iv.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        dig.dismiss();
                    }
                });
            }
        });
    }

    @Override
    public long getItemId(int position) {
        return super.getItemId(position);
    }

    @Override
    public int getItemCount() {
        return items.size();
    }

    public void addItem(ArrayList<FileDatum> data) {

        // 외부에서 item을 추가시킬 함수입니다.
        items.clear();
        items.addAll(data);
        notifyDataSetChanged();
    }

    public void clearItem() {
        items.clear();
        notifyDataSetChanged();
    }

    public class ItemViewHolder extends RecyclerView.ViewHolder {

        ImageView serviceIV;
        LinearLayout serviceLL;

        public ItemViewHolder(@NonNull View itemView) {
            super(itemView);
            serviceIV = itemView.findViewById(R.id.serviceIV);
            serviceLL = itemView.findViewById(R.id.serviceLL);
        }

        void onBind(FileDatum data) {

            //Glide.with(Objects.requireNonNull(context)).load(Uri.parse(data.getUrl())).into(serviceIV);
            Picasso.with(context).load(data.getUrl()).resize(200, 200).into(serviceIV);

        }
    }
}
