package kr.co.compcareworker.Util;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.media.MediaScannerConnection;
import android.os.Build;
import android.os.Environment;
import android.util.LruCache;
import android.view.View;
import android.widget.ScrollView;

import androidx.recyclerview.widget.RecyclerView;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class CaptureUtils {    // 캡쳐가 저장될 외부 저장소

    private static final String CAPTURE_PATH = "/CompcareReport";

    /**
     * 특정 뷰만 캡쳐     * @param View
     */
    public static void captureView(View View) {
        View.buildDrawingCache();
        Bitmap captureView = View.getDrawingCache();
        FileOutputStream fos;
        String strFolderPath = Environment.getExternalStorageDirectory().getAbsolutePath() + CAPTURE_PATH;
        File folder = new File(strFolderPath);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        String strFilePath = strFolderPath + "/" + System.currentTimeMillis() + ".jpg";
        File fileCacheItem = new File(strFilePath);
        try {
            fos = new FileOutputStream(fileCacheItem);
            captureView.compress(Bitmap.CompressFormat.JPEG, 100, fos);
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void captureView(ScrollView View, Context context) {
        View.buildDrawingCache();
        Bitmap captureView = get_bitmap(View);
        FileOutputStream fos;

        File folder = commonDocumentDirPath(CAPTURE_PATH);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        File fileCacheItem = new File(folder,  System.currentTimeMillis() + ".jpg");
        try {
            fos = new FileOutputStream(fileCacheItem);
            captureView.compress(Bitmap.CompressFormat.JPEG, 100, fos);
            galleryAddPic(fileCacheItem.getPath(), context);
            Common.getInstance().toastShow(context, "레포트를 사진첩에 저장했습니다");
        } catch (FileNotFoundException e) {
            Common.getInstance().toastShow(context, "레포트 저장에 실패했습니다");
            e.printStackTrace();
        }
    }

    //갤러리 갱신
    private static void galleryAddPic(String Image_Path, Context context) {
        File file = new File(Image_Path);
        MediaScannerConnection.scanFile(context,
                new String[]{file.toString()},
                null, null);
    }

    //android version 에 따른 file 생성
    public static File commonDocumentDirPath(String FolderName) {
        File dir;
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.R)
            dir = new File(Environment.getExternalStoragePublicDirectory(Environment.DIRECTORY_DOCUMENTS) + "/" + FolderName);
        else
            dir = new File(Environment.getExternalStorageDirectory() + "/" + FolderName);

        // Make sure the path directory exists.
        if (!dir.exists()) {
            // Make it, if it doesn't exit
            boolean success = dir.mkdirs();
            if (!success) {
                dir = null;
            }
        }
        return dir;
    }

    private static Bitmap get_bitmap(ScrollView view) {
        int height = 0;
        for (int i = 0; i < view.getChildCount(); i++) {
            height += view.getChildAt(i).getHeight();
        }

        Bitmap bitmap = Bitmap.createBitmap(view.getWidth(), height, Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        Drawable background = view.getBackground();

        if (background!=null) background.draw(canvas);
        else canvas.drawColor(Color.WHITE);
        view.draw(canvas);
        return bitmap;
    }

    /**
     * 액티비티 전체 캡쳐     * @param context
     */
    public static void captureActivity(Activity context) throws IOException {
        if (context == null) return;
        View root = context.getWindow().getDecorView().getRootView();
        root.setDrawingCacheEnabled(true);
        root.buildDrawingCache();        // 루트뷰의 캐시를 가져옴
        Bitmap screenshot = root.getDrawingCache();        // get view coordinates
        int[] location = new int[2];
        root.getLocationInWindow(location);        // 이미지를 자를 수 있으나 전체 화면을 캡쳐 하도록 함
        Bitmap bmp = Bitmap.createBitmap(screenshot, location[0], location[1], root.getWidth(), root.getHeight(), null, false);

        String path= context.getExternalCacheDir()+"/DCIM/CompcareReport" + System.currentTimeMillis() + ".jpg";
        File file=new File(path);

        if (!file.exists()) {
            file.mkdirs();
        }

        File file_stream = new File(context.getExternalCacheDir()+"/DCIM/CompcareReport" + System.currentTimeMillis() + ".jpg");

        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file_stream);
            bmp.compress(Bitmap.CompressFormat.JPEG, 100, out);
            out.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 리사이클러뷰 전체스크롤 캡쳐     * @param view     * @param bgColor
     */
    public static void captureRecyclerView(RecyclerView view, int bgColor) {
        if (view == null) return;
        captureMyRecyclerView(view, bgColor, 0, view.getAdapter().getItemCount() - 1);
    }

    /**
     * 리사이클러뷰 범위 캡쳐     * @param view     * @param bgColor     * @param startPosition     * @param endPosition
     */
    public static void captureRecyclerView(RecyclerView view, int bgColor, int startPosition, int endPosition) {
        if (view == null) return;
        captureMyRecyclerView(view, bgColor, startPosition, endPosition);
    }

    private static void captureMyRecyclerView(RecyclerView view, int bgColor, int startPosition, int endPosition) {
        RecyclerView.Adapter adapter = view.getAdapter();
        Bitmap bigBitmap = null;
        if (adapter != null) {
            if (startPosition > endPosition) {
                int tmp = endPosition;
                endPosition = startPosition;
                startPosition = tmp;
            }
            int size = endPosition - startPosition;
            int height = 0;
            Paint paint = new Paint();
            int iHeight = 0;
            final int maxMemory = (int) (Runtime.getRuntime().maxMemory() / 1024);
            final int cacheSize = maxMemory / 8;
            LruCache<String, Bitmap> bitmaCache = new LruCache<>(cacheSize);
            for (int i = startPosition; i < endPosition + 1; i++) {
                RecyclerView.ViewHolder holder = adapter.createViewHolder(view, adapter.getItemViewType(i));
                adapter.onBindViewHolder(holder, i);
                holder.itemView.measure(View.MeasureSpec.makeMeasureSpec(view.getWidth(), View.MeasureSpec.EXACTLY), View.MeasureSpec.makeMeasureSpec(0, View.MeasureSpec.UNSPECIFIED));
                holder.itemView.layout(0, 0, holder.itemView.getMeasuredWidth(), holder.itemView.getMeasuredHeight());
                holder.itemView.setDrawingCacheEnabled(true);
                holder.itemView.buildDrawingCache();
                if (bgColor != 0) holder.itemView.setBackgroundColor(bgColor);
                Bitmap drawingCache = holder.itemView.getDrawingCache();
                if (drawingCache != null) {
                    bitmaCache.put(String.valueOf(i), drawingCache);
                }
                height += holder.itemView.getMeasuredHeight();
            }
            bigBitmap = Bitmap.createBitmap(view.getMeasuredWidth(), height, Bitmap.Config.ARGB_8888);
            Canvas bigCanvas = new Canvas(bigBitmap);
            bigCanvas.drawColor(Color.WHITE);
            for (int i = 0; i < size + 1; i++) {
                Bitmap bitmap = bitmaCache.get(String.valueOf(i));
                bigCanvas.drawBitmap(bitmap, 0f, iHeight, paint);
                iHeight += bitmap.getHeight();
                bitmap.recycle();
            }
        }
        String strFolderPath = Environment.getExternalStorageDirectory().getAbsolutePath() + CAPTURE_PATH;
        File folder = new File(strFolderPath);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        String strFilePath = strFolderPath + "/" + System.currentTimeMillis() + ".png";
        File fileCacheItem = new File(strFilePath);
        OutputStream out = null;
        try {
            fileCacheItem.createNewFile();
            out = new FileOutputStream(fileCacheItem);
            bigBitmap.compress(Bitmap.CompressFormat.PNG, 100, out);
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            try {
                out.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}
