package kr.co.compcareworker.Util.CustomView;

import android.app.Dialog;
import android.content.Context;
import android.graphics.Color;
import android.graphics.Point;
import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.ArraySet;
import android.util.Log;
import android.view.Display;
import android.view.View;
import android.view.Window;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.EditText;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;

import java.util.Arrays;
import java.util.HashMap;

import kr.co.compcareworker.Data.ArrayItem;
import kr.co.compcareworker.Data.Company.ManagerList.ManagerData;
import kr.co.compcareworker.R;
import kr.co.compcareworker.Util.Adapter.MemberCallListAdapter;
import kr.co.compcareworker.Util.Api.ApiClient;
import kr.co.compcareworker.Util.Common;

public class MemberCallListDialog extends Dialog {

    Context context;
    private String pt_idx;
    private Handler hdr;
    private RecyclerView cp_member_listRV;
    private TextView cp_member_noneTV, dlg_closeTV;
    private ArrayItem<ManagerData> items;
    private MemberCallListAdapter adapter;

    public MemberCallListDialog(@NonNull Context context, Handler hdr, String pt_idx) {
        super(context);
        this.context = context;
        this.hdr = hdr;
        this.pt_idx = pt_idx;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        requestWindowFeature(Window.FEATURE_NO_TITLE);
        getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
        setContentView(R.layout.dlg_company_member_list);

        Display display = getWindow().getWindowManager().getDefaultDisplay();
        Point size = new Point();
        display.getSize(size);

        Window thisWindow = this.getWindow();

        int x = (int) (size.x * 0.95f);
        int y = (int) (size.y * 0.90f);

        thisWindow.setLayout(x, y);

        cp_member_listRV = findViewById(R.id.cp_member_listRV);
        cp_member_noneTV = findViewById(R.id.cp_member_noneTV);
        dlg_closeTV = findViewById(R.id.dlg_closeTV);
        adapter = new MemberCallListAdapter(context, hdr);
        cp_member_listRV.setAdapter(adapter);

        init_Handler();
        init_Listener();
        Get_Contents();
    }

    void init_Listener() {

        dlg_closeTV.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                dismiss();
            }
        });

    }

    void Get_Contents() {

        HashMap<String, String> data = new HashMap<>();
        data.put("pt_idx", pt_idx);
        new ApiClient(data, "proc_partner_men_view", hdr);
    }

    void init_Handler() {

        hdr = new Handler() {
            @Override
            public void handleMessage(Message msg) {
                super.handleMessage(msg);
                String url = msg.getData().getString("url");

                if (msg.what == 1) {

                    if (url.equals("proc_partner_men_view")) {
                        JsonElement element = new JsonParser().parse(msg.obj.toString());
                        JsonObject result_item = element.getAsJsonObject();
                        items = new Gson().fromJson(result_item, new TypeToken<ArrayItem<ManagerData>>() {
                        }.getType());

                        if (items.isSuccess()) {
                            cp_member_noneTV.setVisibility(View.GONE);
                            adapter.addItem(items.getArrayitem());

                        } else {
                            cp_member_noneTV.setVisibility(View.VISIBLE);
                        }
                    }

                } else if (msg.what == -1){
                    Toast.makeText(getContext(), msg.obj.toString(), Toast.LENGTH_SHORT).show();
                    cp_member_noneTV.setVisibility(View.VISIBLE);
                }
            }
        };
    }
}

