package kr.co.compcareworker.Util.CustomView;

import android.app.Dialog;
import android.content.Context;
import android.graphics.Color;
import android.graphics.Point;
import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.view.Display;
import android.view.View;
import android.view.Window;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;

import java.util.HashMap;

import kr.co.compcareworker.Data.ArrayItem;
import kr.co.compcareworker.Data.Company.Machine.Product.ProductData;
import kr.co.compcareworker.R;
import kr.co.compcareworker.Util.Adapter.SearchMachineAdapter;
import kr.co.compcareworker.Util.Api.ApiClient;
import kr.co.compcareworker.Util.Common;

public class SearchMachineDialog extends Dialog {

    Context context;
    private String ag_idx, product;
    private Handler hdr;
    private TextView dlg_machine_search_noneTV;
    private EditText dlg_machine_search_productET;
    private ImageView dlg_machine_search_productIV;
    private RecyclerView dlg_search_machineRV;
    private SearchMachineAdapter machineAdapter;
    private ArrayItem<ProductData> product_array;
    ArrayItem<ProductData> product_items;

    private SearchMachineDialog.clickListener clickListener;

    public interface clickListener {
        void clickBtn(HashMap<String, ProductData> data);
    }

    public SearchMachineDialog(@NonNull Context context, Handler hdr, String ag_idx, String product, ArrayItem<ProductData> product_items, SearchMachineDialog.clickListener clickListener) {
        super(context);
        this.context = context;
        this.hdr = hdr;
        this.ag_idx = ag_idx;
        this.product = product;
        this.product_items = product_items;
        this.clickListener = clickListener;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        requestWindowFeature(Window.FEATURE_NO_TITLE);
        getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
        setContentView(R.layout.dlg_search_machine);

        Display display = getWindow().getWindowManager().getDefaultDisplay();
        Point size = new Point();
        display.getSize(size);

        Window thisWindow = this.getWindow();

        int x = (int) (size.x * 0.95f);
        int y = (int) (size.y * 0.90f);

        thisWindow.setLayout(x, y);

        dlg_machine_search_productET = findViewById(R.id.dlg_machine_search_productET);
        dlg_machine_search_productIV = findViewById(R.id.dlg_machine_search_productIV);
        dlg_search_machineRV = findViewById(R.id.dlg_search_machineRV);
        dlg_machine_search_noneTV = findViewById(R.id.dlg_machine_search_noneTV);

        LinearLayoutManager layoutManager = new LinearLayoutManager(getContext());
        layoutManager.setReverseLayout(true);
        layoutManager.setStackFromEnd(true);
        dlg_search_machineRV.setLayoutManager(layoutManager);
        machineAdapter = new SearchMachineAdapter(getContext(), new SearchMachineAdapter.clickListener() {
            @Override
            public void clickBtn(HashMap<String, ProductData> data) {
                clickListener.clickBtn(data);
                dismiss();
            }
        });
        dlg_machine_search_productET.setText(product);
        dlg_search_machineRV.setAdapter(machineAdapter);

        machineAdapter.addItem(product_items.getArrayitem());
        dlg_machine_search_noneTV.setVisibility(View.GONE);

        init_Handler();
        init_Listener();
    }

    void Get_Machine() {
        HashMap<String, String> data = new HashMap<>();
        data.put("ag_idx", ag_idx);
        data.put("pd_name", product);
        data.put("type", "COMPANY");
        new ApiClient(data, "proc_admin_search_machine", hdr);
    }

    void init_Listener() {

        //검색버튼 클릭 리스너
        dlg_machine_search_productIV.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                product = dlg_machine_search_productET.getText().toString();

                if (TextUtils.isEmpty(product)) {
                    Common.getInstance().toastShow(getContext(), "찾는 기종명을 입력해주세요.");
                    return;
                }

                Get_Machine();
            }
        });
    }

    void init_Handler() {

        hdr = new Handler() {
            @Override
            public void handleMessage(Message msg) {
                super.handleMessage(msg);
                String url = msg.getData().getString("url");

                if (msg.what == 1) {

                    if (url.equals("proc_admin_search_machine")) {
                        JsonElement element = new JsonParser().parse(msg.obj.toString());
                        JsonObject result_item = element.getAsJsonObject();
                        product_array = new Gson().fromJson(result_item, new TypeToken<ArrayItem<ProductData>>() {
                        }.getType());

                        if (product_array.isSuccess()) {

                            machineAdapter.addItem(product_array.getArrayitem());
                            dlg_machine_search_noneTV.setVisibility(View.GONE);

                        } else {
                            Toast.makeText(getContext(), msg.obj.toString().replace("\"", ""), Toast.LENGTH_SHORT).show();
                            dlg_machine_search_noneTV.setVisibility(View.VISIBLE);
                        }
                    }

                } else if (msg.what == -1){
                    Toast.makeText(getContext(), msg.obj.toString(), Toast.LENGTH_SHORT).show();
                }
            }
        };
    }
}

