/*
 * Decompiled with CFR 0.152.
 */
package net.daum.android.map;

import java.io.InputStream;
import net.daum.mf.map.common.net.WebClient;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserFactory;

public class MapTileVersionCheckWebService {
    private WebClient httpClient;
    private MapTileVersionCheckResultListener resultListener;
    private String imageTileVersion;
    private String hybridTileVersion;
    private String roadViewTileVersion;

    public MapTileVersionCheckWebService(MapTileVersionCheckResultListener resultListener) {
        this.resultListener = resultListener;
    }

    private void _parseResultXML(InputStream contentStream) throws Exception {
        XmlPullParserFactory parserCreator = XmlPullParserFactory.newInstance();
        XmlPullParser parser = parserCreator.newPullParser();
        parser.setInput(contentStream, "utf-8");
        int parserEvent = parser.getEventType();
        boolean inMapTileVersion = false;
        boolean inMapTileVersionImage = false;
        boolean inMapTileVersionHybrid = false;
        boolean inMapTileVersionRoadView = false;
        while (parserEvent != 1) {
            switch (parserEvent) {
                case 4: {
                    if (!inMapTileVersion) break;
                    if (inMapTileVersionImage) {
                        this.imageTileVersion = parser.getText().trim();
                        break;
                    }
                    if (inMapTileVersionHybrid) {
                        this.hybridTileVersion = parser.getText().trim();
                        break;
                    }
                    if (!inMapTileVersionRoadView) break;
                    this.roadViewTileVersion = parser.getText().trim();
                    break;
                }
                case 3: {
                    String tag = parser.getName();
                    if (tag.compareTo("version") == 0) {
                        inMapTileVersion = false;
                        break;
                    }
                    if (!inMapTileVersion) break;
                    if (tag.compareTo("i") == 0) {
                        inMapTileVersionImage = false;
                        break;
                    }
                    if (tag.compareTo("h") == 0) {
                        inMapTileVersionHybrid = false;
                        break;
                    }
                    if (tag.compareTo("t") != 0) break;
                    inMapTileVersionRoadView = false;
                    break;
                }
                case 2: {
                    String tag = parser.getName();
                    if (tag.compareTo("version") == 0) {
                        inMapTileVersion = true;
                        break;
                    }
                    if (!inMapTileVersion) break;
                    if (tag.compareTo("i") == 0) {
                        inMapTileVersionImage = true;
                        break;
                    }
                    if (tag.compareTo("h") == 0) {
                        inMapTileVersionHybrid = true;
                        break;
                    }
                    if (tag.compareTo("t") != 0) break;
                    inMapTileVersionRoadView = true;
                }
            }
            parserEvent = parser.next();
        }
    }

    public void requestMapTileVersionCheckService() {
        Thread t = new Thread(){

            @Override
            public void run() {
                MapTileVersionCheckWebService.this.httpClient = new WebClient();
                String requestUrl = "http://dmaps.daum.net/map_js_init/maps_version.xml";
                if (!MapTileVersionCheckWebService.this.httpClient.requestGet(requestUrl)) {
                    if (MapTileVersionCheckWebService.this.resultListener != null) {
                        MapTileVersionCheckWebService.this.resultListener.onMapTileVersionCheckServiceErrorOccured();
                    }
                    return;
                }
                if (MapTileVersionCheckWebService.this.resultListener != null) {
                    try {
                        InputStream xmlStream = MapTileVersionCheckWebService.this.httpClient.openContentStream();
                        MapTileVersionCheckWebService.this._parseResultXML(xmlStream);
                    }
                    catch (Exception e) {
                        MapTileVersionCheckWebService.this.resultListener.onMapTileVersionCheckServiceErrorOccured();
                        return;
                    }
                    MapTileVersionCheckWebService.this.resultListener.onMapTileVersionCheckResultReceived(MapTileVersionCheckWebService.this.imageTileVersion, MapTileVersionCheckWebService.this.hybridTileVersion, MapTileVersionCheckWebService.this.roadViewTileVersion);
                }
            }
        };
        t.start();
    }

    public static interface MapTileVersionCheckResultListener {
        public void onMapTileVersionCheckResultReceived(String var1, String var2, String var3);

        public void onMapTileVersionCheckServiceErrorOccured();
    }
}

