/*
 * Decompiled with CFR 0.152.
 */
package net.daum.android.map;

import android.os.Build;
import net.daum.android.map.MapEngineManager;
import net.daum.android.map.coord.MapCoord;
import net.daum.mf.map.n.api.NativeMapCoord;
import net.daum.mf.map.n.api.internal.NativeMapViewController;
import net.daum.mf.map.task.MainQueueManager;
import net.daum.mf.map.task.MapTaskManager;

public final class MapViewController {
    protected NativeMapViewController _nativeMapViewController = new NativeMapViewController();
    private static final MapViewController _instance = new MapViewController();

    public static MapViewController getInstance() {
        return _instance;
    }

    private MapViewController() {
    }

    public void disuseInfoWindows() {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                MapViewController.this._nativeMapViewController.disuseInfoWindows();
            }
        };
        MapTaskManager.getInstance().queueTask(task, MapEngineManager.getInstance().getStopGlSwap());
    }

    public void showZoomControls(final boolean show) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                MapViewController.this._nativeMapViewController.showZoomControls(show);
            }
        };
        MapTaskManager.getInstance().queueTask(task, MapEngineManager.getInstance().getStopGlSwap());
    }

    public void switchTrackingMarker(final boolean shouldTurnOn) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                MapViewController.this._nativeMapViewController.switchTrackingMarker(shouldTurnOn);
            }
        };
        MainQueueManager.getInstance().queueToMainQueue(task);
    }

    public void switchHeadingMarker(final boolean shouldTurnOn) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                MapViewController.this._nativeMapViewController.switchHeadingMarker(shouldTurnOn);
            }
        };
        MainQueueManager.getInstance().queueToMainQueue(task);
    }

    public void showLocationMarkerWithAnimation(final MapCoord coord, final boolean animate, boolean forceRunOnMapEngineLoop) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                NativeMapCoord nativeMapCoord = new NativeMapCoord(coord);
                boolean drawRange = true;
                String deviceModelName = Build.MODEL;
                if (deviceModelName.equals("LG-SU760")) {
                    drawRange = false;
                }
                MapViewController.this._nativeMapViewController.showLocationMarkerWithAnimation(nativeMapCoord, animate, drawRange);
            }
        };
        if (forceRunOnMapEngineLoop) {
            MainQueueManager.getInstance().queueToMainQueue(task);
        } else {
            task.run();
        }
    }

    public void setLocationMarkerRotation(final float rotation, boolean forceRunOnMapEngineLoop) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                MapViewController.this._nativeMapViewController.setLocationMarkerRotation(rotation);
            }
        };
        if (forceRunOnMapEngineLoop) {
            MainQueueManager.getInstance().queueToMainQueue(task);
        } else {
            task.run();
        }
    }

    public void setAccuracy(final float accuracy, boolean forceRunOnMapEngineLoop) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                MapViewController.this._nativeMapViewController.setAccuracy(accuracy);
            }
        };
        if (forceRunOnMapEngineLoop) {
            MainQueueManager.getInstance().queueToMainQueue(task);
        } else {
            task.run();
        }
    }

    public void showInfoPanelTimedMessage(final String message, final float timeoutTimeInterval, boolean forceRunOnMapEngineLoop) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                MapViewController.this._nativeMapViewController.showInfoPanelTimedMessage(message, timeoutTimeInterval);
            }
        };
        if (forceRunOnMapEngineLoop) {
            MainQueueManager.getInstance().queueToMainQueue(task);
        } else {
            task.run();
        }
    }
}

