/*
 * Decompiled with CFR 0.152.
 */
package net.daum.android.map.coord;

import android.util.Log;
import net.daum.android.map.coord.MapCoordConstants;
import net.daum.android.map.coord.MapCoordLatLng;
import net.daum.android.map.util.URLEncoder;
import net.daum.android.map.util.XorEncryptionUtils;
import net.daum.mf.map.n.api.NativeMapCoordConverter;

public class MapCoord {
    private static final String LOG_TAG = "MapCoord";
    protected int _type = MapCoordConstants.MAP_MAIN_COORD_TYPE;
    private static String _encKey = "yeKmuaDeliboM";
    protected double _x = 0.0;
    protected double _y = 0.0;
    public static final MapCoord ZERO = new MapCoord(0.0, 0.0);
    public static final MapCoord UNDEFINED = new MapCoord(-1.0E7, -1.0E7);
    public static final MapCoord WCONG_UNDEFINED = new MapCoord(-1.0E7, -1.0E7, 2);
    public static final MapCoord CONG_UNDEFINED = new MapCoord(-1.0E7, -1.0E7, 1);

    public MapCoord() {
    }

    public MapCoord(int type) {
        this._type = type;
    }

    public MapCoord(double x, double y) {
        this._x = x;
        this._y = y;
    }

    public MapCoord(double x, double y, int type) {
        this._x = x;
        this._y = y;
        this._type = type;
    }

    public int getType() {
        return this._type;
    }

    public double getX() {
        return this._x;
    }

    public double getY() {
        return this._y;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        boolean result = false;
        if (other instanceof MapCoord) {
            MapCoord that = (MapCoord)other;
            result = this.getType() == that.getType() && this.getX() == that.getX() && this.getY() == that.getY();
        }
        return result;
    }

    public int hashCode() {
        return (int)(this._x * 141.431 + this._y * 11.41) + this._type * 41;
    }

    public boolean isUndefined() {
        return this._x == -1.0E7 && this._y == -1.0E7;
    }

    public MapCoord toMainCoord() {
        if (MapCoordConstants.MAP_MAIN_COORD_TYPE == 2) {
            return this.toWcong();
        }
        return this.toCong();
    }

    public MapCoordLatLng toMapCoordLatLng(MapCoord cCoord) {
        return new MapCoordLatLng(cCoord._y, cCoord._x, cCoord._type);
    }

    public MapCoord toCong() {
        if (this._type == 1) {
            return this;
        }
        if (this.isUndefined()) {
            return CONG_UNDEFINED;
        }
        NativeMapCoordConverter converter = new NativeMapCoordConverter();
        MapCoord newCoord = null;
        switch (this._type) {
            case 2: 
            case 3: 
            case 4: {
                newCoord = converter.convertMapCoord(this, 1);
                break;
            }
            default: {
                this.error(1);
            }
        }
        return newCoord;
    }

    public MapCoord toWcong() {
        if (this._type == 2) {
            return this;
        }
        if (this.isUndefined()) {
            return WCONG_UNDEFINED;
        }
        NativeMapCoordConverter converter = new NativeMapCoordConverter();
        MapCoord newCoord = null;
        switch (this._type) {
            case 1: 
            case 3: 
            case 4: {
                newCoord = converter.convertMapCoord(this, 2);
                break;
            }
            default: {
                this.error(2);
            }
        }
        return newCoord;
    }

    public MapCoordLatLng toWgs() {
        if (this.isUndefined()) {
            return MapCoordLatLng.WGS84_UNDEFINED;
        }
        NativeMapCoordConverter converter = new NativeMapCoordConverter();
        MapCoord newCoord = null;
        switch (this._type) {
            case 1: 
            case 2: {
                newCoord = converter.convertMapCoord(this, 4);
                break;
            }
            default: {
                this.error(4);
            }
        }
        return this.toMapCoordLatLng(newCoord);
    }

    public MapCoord addCoord(MapCoord coord) {
        return new MapCoord(this._x + coord.getX(), this._y + coord.getY());
    }

    public static void setKey(String key) {
        _encKey = key;
    }

    protected String getEncryptedCoord(int coord) {
        String stringValue = String.valueOf(coord);
        return URLEncoder.encode(XorEncryptionUtils.encryptString(stringValue, _encKey));
    }

    public String getEncryptedX() {
        return this.getEncryptedCoord((int)this.getX());
    }

    public String getEncryptedY() {
        return this.getEncryptedCoord((int)this.getY());
    }

    private void error(int toType) {
        Log.e((String)LOG_TAG, (String)("cannot convert " + this._type + " => " + toType + ""));
    }
}

