/*
 * Decompiled with CFR 0.152.
 */
package net.daum.android.map.util;

public class URLEncoder {
    static final String digits = "0123456789ABCDEF";

    private URLEncoder() {
    }

    public static String encode(byte[] data) {
        StringBuilder buf = new StringBuilder(data.length + 16);
        for (int i = 0; i < data.length; ++i) {
            char ch = (char)data[i];
            if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ".-*_".indexOf(ch) > -1) {
                buf.append(ch);
                continue;
            }
            if (ch == ' ') {
                buf.append('+');
                continue;
            }
            buf.append('%');
            buf.append(digits.charAt((data[i] & 0xF0) >> 4));
            buf.append(digits.charAt(data[i] & 0xF));
        }
        return buf.toString();
    }

    public static int decode(String s, byte[] result) {
        int numChars = s.length();
        int i = 0;
        int pos = 0;
        block6: while (i < numChars) {
            char c = s.charAt(i);
            switch (c) {
                case '+': {
                    result[pos++] = 32;
                    ++i;
                    continue block6;
                }
                case '%': {
                    try {
                        while (i + 2 < numChars && c == '%') {
                            int v = Integer.parseInt(s.substring(i + 1, i + 3), 16);
                            if (v < 0) {
                                throw new IllegalArgumentException("URLDecoder: Illegal hex characters in escape (%) pattern - negative value");
                            }
                            result[pos++] = (byte)v;
                            if ((i += 3) >= numChars) continue;
                            c = s.charAt(i);
                        }
                        continue block6;
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("URLDecoder: Illegal hex characters in escape (%) pattern - " + e.getMessage());
                    }
                }
            }
            result[pos++] = (byte)c;
            ++i;
        }
        return pos;
    }
}

