/*
 * Decompiled with CFR 0.152.
 */
package net.daum.mf.map.api;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.DrawFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PaintFlagsDrawFilter;
import android.graphics.Shader;
import android.view.MotionEvent;
import android.view.View;
import android.widget.FrameLayout;
import net.daum.mf.map.api.MapView;

public class MapLayout
extends FrameLayout {
    public static final String VIEW_TO_SHOW_BEFORE_MAP_VIEW_INITIALIZED = "VIEW_TO_SHOW_BEFORE_MAP_VIEW_INITIALIZED";
    private MapView mapView;
    private View viewToShowBeforeMapViewInitialized;
    private Activity activity;

    public MapLayout(Activity activity) {
        super((Context)activity);
        this.activity = activity;
        this.mapView = new MapView(activity);
        this.addView((View)this.mapView);
    }

    protected void onAttachedToWindow() {
        if (this.viewToShowBeforeMapViewInitialized == null) {
            this.viewToShowBeforeMapViewInitialized = new GridPatternView((Context)this.activity);
        }
        this.viewToShowBeforeMapViewInitialized.setTag((Object)VIEW_TO_SHOW_BEFORE_MAP_VIEW_INITIALIZED);
        this.addView(this.viewToShowBeforeMapViewInitialized);
        super.onAttachedToWindow();
    }

    private static Bitmap makeBitmap() {
        Bitmap bm = Bitmap.createBitmap((int)32, (int)32, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas c = new Canvas(bm);
        c.drawColor(Color.argb((int)255, (int)221, (int)222, (int)213));
        Paint p = new Paint();
        p.setColor(Color.argb((int)255, (int)237, (int)235, (int)237));
        c.drawRect(0.5f, 0.5f, 31.5f, 31.5f, p);
        return bm;
    }

    public MapView getMapView() {
        return this.mapView;
    }

    public void setViewToShowBeforeMapViewInitialized(View viewToShowBeforeMapViewInitialized) {
        this.viewToShowBeforeMapViewInitialized = viewToShowBeforeMapViewInitialized;
    }

    private static class GridPatternView
    extends View {
        private final Shader mShader;
        private final Paint mPaint;
        private final DrawFilter mFastDF;
        private float mTouchStartX;
        private float mTouchStartY;
        private float mTouchCurrX;
        private float mTouchCurrY;
        private DrawFilter mDF;

        public GridPatternView(Context context) {
            super(context);
            this.setFocusable(true);
            this.setFocusableInTouchMode(true);
            this.mFastDF = new PaintFlagsDrawFilter(6, 0);
            this.mShader = new BitmapShader(MapLayout.makeBitmap(), Shader.TileMode.REPEAT, Shader.TileMode.REPEAT);
            Matrix m = new Matrix();
            m.setRotate(30.0f);
            this.mPaint = new Paint(2);
        }

        protected void onDraw(Canvas canvas) {
            canvas.setDrawFilter(this.mDF);
            this.mPaint.setShader(this.mShader);
            canvas.drawPaint(this.mPaint);
            canvas.translate(this.mTouchCurrX - this.mTouchStartX, this.mTouchCurrY - this.mTouchStartY);
            canvas.drawPaint(this.mPaint);
        }

        public boolean onTouchEvent(MotionEvent event) {
            float x = event.getX();
            float y = event.getY();
            switch (event.getAction()) {
                case 0: {
                    this.mTouchStartX = this.mTouchCurrX = x;
                    this.mTouchStartY = this.mTouchCurrY = y;
                    this.mDF = this.mFastDF;
                    this.invalidate();
                    break;
                }
                case 2: {
                    this.mTouchCurrX = x;
                    this.mTouchCurrY = y;
                    this.invalidate();
                    break;
                }
                case 1: {
                    this.mDF = null;
                    this.invalidate();
                }
            }
            return true;
        }
    }
}

