/*
 * Decompiled with CFR 0.152.
 */
package net.daum.mf.map.api;

import java.util.ArrayList;
import java.util.Arrays;
import net.daum.mf.map.api.MapPoint;

public class MapPointBounds {
    public MapPoint bottomLeft;
    public MapPoint topRight;

    public MapPointBounds() {
    }

    public void add(MapPoint point) {
        if (this.bottomLeft == null) {
            this.bottomLeft = point;
        }
        if (this.topRight == null) {
            this.topRight = point;
        }
        MapPoint[] mapPoints = new MapPoint[]{this.bottomLeft, this.topRight, point};
        this.calcBounds(mapPoints);
    }

    public MapPointBounds(MapPoint bottomLeft, MapPoint topRight) {
        this.bottomLeft = bottomLeft;
        this.topRight = topRight;
    }

    public MapPointBounds(MapPoint[] mapPointArray) {
        this.calcBounds(mapPointArray);
    }

    public MapPointBounds(MapPointBounds[] mapPointBoundsArray) {
        ArrayList<MapPoint> mapPointList = new ArrayList<MapPoint>();
        for (MapPointBounds mapPointBounds : mapPointBoundsArray) {
            mapPointList.add(mapPointBounds.bottomLeft);
            mapPointList.add(mapPointBounds.topRight);
        }
        this.calcBounds(mapPointList.toArray(new MapPoint[0]));
    }

    private void calcBounds(MapPoint[] mapPoints) {
        if (mapPoints == null || mapPoints.length == 0) {
            this.bottomLeft = MapPoint.mapPointWithWCONGCoord(-1.0E100, -1.0E100);
            this.topRight = MapPoint.mapPointWithWCONGCoord(1.0E100, 1.0E100);
            return;
        }
        double left = 1.0E100;
        double right = -1.0E100;
        double bottom = 1.0E100;
        double top = -1.0E100;
        for (MapPoint point : mapPoints) {
            double x = point.getInternalCoordObject().getX();
            double y = point.getInternalCoordObject().getY();
            left = Math.min(left, x);
            right = Math.max(right, x);
            bottom = Math.min(bottom, y);
            top = Math.max(top, y);
        }
        this.bottomLeft = MapPoint.mapPointWithWCONGCoord(left, bottom);
        this.topRight = MapPoint.mapPointWithWCONGCoord(right, top);
    }

    public boolean contains(MapPoint mapPoint) {
        double[] latBounds = new double[2];
        double[] lngBounds = new double[2];
        latBounds[0] = this.bottomLeft.getMapPointGeoCoord().latitude;
        latBounds[1] = this.topRight.getMapPointGeoCoord().latitude;
        Arrays.sort(latBounds);
        lngBounds[0] = this.bottomLeft.getMapPointGeoCoord().longitude;
        lngBounds[1] = this.topRight.getMapPointGeoCoord().longitude;
        Arrays.sort(lngBounds);
        double lat = mapPoint.getMapPointGeoCoord().latitude;
        double lng = mapPoint.getMapPointGeoCoord().longitude;
        return latBounds[0] <= lat && lat <= latBounds[1] && lngBounds[0] <= lng && lng <= lngBounds[1];
    }

    public MapPoint getCenter() {
        double centerLat = (this.bottomLeft.getMapPointGeoCoord().latitude + this.topRight.getMapPointGeoCoord().latitude) / 2.0;
        double centerLng = (this.bottomLeft.getMapPointGeoCoord().longitude + this.topRight.getMapPointGeoCoord().longitude) / 2.0;
        return MapPoint.mapPointWithGeoCoord(centerLat, centerLng);
    }
}

