/*
 * Decompiled with CFR 0.152.
 */
package net.daum.mf.map.common;

import java.util.concurrent.atomic.AtomicLong;
import net.daum.mf.map.n.api.NativeMapLoopScheduling;

public class MapThreadScheduling {
    private static NativeMapLoopScheduling loopScheduling = new NativeMapLoopScheduling();
    private static AtomicLong waitStarted = new AtomicLong();
    private static AtomicLong waitStartedRoadView = new AtomicLong();
    private static boolean _mapViewMode = true;

    public static boolean isMapViewMode() {
        return _mapViewMode;
    }

    public static void setMapViewMode(boolean mapViewMode) {
        _mapViewMode = mapViewMode;
    }

    public static void forceContinue() {
        if (_mapViewMode) {
            waitStarted.set(0L);
        } else {
            waitStartedRoadView.set(0L);
        }
    }

    private static void clearStarted() {
        if (_mapViewMode) {
            waitStarted.set(0L);
        } else {
            waitStartedRoadView.set(0L);
        }
    }

    public static void setBusyLoop(boolean busy) {
        if (_mapViewMode) {
            loopScheduling.setBusyLoop(busy);
        } else {
            loopScheduling.setRoadViewBusyLoop(busy);
        }
    }

    public static boolean needToWait() {
        boolean busy = false;
        if (_mapViewMode) {
            busy = loopScheduling.isBusyLoop();
            if (busy) {
                MapThreadScheduling.clearStarted();
            } else {
                waitStarted.set(System.currentTimeMillis());
            }
        } else {
            busy = loopScheduling.isRoadViewInBusyLoop();
            if (busy) {
                MapThreadScheduling.clearStarted();
            } else {
                waitStartedRoadView.set(System.currentTimeMillis());
            }
        }
        return !busy;
    }

    public static boolean isWaiting() {
        if (_mapViewMode) {
            if (waitStarted.get() <= 0L) {
                return false;
            }
            boolean busy = loopScheduling.isBusyLoop();
            if (busy) {
                MapThreadScheduling.clearStarted();
                return false;
            }
            long millis = System.currentTimeMillis();
            return millis - waitStarted.get() < 500L;
        }
        if (waitStartedRoadView.get() <= 0L) {
            return false;
        }
        boolean busy = loopScheduling.isRoadViewInBusyLoop();
        if (busy) {
            MapThreadScheduling.clearStarted();
            return false;
        }
        long millis = System.currentTimeMillis();
        return millis - waitStartedRoadView.get() < 500L;
    }
}

