/*
 * Decompiled with CFR 0.152.
 */
package net.daum.mf.map.common.net;

import android.text.TextUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLException;
import net.daum.mf.map.common.io.InputStreamUtils;
import net.daum.mf.map.common.net.HeaderItem;
import net.daum.mf.map.common.net.KeyValuePair;
import net.daum.mf.map.common.net.UrlEncodedFormHelper;

public class NetWebClient {
    static final int DEFAULT_CONNECTION_TIMEOUT = 30000;
    static final int DEFAULT_SOCKET_TIMEOUT = 60000;
    static final String REQUEST_ENCODING = "utf-8";
    protected String userAgent;
    static final String HEADER_NAME_COOKIE = "Cookie";
    static final String HEADER_NAME_USER_AGENT = "User-Agent";
    private int _connectionTimeout = 30000;
    private int _socketTimeout = 60000;
    boolean _keepAlive = true;
    static final String METHOD_GET = "GET";
    static final String METHOD_POST = "POST";
    static final String METHOD_HEAD = "HEAD";
    private HttpURLConnection _connection;
    private List<KeyValuePair> _params;
    private int _responseCode;
    private boolean _isResponseHandled = false;
    private List<HeaderItem> headers = new ArrayList<HeaderItem>();

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public static boolean isSuccessStatusCode(int statusCode) {
        return statusCode >= 200 && statusCode < 300;
    }

    public int getConnectionTimeout() {
        return this._connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this._connectionTimeout = connectionTimeout;
    }

    public int getSocketTimeout() {
        return this._socketTimeout;
    }

    private void _setTimeout(int connectTimeout, int readTimeout) {
        this._connection.setReadTimeout(readTimeout);
        this._connection.setConnectTimeout(connectTimeout);
    }

    private void setHeaderItems(HttpURLConnection conn) {
        for (HeaderItem item : this.headers) {
            if (item.getMethod() == HeaderItem.HeaderItemMethod.ADD) {
                conn.addRequestProperty(item.getName(), item.getValue());
                continue;
            }
            conn.setRequestProperty(item.getName(), item.getValue());
        }
    }

    private boolean _request(String requestMethod, String url, String cookie) throws SSLException {
        this._isResponseHandled = false;
        boolean ret = false;
        try {
            HttpURLConnection connection = this._connection = (HttpURLConnection)new URL(URI.create(url).toASCIIString()).openConnection();
            connection.setRequestMethod(requestMethod);
            if (this._keepAlive) {
                connection.setRequestProperty("connection", "Keep-Alive");
            } else {
                connection.setRequestProperty("connection", "Close");
            }
            this._setTimeout(this.getConnectionTimeout(), this.getSocketTimeout());
            if (!TextUtils.isEmpty((CharSequence)cookie)) {
                connection.addRequestProperty(HEADER_NAME_COOKIE, cookie);
            }
            if (!TextUtils.isEmpty((CharSequence)this.userAgent)) {
                connection.addRequestProperty(HEADER_NAME_USER_AGENT, this.userAgent);
            }
            UrlEncodedFormHelper entity = null;
            if (this._params != null) {
                long contentLength;
                String contentEncoding;
                entity = new UrlEncodedFormHelper(this._params, REQUEST_ENCODING);
                String contentType = entity.getContentType();
                if (contentType != null) {
                    connection.addRequestProperty("Content-Type", contentType);
                }
                if ((contentEncoding = entity.getContentEncoding()) != null) {
                    connection.addRequestProperty("Content-Encoding", contentEncoding);
                }
                if ((contentLength = entity.getContentLength()) >= 0L) {
                    connection.addRequestProperty("Content-Length", Long.toString(contentLength));
                }
                this.setHeaderItems(connection);
                if (contentLength != 0L) {
                    connection.setDoOutput(true);
                    if (contentLength >= 0L && contentLength <= Integer.MAX_VALUE) {
                        connection.setFixedLengthStreamingMode((int)contentLength);
                    } else {
                        connection.setChunkedStreamingMode(0);
                    }
                    entity.writeTo(connection.getOutputStream());
                }
            } else {
                this.setHeaderItems(connection);
            }
            connection.connect();
            ret = true;
        }
        catch (MalformedURLException entity) {
        }
        catch (UnsupportedEncodingException entity) {
        }
        catch (SSLException e) {
            throw e;
        }
        catch (IOException iOException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return ret;
    }

    public boolean requestGetWithCookie(String url, String cookie) throws SSLException {
        return this._request(METHOD_GET, url, cookie);
    }

    public boolean requestHead(String url) throws SSLException {
        return this._request(METHOD_HEAD, url, null);
    }

    public boolean requestPost(String url, ArrayList<KeyValuePair> params, String cookie) throws SSLException {
        this._params = params;
        return this._request(METHOD_POST, url, cookie);
    }

    public void cancel() {
        if (this._connection != null) {
            this._connection.disconnect();
        }
    }

    private void _getResponse() {
        if (this._isResponseHandled) {
            return;
        }
        this._isResponseHandled = true;
        this._responseCode = 0;
        HttpURLConnection connection = this._connection;
        try {
            this._responseCode = connection.getResponseCode();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public InputStream openContentStream() throws IllegalStateException, IOException {
        this._getResponse();
        return NetWebClient.isSuccessStatusCode(this._responseCode) ? this._connection.getInputStream() : this._connection.getErrorStream();
    }

    public String getContentString(String encoding) {
        this._getResponse();
        String result = null;
        try {
            result = InputStreamUtils.toString(this.openContentStream(), encoding, (int)this.getContentLength());
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public int getStatusCode() {
        this._getResponse();
        return this._responseCode;
    }

    public long getContentLength() {
        this._getResponse();
        String string = this._connection.getHeaderField("Content-Length");
        return string == null ? -1L : Long.parseLong(string);
    }

    public void addHeader(String name, String value) {
        this.headers.add(new HeaderItemAdding(name, value));
    }

    public void setHeader(String name, String value) {
        this.headers.add(new HeaderItemSetting(name, value));
    }

    protected static class HeaderItemSetting
    extends HeaderItem {
        public HeaderItemSetting(String name, String value) {
            super(HeaderItem.HeaderItemMethod.SET, name, value);
        }
    }

    protected static class HeaderItemAdding
    extends HeaderItem {
        public HeaderItemAdding(String name, String value) {
            super(HeaderItem.HeaderItemMethod.ADD, name, value);
        }
    }
}

