/*
 * Decompiled with CFR 0.152.
 */
package net.daum.mf.map.common.net;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import net.daum.mf.map.common.net.KeyValuePair;
import net.daum.mf.map.common.net.UrlEncodeUtils;

public class UrlEncodedFormHelper {
    protected final byte[] content;
    private String contentType;
    private String contentEncoding;
    private boolean chunked;

    public void setContentType(String ctString) {
        this.contentType = ctString;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentEncoding(String ctString) {
        this.contentEncoding = ctString;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public boolean isChunked() {
        return this.chunked;
    }

    public void setChunked(boolean b) {
        this.chunked = b;
    }

    public long getContentLength() {
        return this.content.length;
    }

    public boolean isRepeatable() {
        return true;
    }

    public InputStream getContent() throws IOException {
        return new ByteArrayInputStream(this.content);
    }

    public void writeTo(OutputStream outstream) throws IOException {
        if (outstream == null) {
            throw new IllegalArgumentException("Output stream may not be null");
        }
        outstream.write(this.content);
        outstream.flush();
    }

    public boolean isStreaming() {
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public UrlEncodedFormHelper(List<KeyValuePair> parameters, String encoding) throws UnsupportedEncodingException {
        String s = UrlEncodeUtils.format(parameters, encoding);
        if (s == null) {
            throw new IllegalArgumentException("Source string may not be null");
        }
        String charset = encoding;
        if (charset == null) {
            charset = "ISO-8859-1";
        }
        this.content = s.getBytes(charset);
        this.setContentType("application/x-www-form-urlencoded");
    }

    public UrlEncodedFormHelper(List<KeyValuePair> parameters) throws UnsupportedEncodingException {
        this(parameters, "ISO-8859-1");
        this.setContentType("application/x-www-form-urlencoded");
    }
}

