/*
 * Decompiled with CFR 0.152.
 */
package com.skt.Tmap;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.skt.Tmap.ITileOrigin;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class MapTileDownloader {
    public static final int TILE_DOWNLOAD_THREADS = 18;
    public static final int TILE_DOWNLOAD_SECONDS_TO_WORK = 25;
    private ThreadPoolExecutor mThreadPoolExecutor = null;
    private List<IMapDownloaderCallback> mCallback = new ArrayList<IMapDownloaderCallback>();
    private Set<String> mCurrentDownload = null;

    public MapTileDownloader() {
        if (this.mThreadPoolExecutor == null) {
            int nCorePoolSize = Runtime.getRuntime().availableProcessors();
            this.mThreadPoolExecutor = new ThreadPoolExecutor(nCorePoolSize, 18, 25L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        }
        this.mThreadPoolExecutor.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
        this.mCurrentDownload = Collections.synchronizedSet(new HashSet());
    }

    public MapTileDownloader(int numberOfThreads) {
        if (this.mThreadPoolExecutor == null) {
            int nCorePoolSize = Runtime.getRuntime().availableProcessors();
            this.mThreadPoolExecutor = new ThreadPoolExecutor(nCorePoolSize, numberOfThreads, 25L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        }
        this.mThreadPoolExecutor.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
        this.mCurrentDownload = Collections.synchronizedSet(new HashSet());
    }

    public void threadPoolShutDown() {
        this.mThreadPoolExecutor.shutdown();
    }

    public void addDownloaderMapCallback(IMapDownloaderCallback callback) {
        this.mCallback.add(callback);
    }

    public void removeDownloaderMapCallback(IMapDownloaderCallback callback) {
        if (this.mCallback.size() > 0) {
            this.mCallback.remove(callback);
        }
    }

    public List<IMapDownloaderCallback> getDownloaderMapCallback() {
        return this.mCallback;
    }

    public boolean isFileCurrentDownload(String string) {
        return this.mCurrentDownload.contains(string);
    }

    public boolean isDownLoding() {
        return !this.mCurrentDownload.isEmpty();
    }

    public int getRemainingCount() {
        return (int)this.mThreadPoolExecutor.getTaskCount();
    }

    public void refuseAllPreviousDataRequests() {
        while (!this.mThreadPoolExecutor.getQueue().isEmpty()) {
            this.mThreadPoolExecutor.getQueue().poll();
        }
    }

    public void downloadRequest(DownloadRequest downloadRequest) {
        if (downloadRequest.url == null) {
            return;
        }
        try {
            if (!this.isFileCurrentDownload(downloadRequest.url)) {
                this.mThreadPoolExecutor.execute(new DownloadMapWorker(downloadRequest));
            }
        }
        catch (RejectedExecutionException rejectedExecutionException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void requestToFileDownload(DownloadRequest request) {
        if (request.filepath == null) {
            return;
        }
        try {
            if (!this.isFileCurrentDownload(request.filepath)) {
                this.mThreadPoolExecutor.execute(new DownloadFileWorker(request));
            }
        }
        catch (RejectedExecutionException rejectedExecutionException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class DownloadFileWorker
    implements Runnable,
    Comparable<DownloadFileWorker> {
        private DownloadRequest request;

        private DownloadFileWorker(DownloadRequest request) {
            this.request = request;
        }

        @Override
        public void run() {
            if (this.request != null && this.request.url != null) {
                if (MapTileDownloader.this.mCurrentDownload.contains(this.request.filepath)) {
                    return;
                }
                MapTileDownloader.this.mCurrentDownload.add(this.request.filepath);
                FileInputStream fileInputStream = null;
                try {
                    File file = new File(this.request.filepath);
                    fileInputStream = new FileInputStream(file);
                    this.request.fileToSave = BitmapFactory.decodeStream((InputStream)fileInputStream);
                    fileInputStream.close();
                }
                catch (OutOfMemoryError e) {
                    this.request.setError(true);
                    this.request.memoryErr = true;
                }
                catch (IOException e) {
                    this.request.setError(true);
                }
                catch (Exception e) {
                    this.request.setError(true);
                }
                finally {
                    MapTileDownloader.this.mCurrentDownload.remove(this.request.filepath);
                }
                if (this.request.matchzoom) {
                    for (IMapDownloaderCallback c : new ArrayList(MapTileDownloader.this.mCallback)) {
                        c.tileDownloaded(this.request);
                    }
                }
            }
        }

        @Override
        public int compareTo(DownloadFileWorker another) {
            return 0;
        }
    }

    static class FlushedInputStream
    extends FilterInputStream {
        public FlushedInputStream(InputStream inputStream) {
            super(inputStream);
        }

        @Override
        public long skip(long n) throws IOException {
            long totalBytesSkipped;
            long bytesSkipped;
            for (totalBytesSkipped = 0L; totalBytesSkipped < n; totalBytesSkipped += bytesSkipped) {
                bytesSkipped = this.in.skip(n - totalBytesSkipped);
                if (bytesSkipped != 0L) continue;
                int b = this.read();
                if (b < 0) break;
                bytesSkipped = 1L;
            }
            return totalBytesSkipped;
        }
    }

    private class DownloadMapWorker
    implements Runnable,
    Comparable<DownloadMapWorker> {
        private DownloadRequest request = null;

        private DownloadMapWorker(DownloadRequest request) {
            if (request != null) {
                this.request = request;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block38: {
                if (this.request != null && this.request.url != null) {
                    if (MapTileDownloader.this.mCurrentDownload.contains(this.request.url)) {
                        return;
                    }
                    MapTileDownloader.this.mCurrentDownload.add(this.request.url);
                    String requestURL = this.request.url;
                    if (requestURL.indexOf("hd_tile") > -1) {
                        if (this.request.retry == 0) {
                            if (this.request.yTile % 3 == 0) {
                                requestURL = requestURL.replace("topopentile1", "topopentile2");
                            } else if (this.request.yTile % 3 == 1) {
                                requestURL = requestURL.replace("topopentile1", "topopentile3");
                            }
                        } else {
                            requestURL = this.request.retry == 1 ? requestURL.replace("topopentile1", "topopentile1") : (this.request.retry == 2 ? requestURL.replace("topopentile1", "topopentile2") : requestURL.replace("topopentile1", "topopentile3"));
                        }
                    }
                    InputStream inputStream = null;
                    HttpURLConnection urlCon = null;
                    try {
                        URL url = new URL(requestURL);
                        urlCon = (HttpURLConnection)url.openConnection();
                        urlCon.setConnectTimeout(10000);
                        int statusCode = urlCon.getResponseCode();
                        if (statusCode == 200) {
                            inputStream = urlCon.getInputStream();
                            if (inputStream != null) {
                                try {
                                    inputStream = urlCon.getInputStream();
                                    BitmapFactory.Options options = new BitmapFactory.Options();
                                    options.inPreferredConfig = Bitmap.Config.RGB_565;
                                    Bitmap bmp = null;
                                    bmp = BitmapFactory.decodeStream((InputStream)new FlushedInputStream(inputStream), null, (BitmapFactory.Options)options);
                                    if (bmp != null) {
                                        this.request.fileToSave = bmp;
                                        this.request.setError(false);
                                    } else {
                                        this.request.setError(true);
                                    }
                                    break block38;
                                }
                                finally {
                                    if (inputStream != null) {
                                        inputStream.close();
                                    }
                                }
                            }
                            this.request.setError(true);
                            break block38;
                        }
                        this.request.setError(true);
                        this.request.fileToSave = null;
                    }
                    catch (IllegalStateException e) {
                        this.request.setError(true);
                    }
                    catch (SocketTimeoutException e) {
                        this.request.setError(true);
                    }
                    catch (UnknownHostException e) {
                        this.request.setError(true);
                    }
                    catch (MalformedURLException e) {
                        this.request.setError(true);
                    }
                    catch (UnsupportedEncodingException e) {
                        this.request.setError(true);
                    }
                    catch (IOException e) {
                        this.request.setError(true);
                    }
                    catch (OutOfMemoryError e) {
                        this.request.setError(true);
                        this.request.memoryErr = true;
                    }
                    catch (Exception e) {
                        this.request.setError(true);
                    }
                    finally {
                        if (urlCon != null) {
                            urlCon.disconnect();
                        }
                        if (MapTileDownloader.this.mCurrentDownload.size() > 0) {
                            MapTileDownloader.this.mCurrentDownload.remove(this.request.url);
                        }
                        if (!this.request.matchzoom) break block38;
                        for (IMapDownloaderCallback c : new ArrayList(MapTileDownloader.this.mCallback)) {
                            c.tileDownloaded(this.request);
                        }
                    }
                }
            }
        }

        @Override
        public int compareTo(DownloadMapWorker o) {
            return 0;
        }
    }

    public class DownloadRequest {
        public Bitmap fileToSave = null;
        public final int zoom;
        public final int xTile;
        public final int yTile;
        public final String url;
        public boolean error = false;
        public boolean memoryErr = false;
        public final ITileOrigin tileSource;
        public final int type;
        public int retry = 0;
        public String filepath = "";
        public boolean matchzoom = true;

        public DownloadRequest(String url, Bitmap fileToSave, int xTile, int yTile, int zoom, ITileOrigin tileSource, int _type) {
            this.url = url;
            this.fileToSave = fileToSave;
            this.xTile = xTile;
            this.yTile = yTile;
            this.zoom = zoom;
            this.tileSource = tileSource;
            this.type = _type;
        }

        public DownloadRequest(String url, Bitmap fileToSave, ITileOrigin tileSource, int _type) {
            this.url = url;
            this.fileToSave = fileToSave;
            this.xTile = -1;
            this.yTile = -1;
            this.zoom = -1;
            this.tileSource = tileSource;
            this.type = _type;
        }

        public void setError(boolean error) {
            this.error = error;
        }
    }

    public static interface IMapDownloaderCallback {
        public void tileDownloaded(DownloadRequest var1);
    }

    public class TileLoadDownloadRequest
    extends DownloadRequest {
        public final String tileId;
        public final File dirWithTiles;
        public final ITileOrigin tileSource;
        public final int type;

        public TileLoadDownloadRequest(File dirWithTiles, String url, Bitmap fileToSave, String tileId, ITileOrigin source, int tileX, int tileY, int zoom, int _type) {
            super(url, fileToSave, tileX, tileY, zoom, source, _type);
            this.dirWithTiles = dirWithTiles;
            this.tileSource = source;
            this.tileId = tileId;
            this.type = _type;
        }
    }
}

