/*
 * Decompiled with CFR 0.152.
 */
package com.skt.Tmap;

import android.content.Context;
import android.graphics.PointF;
import android.view.MotionEvent;
import java.lang.reflect.Method;

public class MultiTouchEvent {
    public static final int ACTION_MASK = 255;
    public static final int ACTION_POINTER_ID_SHIFT = 8;
    public static final int ACTION_POINTER_DOWN = 5;
    public static final int ACTION_POINTER_UP = 6;
    private boolean mMultiTouchAPI = false;
    private final MultiTouchListener mListener;
    protected final Context mContext;
    private boolean mInZoomMode = false;
    private float mZoomStartedDistance = 100.0f;
    private float mPreviousZoom = 1.0f;
    private PointF mCenterPoint = new PointF();
    protected Method getPointerCount;
    protected Method getX;
    protected Method getY;
    protected Method getPointerId;

    public MultiTouchEvent(Context ctx, MultiTouchListener listener) {
        this.mContext = ctx;
        this.mListener = listener;
        this.init();
    }

    private void init() {
        try {
            this.getPointerCount = MotionEvent.class.getMethod("getPointerCount", new Class[0]);
            this.getPointerId = MotionEvent.class.getMethod("getPointerId", Integer.TYPE);
            this.getX = MotionEvent.class.getMethod("getX", Integer.TYPE);
            this.getY = MotionEvent.class.getMethod("getY", Integer.TYPE);
            this.mMultiTouchAPI = true;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            this.mMultiTouchAPI = false;
        }
    }

    public boolean isMultiTouch() {
        return this.mMultiTouchAPI;
    }

    public boolean isInZoom() {
        return this.mInZoomMode;
    }

    public boolean onGestureEvent(MotionEvent event) {
        if (!this.isMultiTouch()) {
            return false;
        }
        int code = event.getAction() & 0xFF;
        try {
            Integer count = (Integer)this.getPointerCount.invoke((Object)event, new Object[0]);
            if (count < 2) {
                if (this.mInZoomMode) {
                    this.mListener.onEndZoom(this.mZoomStartedDistance * this.mPreviousZoom, this.mPreviousZoom);
                }
                return false;
            }
            Float xValue1 = (Float)this.getX.invoke((Object)event, 0);
            Float xValue2 = (Float)this.getX.invoke((Object)event, 1);
            Float yValue1 = (Float)this.getY.invoke((Object)event, 0);
            Float yValue2 = (Float)this.getY.invoke((Object)event, 1);
            float distanceValue = (float)Math.sqrt((xValue2.floatValue() - xValue1.floatValue()) * (xValue2.floatValue() - xValue1.floatValue()) + (yValue2.floatValue() - yValue1.floatValue()) * (yValue2.floatValue() - yValue1.floatValue()));
            this.mPreviousZoom = distanceValue / this.mZoomStartedDistance;
            if (code == 5) {
                this.mCenterPoint = new PointF((xValue1.floatValue() + xValue2.floatValue()) / 2.0f, (yValue1.floatValue() + yValue2.floatValue()) / 2.0f);
                this.mListener.onStartZoom(distanceValue, this.mCenterPoint);
                this.mZoomStartedDistance = distanceValue;
                this.mInZoomMode = true;
                return true;
            }
            if (code == 6) {
                if (this.mInZoomMode) {
                    this.mListener.onEndZoom(distanceValue, this.mPreviousZoom);
                    this.mInZoomMode = false;
                }
                return true;
            }
            if (this.mInZoomMode && code == 2) {
                this.mListener.onZoom(distanceValue, this.mPreviousZoom);
                return true;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static interface MultiTouchListener {
        public void onStartZoom(float var1, PointF var2);

        public void onZoom(float var1, float var2);

        public void onEndZoom(float var1, float var2);
    }
}

