/*
 * Decompiled with CFR 0.152.
 */
package com.skt.Tmap;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Point;
import android.os.Build;
import android.view.WindowManager;
import com.skt.Tmap.ITileOrigin;
import com.skt.Tmap.LruCacheSave;
import com.skt.Tmap.MapTileDownloader;
import com.skt.Tmap.MapUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;

public class ResourceManager {
    public String PackageName = "";
    public String TILES_PATH_HD = null;
    private static String baseUrl = null;
    public int MaxTileNum = 4;
    public int AddTileNum = 2;
    private String mRoute = "/data/data/";
    private LruCacheSave<String, Bitmap> cacheOfImages = null;
    protected ArrayList<String> nameInFS = new ArrayList();
    protected StringBuilder builder = new StringBuilder(40);
    public MapTileDownloader downloader = null;

    public static void setBaseUrl(String url) {
        baseUrl = url;
    }

    public ResourceManager(Context context, String packagename, MapTileDownloader downloader) {
        this.downloader = downloader;
        this.PackageName = packagename;
        this.TILES_PATH_HD = this.mRoute + this.PackageName + "/skttiles_hd";
        WindowManager wmgr = (WindowManager)context.getSystemService("window");
        int cacheSize = 0;
        int tileSize = 1024;
        int w = 0;
        int h = 0;
        if (Build.VERSION.SDK_INT >= 13) {
            Point outSize = new Point();
            wmgr.getDefaultDisplay().getSize(outSize);
            w = outSize.x;
            h = outSize.y;
        } else {
            w = wmgr.getDefaultDisplay().getWidth();
            h = wmgr.getDefaultDisplay().getHeight();
        }
        double viewWidth = w < h ? (double)h : (double)w;
        double halfTileNum = Math.ceil(viewWidth / 1024.0);
        double tileNum = (halfTileNum + halfTileNum + 1.0) * 4.0;
        cacheSize = (int)(1024.0 * tileNum * tileNum);
        this.cacheOfImages = new LruCacheSave<String, Bitmap>(cacheSize){

            protected int sizeOf(String key, Bitmap bitmap) {
                int byteCount = bitmap.getRowBytes() * bitmap.getHeight();
                return byteCount / 1024;
            }
        };
        this.deleteCacheTile();
    }

    public void deleteCacheTile() {
        this.removeTileImageFromCache();
        File parent_hd = new File(this.TILES_PATH_HD);
        if (parent_hd.isDirectory()) {
            if (null != parent_hd.listFiles() && parent_hd.listFiles().length > 0) {
                for (File file : parent_hd.listFiles()) {
                    file.delete();
                }
            }
            parent_hd = null;
        }
        this.nameInFS.clear();
    }

    public void resetNameInFS(int type) {
        this.nameInFS.clear();
        File parent = null;
        File parent_hd = new File(this.TILES_PATH_HD);
        if (parent_hd.isDirectory()) {
            if (null != parent_hd.listFiles() && parent_hd.listFiles().length > 0) {
                for (File file : parent_hd.listFiles()) {
                    file.delete();
                }
            }
            parent_hd = null;
        }
        if (!(parent = new File(this.TILES_PATH_HD)).isDirectory()) {
            parent.mkdirs();
        } else {
            if (null != parent.listFiles() && parent.listFiles().length > 0) {
                for (File file : parent.listFiles()) {
                    this.nameInFS.add(file.getName());
                }
            }
            parent = null;
        }
    }

    public synchronized String calculateTileId(ITileOrigin map, int x, int y, int zoom) {
        this.builder.setLength(0);
        this.builder.append(zoom).append('_').append(x).append('_').append(y).append(map == null ? ".jpg" : map.getTileFormatData());
        return this.builder.toString();
    }

    public Bitmap getTileImageForMapAsync(String file, ITileOrigin map, int x, int y, int zoom, boolean loadFromInternetIfNeeded) {
        return this.getTileImageForMap(file, map, x, y, zoom, loadFromInternetIfNeeded, false, true);
    }

    public Bitmap getTileImageForMapSync(String file, ITileOrigin map, int x, int y, int zoom, boolean loadFromInternetIfNeeded) {
        return this.getTileImageForMap(file, map, x, y, zoom, loadFromInternetIfNeeded, true, true);
    }

    protected Bitmap getTileImageForMap(String file, ITileOrigin map, int x, int y, int zoom, boolean loadFromInternetIfNeeded, boolean sync, boolean loadFromFs) {
        return this.getTileImageForMap(file, map, x, y, zoom, loadFromInternetIfNeeded, sync, loadFromFs, false);
    }

    protected synchronized Bitmap getTileImageForMap(String tileId, ITileOrigin map, int x, int y, int zoom, boolean loadFromInternetIfNeeded, boolean sync, boolean loadFromFs, boolean deleteBefore) {
        if (tileId == null) {
            tileId = this.calculateTileId(map, x, y, zoom);
        }
        if (this.cacheOfImages.getCache(tileId) == null) {
            String url = loadFromInternetIfNeeded ? map.getUrlLoadData(x, y, zoom) : null;
            MapTileDownloader mapTileDownloader = this.downloader;
            Objects.requireNonNull(mapTileDownloader);
            MapTileDownloader.TileLoadDownloadRequest req = mapTileDownloader.new MapTileDownloader.TileLoadDownloadRequest(null, url, null, tileId, map, x, y, zoom, 0);
            if (sync) {
                return this.getRequestedImageTileSync(req);
            }
            return this.getRequestedImageTile(req);
        }
        return this.cacheOfImages.getCache(tileId);
    }

    private Bitmap getRequestedImageTile(MapTileDownloader.TileLoadDownloadRequest req) {
        if (req.tileId == null) {
            return null;
        }
        if (this.nameInFS.contains(req.tileId)) {
            req.filepath = this.TILES_PATH_HD + "/" + req.tileId;
            this.downloader.requestToFileDownload(req);
        } else if (this.cacheOfImages.getCache(req.tileId) == null && req.url != null) {
            this.downloader.downloadRequest(req);
        }
        return null;
    }

    private Bitmap getRequestedImageTileSync(MapTileDownloader.TileLoadDownloadRequest req) {
        if (req.tileId == null) {
            return null;
        }
        Bitmap result = null;
        if (this.nameInFS.contains(req.tileId)) {
            req.filepath = this.TILES_PATH_HD + "/" + req.tileId;
            this.downloader.requestToFileDownload(req);
        } else if (this.cacheOfImages.getCache(req.tileId) == null && req.url != null) {
            try {
                URL u = new URL(req.url);
                InputStream is = u.openStream();
                BitmapFactory.Options options = new BitmapFactory.Options();
                options.inPreferredConfig = Bitmap.Config.RGB_565;
                result = BitmapFactory.decodeStream((InputStream)new MapTileDownloader.FlushedInputStream(is), null, (BitmapFactory.Options)options);
                if (is != null) {
                    MapUtils.closeStream(is);
                }
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IOException iOException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return result;
    }

    public void insertImage(final String filename, final Bitmap bitmap) {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ArrayList<String> arrayList = ResourceManager.this.nameInFS;
                synchronized (arrayList) {
                    if (ResourceManager.this.nameInFS.size() > 30) {
                        try {
                            for (int i = 0; i < 10; ++i) {
                                new File(ResourceManager.this.TILES_PATH_HD + "/" + ResourceManager.this.nameInFS.get(i)).delete();
                                ResourceManager.this.nameInFS.remove(i);
                            }
                        }
                        catch (Exception i) {
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    if (!ResourceManager.this.nameInFS.contains(filename)) {
                        try {
                            FileOutputStream out = new FileOutputStream(ResourceManager.this.TILES_PATH_HD + "/" + filename);
                            bitmap.compress(Bitmap.CompressFormat.PNG, 60, (OutputStream)out);
                            out.close();
                            ResourceManager.this.nameInFS.add(filename);
                        }
                        catch (RuntimeException e) {
                            throw e;
                        }
                        catch (Exception exception) {
                        }
                    }
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTileImageFromCache(String tileId, Bitmap bmp) {
        if (this.cacheOfImages.linkedHashMap().entrySet().size() > MapUtils.nTileCacheLimit) {
            Iterator<String> keys = this.cacheOfImages.linkedHashMap().keySet().iterator();
            for (int nIndex = this.cacheOfImages.linkedHashMap().entrySet().size() - MapUtils.nTileCacheLimit; nIndex > 0; --nIndex) {
                if (!keys.hasNext()) continue;
                this.cacheOfImages.remove(keys.next());
            }
        }
        try {
            LruCacheSave<String, Bitmap> nIndex = this.cacheOfImages;
            synchronized (nIndex) {
                if (this.cacheOfImages.getCache(tileId) == null) {
                    this.cacheOfImages.putCache(tileId, bmp);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void removeTileImageFromCache() {
        if (this.cacheOfImages.getSize() > 0) {
            this.cacheOfImages.allEvict();
        }
    }

    public Bitmap getTileImageFromCache(String file) {
        try {
            return this.cacheOfImages.getCache(file);
        }
        catch (Exception e) {
            return null;
        }
    }

    public class Traffice {
        private Bitmap tileBitmap;
        private long nTime;

        public Traffice(Bitmap tile, long time) {
            this.tileBitmap = tile;
            this.nTime = time;
        }

        public Bitmap getTrafficeTile() {
            return this.tileBitmap;
        }

        public long getloadTime() {
            return this.nTime;
        }
    }
}

