/*
 * Decompiled with CFR 0.152.
 */
package com.skt.Tmap;

public class TMapKatec {
    double PI = Math.PI;
    double a = 6377397.155;
    double ee = 0.006674372231315;
    double false_e = 400000.0;
    double false_n = 600000.0;
    double en_m0 = 0.9999;
    double origin_lon = 128.0;
    double A = 1.005037306048555;
    double B = 0.0050478492403;
    double C = 1.0563786831E-5;
    double D = 2.0633322E-8;
    public double mRetX;
    public double mRetY;

    double ConvDDD2Do(String pos_data) {
        double ccSEC;
        double ccMIN;
        String[] ccList = pos_data.split(":");
        double ccDO = Double.parseDouble(ccList[0]);
        String[] ccMS = ccList[1].split("\\.");
        if (ccMS.length == 3) {
            ccMIN = Double.parseDouble(ccMS[0]);
            ccSEC = Double.parseDouble(ccMS[1] + "." + ccMS[2]);
        } else {
            ccMIN = Double.parseDouble(ccMS[0]);
            ccSEC = Double.parseDouble(ccMS[1]);
        }
        return ccDO += ccMIN / 60.0 + ccSEC / 3600.0;
    }

    public void ConvDDD2Kal(String srcX, String srcY) {
        double dstX = Double.parseDouble(srcX);
        double dstY = Double.parseDouble(srcY);
        this.WgsToBessel(dstX, dstY);
        this.BesselToKaTech(this.mRetX, this.mRetY);
    }

    public void ConvDDD2Kal(double dstX, double dstY) {
        this.WgsToBessel(dstX, dstY);
        this.BesselToKaTech(this.mRetX, this.mRetY);
    }

    double rad(double x) {
        return x * this.PI / 180.0;
    }

    double fnxco(double olat) {
        return this.a * (1.0 - this.ee) * (this.A * olat - 0.5 * this.B * Math.sin(2.0 * olat) + 0.25 * this.C * Math.sin(4.0 * olat) - 0.16666666666666666 * this.D * Math.sin(6.0 * olat));
    }

    void BesselToKaTech(double la, double lo) {
        double lat = la;
        double lon = lo;
        double origin_lat = this.rad(38.0);
        lon -= this.origin_lon;
        lon = this.rad(lon);
        lat = this.rad(lat);
        double b = this.fnxco(lat) - this.fnxco(origin_lat);
        double N = this.a / Math.sqrt(1.0 - this.ee * Math.pow(Math.sin(lat), 2.0));
        double e_prime = this.ee / (1.0 - this.ee);
        double nn = e_prime * Math.pow(Math.cos(lat), 2.0);
        double t = Math.tan(lat);
        double e = this.en_m0 * (lon * N * Math.cos(lat) + Math.pow(lon, 3.0) / 6.0 * N * Math.pow(Math.cos(lat), 3.0) * (1.0 - t * t + nn) + Math.pow(lon, 5.0) / 120.0 * N * Math.pow(Math.cos(lat), 5.0) * (5.0 - 18.0 * t * t + Math.pow(t, 4.0)));
        double n = this.en_m0 * (b + Math.pow(lon, 2.0) / 2.0 * N * Math.sin(lat) * Math.cos(lat) + Math.pow(lon, 4.0) / 24.0 * N * Math.sin(lat) * Math.pow(Math.cos(lat), 3.0) * (5.0 - t * t + 9.0 * nn));
        this.mRetX = e + this.false_e;
        this.mRetY = n + this.false_n;
    }

    void WgsToBessel(double lat, double lng) {
        int dtx = 128;
        int dty = -481;
        int dtz = -664;
        double Bessel_a = 6377397.155;
        double wgs84_a = 6378137.0;
        double Bessel_f = 0.003342773182174806;
        double wgs84_f = 0.0033528106647474805;
        double dta = Bessel_a - wgs84_a;
        double dtf = Bessel_f - wgs84_f;
        double wgs84_e2 = (2.0 - wgs84_f) * wgs84_f;
        double Q = this.PI / 180.0 * lat;
        double L = this.PI / 180.0 * lng;
        double S = this.PI / 648000.0;
        double Rn = wgs84_a / Math.pow(1.0 - wgs84_e2 * (Math.sin(Q) * Math.sin(Q)), 0.5);
        double Rm = wgs84_a * (1.0 - wgs84_e2) / Math.pow(1.0 - wgs84_e2 * (Math.sin(Q) * Math.sin(Q)), 1.5);
        double dtlat = ((double)dtz * Math.cos(Q) - (double)dtx * Math.sin(Q) * Math.cos(L) - (double)dty * Math.sin(Q) * Math.sin(L) + (wgs84_a * dtf + wgs84_f * dta) * Math.sin(2.0 * Q)) / Rm;
        double dtlng = ((double)dty * Math.cos(L) - (double)dtx * Math.sin(L)) / (Rn * Math.cos(Q));
        this.mRetX = lat + (dtlat *= 180.0 / this.PI);
        this.mRetY = lng + (dtlng *= 180.0 / this.PI);
    }
}

