/*
 * Decompiled with CFR 0.152.
 */
package com.skt.Tmap;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.RectF;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.skt.Tmap.TMapLayer;
import com.skt.Tmap.TMapPolygon;
import com.skt.Tmap.TMapView;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class TMapPolygonLayer
implements TMapLayer {
    public Map<String, TMapPolygon> mPolygons = new LinkedHashMap<String, TMapPolygon>();
    private TMapView view = null;
    private DisplayMetrics dm = null;
    private Paint paintPolygon_FILL = null;
    private Paint paintPolygon_STROKE = null;

    @Override
    public void initLayer(TMapView view) {
        this.view = view;
        this.dm = new DisplayMetrics();
        WindowManager wmgr = (WindowManager)view.getContext().getSystemService("window");
        wmgr.getDefaultDisplay().getMetrics(this.dm);
        this.paintPolygon_FILL = new Paint();
        this.paintPolygon_FILL.setStyle(Paint.Style.FILL);
        this.paintPolygon_STROKE = new Paint();
        this.paintPolygon_STROKE.setStyle(Paint.Style.STROKE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(Canvas canvas, RectF latlonRect, boolean nightMode) {
        Map<String, TMapPolygon> map = this.mPolygons;
        synchronized (map) {
            ArrayList<String> list = new ArrayList<String>(this.mPolygons.keySet());
            for (int i = 0; i < list.size(); ++i) {
                this.paintPolygon_FILL.setColor(this.mPolygons.get(list.get(i)).getAreaColor());
                this.paintPolygon_FILL.setAlpha(this.mPolygons.get(list.get(i)).getAreaAlpha());
                this.paintPolygon_STROKE.setColor(this.mPolygons.get(list.get(i)).getLineColor());
                this.paintPolygon_STROKE.setAlpha(this.mPolygons.get(list.get(i)).getLineAlpha());
                this.paintPolygon_STROKE.setStrokeWidth(this.mPolygons.get(list.get(i)).getPolygonWidth());
                Path path = new Path();
                for (int k = 0; k < this.mPolygons.get(list.get(i)).getPolygonPoint().size(); ++k) {
                    if (k == 0) {
                        path.moveTo((float)this.view.getMapXForPoint(this.mPolygons.get(list.get(i)).getPolygonPoint().get(k).getLongitude(), this.mPolygons.get(list.get(i)).getPolygonPoint().get(k).getLatitude()), (float)this.view.getMapYForPoint(this.mPolygons.get(list.get(i)).getPolygonPoint().get(k).getLongitude(), this.mPolygons.get(list.get(i)).getPolygonPoint().get(k).getLatitude()));
                        continue;
                    }
                    path.lineTo((float)this.view.getMapXForPoint(this.mPolygons.get(list.get(i)).getPolygonPoint().get(k).getLongitude(), this.mPolygons.get(list.get(i)).getPolygonPoint().get(k).getLatitude()), (float)this.view.getMapYForPoint(this.mPolygons.get(list.get(i)).getPolygonPoint().get(k).getLongitude(), this.mPolygons.get(list.get(i)).getPolygonPoint().get(k).getLatitude()));
                }
                path.lineTo((float)this.view.getMapXForPoint(this.mPolygons.get(list.get(i)).getPolygonPoint().get(0).getLongitude(), this.mPolygons.get(list.get(i)).getPolygonPoint().get(0).getLatitude()), (float)this.view.getMapYForPoint(this.mPolygons.get(list.get(i)).getPolygonPoint().get(0).getLongitude(), this.mPolygons.get(list.get(i)).getPolygonPoint().get(0).getLatitude()));
                canvas.drawPath(path, this.paintPolygon_FILL);
                canvas.drawPath(path, this.paintPolygon_STROKE);
            }
        }
    }

    @Override
    public void destroyTMapLayer() {
    }

    @Override
    public boolean onTouchEvent(PointF point) {
        return false;
    }

    @Override
    public boolean onLongPressEvent(PointF point) {
        return false;
    }

    @Override
    public boolean drawInScreenPixels() {
        return false;
    }
}

