/*
 * Decompiled with CFR 0.152.
 */
package com.skt.Tmap;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.Log;
import com.skt.Tmap.MapUtils;
import com.skt.Tmap.TMapData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TMapTapi {
    private Context Tcontext;
    private String mPackageName = null;
    private String MnoInfo = "";
    private boolean isInstalledTmap = false;
    private static final int GO_HOME = 1;
    private static final int GO_COMPANY = 2;
    public OnAuthenticationListenerCallback onAuthenticationListener;

    public TMapTapi(Context context) {
        this.Tcontext = context;
        MapUtils.setInitMap(context);
        try {
            this.onAuthenticationListener = (OnAuthenticationListenerCallback)context;
        }
        catch (Exception exception) {
            // empty catch block
        }
        String skPackageName = "com.skt.skaf.l001mtm091";
        String kuPackageName = "com.skt.tmap.ku";
        boolean isInstalledSK = false;
        boolean isInstalledKU = false;
        PackageManager packageManager = this.Tcontext.getPackageManager();
        List installedPkgList = null;
        installedPkgList = Build.VERSION.SDK_INT >= 24 ? packageManager.getInstalledApplications(8192) : packageManager.getInstalledApplications(8192);
        for (ApplicationInfo appFmc : installedPkgList) {
            if (appFmc.packageName.equals(skPackageName)) {
                isInstalledSK = true;
                continue;
            }
            if (!appFmc.packageName.equals(kuPackageName)) continue;
            isInstalledKU = true;
        }
        try {
            this.MnoInfo = this.getMnoInfoString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.MnoInfo.equals("SKT")) {
            if (isInstalledSK || isInstalledKU) {
                this.isInstalledTmap = true;
            }
            if (isInstalledSK) {
                this.mPackageName = skPackageName;
            } else if (isInstalledKU) {
                this.mPackageName = kuPackageName;
            }
        } else {
            if (isInstalledKU) {
                this.isInstalledTmap = true;
            }
            if (isInstalledKU) {
                this.mPackageName = kuPackageName;
            }
        }
    }

    public void setOnAuthenticationListener(OnAuthenticationListenerCallback listener) {
        this.onAuthenticationListener = listener;
    }

    public void setSKTMapAuthentication(String apiKey) {
        if (!MapUtils.isVerifyApiKey) {
            MapUtils.mApiKey = apiKey;
            TMapData.checkApiKey(new TMapData.CheckKeyResultListenerCallback(){

                @Override
                public void onCheckKeyResult(String strResult) {
                    if (strResult.equals("OK")) {
                        if (TMapTapi.this.onAuthenticationListener != null) {
                            TMapTapi.this.onAuthenticationListener.SKTMapApikeySucceed();
                        }
                    } else if (TMapTapi.this.onAuthenticationListener != null) {
                        TMapTapi.this.onAuthenticationListener.SKTMapApikeyFailed(strResult);
                    }
                }
            });
        }
    }

    public boolean isTmapApplicationInstalled() {
        if (!MapUtils.isVerifyApiKey || this.mPackageName == null) {
            return false;
        }
        return this.isInstalledTmap;
    }

    private boolean checkTmapApplicationInstalled() {
        if (this.mPackageName == null) {
            return false;
        }
        boolean bResult = false;
        PackageManager packageManager = this.Tcontext.getPackageManager();
        List installedPkgList = null;
        installedPkgList = Build.VERSION.SDK_INT >= 24 ? packageManager.getInstalledApplications(8192) : packageManager.getInstalledApplications(8192);
        for (ApplicationInfo appFmc : installedPkgList) {
            if (!appFmc.packageName.equals(this.mPackageName)) continue;
            bResult = true;
        }
        return bResult;
    }

    public ArrayList<String> getTMapDownUrl() {
        String strURL = "";
        ArrayList<String> arURL = null;
        if (!MapUtils.isVerifyApiKey) {
            return null;
        }
        if (this.MnoInfo.equals("SKT")) {
            arURL = new ArrayList<String>();
            strURL = "http://onesto.re/0000163382 ";
            arURL.add(strURL);
            strURL = "http://onesto.re/0000703533 ";
            arURL.add(strURL);
        } else {
            arURL = new ArrayList();
            strURL = "https://play.google.com/store/apps/details?id=com.skt.tmap.ku";
            arURL.add(strURL);
            strURL = "http://onesto.re/0000703533 ";
            arURL.add(strURL);
        }
        return arURL;
    }

    public boolean invokeTmap() {
        boolean bResult = false;
        if (!MapUtils.isVerifyApiKey || this.mPackageName == null) {
            return false;
        }
        if (TMapData.invokeStatistics("Z0", true)) {
            if (!this.checkTmapApplicationInstalled()) {
                bResult = false;
            } else {
                try {
                    Intent intent = new Intent("android.intent.action.MAIN");
                    intent.setClassName(this.mPackageName, this.mPackageName + ".IntroActivity");
                    intent.setFlags(0x10000000);
                    this.Tcontext.startActivity(intent);
                    bResult = true;
                }
                catch (Exception e) {
                    bResult = false;
                }
            }
        }
        return bResult;
    }

    public boolean invokeSearchPortal(String szDestName) {
        PackageInfo info = null;
        boolean bResult = false;
        if (!MapUtils.isVerifyApiKey || this.mPackageName == null) {
            return false;
        }
        if (TMapData.invokeStatistics("C0", true)) {
            if (!this.checkTmapApplicationInstalled()) {
                bResult = false;
            } else {
                try {
                    info = this.Tcontext.getPackageManager().getPackageInfo(this.mPackageName, 0);
                    String[] version = info.versionName.split("\\.");
                    if (Integer.parseInt(version[0]) == 3) {
                        bResult = this.invokeSearchPortal30(szDestName);
                    } else if (Integer.parseInt(version[0]) >= 4) {
                        try {
                            String szInvokeMessage = "tmap://search?name=" + szDestName;
                            Intent intent = new Intent("android.intent.action.MAIN");
                            intent.setClassName(this.mPackageName, this.mPackageName + ".IntroActivity");
                            intent.putExtra("url", szInvokeMessage);
                            intent.setFlags(0x10000000);
                            this.Tcontext.startActivity(intent);
                            bResult = true;
                        }
                        catch (Exception e) {
                            bResult = false;
                        }
                    }
                }
                catch (PackageManager.NameNotFoundException e) {
                    bResult = false;
                }
            }
        }
        return bResult;
    }

    public boolean invokeSafeDrive() {
        PackageInfo info = null;
        boolean bResult = false;
        if (!MapUtils.isVerifyApiKey || this.mPackageName == null) {
            return false;
        }
        if (TMapData.invokeStatistics("E0", true)) {
            if (!this.checkTmapApplicationInstalled()) {
                bResult = false;
            } else {
                try {
                    info = this.Tcontext.getPackageManager().getPackageInfo(this.mPackageName, 0);
                    String[] version = info.versionName.split("\\.");
                    if (Integer.parseInt(version[0]) == 3) {
                        bResult = this.invokeSafeDrive30();
                    } else if (Integer.parseInt(version[0]) >= 4) {
                        try {
                            String szInvokeMessage = "tmap://ando";
                            Intent intent = new Intent("android.intent.action.MAIN");
                            intent.setClassName(this.mPackageName, this.mPackageName + ".IntroActivity");
                            intent.putExtra("url", szInvokeMessage);
                            intent.setFlags(0x10000000);
                            this.Tcontext.startActivity(intent);
                            bResult = true;
                        }
                        catch (Exception e) {
                            bResult = false;
                        }
                    }
                }
                catch (PackageManager.NameNotFoundException e) {
                    bResult = false;
                }
            }
        }
        return bResult;
    }

    public boolean invokeSetLocation(String szDestName, float fX, float fY) {
        PackageInfo info = null;
        boolean bResult = false;
        if (!MapUtils.isVerifyApiKey || this.mPackageName == null) {
            return false;
        }
        if (TMapData.invokeStatistics("B0", true)) {
            if (!this.checkTmapApplicationInstalled()) {
                bResult = false;
            } else {
                try {
                    info = this.Tcontext.getPackageManager().getPackageInfo(this.mPackageName, 0);
                    String[] version = info.versionName.split("\\.");
                    if (Integer.parseInt(version[0]) == 3) {
                        bResult = this.invokeSetLocation30(szDestName, fX, fY);
                    } else if (Integer.parseInt(version[0]) >= 4) {
                        try {
                            String szInvokeMessage = "tmap://viewmap?x=" + Float.toString(fX) + "&y=" + Float.toString(fY) + "&name=" + szDestName;
                            Intent intent = new Intent("android.intent.action.MAIN");
                            intent.setClassName(this.mPackageName, this.mPackageName + ".IntroActivity");
                            intent.putExtra("url", szInvokeMessage);
                            intent.setFlags(0x10000000);
                            this.Tcontext.startActivity(intent);
                            bResult = true;
                        }
                        catch (Exception e) {
                            bResult = false;
                        }
                    }
                }
                catch (PackageManager.NameNotFoundException e) {
                    bResult = false;
                }
            }
        }
        return bResult;
    }

    public boolean invokeRoute(String szDestName, float fX, float fY) {
        if (szDestName != null && szDestName.getBytes().length > 128) {
            byte[] byteTemp = new byte[128];
            System.arraycopy(szDestName.getBytes(), 0, byteTemp, 0, 128);
            szDestName = new String(byteTemp);
        }
        PackageInfo info = null;
        boolean bResult = false;
        if (!MapUtils.isVerifyApiKey || this.mPackageName == null) {
            return false;
        }
        if (TMapData.invokeStatistics("A0", true)) {
            if (!this.checkTmapApplicationInstalled()) {
                bResult = false;
            } else {
                try {
                    info = this.Tcontext.getPackageManager().getPackageInfo(this.mPackageName, 0);
                    String[] version = info.versionName.split("\\.");
                    if (Integer.parseInt(version[0]) == 3) {
                        bResult = this.invokeRoute30(szDestName, fX, fY);
                    } else if (Integer.parseInt(version[0]) >= 4) {
                        try {
                            String szInvokeMessage = "tmap://route?referrer=com.skt.Tmap&goalx=" + Float.toString(fX) + "&goaly=" + Float.toString(fY) + "&goalname=" + szDestName;
                            Intent intent = new Intent("android.intent.action.MAIN");
                            intent.setClassName(this.mPackageName, this.mPackageName + ".IntroActivity");
                            intent.putExtra("url", szInvokeMessage);
                            intent.setFlags(0x10000000);
                            this.Tcontext.startActivity(intent);
                            bResult = true;
                        }
                        catch (Exception e) {
                            bResult = false;
                        }
                    } else {
                        bResult = false;
                    }
                }
                catch (PackageManager.NameNotFoundException e) {
                    bResult = false;
                }
            }
        }
        return bResult;
    }

    public boolean invokeGoHome() {
        return this.invokeGo("D0", 1);
    }

    public boolean invokeGoCompany() {
        return this.invokeGo("D1", 2);
    }

    private boolean invokeGo(String invokeCate, int nParam) {
        PackageInfo info = null;
        boolean bResult = false;
        if (!MapUtils.isVerifyApiKey || this.mPackageName == null) {
            return false;
        }
        if (TMapData.invokeStatistics(invokeCate, true)) {
            if (!this.checkTmapApplicationInstalled()) {
                bResult = false;
            } else {
                try {
                    info = this.Tcontext.getPackageManager().getPackageInfo(this.mPackageName, 0);
                    String[] version = info.versionName.split("\\.");
                    if (Integer.parseInt(version[0]) == 3) {
                        return false;
                    }
                    if (Integer.parseInt(version[0]) >= 4) {
                        try {
                            String szInvokeMessage = "tmap://goto?code=" + nParam;
                            Intent intent = new Intent("android.intent.action.MAIN");
                            intent.setClassName(this.mPackageName, this.mPackageName + ".IntroActivity");
                            intent.putExtra("url", szInvokeMessage);
                            intent.setFlags(0x10000000);
                            this.Tcontext.startActivity(intent);
                            bResult = true;
                        }
                        catch (Exception e) {
                            bResult = false;
                        }
                    } else {
                        bResult = false;
                    }
                }
                catch (PackageManager.NameNotFoundException e) {
                    bResult = false;
                }
            }
        }
        return bResult;
    }

    public boolean invokeRoute(HashMap<String, String> routeInfo) {
        boolean bResult;
        block71: {
            PackageInfo info = null;
            bResult = false;
            if (!MapUtils.isVerifyApiKey || this.mPackageName == null) {
                return false;
            }
            if (TMapData.invokeStatistics("A1", true)) {
                if (!this.checkTmapApplicationInstalled()) {
                    bResult = false;
                } else {
                    try {
                        info = this.Tcontext.getPackageManager().getPackageInfo(this.mPackageName, 0);
                        String[] version = info.versionName.split("\\.");
                        if (Integer.parseInt(version[0]) == 3) {
                            bResult = false;
                            break block71;
                        }
                        if (Integer.parseInt(version[0]) >= 4) {
                            try {
                                String strGoX = null;
                                String strGoY = null;
                                String strGoName = null;
                                String strGoGX = null;
                                String strGoGY = null;
                                String strGoId = null;
                                String strGoFlag = null;
                                String strGoAddr = null;
                                String strStName = null;
                                String strStX = null;
                                String strStY = null;
                                String strStId = null;
                                String strStFlag = null;
                                String strStAddr = null;
                                String strV1Name = null;
                                String strV1X = null;
                                String strV1Y = null;
                                String strV1Id = null;
                                String strV1Flag = null;
                                String strV1Addr = null;
                                String strV2Name = null;
                                String strV2X = null;
                                String strV2Y = null;
                                String strV2Id = null;
                                String strV2Flag = null;
                                String strV2Addr = null;
                                String strAngle = null;
                                String strHistoryData = null;
                                String strSearchOption = null;
                                for (Map.Entry<String, String> e : routeInfo.entrySet()) {
                                    if (e.getKey().contains("rGoName")) {
                                        strGoName = e.getValue();
                                        continue;
                                    }
                                    if (e.getKey().contains("rGoX")) {
                                        strGoX = e.getValue();
                                        continue;
                                    }
                                    if (e.getKey().contains("rGoY")) {
                                        strGoY = e.getValue();
                                        continue;
                                    }
                                    if (e.getKey().contains("rGoGX")) {
                                        strGoGX = e.getValue();
                                        continue;
                                    }
                                    if (e.getKey().contains("rGoGY")) {
                                        strGoGY = e.getValue();
                                        continue;
                                    }
                                    if (e.getKey().contains("rGoId")) {
                                        strGoId = e.getValue();
                                        continue;
                                    }
                                    if (e.getKey().contains("rGoFlag")) {
                                        strGoFlag = e.getValue();
                                        continue;
                                    }
                                    if (e.getKey().contains("rGoAddr")) {
                                        strGoAddr = e.getValue();
                                        continue;
                                    }
                                    if (e.getKey().contains("rStName")) {
                                        strStName = e.getValue();
                                        continue;
                                    }
                                    if (e.getKey().contains("rStX")) {
                                        strStX = e.getValue();
                                        continue;
                                    }
                                    if (e.getKey().contains("rStY")) {
                                        strStY = e.getValue();
                                        continue;
                                    }
                                    if (e.getKey().contains("rStId")) {
                                        strStId = e.getValue();
                                        continue;
                                    }
                                    if (e.getKey().contains("rStFlag")) {
                                        strStFlag = e.getValue();
                                        continue;
                                    }
                                    if (e.getKey().contains("rStAddr")) {
                                        strStAddr = e.getValue();
                                        continue;
                                    }
                                    if (e.getKey().contains("rV1Name")) {
                                        strV1Name = e.getValue();
                                        continue;
                                    }
                                    if (e.getKey().contains("rV1X")) {
                                        strV1X = e.getValue();
                                        continue;
                                    }
                                    if (e.getKey().contains("rV1Y")) {
                                        strV1Y = e.getValue();
                                        continue;
                                    }
                                    if (e.getKey().contains("rV1Id")) {
                                        strV1Id = e.getValue();
                                        continue;
                                    }
                                    if (e.getKey().contains("rV1Flag")) {
                                        strV1Flag = e.getValue();
                                        continue;
                                    }
                                    if (e.getKey().contains("rV1Addr")) {
                                        strV1Addr = e.getValue();
                                        continue;
                                    }
                                    if (e.getKey().contains("rV2Name")) {
                                        strV2Name = e.getValue();
                                        continue;
                                    }
                                    if (e.getKey().contains("rV2X")) {
                                        strV2X = e.getValue();
                                        continue;
                                    }
                                    if (e.getKey().contains("rV2Y")) {
                                        strV2Y = e.getValue();
                                        continue;
                                    }
                                    if (e.getKey().contains("rV2Id")) {
                                        strV2Id = e.getValue();
                                        continue;
                                    }
                                    if (e.getKey().contains("rV2Flag")) {
                                        strV2Flag = e.getValue();
                                        continue;
                                    }
                                    if (e.getKey().contains("rV2Addr")) {
                                        strV2Addr = e.getValue();
                                        continue;
                                    }
                                    if (e.getKey().contains("rAngle")) {
                                        strAngle = e.getValue();
                                        continue;
                                    }
                                    if (e.getKey().contains("rHisData")) {
                                        strHistoryData = e.getValue();
                                        continue;
                                    }
                                    if (!e.getKey().contains("rSOpt")) continue;
                                    strSearchOption = e.getValue();
                                }
                                if (strGoName == null || strGoX == null || strGoY == null) {
                                    return false;
                                }
                                byte[] byteTemp = null;
                                if (strGoName != null && strGoName.getBytes().length > 128) {
                                    byteTemp = new byte[128];
                                    System.arraycopy(strGoName.getBytes(), 0, byteTemp, 0, 128);
                                    strGoName = new String(byteTemp);
                                }
                                if (strStName != null && strStName.getBytes().length > 128) {
                                    byteTemp = new byte[128];
                                    System.arraycopy(strStName.getBytes(), 0, byteTemp, 0, 128);
                                    strStName = new String(byteTemp);
                                }
                                if (strV1Name != null && strV1Name.getBytes().length > 128) {
                                    byteTemp = new byte[128];
                                    System.arraycopy(strV1Name.getBytes(), 0, byteTemp, 0, 128);
                                    strV1Name = new String(byteTemp);
                                }
                                if (strV2Name != null && strV2Name.getBytes().length > 128) {
                                    byteTemp = new byte[128];
                                    System.arraycopy(strV2Name.getBytes(), 0, byteTemp, 0, 128);
                                    strV2Name = new String(byteTemp);
                                }
                                String szInvokeMessage = "tmap://route?referrer=com.skt.Tmap&goalx=" + strGoX + "&goaly=" + strGoY + "&goalname=" + strGoName;
                                if (strGoGX != null) {
                                    szInvokeMessage = szInvokeMessage + "&goalgx=" + strGoGX;
                                }
                                if (strGoGY != null) {
                                    szInvokeMessage = szInvokeMessage + "&goalgy=" + strGoGY;
                                }
                                if (strGoId != null) {
                                    szInvokeMessage = szInvokeMessage + "&goalid=" + strGoId;
                                }
                                if (strGoFlag != null) {
                                    szInvokeMessage = szInvokeMessage + "&goalflag=" + strGoFlag;
                                }
                                if (strGoAddr != null) {
                                    szInvokeMessage = szInvokeMessage + "&goaladdr=" + strGoAddr;
                                }
                                if (strStX != null) {
                                    szInvokeMessage = szInvokeMessage + "&startx=" + strStX;
                                }
                                if (strStY != null) {
                                    szInvokeMessage = szInvokeMessage + "&starty= " + strStY;
                                }
                                if (strStName != null) {
                                    szInvokeMessage = szInvokeMessage + "&startname=" + strStName;
                                }
                                if (strStId != null) {
                                    szInvokeMessage = szInvokeMessage + "&startid=" + strStId;
                                }
                                if (strStFlag != null) {
                                    szInvokeMessage = szInvokeMessage + "&startflag=" + strStFlag;
                                }
                                if (strStAddr != null) {
                                    szInvokeMessage = szInvokeMessage + "&startaddr=" + strStAddr;
                                }
                                if (strV1X != null) {
                                    szInvokeMessage = szInvokeMessage + "&via1x=" + strV1X;
                                }
                                if (strV1Y != null) {
                                    szInvokeMessage = szInvokeMessage + "&via1y= " + strV1Y;
                                }
                                if (strV1Name != null) {
                                    szInvokeMessage = szInvokeMessage + "&via1name=" + strV1Name;
                                }
                                if (strV1Id != null) {
                                    szInvokeMessage = szInvokeMessage + "&via1id=" + strV1Id;
                                }
                                if (strV1Flag != null) {
                                    szInvokeMessage = szInvokeMessage + "&via1flag=" + strV1Flag;
                                }
                                if (strV1Addr != null) {
                                    szInvokeMessage = szInvokeMessage + "&via1addr=" + strV1Addr;
                                }
                                if (strV2X != null) {
                                    szInvokeMessage = szInvokeMessage + "&via2x=" + strV2X;
                                }
                                if (strV2Y != null) {
                                    szInvokeMessage = szInvokeMessage + "&via2y= " + strV2Y;
                                }
                                if (strV2Name != null) {
                                    szInvokeMessage = szInvokeMessage + "&via2name=" + strV2Name;
                                }
                                if (strV2Id != null) {
                                    szInvokeMessage = szInvokeMessage + "&via2id=" + strV2Id;
                                }
                                if (strV2Flag != null) {
                                    szInvokeMessage = szInvokeMessage + "&via2flag=" + strV2Flag;
                                }
                                if (strV2Addr != null) {
                                    szInvokeMessage = szInvokeMessage + "&via2addr=" + strV2Addr;
                                }
                                if (strAngle != null) {
                                    szInvokeMessage = szInvokeMessage + "&angle=" + strAngle;
                                }
                                if (strHistoryData != null) {
                                    szInvokeMessage = szInvokeMessage + "&history_data=" + strHistoryData;
                                }
                                if (strSearchOption != null) {
                                    szInvokeMessage = szInvokeMessage + "&guideoption=" + strSearchOption;
                                }
                                Intent intent = new Intent("android.intent.action.MAIN");
                                intent.setClassName(this.mPackageName, this.mPackageName + ".IntroActivity");
                                intent.putExtra("url", szInvokeMessage);
                                intent.setFlags(0x10000000);
                                this.Tcontext.startActivity(intent);
                                bResult = true;
                                break block71;
                            }
                            catch (RuntimeException e) {
                                throw e;
                            }
                            catch (Exception e) {
                                bResult = false;
                                break block71;
                            }
                        }
                        bResult = false;
                    }
                    catch (PackageManager.NameNotFoundException e) {
                        bResult = false;
                    }
                }
            }
        }
        return bResult;
    }

    private boolean invokeSetLocation30(String szDestName, float fX, float fY) {
        boolean blcheck = false;
        try {
            String szInvokeMessage = "A2,+" + Float.toString(fX) + ",+" + Float.toString(fY) + "," + szDestName;
            Intent intent = new Intent("android.intent.action.MAIN");
            intent.setClassName(this.mPackageName, this.mPackageName + ".IntroActivity");
            intent.putExtra("url", szInvokeMessage);
            intent.setFlags(0x10000000);
            this.Tcontext.startActivity(intent);
            blcheck = true;
        }
        catch (Exception e) {
            blcheck = false;
        }
        return blcheck;
    }

    private boolean invokeSafeDrive30() {
        boolean blcheck = false;
        try {
            String szInvokeMessage = "A3";
            Intent intent = new Intent("android.intent.action.MAIN");
            intent.setClassName(this.mPackageName, this.mPackageName + ".IntroActivity");
            intent.putExtra("url", szInvokeMessage);
            intent.setFlags(0x10000000);
            this.Tcontext.startActivity(intent);
            blcheck = true;
        }
        catch (Exception e) {
            blcheck = false;
        }
        return blcheck;
    }

    private boolean invokeSearchPortal30(String szDestName) {
        boolean blcheck = false;
        try {
            String szInvokeMessage = "A4," + szDestName;
            Intent intent = new Intent("android.intent.action.MAIN");
            intent.setClassName(this.mPackageName, this.mPackageName + ".IntroActivity");
            intent.putExtra("url", szInvokeMessage);
            intent.setFlags(0x10000000);
            this.Tcontext.startActivity(intent);
            blcheck = true;
        }
        catch (Exception e) {
            blcheck = false;
        }
        return blcheck;
    }

    private boolean invokeRoute30(String szDestName, float fX, float fY) {
        boolean blcheck = false;
        try {
            String szInvokeMessage = "A1,+" + Float.toString(fX) + ",+" + Float.toString(fY) + "," + szDestName;
            Intent intent = new Intent("android.intent.action.MAIN");
            intent.setClassName(this.mPackageName, this.mPackageName + ".IntroActivity");
            intent.putExtra("url", szInvokeMessage);
            intent.setFlags(0x10000000);
            this.Tcontext.startActivity(intent);
            blcheck = true;
        }
        catch (Exception e) {
            blcheck = false;
        }
        return blcheck;
    }

    public String getMnoInfoString() {
        TelephonyManager tm = (TelephonyManager)this.Tcontext.getSystemService("phone");
        String mno = tm.getNetworkOperatorName();
        String operator = tm.getNetworkOperator();
        if ((mno = mno.toUpperCase()).contains("SKT")) {
            return "SKT";
        }
        if (mno.contains("KT") || mno.contains("OLLEH")) {
            return "KTF";
        }
        if (mno.contains("LG")) {
            return "LGT";
        }
        if ("45005".equals(operator)) {
            return "SKT";
        }
        if ("45008".equals(operator)) {
            return "KTF";
        }
        if ("45006".equals(operator)) {
            return "LGT";
        }
        return "Other";
    }

    public boolean invokeNavigate(String szDestName, float fX, float fY, int poiid, boolean isAutoClose) {
        boolean bResult;
        block14: {
            if (szDestName != null && szDestName.getBytes().length > 128) {
                byte[] byteTemp = new byte[128];
                System.arraycopy(szDestName.getBytes(), 0, byteTemp, 0, 128);
                szDestName = new String(byteTemp);
            }
            PackageInfo info = null;
            bResult = false;
            if (!MapUtils.isVerifyApiKey || this.mPackageName == null) {
                return false;
            }
            if (TMapData.invokeStatistics("A0", true)) {
                if (!this.checkTmapApplicationInstalled()) {
                    bResult = false;
                } else {
                    try {
                        info = this.Tcontext.getPackageManager().getPackageInfo(this.mPackageName, 0);
                        String[] version = info.versionName.split("\\.");
                        if (Integer.parseInt(version[0] + version[1] + version[2]) >= 704) {
                            try {
                                String szInvokeMessage = "tmap://navigate?referrer=com.skt.Tmap&name=";
                                szInvokeMessage = szDestName != null && szDestName.trim() != "" ? szInvokeMessage + szDestName : szInvokeMessage + "\ub3c4\ucc29\uc9c0";
                                if (fX > 0.0f && fY > 0.0f) {
                                    szInvokeMessage = szInvokeMessage + "&lon=" + Float.toString(fX) + "&lat=" + Float.toString(fY);
                                } else if (poiid > 0) {
                                    szInvokeMessage = szInvokeMessage + "&poiid=" + poiid;
                                }
                                if (fX > 0.0f && fY > 0.0f || poiid > 0) {
                                    szInvokeMessage = szInvokeMessage + "&autoclose=" + (isAutoClose ? "y" : "n");
                                    Intent intent = new Intent("android.intent.action.MAIN");
                                    intent.setClassName(this.mPackageName, this.mPackageName + ".IntroActivity");
                                    intent.putExtra("url", szInvokeMessage);
                                    intent.setFlags(0x10000000);
                                    this.Tcontext.startActivity(intent);
                                    bResult = true;
                                }
                                break block14;
                            }
                            catch (Exception e) {
                                bResult = false;
                            }
                            break block14;
                        }
                        Log.w((String)"SKT", (String)"invokeNavigate \ud568\uc218\ub294 TMapApp v7.0.4 \uc774\uc0c1\ubd80\ud130 \uc9c0\uc6d0\ud569\ub2c8\ub2e4.");
                        bResult = false;
                    }
                    catch (PackageManager.NameNotFoundException e) {
                        bResult = false;
                    }
                }
            }
        }
        return bResult;
    }

    public boolean invokeNavigate(String szDestName, float fX, float fY, int poiid, boolean isAutoClose, int guideOption) {
        boolean bResult;
        block14: {
            if (szDestName != null && szDestName.getBytes().length > 128) {
                byte[] byteTemp = new byte[128];
                System.arraycopy(szDestName.getBytes(), 0, byteTemp, 0, 128);
                szDestName = new String(byteTemp);
            }
            PackageInfo info = null;
            bResult = false;
            if (!MapUtils.isVerifyApiKey || this.mPackageName == null) {
                return false;
            }
            if (TMapData.invokeStatistics("A0", true)) {
                if (!this.checkTmapApplicationInstalled()) {
                    bResult = false;
                } else {
                    try {
                        info = this.Tcontext.getPackageManager().getPackageInfo(this.mPackageName, 0);
                        String[] version = info.versionName.split("\\.");
                        if (Integer.parseInt(version[0] + version[1] + version[2]) >= 704) {
                            try {
                                String szInvokeMessage = "tmap://navigate?referrer=com.skt.Tmap&name=";
                                szInvokeMessage = szDestName != null && szDestName.trim() != "" ? szInvokeMessage + szDestName : szInvokeMessage + "\ub3c4\ucc29\uc9c0";
                                if (fX > 0.0f && fY > 0.0f) {
                                    szInvokeMessage = szInvokeMessage + "&lon=" + Float.toString(fX) + "&lat=" + Float.toString(fY);
                                } else if (poiid > 0) {
                                    szInvokeMessage = szInvokeMessage + "&poiid=" + poiid;
                                }
                                szInvokeMessage = szInvokeMessage + "&guideoption=" + guideOption;
                                if (fX > 0.0f && fY > 0.0f || poiid > 0) {
                                    szInvokeMessage = szInvokeMessage + "&autoclose=" + (isAutoClose ? "y" : "n");
                                    Intent intent = new Intent("android.intent.action.MAIN");
                                    intent.setClassName(this.mPackageName, this.mPackageName + ".IntroActivity");
                                    intent.putExtra("url", szInvokeMessage);
                                    intent.setFlags(0x10000000);
                                    this.Tcontext.startActivity(intent);
                                    bResult = true;
                                }
                                break block14;
                            }
                            catch (Exception e) {
                                bResult = false;
                            }
                            break block14;
                        }
                        Log.w((String)"SKT", (String)"invokeNavigate \ud568\uc218\ub294 TMapApp v7.0.4 \uc774\uc0c1\ubd80\ud130 \uc9c0\uc6d0\ud569\ub2c8\ub2e4.");
                        bResult = false;
                    }
                    catch (PackageManager.NameNotFoundException e) {
                        bResult = false;
                    }
                }
            }
        }
        return bResult;
    }

    public static interface OnAuthenticationListenerCallback {
        public void SKTMapApikeySucceed();

        public void SKTMapApikeyFailed(String var1);
    }
}

