/*
 * Decompiled with CFR 0.152.
 */
package com.skt.Tmap;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.opengl.GLSurfaceView;
import android.os.Build;
import android.os.Handler;
import android.os.PowerManager;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.View;
import android.view.WindowManager;
import android.widget.ImageView;
import com.skt.Tmap.DraggingAnimateThread;
import com.skt.Tmap.ITileOrigin;
import com.skt.Tmap.MainThread;
import com.skt.Tmap.MapTileDownloader;
import com.skt.Tmap.MapUtils;
import com.skt.Tmap.MultiTouchEvent;
import com.skt.Tmap.PointLocationLayer;
import com.skt.Tmap.ResourceManager;
import com.skt.Tmap.TMapCircle;
import com.skt.Tmap.TMapCircleLayer;
import com.skt.Tmap.TMapData;
import com.skt.Tmap.TMapGLRenderer;
import com.skt.Tmap.TMapInfo;
import com.skt.Tmap.TMapLabelInfo;
import com.skt.Tmap.TMapLayer;
import com.skt.Tmap.TMapMarkerItem;
import com.skt.Tmap.TMapMarkerItem2;
import com.skt.Tmap.TMapMarkerItemLayer;
import com.skt.Tmap.TMapOverlay;
import com.skt.Tmap.TMapOverlayItem;
import com.skt.Tmap.TMapPOILayer;
import com.skt.Tmap.TMapPathLayer;
import com.skt.Tmap.TMapPoint;
import com.skt.Tmap.TMapPolyLine;
import com.skt.Tmap.TMapPolyLineLayer;
import com.skt.Tmap.TMapPolygon;
import com.skt.Tmap.TMapPolygonLayer;
import com.skt.Tmap.TMapRenderer;
import com.skt.Tmap.TileSourceManager;
import com.skt.Tmap.TrackingThread;
import com.skt.Tmap.poi_item.TMapPOIItem;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONObject;

public class TMapView
extends GLSurfaceView
implements DraggingAnimateThread.DraggingCallback,
GestureDetector.OnGestureListener,
GestureDetector.OnDoubleTapListener,
MultiTouchEvent.MultiTouchListener,
SensorEventListener,
SurfaceHolder.Callback {
    private ArrayList<TMapRenderer.Tile> artile = new ArrayList();
    private int MaxTiles = 0;
    private boolean Slide = false;
    private Context mContext = null;
    private ResourceManager mResourceManager = null;
    protected int emptyTileDivisor = 8;
    private boolean isScreenOff = false;
    protected float zoom = 15.0f;
    private double latitude = 37.566474;
    private double longitude = 126.985022;
    private double locationlatitude = 37.566474;
    private double locationLongitude = 126.985022;
    private float rotate = 0.0f;
    private float rotateSin = 0.0f;
    private float rotateCos = 1.0f;
    private int mapPosition = 0;
    public static final int POSITION_DEFAULT = 0;
    public static final int POSITION_NAVI = 1;
    public ITileOrigin map = null;
    public MapUtils mapUtils = null;
    private List<TMapLayer> layers = new ArrayList<TMapLayer>();
    private Map<TMapLayer, Float> zOrders = new HashMap<TMapLayer, Float>();
    protected Handler handler = new Handler();
    private DraggingAnimateThread animatedDraggingThread = null;
    private TrackingThread trackingthread = null;
    private float initialMultiTouchZoom = 0.0f;
    private GestureDetector gestureDetector = null;
    private MultiTouchEvent multiTouchSupport = null;
    private PointLocationLayer locationLayer = null;
    private TMapCircleLayer circleLayer = null;
    private TMapPolygonLayer polygonLayer = null;
    private TMapPolyLineLayer polyLineLayer = null;
    private TMapMarkerItemLayer markerItemLayer = null;
    private TMapPOILayer poiLayer = null;
    private TMapPathLayer pathLayer = null;
    private DisplayMetrics dm = null;
    private int currentScreenOrientation = 0;
    private boolean compassMode = false;
    private boolean compassMode_2 = false;
    private int Language = 0;
    public static final int LANGUAGE_KOREAN = 0;
    private int MapType = 0;
    public static final int MAPTYPE_STANDARD = 0;
    public static final int MAPTYPE_SATELLITE = 1;
    public static final int MAPTYPE_HYBRID = 2;
    public int TileType = 2;
    public static final int TILETYPE_NORMALTILE = 0;
    public static final int TILETYPE_HDTILE = 2;
    private Bitmap EmptyBitmap = null;
    private Bitmap LogoBitmap = null;
    private boolean mbZooming = false;
    private boolean onSingleTapUp = false;
    private TMapGLRenderer mRenderer;
    private MainThread mGlMainThread;
    private Handler mGlHandler;
    private boolean mGlDrawCls = false;
    TMapRenderer mTMapRenderer = null;
    private int mBackgroundCheck = 0;
    private int mScreenWidth = 0;
    private int mScreenHeight = 0;
    private TMapLogoPositon mLogoPlace = TMapLogoPositon.POSITION_BOTTOMRIGHT;
    private ArrayList<String> mlist = new ArrayList();
    private MapTileDownloader mMapTileDownloader = null;
    private boolean mClusterView = false;
    private Bitmap mClusteringBitmap = null;
    private Bitmap mDefaultIcon = null;
    private boolean mUserScrollZoomEnable = false;
    private SensorManager mSensorMgr = null;
    private Map<String, TMapOverlay> overlays = new LinkedHashMap<String, TMapOverlay>();
    private final CopyOnWriteArrayList<TMapOverlay> mOverlayList = new CopyOnWriteArrayList();
    private ImageView mImageView = null;
    private int mWidthV = 0;
    private int mHeightV = 0;
    private int mWidthH = 0;
    private int mHeightH = 0;
    private Bitmap mEmpty;
    private Bitmap mEmptyH;
    private Bitmap mEmptyV;
    private Canvas mCanvas2;
    private Canvas mCanvasV;
    private Canvas mCanvasH;
    public static final int JUMP_ZOOM = 0;
    public static final int NEXT_ZOOM = 1;
    public static final int PREV_ZOOM = 2;
    public static final int DEFAULT_ZOOM = -1;
    private int zoomType = -1;
    private int moveZoomLevel = -1;
    private static String mHDUrl = null;
    private static String mSslHDUrl = null;
    private static final String mENGUrl = "http://topenbtile.tmap.co.kr:80";
    private static final String mCNUrl = "http://topcnbtile.tmap.co.kr:80";
    private static final String mSDUrl = "http://topsdbtile.tmap.co.kr:80";
    private static final String mCONUrl = "http://topkoctile.tmap.co.kr:80";
    public float mDensity = 0.0f;
    private float mFullHDSizeUP = 1.0f;
    private boolean isAddView = false;
    private Object objDrawSync = new Object();
    private Object objDrawBoardSync = new Object();
    public static final int SCROLL_SENSITIVITY_ZORO = 0;
    public static final int SCROLL_SENSITIVITY_LOW = 1;
    public static final int SCROLL_SENSITIVITY_MIDDLE = 2;
    public static final int SCROLL_SENSITIVITY_HIGH = 3;
    private boolean isTrafficInfoActive = false;
    private long prevTrafficActionUpTime = 0L;
    private float prevZoom = 0.0f;
    private TMapPoint mLeftTop = null;
    private TMapPoint mRightBottom = null;
    private int mTrafficListSize = 0;
    float d = 0.0f;
    float newRot = 0.0f;
    float lastRot = 0.0f;
    private boolean isRotateEnable = false;
    public OnLongClickListenerCallback onLongClickListener;
    public OnClickListenerCallback onClickListener;
    public OnCalloutRightButtonClickCallback onCalloutRightButtonListener;
    public OnEnableScrollWithZoomLevelCallback onEnableScrollWithZoomLevelListener;
    public OnDisableScrollWithZoomLevelCallback onDisableScrollWithZoomLevelListener;
    public OnClickReverseLabelListenerCallback onClickReverseLabelListener;
    public OnApiKeyListenerCallback onApiKeyListener;
    public OnCalloutMarker2ClickCallback onMarker2ClickListener;
    private boolean isZoom = false;
    protected RectF tilesRect = new RectF();
    protected RectF TMapPointRect = new RectF();
    protected Rect boundsRect = new Rect();
    protected RectF bitmapToDraw = new RectF();
    protected Rect bitmapToZoom = new Rect();
    private static final int NONE = 0;
    private static final int DRAG = 1;
    private static final int ZOOM = 2;
    private static final int PINCHZOOM = 3;
    private int mode = 0;
    private long prevActionUpTime = 0L;
    private double prevLongitude = 0.0;
    private double prevLatitude = 0.0;
    private float prevActionMoveX = 0.0f;
    private float prevActionMoveY = 0.0f;
    private float actionMoveDiffX = 0.0f;
    private float actionMoveDiffY = 0.0f;
    private static final int FLING_APPROVAL_STANDARD = 2000;
    private static final int FLING_MOVE_DELAY = 10;
    private static final int MAX_FLING_MOVE_DELAY = 20;
    private static int OFFSET_FLING_DISTANCE = 5;
    private static int BASE_CNT_FLING_MOVE = 60;
    private Thread flingThread = null;
    private boolean isflingStop = false;
    private boolean isPinchZoom = false;
    private boolean isScrolling = false;
    private float[] prevAccelData = new float[]{0.0f, 0.0f, 0.0f};
    private float lastAngle = 0.0f;
    private int offsetAngleRange = 10;
    private float[] accelData = null;
    private float[] magneticData = null;
    private double zoomLongitude = 0.0;
    private double zoomLatitude = 0.0;
    private boolean isFixZoomPosition = false;
    private int zoomPointX = 0;
    private int zoomPointY = 0;
    private boolean isScrollAnimationActive = false;
    private boolean isHttpsMode = false;

    public TMapView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs);
        this.setInitMap(context);
    }

    public TMapView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setInitMap(context);
    }

    public TMapView(Context context) {
        super(context);
        this.setInitMap(context);
    }

    public TMapView(Context context, int tileType) {
        super(context);
        this.TileType = tileType;
        this.setInitMap(context);
    }

    public TMapView(Context context, double centerLon, double centerLat, int zoomLevel) {
        super(context);
        this.longitude = centerLon;
        this.latitude = centerLat;
        if (zoomLevel > this.getMaximumShownMapZoom()) {
            zoomLevel = this.getMaximumShownMapZoom();
        } else if (zoomLevel < this.getMinimumShownMapZoom()) {
            zoomLevel = this.getMinimumShownMapZoom();
        }
        this.zoom = zoomLevel;
        this.setInitMap(context);
    }

    public TMapView(Context context, double centerLon, double centerLat, int zoomLevel, int tileType) {
        super(context);
        this.longitude = centerLon;
        this.latitude = centerLat;
        this.TileType = tileType;
        if (zoomLevel <= this.getMaximumShownMapZoom() && zoomLevel >= this.getMinimumShownMapZoom()) {
            this.zoom = zoomLevel;
        }
        this.setInitMap(context);
    }

    protected int[] onCreateDrawableState(int extraSpace) {
        this.setBackgroundColor(-3355444);
        return super.onCreateDrawableState(extraSpace);
    }

    protected void drawableStateChanged() {
        this.setBackgroundColor(-3355444);
        super.drawableStateChanged();
    }

    private void setInitMap(Context context) {
        int ip;
        float fp;
        float ratio;
        this.mContext = context;
        this.setScreenOffEvent();
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
        this.setFocusable(true);
        if (Build.VERSION.SDK_INT >= 28) {
            this.isHttpsMode = true;
        }
        mHDUrl = TMapView.getProperties(context).getProperty("tileUrl");
        mSslHDUrl = TMapView.getProperties(context).getProperty("sslTileUrl");
        Display display = null;
        if (null == this.dm) {
            this.dm = new DisplayMetrics();
            WindowManager wmgr = (WindowManager)this.getContext().getSystemService("window");
            display = wmgr.getDefaultDisplay();
            display.getMetrics(this.dm);
        }
        this.mFullHDSizeUP = 1.0f;
        this.mDensity = this.dm.density / 2.0f;
        if (this.mDensity < 1.0f) {
            this.mDensity = 1.0f;
        }
        this.mFullHDSizeUP = (ratio = this.dm.xdpi / 256.0f) >= 1.0f ? ((double)(fp = ratio - (float)(ip = (int)ratio)) >= 0.5 ? (float)ip + 0.5f : (float)ip) : 1.0f;
        if (this.mFullHDSizeUP < 1.0f) {
            this.mFullHDSizeUP = 1.0f;
        }
        MapUtils.setInitMap(context);
        this.mMapTileDownloader = new MapTileDownloader();
        this.mResourceManager = new ResourceManager(this.mContext, this.mContext.getPackageName(), this.mMapTileDownloader);
        this.mTMapRenderer = new TMapRenderer(this.mContext, this, this.mMapTileDownloader, this.mResourceManager);
        this.initView();
        this.setCallback();
        this.setWillNotDraw(false);
        this.setScrollAnimation(2);
        this.setBufferStep(1);
        String strModel = Build.MODEL;
        Log.d((String)"slsolution", (String)("Build.MODEL : " + Build.MODEL));
        Log.d((String)"slsolution", (String)("Build.VERSION.SDK_INT : " + Build.VERSION.SDK_INT));
        if (Build.VERSION.SDK_INT < 27 || strModel.indexOf("LM-G7") > -1) {
            this.setLayerType(1, null);
            MapUtils.nTileCacheLimit = 200;
        } else {
            this.setLayerType(2, null);
            MapUtils.nTileCacheLimit = 400;
        }
        if (Build.VERSION.SDK_INT >= 13) {
            Point outSize = new Point();
            display.getSize(outSize);
            this.setMinZoomLevel(outSize.x, outSize.y);
        } else {
            this.setMinZoomLevel(display.getWidth(), display.getHeight());
        }
        this.locationLayer = new PointLocationLayer();
        this.addLayer(this.locationLayer, 5.0f);
        this.circleLayer = new TMapCircleLayer();
        this.addLayer(this.circleLayer, 6.0f);
        this.polygonLayer = new TMapPolygonLayer();
        this.addLayer(this.polygonLayer, 7.0f);
        this.polyLineLayer = new TMapPolyLineLayer();
        this.addLayer(this.polyLineLayer, 8.0f);
        this.pathLayer = new TMapPathLayer(this.mContext);
        this.addLayer(this.pathLayer, 9.0f);
        this.markerItemLayer = new TMapMarkerItemLayer(this.mContext);
        this.addLayer(this.markerItemLayer, 10.0f);
        this.poiLayer = new TMapPOILayer();
        this.addLayer(this.poiLayer, 11.0f);
        this.mSensorMgr = (SensorManager)context.getSystemService("sensor");
        try {
            this.onLongClickListener = (OnLongClickListenerCallback)context;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.onClickListener = (OnClickListenerCallback)context;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.onCalloutRightButtonListener = (OnCalloutRightButtonClickCallback)context;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.onEnableScrollWithZoomLevelListener = (OnEnableScrollWithZoomLevelCallback)context;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.onDisableScrollWithZoomLevelListener = (OnDisableScrollWithZoomLevelCallback)context;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.onClickReverseLabelListener = (OnClickReverseLabelListenerCallback)context;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.onApiKeyListener = (OnApiKeyListenerCallback)context;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mGlDrawCls = true;
    }

    private void setArTile(TMapRenderer.Tile t) {
        if (this.artile.size() > this.MaxTiles - 1) {
            this.artile.remove(0);
        }
        this.artile.add(t);
    }

    public ArrayList<TMapRenderer.Tile> getSlideTiles() {
        return this.artile;
    }

    public void setSlideMode(boolean mode) {
        this.Slide = mode;
        if (this.Slide) {
            this.postInvalidate();
        } else {
            this.artile.clear();
        }
    }

    private void setMinZoomLevel(int width, int height) {
        int tileSize = 0;
        tileSize = 512;
        tileSize = (int)((float)tileSize * this.mFullHDSizeUP);
        int wTileCnt = width / tileSize;
        int hTileCnt = height / tileSize;
        int minZoom = 3;
        int TileCnt = (int)Math.pow(2.0, minZoom - 2);
        while (TileCnt < wTileCnt || TileCnt < hTileCnt) {
            TileCnt = (int)Math.pow(2.0, ++minZoom - 2);
            this.map.setMinimumZoom(minZoom);
        }
    }

    private void initMapView() {
        this.setEGLContextClientVersion(2);
        this.mRenderer = new TMapGLRenderer();
        this.setRenderer(this.mRenderer);
        this.setRenderMode(0);
        this.EmptyBitmap = this.loadBitmap("empty.png", true);
        this.LogoBitmap = this.loadBitmap("poweredby.png", true);
        this.mClusteringBitmap = this.loadBitmap("clustering.png", true);
        this.mDefaultIcon = this.loadBitmap("point.png", true);
    }

    public Bitmap loadBitmap(String imgName, boolean isSizeUp) {
        Bitmap bitmap = null;
        AssetManager assetmanager = this.getResources().getAssets();
        try {
            InputStream is = assetmanager.open(imgName, 3);
            bitmap = BitmapFactory.decodeStream((InputStream)is);
        }
        catch (Exception is) {
            // empty catch block
        }
        if (isSizeUp) {
            int width = (int)((float)bitmap.getWidth() * this.mDensity);
            int height = (int)((float)bitmap.getHeight() * this.mDensity);
            bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)width, (int)height, (boolean)true);
        }
        return bitmap;
    }

    public void showFullPath(TMapPolyLine path) {
        double MinX = 9.9999999E7;
        double MaxX = 0.0;
        double MinY = 9.9999999E7;
        double MaxY = 0.0;
        for (int i = 0; i < path.getLinePoint().size(); ++i) {
            if (MinX > path.getLinePoint().get(i).getLatitude()) {
                MinX = path.getLinePoint().get(i).getLatitude();
            }
            if (MaxX < path.getLinePoint().get(i).getLatitude()) {
                MaxX = path.getLinePoint().get(i).getLatitude();
            }
            if (MaxY < path.getLinePoint().get(i).getLongitude()) {
                MaxY = path.getLinePoint().get(i).getLongitude();
            }
            if (!(MinY > path.getLinePoint().get(i).getLongitude())) continue;
            MinY = path.getLinePoint().get(i).getLongitude();
        }
        double CenterX = (MinX + MaxX) / 2.0;
        double CenterY = (MinY + MaxY) / 2.0;
        this.setCenterPoint(CenterY, CenterX, false);
        float margin = 5.0f * this.mDensity;
        double DisX = MapUtils.getDistance(MinX, MinY, MaxX, MinY) + (double)margin;
        double DisY = MapUtils.getDistance(MinX, MinY, MinX, MaxY) + (double)margin;
        float tileSize = 256.0f * this.mFullHDSizeUP;
        double wTile = Math.round((float)this.getWidth() / tileSize);
        double hTile = Math.round((float)this.getHeight() / tileSize);
        double meterOfTile = 30.0;
        double visibleWidth = meterOfTile * wTile;
        double visibleHeight = meterOfTile * hTile;
        int s = 0;
        for (int i = this.getMaximumShownMapZoom(); i >= this.getMinimumShownMapZoom(); --i) {
            double avableWidth = visibleWidth * Math.pow(2.0, s);
            double avableHeight = visibleHeight * Math.pow(2.0, s);
            ++s;
            if (!(DisX < avableHeight) || !(DisY < avableWidth)) continue;
            this.setZoom(i);
            break;
        }
        this.postInvalidate();
    }

    public TMapInfo getDisplayTMapInfo(ArrayList<TMapPoint> point) {
        double MinX = 9.9999999E7;
        double MaxX = 0.0;
        double MinY = 9.9999999E7;
        double MaxY = 0.0;
        double x = 0.0;
        double y = 0.0;
        for (int i = 0; i < point.size(); ++i) {
            x = point.get(i).getLatitude();
            y = point.get(i).getLongitude();
            MinY = Math.min(MinY, y);
            MaxY = Math.max(MaxY, y);
            MinX = Math.min(MinX, x);
            MaxX = Math.max(MaxX, x);
        }
        double CenterX = (MinX + MaxX) / 2.0;
        double CenterY = (MinY + MaxY) / 2.0;
        float margin = 5.0f * this.mDensity;
        double DisY = MapUtils.getDistance(MinX, MinY, MinX, MaxY) + (double)margin;
        double DisX = MapUtils.getDistance(MinX, MinY, MaxX, MinY) + (double)margin;
        int nZoomLevel = 12;
        float tileSize = 256.0f * this.mFullHDSizeUP;
        double wTile = Math.round((float)this.getWidth() / tileSize);
        double hTile = Math.round((float)this.getHeight() / tileSize);
        double meterOfTile = 30.0;
        double visibleWidth = meterOfTile * wTile;
        double visibleHeight = meterOfTile * hTile;
        int s = 0;
        for (int i = this.getMaximumShownMapZoom(); i >= this.getMinimumShownMapZoom(); --i) {
            double avableWidth = visibleWidth * Math.pow(2.0, s);
            double avableHeight = visibleHeight * Math.pow(2.0, s);
            ++s;
            nZoomLevel = i;
            if (DisX < avableHeight && DisY < avableWidth) break;
        }
        return new TMapInfo(new TMapPoint(CenterX, CenterY), nZoomLevel);
    }

    public boolean isValidTMapPoint(TMapPoint point) {
        double minLatitude = 32.814978;
        double maxLatitude = 39.036253;
        double minLongitude = 124.661865;
        double maxLongitude = 132.550049;
        return point.getLatitude() > 32.814978 && point.getLatitude() < 39.036253 && point.getLongitude() > 124.661865 && point.getLongitude() < 132.550049;
    }

    public void setCallback() {
        this.setMap();
    }

    public TMapPoint convertPointToGps(float x, float y) {
        return this.getTMapPointFromScreenPoint(x, y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TMapMarkerItem getMarkerItemFromID(String id) {
        Map<String, TMapMarkerItem> map = this.markerItemLayer.mMarkerItems;
        synchronized (map) {
            return this.markerItemLayer.mMarkerItems.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<TMapMarkerItem2> getAllMarkerItem2() {
        Map<String, TMapOverlay> map = this.overlays;
        synchronized (map) {
            Set<String> keyset = this.overlays.keySet();
            Iterator<String> iterator = keyset.iterator();
            TMapMarkerItem2 markerItem2 = null;
            ArrayList<TMapMarkerItem2> markerList = new ArrayList<TMapMarkerItem2>();
            while (iterator.hasNext()) {
                String keyName = iterator.next();
                markerItem2 = (TMapMarkerItem2)this.overlays.get(keyName);
                markerList.add(markerItem2);
            }
            return markerList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TMapMarkerItem2 getMarkerItem2FromID(String id) {
        Map<String, TMapOverlay> map = this.overlays;
        synchronized (map) {
            TMapMarkerItem2 markerItem2 = null;
            if (this.overlays.size() > 0) {
                markerItem2 = (TMapMarkerItem2)this.overlays.get(id);
            }
            return markerItem2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TMapPolyLine getPolyLineFromID(String id) {
        Map<String, TMapPolyLine> map = this.polyLineLayer.mPolyLines;
        synchronized (map) {
            return this.polyLineLayer.mPolyLines.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TMapPolygon getPolygonFromID(String id) {
        Map<String, TMapPolygon> map = this.polygonLayer.mPolygons;
        synchronized (map) {
            return this.polygonLayer.mPolygons.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TMapCircle getCircleFromID(String id) {
        Map<String, TMapCircle> map = this.circleLayer.mCircles;
        synchronized (map) {
            return this.circleLayer.mCircles.get(id);
        }
    }

    public void setPOIRotate(boolean rotate) {
        this.poiLayer.setRotate(rotate);
    }

    public void setMarkerRotate(boolean rotate) {
        this.markerItemLayer.setRotate(rotate);
    }

    public void setPathRotate(boolean rotate) {
        this.pathLayer.setRotate(rotate);
    }

    public boolean setClick() {
        try {
            this.onClickListener = (OnClickListenerCallback)this.mContext;
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean setLongClick() {
        try {
            this.onLongClickListener = (OnLongClickListenerCallback)this.mContext;
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setOnClickListenerCallBack(OnClickListenerCallback listener) {
        this.onClickListener = listener;
    }

    public void setOnLongClickListenerCallback(OnLongClickListenerCallback listener) {
        this.onLongClickListener = listener;
    }

    public void setOnEnableScrollWithZoomLevelListener(OnEnableScrollWithZoomLevelCallback listener) {
        this.onEnableScrollWithZoomLevelListener = listener;
    }

    public void setOnDisableScrollWithZoomLevelListener(OnDisableScrollWithZoomLevelCallback listener) {
        this.onDisableScrollWithZoomLevelListener = listener;
    }

    public void setOnCalloutRightButtonClickListener(OnCalloutRightButtonClickCallback listener) {
        this.onCalloutRightButtonListener = listener;
    }

    public void setOnClickReverseLabelListener(OnClickReverseLabelListenerCallback listener) {
        this.onClickReverseLabelListener = listener;
    }

    public void setOnApiKeyListener(OnApiKeyListenerCallback listener) {
        this.onApiKeyListener = listener;
    }

    public void setTMapPathIcon(Bitmap start, Bitmap end) {
        this.pathLayer.setIcon(start, end);
    }

    public void setTMapPathIcon(Bitmap start, Bitmap end, Bitmap pass) {
        this.pathLayer.setIcon(start, end, pass);
    }

    public void setSKTMapApiKey(String key) {
        if (!MapUtils.isVerifyApiKey) {
            MapUtils.mApiKey = key;
            TMapData.checkApiKey(new TMapData.CheckKeyResultListenerCallback(){

                @Override
                public void onCheckKeyResult(String strResult) {
                    if (strResult.equals("OK")) {
                        if (TMapView.this.onApiKeyListener != null) {
                            TMapView.this.onApiKeyListener.SKTMapApikeySucceed();
                        }
                        TMapView.this.postInvalidate();
                    } else if (TMapView.this.onApiKeyListener != null) {
                        TMapView.this.onApiKeyListener.SKTMapApikeyFailed(strResult);
                    }
                }
            });
        }
    }

    public void setTrackingMode(boolean Mode) {
        if (Mode) {
            if (this.trackingthread == null) {
                this.trackingthread = new TrackingThread(this);
            }
            this.trackingthread.startTracking();
        } else {
            if (this.trackingthread == null) {
                this.trackingthread = new TrackingThread(this);
            }
            this.trackingthread.stopTracking();
        }
    }

    public boolean getIsTracking() {
        return this.trackingthread.isTracking();
    }

    public void setLanguage(int language) {
        this.Language = language;
    }

    public void setMapType(int type) {
        this.MapType = type;
    }

    public int getMapType() {
        return this.MapType;
    }

    public void setTileType(int type) {
        boolean isDelete = false;
        switch (type) {
            case 2: {
                if (this.TileType == 2) break;
                isDelete = true;
                MapUtils.setTileType("anTileKoHd");
                break;
            }
            default: {
                if (this.TileType == 2) break;
                isDelete = true;
                MapUtils.setTileType("anTileKoHd");
            }
        }
        if (isDelete) {
            this.TileType = type;
            this.mResourceManager.resetNameInFS(type);
            this.mResourceManager.removeTileImageFromCache();
            this.setMap();
            this.postInvalidate();
        }
    }

    public int getTileType() {
        return this.TileType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTMapPath(TMapPolyLine polyline) {
        TMapPolyLine tMapPolyLine = this.pathLayer.polyline;
        synchronized (tMapPolyLine) {
            this.pathLayer.polyline = polyline;
            this.postInvalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTMapPath() {
        TMapPolyLine tMapPolyLine = this.pathLayer.polyline;
        synchronized (tMapPolyLine) {
            this.pathLayer.polyline.getLinePoint().clear();
            this.pathLayer.polyline.getPassPoint().clear();
            this.postInvalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTMapPOIItem(ArrayList<TMapPOIItem> poiitem) {
        ArrayList<TMapPOIItem> arrayList = this.poiLayer.POIITem;
        synchronized (arrayList) {
            for (int i = 0; i < poiitem.size(); ++i) {
                this.poiLayer.POIITem.add(poiitem.get(i));
            }
            this.postInvalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTMapPOIItem(String id) {
        ArrayList<TMapPOIItem> arrayList = this.poiLayer.POIITem;
        synchronized (arrayList) {
            for (int i = 0; i < this.poiLayer.POIITem.size(); ++i) {
                if (!this.poiLayer.POIITem.get((int)i).id.equals(id)) continue;
                this.poiLayer.POIITem.remove(i);
            }
            this.postInvalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllTMapPOIItem() {
        ArrayList<TMapPOIItem> arrayList = this.poiLayer.POIITem;
        synchronized (arrayList) {
            this.poiLayer.POIITem.clear();
            this.postInvalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTMapCircle(String id, TMapCircle tmapcircle) {
        Map<String, TMapCircle> map = this.circleLayer.mCircles;
        synchronized (map) {
            tmapcircle.setID(id);
            this.circleLayer.mCircles.put(id, tmapcircle);
            this.postInvalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTMapCircle(String id) {
        Map<String, TMapCircle> map = this.circleLayer.mCircles;
        synchronized (map) {
            this.circleLayer.mCircles.remove(id);
            this.postInvalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllTMapCircle() {
        Map<String, TMapCircle> map = this.circleLayer.mCircles;
        synchronized (map) {
            this.circleLayer.mCircles.clear();
            this.postInvalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTMapPolygon(String id, TMapPolygon tmappolygon) {
        Map<String, TMapPolygon> map = this.polygonLayer.mPolygons;
        synchronized (map) {
            tmappolygon.setID(id);
            this.polygonLayer.mPolygons.put(id, tmappolygon);
            this.postInvalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTMapPolygon(String id) {
        Map<String, TMapPolygon> map = this.polygonLayer.mPolygons;
        synchronized (map) {
            this.polygonLayer.mPolygons.remove(id);
            this.postInvalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllTMapPolygon() {
        Map<String, TMapPolygon> map = this.polygonLayer.mPolygons;
        synchronized (map) {
            this.polygonLayer.mPolygons.clear();
            this.postInvalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTMapPolyLine(String id, TMapPolyLine tmappolyline) {
        Map<String, TMapPolyLine> map = this.polyLineLayer.mPolyLines;
        synchronized (map) {
            tmappolyline.setID(id);
            this.polyLineLayer.mPolyLines.put(id, tmappolyline);
            this.postInvalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTMapPolyLine(String id) {
        Map<String, TMapPolyLine> map = this.polyLineLayer.mPolyLines;
        synchronized (map) {
            this.polyLineLayer.mPolyLines.remove(id);
            this.postInvalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllTMapPolyLine() {
        Map<String, TMapPolyLine> map = this.polyLineLayer.mPolyLines;
        synchronized (map) {
            this.polyLineLayer.mPolyLines.clear();
            this.postInvalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMarkerItem(String id, TMapMarkerItem markeritem) {
        try {
            Map<String, TMapMarkerItem> map = this.markerItemLayer.mMarkerItems;
            synchronized (map) {
                if (id == null) {
                    throw new Exception("TMapView - addMarkerItem \ud568\uc218\uc758 id \ud30c\ub77c\ubbf8\ud130\uc5d0 null \uac12\uc744 \ub123\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4");
                }
                markeritem.setID(id);
                this.markerItemLayer.mMarkerItems.put(id, markeritem);
                this.postInvalidate();
            }
        }
        catch (Exception e) {
            Log.e((String)"SKT", (String)e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMarkerItem(String id) {
        try {
            Map<String, TMapMarkerItem> map = this.markerItemLayer.mMarkerItems;
            synchronized (map) {
                if (id == null) {
                    throw new Exception("TMapView - removeMarkerItem \ud568\uc218\uc758 id \ud30c\ub77c\ubbf8\ud130\uc5d0 null \uac12\uc744 \ub123\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4");
                }
                this.markerItemLayer.removeCallot(this.getMarkerItemFromID(id));
                this.markerItemLayer.mMarkerItems.remove(id);
                this.postInvalidate();
            }
        }
        catch (Exception e) {
            Log.e((String)"SKT", (String)e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllMarkerItem() {
        Map<String, TMapMarkerItem> map = this.markerItemLayer.mMarkerItems;
        synchronized (map) {
            this.markerItemLayer.bShowCallot = false;
            this.markerItemLayer.showcallot_id = null;
            this.markerItemLayer.mMarkerItems.clear();
            this.postInvalidate();
        }
    }

    public void setCompassMode(boolean Mode) {
        this.compassMode = Mode;
        if (this.compassMode) {
            this.mResourceManager.AddTileNum = this.mResourceManager.MaxTileNum;
            Sensor accelSensor = this.mSensorMgr.getDefaultSensor(1);
            Sensor magneticSensor = this.mSensorMgr.getDefaultSensor(2);
            if (accelSensor != null && magneticSensor != null) {
                this.mSensorMgr.registerListener((SensorEventListener)this, accelSensor, 2);
                this.mSensorMgr.registerListener((SensorEventListener)this, magneticSensor, 2);
            }
            this.currentScreenOrientation = this.getResources().getConfiguration().orientation;
        } else {
            this.mResourceManager.AddTileNum = this.mResourceManager.MaxTileNum;
            Sensor accelSensor = this.mSensorMgr.getDefaultSensor(1);
            Sensor magneticSensor = this.mSensorMgr.getDefaultSensor(2);
            if (accelSensor != null) {
                this.mSensorMgr.unregisterListener((SensorEventListener)this, accelSensor);
            }
            if (magneticSensor != null) {
                this.mSensorMgr.unregisterListener((SensorEventListener)this, magneticSensor);
            }
            this.setRotate(0.0f);
        }
    }

    public boolean getIsCompass() {
        return this.compassMode;
    }

    public void setCenterPoint(double LocationLongitude, double LocationLatitude) {
        this.longitude = MapUtils.boundaryInLongitude(this.getZoom(), LocationLongitude);
        this.latitude = MapUtils.boundaryInLatitude(this.getZoom(), LocationLatitude);
        this.postInvalidate();
    }

    public void setCenterPoint(double LocationLongitude, double LocationLatitude, boolean animatate) {
        LocationLongitude = MapUtils.boundaryInLongitude(this.getZoom(), LocationLongitude);
        LocationLatitude = MapUtils.boundaryInLatitude(this.getZoom(), LocationLatitude);
        if (animatate) {
            this.getAnimatedDraggingThread().startDraggingMoving(this.getLatitude(), this.getLongitude(), LocationLatitude, LocationLongitude, this.getZoomLevel(), this.getZoomLevel(), (int)this.getTileSize(), this.getRotateData(), true);
        } else {
            this.longitude = LocationLongitude;
            this.latitude = LocationLatitude;
            this.postInvalidate();
        }
    }

    public TMapPoint getCenterPoint() {
        return new TMapPoint(this.latitude, this.longitude);
    }

    public void setLocationPoint(double locationLongitude, double locationlatitude) {
        this.locationLongitude = locationLongitude;
        this.locationlatitude = locationlatitude;
    }

    public TMapPoint getLocationPoint() {
        return new TMapPoint(this.locationlatitude, this.locationLongitude);
    }

    public void setIconVisibility(boolean visibility) {
        if (visibility) {
            this.locationLayer.showIcon = true;
            this.postInvalidate();
        } else {
            this.locationLayer.showIcon = false;
            this.postInvalidate();
        }
    }

    public void setSightVisible(boolean sight) {
        if (sight) {
            this.locationLayer.showSight = true;
            this.postInvalidate();
        } else {
            this.locationLayer.showSight = false;
            this.postInvalidate();
        }
    }

    public void setIcon(Bitmap icon) {
        this.locationLayer.setIcon(icon);
    }

    public void setZoomLevel(int level) {
        if (this.isZooming()) {
            return;
        }
        if (this.isFixZoomPosition) {
            this.isFixZoomPosition = this.chkZoomPosition();
        }
        if (level > this.getMaximumShownMapZoom()) {
            level = this.getMaximumShownMapZoom();
        } else if (level < this.getMinimumShownMapZoom()) {
            level = this.getMinimumShownMapZoom();
        }
        this.zoomType = 0;
        if (this.animatedDraggingThread != null) {
            this.getAnimatedDraggingThread().startDraggingZooming(this.zoom, level);
        } else {
            this.zoom = level;
            this.postInvalidate();
        }
    }

    public int getZoomLevel() {
        return (int)Math.ceil(this.zoom);
    }

    public boolean ZoomEnable() {
        return this.getZoomLevel() < this.getMaximumShownMapZoom() && this.getZoomLevel() > this.getMinimumShownMapZoom();
    }

    public void MapZoomIn() {
        if (this.isZooming()) {
            return;
        }
        if (this.isFixZoomPosition) {
            this.isFixZoomPosition = this.chkZoomPosition();
        }
        if (this.zoom < (float)this.getMaximumShownMapZoom()) {
            this.zoomType = 1;
            int setZoom = 0;
            setZoom = this.getZoomLevel() == this.getMaximumShownMapZoom() ? (int)(Math.floor(this.zoom) + 1.0) : this.getZoomLevel() + 1;
            if (this.animatedDraggingThread != null) {
                this.getAnimatedDraggingThread().startDraggingZooming(this.zoom, setZoom);
            } else {
                this.zoom = setZoom;
            }
        }
    }

    public void MapZoomOut() {
        if (this.isZooming()) {
            return;
        }
        if (this.isFixZoomPosition) {
            this.isFixZoomPosition = this.chkZoomPosition();
        }
        if (this.zoom > (float)this.getMinimumShownMapZoom()) {
            this.zoomType = 2;
            int setZoom = this.getZoomLevel() - 1;
            if (this.animatedDraggingThread != null) {
                this.getAnimatedDraggingThread().startDraggingZooming(this.zoom, setZoom);
            } else {
                this.zoom = setZoom;
            }
        }
    }

    public void setTMapBackgroundColor(int backgroundColor) {
        this.mTMapRenderer.setTMapBackgroundColor(backgroundColor);
    }

    public void initView() {
        this.setClickable(true);
        this.setLongClickable(true);
        this.setFocusable(true);
        this.animatedDraggingThread = new DraggingAnimateThread(this);
        this.animatedDraggingThread.setDraggingCallback(this);
        this.gestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)this);
        this.multiTouchSupport = new MultiTouchEvent(this.getContext(), this);
        this.gestureDetector.setOnDoubleTapListener((GestureDetector.OnDoubleTapListener)this);
        WindowManager mgr = (WindowManager)this.getContext().getSystemService("window");
        this.dm = new DisplayMetrics();
        mgr.getDefaultDisplay().getMetrics(this.dm);
        this.initialMultiTouchZoom = this.zoom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        try {
            if (this.mMapTileDownloader != null) {
                this.mMapTileDownloader.threadPoolShutDown();
                this.mMapTileDownloader = null;
            }
            CopyOnWriteArrayList<TMapOverlay> copyOnWriteArrayList = this.mOverlayList;
            synchronized (copyOnWriteArrayList) {
                if (this.mOverlayList.size() > 0) {
                    for (int i = 0; i < this.mOverlayList.size(); ++i) {
                        this.mOverlayList.get(i).initAnimationIcons();
                    }
                    this.mOverlayList.clear();
                }
            }
            if (this.animatedDraggingThread != null) {
                this.animatedDraggingThread.stopDraggingAnimating();
                this.animatedDraggingThread = null;
            }
            if (this.trackingthread != null && this.trackingthread.isTracking()) {
                this.trackingthread.stopTracking();
                this.trackingthread = null;
            }
            if (this.mResourceManager != null) {
                this.mResourceManager.removeTileImageFromCache();
            }
            if (this.mEmptyH != null) {
                this.mEmptyH.recycle();
                this.mEmptyH = null;
            }
            if (this.mEmptyV != null) {
                this.mEmptyV.recycle();
                this.mEmptyV = null;
            }
            if (this.mEmpty != null) {
                this.mEmpty.recycle();
                this.mDefaultIcon.recycle();
                this.mClusteringBitmap.recycle();
                this.LogoBitmap.recycle();
                this.mCanvas2 = null;
                this.mDefaultIcon = null;
                this.LogoBitmap = null;
                this.mClusteringBitmap = null;
                this.mEmpty = null;
            }
            if (this.EmptyBitmap != null) {
                this.EmptyBitmap.recycle();
            }
            if (this.handler.hasMessages(1)) {
                this.handler.removeMessages(1);
            }
            if (this.mImageView != null) {
                TMapView.recycleBitmap(this.mImageView);
                this.mImageView = null;
            }
            this.mContext = null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void ClearTile() {
        if (this.mResourceManager != null) {
            this.mResourceManager.removeTileImageFromCache();
        }
    }

    public void addLayer(TMapLayer layer, float zOrder) {
        int i = 0;
        for (i = 0; i < this.layers.size() && !(this.zOrders.get(this.layers.get(i)).floatValue() > zOrder); ++i) {
        }
        layer.initLayer(this);
        this.layers.add(i, layer);
        this.zOrders.put(layer, Float.valueOf(zOrder));
    }

    public void removeLayer(TMapLayer layer) {
        this.layers.remove(layer);
        this.zOrders.remove(layer);
        layer.destroyTMapLayer();
    }

    public List<TMapLayer> getLayers() {
        return this.layers;
    }

    public float getTileSize() {
        float res = 0.0f;
        res = 512.0f;
        res *= this.mFullHDSizeUP;
        float tempDz = this.zoom - (float)((int)this.zoom);
        if (tempDz > 0.0f) {
            if (!this.isZooming()) {
                res = (double)tempDz < 0.5 ? (res *= tempDz + 1.0f) : (res *= tempDz / 2.0f + 0.5f);
            } else if (this.initialMultiTouchZoom <= (float)this.getZoom()) {
                res *= (float)Math.pow(2.0, this.zoom - (float)((int)this.initialMultiTouchZoom));
            } else {
                float a = 0.0f;
                int b = (int)this.initialMultiTouchZoom - (int)this.zoom - 1;
                if (b > 0) {
                    res /= (float)Math.pow(2.0, b);
                }
                res = (double)(a = (float)Math.pow(2.0, this.zoom - (float)((int)this.zoom)) - 1.0f) < 0.5 ? (float)((double)res * 0.5) : (res *= a);
                if (res < 4.0f) {
                    res = 4.0f;
                }
            }
        }
        return res;
    }

    public int getSourceTileSize() {
        return this.map == null ? 512 : this.map.getTileSizeValue();
    }

    public float getXTile() {
        return (float)this.mapUtils.getTileNumberX(this.getZoom(), this.longitude, this.latitude);
    }

    public float getXTile_Up(int zoom) {
        return (float)this.mapUtils.getTileNumberX(zoom, this.longitude, this.latitude);
    }

    public double getXTile_double() {
        return this.mapUtils.getTileNumberX(this.getZoom(), this.longitude, this.latitude);
    }

    public double getYTile_double() {
        return this.mapUtils.getTileNumberY(this.getZoom(), this.longitude, this.latitude);
    }

    public float getYTile() {
        return (float)this.mapUtils.getTileNumberY(this.getZoom(), this.longitude, this.latitude);
    }

    public float getYTile_Up(int zoom) {
        return (float)this.mapUtils.getTileNumberY(zoom, this.longitude, this.latitude);
    }

    public int getMaximumShownMapZoom() {
        return this.map.getMaximumZoom();
    }

    public int getMinimumShownMapZoom() {
        return this.map.getMinimumZoom();
    }

    public void setZoom(float zoom) {
        if (zoom <= (float)this.getMaximumShownMapZoom() && zoom >= (float)this.getMinimumShownMapZoom()) {
            if (this.isFixZoomPosition) {
                this.isFixZoomPosition = this.chkZoomPosition();
            }
            if (this.animatedDraggingThread != null) {
                this.animatedDraggingThread.stopDraggingAnimating();
            }
            this.zoom = zoom;
        }
    }

    @Override
    public void zoom(float zoom, boolean notify) {
        if (zoom <= (float)this.getMaximumShownMapZoom() && zoom >= (float)this.getMinimumShownMapZoom()) {
            this.zoom = zoom;
            if (this.initialMultiTouchZoom > zoom) {
                this.longitude = MapUtils.boundaryInLongitude(this.getZoom(), this.longitude);
                this.latitude = MapUtils.boundaryInLatitude(this.getZoom(), this.latitude);
            }
            this.postInvalidate();
        }
    }

    @Override
    public void zoomEnd(float zoom) {
        this.zoom = zoom;
        this.isZoom = false;
        if (this.onDisableScrollWithZoomLevelListener != null) {
            this.onDisableScrollWithZoomLevelListener.onDisableScrollWithZoomLevelEvent(zoom, this.getCenterPoint());
            this.findTraffic();
        }
        if (this.animatedDraggingThread != null) {
            this.animatedDraggingThread.stopDraggingAnimating();
        }
    }

    @Override
    public void zoomStart(int startZoom, int endZoom) {
        this.moveZoomLevel = endZoom;
        this.initialMultiTouchZoom = startZoom;
    }

    public void setRotate(float rotate) {
        float diff = rotate - this.rotate;
        if (Math.min(Math.abs((diff + 360.0f) % 360.0f), Math.abs((diff - 360.0f) % 360.0f)) > 5.0f && this.animatedDraggingThread != null) {
            this.animatedDraggingThread.rotateStart(rotate);
        }
    }

    public float getRotate() {
        return this.rotate;
    }

    @Override
    public float getRotateData() {
        return this.rotate;
    }

    public ITileOrigin getMap() {
        return this.map;
    }

    public void setMap() {
        TileSourceManager.TileOriginTemplate newSource = null;
        if (this.TileType == 2) {
            if (this.isHttpsMode) {
                TileSourceManager.setBaseUrl(mSslHDUrl);
            } else {
                TileSourceManager.setBaseUrl(mHDUrl);
            }
            newSource = TileSourceManager.getHDTileSource();
            MapUtils.setTileType("anTileKoHd");
        } else {
            if (this.isHttpsMode) {
                TileSourceManager.setBaseUrl(mSslHDUrl);
            } else {
                TileSourceManager.setBaseUrl(mHDUrl);
            }
            newSource = TileSourceManager.getHDTileSource();
            MapUtils.setTileType("anTileKoHd");
        }
        this.map = newSource;
        this.mapUtils = this.map.getMapUtils();
        this.mTMapRenderer.setMap(this.map, this.mapUtils);
    }

    public void setTMapPoint(double latitude, double longitude) {
        this.animatedDraggingThread.stopDraggingAnimating();
        this.latitude = latitude;
        this.longitude = longitude;
        this.postInvalidate();
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    protected int getZoom() {
        return Math.round(this.zoom);
    }

    protected int getZoom_Up() {
        return (int)Math.ceil(this.zoom);
    }

    private boolean isZooming() {
        return this.isZoom;
    }

    public int getScreenWidth() {
        return this.getWidth();
    }

    public int getScreenHeight() {
        return this.getHeight();
    }

    public int getCenterPointX() {
        if (this.isFixZoomPosition) {
            return this.zoomPointX;
        }
        return this.getWidth() / 2;
    }

    public int getCenterPointY() {
        if (this.isFixZoomPosition) {
            return this.zoomPointY;
        }
        if (this.mapPosition == 1) {
            return 3 * this.getHeight() / 4;
        }
        return this.getHeight() / 2;
    }

    public void setMapPosition(int type) {
        this.mapPosition = type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawOverMap(Canvas canvas, RectF TMapPointRect, boolean nightMode) {
        int w = this.getCenterPointX();
        int h = this.getCenterPointY();
        if (canvas != null) {
            if (TMapRenderer.m_bCanvasSave) {
                canvas.restore();
            }
        }
        boolean bShowCallout = false;
        CopyOnWriteArrayList<TMapOverlay> copyOnWriteArrayList = this.mOverlayList;
        synchronized (copyOnWriteArrayList) {
            for (int i = 0; i < this.mOverlayList.size(); ++i) {
                canvas.save();
                canvas.rotate(this.rotate, (float)w, (float)h);
                this.mOverlayList.get(i).draw(canvas, this, false);
                canvas.restore();
            }
        }
        for (int i = 0; i < this.layers.size(); ++i) {
            try {
                TMapLayer layer = this.layers.get(i);
                canvas.save();
                if (!layer.drawInScreenPixels()) {
                    canvas.rotate(this.rotate, (float)w, (float)h);
                }
                layer.draw(canvas, TMapPointRect, nightMode);
                canvas.restore();
                continue;
            }
            catch (IndexOutOfBoundsException layer) {
                // empty catch block
            }
        }
        Map<String, TMapOverlay> map = this.overlays;
        synchronized (map) {
            ArrayList<String> list = new ArrayList<String>(this.overlays.keySet());
            for (int i = 0; i < list.size(); ++i) {
                canvas.save();
                canvas.rotate(this.rotate, (float)w, (float)h);
                TMapMarkerItem2 item = (TMapMarkerItem2)this.overlays.get(list.get(i));
                if (item != null) {
                    this.overlays.get(list.get(i)).draw(canvas, this, item.getMarkerTouch());
                }
                canvas.restore();
            }
        }
    }

    public void calculateTileRectangle(Rect pixRect, float cx, float cy, float ctilex, float ctiley, RectF tileRect) {
        float b;
        float t;
        float x1 = this.calcDiffTileX((float)pixRect.left - cx, (float)pixRect.top - cy);
        float x2 = this.calcDiffTileX((float)pixRect.left - cx, (float)pixRect.bottom - cy);
        float x3 = this.calcDiffTileX((float)pixRect.right - cx, (float)pixRect.top - cy);
        float x4 = this.calcDiffTileX((float)pixRect.right - cx, (float)pixRect.bottom - cy);
        float y1 = this.calcDiffTileY((float)pixRect.left - cx, (float)pixRect.top - cy);
        float y2 = this.calcDiffTileY((float)pixRect.left - cx, (float)pixRect.bottom - cy);
        float y3 = this.calcDiffTileY((float)pixRect.right - cx, (float)pixRect.top - cy);
        float y4 = this.calcDiffTileY((float)pixRect.right - cx, (float)pixRect.bottom - cy);
        float l = Math.min(Math.min(x1, x2), Math.min(x3, x4)) + ctilex;
        float r = Math.max(Math.max(x1, x2), Math.max(x3, x4)) + ctilex;
        if (this.map == null || this.map.getVIndexOrder() > 0) {
            t = Math.min(Math.min(y1, y2), Math.min(y3, y4)) + ctiley;
            b = Math.max(Math.max(y1, y2), Math.max(y3, y4)) + ctiley;
        } else {
            b = -Math.min(Math.min(y1, y2), Math.min(y3, y4)) + ctiley;
            t = -Math.max(Math.max(y1, y2), Math.max(y3, y4)) + ctiley;
        }
        tileRect.set(l, t, r, b);
    }

    public void calculatePixelRectangle(Rect pixelRect, float cx, float cy, float ctilex, float ctiley, RectF tileRect) {
        int b;
        int t;
        float x1 = this.calcDiffPixelX(tileRect.left - ctilex, tileRect.top - ctiley);
        float x2 = this.calcDiffPixelX(tileRect.left - ctilex, tileRect.bottom - ctiley);
        float x3 = this.calcDiffPixelX(tileRect.right - ctilex, tileRect.top - ctiley);
        float x4 = this.calcDiffPixelX(tileRect.right - ctilex, tileRect.bottom - ctiley);
        float y1 = this.calcDiffPixelY(tileRect.left - ctilex, tileRect.top - ctiley);
        float y2 = this.calcDiffPixelY(tileRect.left - ctilex, tileRect.bottom - ctiley);
        float y3 = this.calcDiffPixelY(tileRect.right - ctilex, tileRect.top - ctiley);
        float y4 = this.calcDiffPixelY(tileRect.right - ctilex, tileRect.bottom - ctiley);
        int l = Math.round(Math.min(Math.min(x1, x2), Math.min(x3, x4)) + cx);
        int r = Math.round(Math.max(Math.max(x1, x2), Math.max(x3, x4)) + cx);
        if (this.map == null || this.map.getVIndexOrder() > 0) {
            t = Math.round(Math.min(Math.min(y1, y2), Math.min(y3, y4)) + cy);
            b = Math.round(Math.max(Math.max(y1, y2), Math.max(y3, y4)) + cy);
        } else {
            b = Math.round(-Math.min(Math.min(y1, y2), Math.min(y3, y4)) + cy);
            t = Math.round(-Math.max(Math.max(y1, y2), Math.max(y3, y4)) + cy);
        }
        pixelRect.set(l, t, r, b);
    }

    public boolean mapIsRefreshing() {
        return this.handler.hasMessages(1);
    }

    public boolean mapIsAnimating() {
        return this.animatedDraggingThread != null && this.animatedDraggingThread.isDraggingAnimating();
    }

    public float calcDiffTileY(float dx, float dy) {
        return (-this.rotateSin * dx + this.rotateCos * dy) / this.getTileSize();
    }

    public float calcDiffTileX(float dx, float dy) {
        return (this.rotateCos * dx + this.rotateSin * dy) / this.getTileSize();
    }

    public float calcDiffPixelY(float dTileX, float dTileY) {
        return (this.rotateSin * dTileX + this.rotateCos * dTileY) * this.getTileSize();
    }

    public float calcDiffPixelX(float dTileX, float dTileY) {
        return (this.rotateCos * dTileX - this.rotateSin * dTileY) * this.getTileSize();
    }

    public TMapPoint getLeftTopPoint() {
        TMapPoint point = this.getTMapPointFromScreenPoint(0.0f, 0.0f);
        return point;
    }

    public TMapPoint getRightBottomPoint() {
        TMapPoint point = this.getTMapPointFromScreenPoint(this.getScreenWidth(), this.getScreenHeight());
        return point;
    }

    public TMapPoint getTMapPointFromScreenPoint(float x, float y) {
        double longitude;
        double latitude;
        float dx = x - (float)this.getCenterPointX();
        float dy = y - (float)this.getCenterPointY();
        float fy = this.calcDiffTileY(dx, dy);
        float fx = this.calcDiffTileX(dx, dy);
        if (this.map == null || this.map.getVIndexOrder() > 0) {
            latitude = this.mapUtils.getLatitudeTile(this.getZoom(), this.getXTile() + fx, this.getYTile() + fy);
            longitude = this.mapUtils.getLongitudeFromTile(this.getZoom(), this.getXTile() + fx, this.getYTile() + fy);
        } else {
            latitude = this.mapUtils.getLatitudeTile(this.getZoom(), this.getXTile() + fx, this.getYTile() - fy);
            longitude = this.mapUtils.getLongitudeFromTile(this.getZoom(), this.getXTile() + fx, this.getYTile() - fy);
        }
        return new TMapPoint(latitude, longitude);
    }

    public int getMetersToPixel(double meters) {
        return this.mapUtils.getLengthXMeters(this.getZoom(), this.getLatitude(), this.getLongitude(), meters, this.getTileSize(), this.getScreenWidth());
    }

    public int getMapXForPoint(double longitude, double latitude) {
        double tileX = this.mapUtils.getTileNumberX(this.getZoom(), longitude, latitude);
        return (int)((tileX - (double)this.getXTile()) * (double)this.getTileSize() + (double)this.getCenterPointX());
    }

    private float getMapXForPoint2(double longitude, double latitude) {
        double tileX = this.mapUtils.getTileNumberX(this.getZoom(), longitude, latitude);
        return (float)((tileX - (double)this.getXTile()) * (double)this.getTileSize() + (double)this.getCenterPointX());
    }

    public int getMapYForPoint(double longitude, double latitude) {
        double tileY = this.mapUtils.getTileNumberY(this.getZoom(), longitude, latitude);
        if (this.map == null || this.map.getVIndexOrder() > 0) {
            return (int)((tileY - (double)this.getYTile()) * (double)this.getTileSize() + (double)this.getCenterPointY());
        }
        return (int)(-(tileY - (double)this.getYTile()) * (double)this.getTileSize() + (double)this.getCenterPointY());
    }

    private float getMapYForPoint2(double longitude, double latitude) {
        double tileY = this.mapUtils.getTileNumberY(this.getZoom(), longitude, latitude);
        if (this.map == null || this.map.getVIndexOrder() > 0) {
            return (float)((tileY - (double)this.getYTile()) * (double)this.getTileSize() + (double)this.getCenterPointY());
        }
        return (float)(-(tileY - (double)this.getYTile()) * (double)this.getTileSize() + (double)this.getCenterPointY());
    }

    public int getRotatedMapXForPoint(double latitude, double longitude) {
        int cx = this.getCenterPointX();
        double xTile = this.mapUtils.getTileNumberX(this.getZoom(), longitude, latitude);
        double yTile = this.mapUtils.getTileNumberY(this.getZoom(), longitude, latitude);
        float xTileF = Float.parseFloat(String.format(Locale.US, "%.4f", xTile));
        float yTileF = Float.parseFloat(String.format(Locale.US, "%.4f", yTile));
        if (this.map == null || this.map.getVIndexOrder() > 0) {
            return (int)(this.calcDiffPixelX(xTileF - this.getXTile(), yTileF - this.getYTile()) + (float)cx);
        }
        return (int)(this.calcDiffPixelX(xTileF - this.getXTile(), -(yTileF - this.getYTile())) + (float)cx);
    }

    public int getRotatedMapYForPoint(double latitude, double longitude) {
        int cy = this.getCenterPointY();
        double xTile = this.mapUtils.getTileNumberX(this.getZoom(), longitude, latitude);
        double yTile = this.mapUtils.getTileNumberY(this.getZoom(), longitude, latitude);
        float xTileF = Float.parseFloat(String.format(Locale.US, "%.4f", xTile));
        float yTileF = Float.parseFloat(String.format(Locale.US, "%.4f", yTile));
        if (this.map == null || this.map.getVIndexOrder() > 0) {
            return (int)(this.calcDiffPixelY(xTileF - this.getXTile(), yTileF - this.getYTile()) + (float)cy);
        }
        return (int)(this.calcDiffPixelY(xTileF - this.getXTile(), -(yTileF - this.getYTile())) + (float)cy);
    }

    public boolean isPointOnTheRotatedMap(double latitude, double longitude) {
        int newY;
        int newX;
        int cx = this.getCenterPointX();
        int cy = this.getCenterPointY();
        double xTile = this.mapUtils.getTileNumberX(this.getZoom(), longitude, latitude);
        double yTile = this.mapUtils.getTileNumberY(this.getZoom(), longitude, latitude);
        if (this.map == null || this.map.getVIndexOrder() > 0) {
            newX = (int)(this.calcDiffPixelX((float)(xTile - (double)this.getXTile()), (float)(yTile - (double)this.getYTile())) + (float)cx);
            newY = (int)(this.calcDiffPixelY((float)(xTile - (double)this.getXTile()), (float)(yTile - (double)this.getYTile())) + (float)cy);
        } else {
            newX = (int)(this.calcDiffPixelX((float)(xTile - (double)this.getXTile()), -((float)(yTile - (double)this.getYTile()))) + (float)cx);
            newY = (int)(this.calcDiffPixelY((float)(xTile - (double)this.getXTile()), -((float)(yTile - (double)this.getYTile()))) + (float)cy);
        }
        return newX >= 0 && newX <= this.getWidth() && newY >= 0 && newY <= this.getHeight();
    }

    @Override
    public void drag(float fromX, float fromY, float toX, float toY, boolean notify) {
        float dx = fromX - toX;
        float dy = fromY - toY;
        this.moveTo(dx, dy);
        if (this.trackingthread != null && this.trackingthread.isTracking()) {
            this.trackingthread.stopTracking();
        }
    }

    @Override
    public void rotate(float rotate) {
        this.rotate = rotate;
        float rotateRad = (float)Math.toRadians(rotate);
        this.rotateCos = (float)Math.cos(rotateRad);
        this.rotateSin = (float)Math.sin(rotateRad);
        this.postInvalidate();
    }

    @Override
    public void setTMapPoint(double latitude, double longitude, boolean notify) {
        this.latitude = latitude;
        this.longitude = longitude;
        this.postInvalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveTo(float dx, float dy) {
        Object object = this.objDrawSync;
        synchronized (object) {
            double fy = this.calcDiffTileY(dx, dy);
            double fx = this.calcDiffTileX(dx, dy);
            double lat = 0.0;
            double lon = 0.0;
            if (this.map == null || this.map.getVIndexOrder() > 0) {
                lat = this.mapUtils.getLatitudeTile(this.getZoom(), this.getXTile_double() + fx, this.getYTile_double() + fy * 1.25);
                lon = MapUtils.getLongitudeFromTile(this.getZoom(), this.getXTile_double() + fx * 1.25);
            } else {
                lat = this.mapUtils.getLatitudeTile(this.getZoom(), this.getXTile_double() + fx, this.getYTile_double() - fy);
                lon = this.mapUtils.getLongitudeFromTile(this.getZoom(), this.getXTile_double() + fx, this.getYTile_double() - fy);
            }
            this.longitude = MapUtils.boundaryInLongitude(this.getZoom(), lon);
            this.latitude = MapUtils.boundaryInLatitude(this.getZoom(), lat);
            this.postInvalidate();
        }
    }

    public void zoomToSpan(double latSpan, double lonSpan) {
        TMapPoint minPointX = new TMapPoint(this.latitude - latSpan / 2.0, this.longitude);
        TMapPoint maxPointX = new TMapPoint(this.latitude + latSpan / 2.0, this.longitude);
        TMapPoint minPointY = new TMapPoint(this.latitude, this.longitude - lonSpan / 2.0);
        TMapPoint maxPointY = new TMapPoint(this.latitude, this.longitude + lonSpan / 2.0);
        int findZoom = this.findZoomLevel(minPointX, maxPointX, minPointY, maxPointY);
        this.setZoomLevel(findZoom);
    }

    public void zoomToTMapPoint(TMapPoint leftTop, TMapPoint rightBottom) {
        TMapPoint minPointX = new TMapPoint(leftTop.getLatitude(), leftTop.getLongitude());
        TMapPoint maxPointX = new TMapPoint(rightBottom.getLatitude(), leftTop.getLongitude());
        TMapPoint minPointY = new TMapPoint(leftTop.getLatitude(), rightBottom.getLongitude());
        TMapPoint maxPointY = new TMapPoint(leftTop.getLatitude(), leftTop.getLongitude());
        int findZoom = this.findZoomLevel(minPointX, maxPointX, minPointY, maxPointY);
        this.setZoomLevel(findZoom);
    }

    private int findZoomLevel(TMapPoint minPointX, TMapPoint maxPointX, TMapPoint minPointY, TMapPoint maxPointY) {
        double DisX = MapUtils.getDistance(minPointX, maxPointX);
        double DisY = MapUtils.getDistance(minPointY, maxPointY);
        double[] mScaleInfo = new double[]{156543.033928041, 78271.51696402048, 39135.75848201023, 19567.87924100512, 9783.93962050256, 4891.96981025128, 2445.98490512564, 1222.99245256282, 611.49622628141, 305.7481131407048, 152.8740565703525, 76.43702828517624, 38.21851414258813, 19.10925707129406, 9.554628535647032, 4.777314267823516, 2.388657133911758, 1.194328566955879, 0.5971642834779395, 0.2985821417389698};
        for (int i = this.getMaximumShownMapZoom(); i >= this.getMinimumShownMapZoom(); --i) {
            double mapDis = mScaleInfo[i] * 512.0;
            if (!(DisX < mapDis) || !(DisY < mapDis)) continue;
            return i;
        }
        return 0;
    }

    public static double latitudeToY(double latitude) {
        double sinLatitude = Math.sin(latitude * (Math.PI / 180));
        return 0.5 - Math.log((1.0 + sinLatitude) / (1.0 - sinLatitude)) / (Math.PI * 4);
    }

    public static double longitudeToX(double longitude) {
        return (longitude + 180.0) / 360.0;
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction() & 0xFF) {
            case 0: {
                this.isPinchZoom = false;
                this.mode = 1;
                PointF pointf = new PointF(event.getX(), event.getY());
                TMapPoint point = this.getTMapPointFromScreenPoint(pointf.x, pointf.y);
                if (this.onClickListener != null) {
                    this.onClickListener.onPressEvent(this.markerItemLayer.onClickEvent(pointf), this.poiLayer.onClickEvent(pointf), point, pointf);
                }
                if (!this.mUserScrollZoomEnable) {
                    this.getParent().requestDisallowInterceptTouchEvent(true);
                }
                if (this.flingThread == null || !this.flingThread.isAlive()) break;
                this.isflingStop = true;
                this.flingThread.interrupt();
                break;
            }
            case 5: {
                this.isPinchZoom = true;
                this.mode = 3;
                if (this.isFixZoomPosition && (this.isFixZoomPosition = this.chkZoomPosition()) && (this.prevLongitude != this.longitude || this.prevLatitude != this.latitude)) {
                    this.updateZoomPoint();
                }
                if (!this.isRotateEnable || event.getPointerCount() != 2) break;
                this.d = this.rotation(event);
                break;
            }
            case 1: {
                if (this.mode != 3 && this.compassMode && !this.compassMode_2) {
                    this.compassMode = false;
                    this.setRotate(0.0f);
                }
                this.mode = 0;
                PointF pointf = new PointF(event.getX(), event.getY());
                TMapPoint point = this.getTMapPointFromScreenPoint(pointf.x, pointf.y);
                if (this.onClickListener != null) {
                    this.onClickListener.onPressUpEvent(this.markerItemLayer.onClickEvent(pointf), this.poiLayer.onClickEvent(pointf), point, pointf);
                }
                if (this.isScrollAnimationActive) {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Thread.sleep(400L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            if (!TMapView.this.isScrolling && TMapView.this.prevActionUpTime != 0L && System.currentTimeMillis() - TMapView.this.prevActionUpTime >= 400L) {
                                if (TMapView.this.onDisableScrollWithZoomLevelListener != null) {
                                    TMapView.this.onDisableScrollWithZoomLevelListener.onDisableScrollWithZoomLevelEvent(TMapView.this.getZoomLevel(), TMapView.this.getCenterPoint());
                                }
                                if (System.currentTimeMillis() - TMapView.this.prevActionUpTime >= 700L) {
                                    TMapView.this.findTraffic();
                                }
                            }
                        }
                    }).start();
                    this.prevActionUpTime = System.currentTimeMillis();
                } else {
                    if (this.onDisableScrollWithZoomLevelListener != null) {
                        this.onDisableScrollWithZoomLevelListener.onDisableScrollWithZoomLevelEvent(this.getZoomLevel(), this.getCenterPoint());
                    }
                    this.findTraffic();
                }
                if (this.isFixZoomPosition && (this.prevLongitude != this.longitude || this.prevLatitude != this.latitude)) {
                    this.updateZoomPoint();
                }
                if (!this.mUserScrollZoomEnable) {
                    this.getParent().requestDisallowInterceptTouchEvent(false);
                }
                this.mTMapRenderer.setMapPosition(this.longitude, this.latitude, this.getZoom());
                this.prevActionMoveX = 0.0f;
                this.prevActionMoveY = 0.0f;
                break;
            }
            case 6: {
                this.isPinchZoom = true;
                this.mode = 3;
                if (!this.isRotateEnable || event.getPointerCount() != 2) break;
                this.lastRot += this.newRot - this.d;
                break;
            }
            case 2: {
                if (this.prevActionMoveX != 0.0f || this.prevActionMoveY != 0.0f) {
                    this.actionMoveDiffX = this.prevActionMoveX - event.getX();
                    this.actionMoveDiffY = this.prevActionMoveY - event.getY();
                }
                this.prevActionMoveX = event.getX();
                this.prevActionMoveY = event.getY();
                if (this.onEnableScrollWithZoomLevelListener != null) {
                    this.onEnableScrollWithZoomLevelListener.onEnableScrollWithZoomLevelEvent(this.getZoomLevel(), this.getCenterPoint());
                }
                if (!this.isRotateEnable || event.getPointerCount() != 2) break;
                this.newRot = this.rotation(event);
                float r = this.lastRot + (this.newRot - this.d);
                this.rotate(r);
                break;
            }
        }
        if (event.getAction() == 0) {
            if (this.animatedDraggingThread != null) {
                this.animatedDraggingThread.stopDraggingAnimating();
            }
            this.zoomType = -1;
        }
        if (!this.multiTouchSupport.onGestureEvent(event)) {
            this.gestureDetector.onTouchEvent(event);
        }
        return true;
    }

    public boolean onDown(MotionEvent e) {
        return false;
    }

    @Override
    public void onEndZoom(float distance, float relativeToStart) {
        this.mbZooming = false;
        this.isZoom = false;
    }

    @Override
    public void onStartZoom(float distance, PointF centerPoint) {
        this.initialMultiTouchZoom = this.zoom;
    }

    @Override
    public void onZoom(float distance, float relativeToStart) {
        float dz;
        float calcZoom;
        this.mbZooming = true;
        if (!this.mUserScrollZoomEnable && (double)Math.abs((calcZoom = this.initialMultiTouchZoom + (dz = (float)(Math.log(relativeToStart) / Math.log(2.0) * 0.6))) - this.zoom) > 0.02) {
            if (calcZoom <= (float)this.getMaximumShownMapZoom() && calcZoom >= (float)this.getMinimumShownMapZoom()) {
                this.zoom(calcZoom, false);
            } else if (calcZoom > (float)this.getMaximumShownMapZoom()) {
                this.zoom(this.getMaximumShownMapZoom(), false);
            } else {
                this.zoom(this.getMinimumShownMapZoom(), false);
            }
        }
    }

    public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
        if (this.isScrollAnimationActive) {
            float tempDx = (e1.getX() - e2.getX()) / (float)OFFSET_FLING_DISTANCE;
            float tempDy = (e1.getY() - e2.getY()) / (float)OFFSET_FLING_DISTANCE;
            float absVelocityX = Math.abs(velocityX);
            float absVelocityY = Math.abs(velocityY);
            float maxVelocity = Math.max(absVelocityX, absVelocityY);
            int cntMove = BASE_CNT_FLING_MOVE;
            if (maxVelocity > 10000.0f) {
                cntMove *= (int)(maxVelocity / 10000.0f);
            }
            final int finalCntMove = cntMove;
            if (!this.isPinchZoom && (absVelocityX >= 2000.0f || absVelocityY >= 2000.0f)) {
                if (this.flingThread != null && this.flingThread.isAlive()) {
                    this.isflingStop = true;
                    this.flingThread.interrupt();
                }
                if (this.actionMoveDiffX > 0.0f && tempDx < 0.0f || this.actionMoveDiffX < 0.0f && tempDx > 0.0f) {
                    tempDx = (float)((double)tempDx * -1.0);
                }
                if (this.actionMoveDiffY > 0.0f && tempDy < 0.0f || this.actionMoveDiffY < 0.0f && tempDy > 0.0f) {
                    tempDy = (float)((double)tempDy * -1.0);
                }
                if (Math.abs(this.actionMoveDiffX / (float)(OFFSET_FLING_DISTANCE / 2)) > Math.abs(tempDx)) {
                    tempDx = this.actionMoveDiffX / (float)(OFFSET_FLING_DISTANCE / 2);
                }
                if (Math.abs(this.actionMoveDiffY / (float)(OFFSET_FLING_DISTANCE / 2)) > Math.abs(tempDy)) {
                    tempDy = this.actionMoveDiffY / (float)(OFFSET_FLING_DISTANCE / 2);
                }
                final float dx = tempDx;
                final float dy = tempDy;
                this.isScrolling = true;
                this.flingThread = null;
                this.isflingStop = false;
                this.flingThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        int i;
                        float slowDownByArrival = 0.0f;
                        long calMoveDelay = 0L;
                        for (i = 1; !TMapView.this.isflingStop && i <= finalCntMove; ++i) {
                            long beforMoveTo = System.currentTimeMillis();
                            slowDownByArrival = (float)(finalCntMove - (i - 1)) / (float)finalCntMove;
                            if ((double)slowDownByArrival < 0.7) {
                                TMapView.this.moveTo(dx * slowDownByArrival, dy * slowDownByArrival);
                            } else {
                                TMapView.this.moveTo(dx, dy);
                            }
                            long afterMoveTo = System.currentTimeMillis();
                            long syncDelay = afterMoveTo - beforMoveTo;
                            try {
                                calMoveDelay = 10L - syncDelay;
                                calMoveDelay = (long)((float)calMoveDelay + 10.0f * ((float)i / (float)finalCntMove));
                                if (calMoveDelay < 0L) continue;
                                Thread.sleep(calMoveDelay);
                                continue;
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        if (i > finalCntMove) {
                            TMapView.this.isScrolling = false;
                            if (TMapView.this.prevActionUpTime != 0L && System.currentTimeMillis() - TMapView.this.prevActionUpTime >= 400L) {
                                if (TMapView.this.onDisableScrollWithZoomLevelListener != null) {
                                    TMapView.this.onDisableScrollWithZoomLevelListener.onDisableScrollWithZoomLevelEvent(TMapView.this.getZoomLevel(), TMapView.this.getCenterPoint());
                                }
                                if (TMapView.this.isFixZoomPosition) {
                                    TMapView.this.updateZoomPoint();
                                }
                                if (System.currentTimeMillis() - TMapView.this.prevActionUpTime >= 700L) {
                                    TMapView.this.findTraffic();
                                }
                            }
                        }
                    }
                });
                this.flingThread.start();
            }
        }
        return true;
    }

    public DraggingAnimateThread getAnimatedDraggingThread() {
        return this.animatedDraggingThread;
    }

    public void onLongPress(MotionEvent e) {
        PointF pointf = new PointF(e.getX(), e.getY());
        TMapPoint point = this.getTMapPointFromScreenPoint(pointf.x, pointf.y);
        if (this.onLongClickListener != null && !this.multiTouchSupport.isInZoom()) {
            this.onLongClickListener.onLongPressEvent(this.markerItemLayer.onClickEvent(pointf), this.poiLayer.onClickEvent(pointf), point);
        }
    }

    public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
        if (!this.multiTouchSupport.isInZoom() && this.mode == 1 && !this.mUserScrollZoomEnable) {
            this.drag(e2.getX() + distanceX, e2.getY() + distanceY, e2.getX(), e2.getY(), true);
        }
        return true;
    }

    public void onShowPress(MotionEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onSingleTapUp(MotionEvent e) {
        if (this.mode != 3 && this.onClickReverseLabelListener != null) {
            TMapPoint point = this.getTMapPointFromScreenPoint(e.getX(), e.getY());
            TMapData.findReverseLabel(point, this.getZoomLevel(), new TMapData.findReverseLabelCallBack(){

                @Override
                public void onReverseLabelCallBack(TMapLabelInfo labelInfo) {
                    TMapView.this.onClickReverseLabelListener.onClickReverseLabelEvent(labelInfo);
                }
            });
        }
        if (this.mbZooming) {
            this.mbZooming = false;
            this.onSingleTapUp = true;
            return false;
        }
        if (!this.mbZooming) {
            this.onSingleTapUp = false;
            PointF pointf = new PointF(e.getX(), e.getY());
            this.markerItemLayer.onSingleTapUp(pointf);
            int xPoint1 = 0;
            int yPoint1 = 0;
            int xPoint2 = 0;
            int yPoint2 = 0;
            int ex = (int)e.getX();
            int ey = (int)e.getY();
            Map<String, TMapOverlay> map = this.overlays;
            synchronized (map) {
                ArrayList<String> list = new ArrayList<String>(this.overlays.keySet());
                for (int k = list.size() - 1; k > -1; --k) {
                    TMapMarkerItem2 item2 = (TMapMarkerItem2)this.overlays.get(list.get(k));
                    if (!item2.getMarkerTouch() || item2.getCalloutRect() == null || !item2.getCalloutRect().contains(ex, ey)) continue;
                    this.onMarker2ClickListener.onCalloutMarker2ClickEvent(item2.getID(), item2);
                    return true;
                }
                for (int i = list.size() - 1; i > -1; --i) {
                    TMapMarkerItem2 item = (TMapMarkerItem2)this.overlays.get(list.get(i));
                    if (item == null || item.getIcon() == null) continue;
                    int x = this.getRotatedMapXForPoint(item.getTMapPoint().getLatitude(), item.getTMapPoint().getLongitude());
                    int y = this.getRotatedMapYForPoint(item.getTMapPoint().getLatitude(), item.getTMapPoint().getLongitude());
                    float xPos = item.getPositionX();
                    float yPos = item.getPositionY();
                    int nMarkerIconWidth = 0;
                    int nMarkerIconHeight = 0;
                    int marginX = 0;
                    int marginY = 0;
                    nMarkerIconWidth = item.getIcon().getWidth();
                    nMarkerIconHeight = item.getIcon().getHeight();
                    int nPos_x = (int)(xPos * (float)nMarkerIconWidth);
                    int nPos_y = (int)(yPos * (float)nMarkerIconHeight);
                    marginX = nPos_x == 0 ? nMarkerIconWidth / 2 : nPos_x;
                    marginY = nPos_y == 0 ? nMarkerIconHeight / 2 : nPos_y;
                    xPoint1 = x - marginX;
                    yPoint1 = y - marginY;
                    xPoint2 = xPoint1 + nMarkerIconWidth;
                    yPoint2 = yPoint1 + nMarkerIconHeight;
                    if (xPoint1 > ex || yPoint1 > ey || ex > xPoint2 || ey > yPoint2) continue;
                    this.overlays.get(list.get(i)).onSingleTapUp(pointf, this);
                    for (int j = 0; j < list.size(); ++j) {
                        TMapMarkerItem2 item2 = (TMapMarkerItem2)this.overlays.get(list.get(j));
                        if (item.getID().equals(item2.getID()) || !item2.getMarkerTouch()) continue;
                        item2.setMarkerTouch(false);
                    }
                    this.postInvalidate();
                    return true;
                }
            }
            return true;
        }
        return false;
    }

    public boolean onDoubleTap(MotionEvent e) {
        if (this.mUserScrollZoomEnable) {
            return false;
        }
        if (this.getZoomLevel() < this.map.getMaximumZoom()) {
            if (this.isFixZoomPosition) {
                this.isFixZoomPosition = this.chkZoomPosition();
            }
            TMapPoint l = this.getTMapPointFromScreenPoint(e.getX(), e.getY());
            this.getAnimatedDraggingThread().startDraggingMoving(this.getLatitude(), this.getLongitude(), l.getLatitude(), l.getLongitude(), this.getZoom(), this.getZoom() + 1, (int)this.getTileSize(), this.getRotateData(), true);
        }
        return true;
    }

    public boolean onDoubleTapEvent(MotionEvent e) {
        return false;
    }

    public boolean onSingleTapConfirmed(MotionEvent e) {
        if (!this.onSingleTapUp) {
            return false;
        }
        if (this.onSingleTapUp) {
            PointF pointf = new PointF(e.getX(), e.getY());
            this.markerItemLayer.onSingleTapUp(pointf);
            this.onSingleTapUp = false;
        }
        return false;
    }

    public void tileDownloaded_Reload(MapTileDownloader.DownloadRequest request) {
        if (request == null) {
            return;
        }
        String ordImgTile = request.zoom + "_" + request.xTile + "_" + request.yTile + ".png";
        if (request.memoryErr) {
            if (this.mResourceManager != null) {
                this.mResourceManager.removeTileImageFromCache();
            }
            return;
        }
        if (request.error) {
            if (request.retry < 5) {
                ++request.retry;
                this.mResourceManager.downloader.downloadRequest(request);
            }
            return;
        }
        if (request.retry > 0) {
            // empty if block
        }
        if (this.rotate != 0.0f) {
            if (request.fileToSave != null && request.type == 0) {
                this.mResourceManager.setTileImageFromCache(ordImgTile, request.fileToSave);
            }
            this.postInvalidate();
            return;
        }
        if (request.zoom != this.getZoom()) {
            return;
        }
        if (request.fileToSave != null) {
            if (request.type == 0) {
                this.mResourceManager.setTileImageFromCache(ordImgTile, request.fileToSave);
            }
            if (this.mlist.size() > 0 && this.mlist.contains(ordImgTile)) {
                this.mlist.remove(ordImgTile);
            }
            if (request.type == 0) {
                this.mResourceManager.insertImage(ordImgTile, request.fileToSave);
            }
            this.postInvalidate();
            return;
        }
        if (request.retry < 5) {
            ++request.retry;
            this.mResourceManager.downloader.downloadRequest(request);
        }
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    public void onSensorChanged(SensorEvent event) {
        float nowAngle;
        if (this.compassMode && (nowAngle = this.calAngle(event.sensor.getType(), event.values)) != -1.0f) {
            float diffAngle = 0.0f;
            if (this.getRangeInAngle(this.lastAngle, nowAngle) > (float)this.offsetAngleRange) {
                this.setRotate(-nowAngle);
                if (this.isDeviceMoving()) {
                    this.offsetAngleRange = 10;
                } else {
                    diffAngle = this.getRangeInAngle(this.lastAngle, nowAngle);
                    if (diffAngle < 20.0f && diffAngle > (float)this.offsetAngleRange) {
                        this.offsetAngleRange = (int)diffAngle + 1;
                    }
                }
                this.lastAngle = nowAngle;
            }
            this.prevAccelData = this.accelData;
        }
    }

    private float getRangeInAngle(float angle1, float angle2) {
        float diffResult = 0.0f;
        float diffAngle = Math.abs(angle2 - angle1);
        diffResult = diffAngle > 180.0f ? (angle2 > angle1 ? 360.0f - angle2 + (angle1 + 1.0f) : 360.0f - angle1 + (angle2 + 1.0f)) : diffAngle;
        return diffResult;
    }

    private boolean isDeviceMoving() {
        boolean result = false;
        if (this.accelData != null && this.prevAccelData != null && (Math.abs(this.accelData[0] - this.prevAccelData[0]) > 0.0f || Math.abs(this.accelData[1] - this.prevAccelData[1]) > 0.0f || Math.abs(this.accelData[2] - this.prevAccelData[2]) > 0.0f)) {
            result = true;
        }
        return result;
    }

    private float calAngle(int sensorType, float[] eventValue) {
        float[] rotation = new float[9];
        float[] resultData = new float[]{-1.0f, -1.0f, -1.0f};
        if (sensorType == 1) {
            this.accelData = (float[])eventValue.clone();
        } else if (sensorType == 2) {
            this.magneticData = (float[])eventValue.clone();
        }
        if (this.accelData != null && this.magneticData != null) {
            SensorManager.getRotationMatrix((float[])rotation, null, (float[])this.accelData, (float[])this.magneticData);
            SensorManager.getOrientation((float[])rotation, (float[])resultData);
            resultData[0] = (float)Math.toDegrees(resultData[0]);
            if (resultData[0] < 0.0f) {
                resultData[0] = resultData[0] + 360.0f;
            }
            this.currentScreenOrientation = this.getResources().getConfiguration().orientation;
            if (this.currentScreenOrientation == 2) {
                resultData[0] = resultData[0] + 90.0f;
            }
        }
        return resultData[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bringMarkerToFront(TMapMarkerItem item) {
        if (item != null) {
            try {
                Map<String, TMapMarkerItem> map = this.markerItemLayer.mMarkerItems;
                synchronized (map) {
                    this.markerItemLayer.mMarkerItems.remove(item.getID());
                    this.markerItemLayer.mMarkerItems.put(item.getID(), item);
                    this.postInvalidate();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMarkerToBack(TMapMarkerItem item) {
        if (item == null) {
            return;
        }
        try {
            Map<String, TMapMarkerItem> map = this.markerItemLayer.mMarkerItems;
            synchronized (map) {
                int i;
                this.markerItemLayer.mMarkerItems.remove(item.getID());
                LinkedHashMap<String, TMapMarkerItem> MarkerItemsTemp = new LinkedHashMap<String, TMapMarkerItem>();
                ArrayList<String> list = new ArrayList<String>(this.markerItemLayer.mMarkerItems.keySet());
                for (i = 0; i < list.size(); ++i) {
                    MarkerItemsTemp.put(this.markerItemLayer.mMarkerItems.get(list.get(i)).getID(), this.markerItemLayer.mMarkerItems.get(list.get(i)));
                }
                this.markerItemLayer.mMarkerItems.clear();
                this.markerItemLayer.mMarkerItems.put(item.getID(), item);
                list = new ArrayList(MarkerItemsTemp.keySet());
                for (i = 0; i < list.size(); ++i) {
                    this.markerItemLayer.mMarkerItems.put(((TMapMarkerItem)MarkerItemsTemp.get(list.get(i))).getID(), (TMapMarkerItem)MarkerItemsTemp.get(list.get(i)));
                }
                MarkerItemsTemp.clear();
            }
            this.postInvalidate();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setEnableClustering(boolean bEnable) {
        this.mClusterView = bEnable;
    }

    public boolean getEnableClustering() {
        return this.mClusterView;
    }

    public void setClusteringIcon(Bitmap bitmap) {
        this.mClusteringBitmap = bitmap;
    }

    public Bitmap getClusteringeIcon() {
        return this.mClusteringBitmap;
    }

    public void setDefaultIcon(Bitmap bitmap) {
        this.mDefaultIcon = bitmap;
    }

    public Bitmap getDefaultIcon() {
        return this.mDefaultIcon;
    }

    public Bitmap getCaptureImage() {
        Bitmap captureBitmap = null;
        if (this.mCanvas2 != null) {
            this.draw(this.mCanvas2);
        }
        if (this.mEmpty != null) {
            captureBitmap = this.mEmpty;
        }
        return captureBitmap;
    }

    public void getCaptureImage(int nTimeOut, MapCaptureImageListenerCallback MapCaptureListener) {
        if (this.mCanvas2 != null) {
            this.draw(this.mCanvas2);
        }
        if (this.mEmpty != null) {
            MapCaptureListener.onMapCaptureImage(this.mEmpty);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onDraw(Canvas canvas) {
        if (this.isAppIsInBackground(this.mContext) || this.isScreenOff) {
            this.mBackgroundCheck = 1;
            this.postInvalidate();
            return;
        }
        if (this.mBackgroundCheck == 1) {
            this.postInvalidate();
            this.mBackgroundCheck = 2;
        } else {
            this.mBackgroundCheck = 0;
        }
        this.mTMapRenderer.setScreenSize(this.getScreenWidth(), this.getScreenHeight());
        Object object = this.objDrawSync;
        synchronized (object) {
            TMapRenderer.DrawParams params = new TMapRenderer.DrawParams();
            params.latitude = this.latitude;
            params.longitude = this.longitude;
            params.zoom = this.getZoom();
            params.zoomType = this.zoomType;
            params.rotate = this.rotate;
            params.isZooming = this.isZooming();
            params.moveZoomLevel = this.moveZoomLevel;
            params.initialMultiTouchZoom = this.initialMultiTouchZoom;
            params.centerPointX = this.getCenterPointX();
            params.centerPointY = this.getCenterPointY();
            params.tileSize = this.getTileSize();
            params.srcTileSize = this.getSourceTileSize();
            params.slide = this.Slide;
            RectF tmapPointRect = this.mTMapRenderer.draw(canvas, params);
            this.drawOverMap(canvas, tmapPointRect, false);
            this.drawLogo(canvas);
        }
    }

    public void surfaceCreated(SurfaceHolder holder) {
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int w, int h) {
        super.surfaceChanged(holder, format, w, h);
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
    }

    private void drawLogo(Canvas canvas) {
        int logoX = 0;
        logoX = this.mLogoPlace == TMapLogoPositon.POSITION_BOTTOMRIGHT ? this.getWidth() - this.LogoBitmap.getWidth() : (this.mLogoPlace == TMapLogoPositon.POSITION_BOTTOMMIDDLE ? this.getWidth() / 2 - this.LogoBitmap.getWidth() / 2 : (this.mLogoPlace == TMapLogoPositon.POSITION_BOTTOMLEFT ? 0 : this.getWidth() - this.LogoBitmap.getWidth()));
        canvas.drawBitmap(this.LogoBitmap, (float)logoX, (float)(this.getHeight() - this.LogoBitmap.getHeight()), null);
    }

    public void setTMapLogoPosition(TMapLogoPositon place) {
        this.mLogoPlace = place == null ? TMapLogoPositon.POSITION_BOTTOMRIGHT : place;
        this.postInvalidate();
    }

    public void setUserScrollZoomEnable(boolean enable) {
        this.mUserScrollZoomEnable = enable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMarkerItem2(String id, TMapMarkerItem2 markeritem) {
        try {
            Map<String, TMapOverlay> map = this.overlays;
            synchronized (map) {
                this.overlays.put(id, markeritem);
                this.postInvalidate();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMarkerItem2(String id) {
        Map<String, TMapOverlay> map = this.overlays;
        synchronized (map) {
            this.overlays.remove(id);
            this.postInvalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTMapOverlayID(int overlayID, TMapOverlayItem overlayItem) {
        CopyOnWriteArrayList<TMapOverlay> copyOnWriteArrayList = this.mOverlayList;
        synchronized (copyOnWriteArrayList) {
            try {
                this.mOverlayList.add(overlayID, overlayItem);
                this.postInvalidate();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTMapOverlayID(int overlayID) {
        CopyOnWriteArrayList<TMapOverlay> copyOnWriteArrayList = this.mOverlayList;
        synchronized (copyOnWriteArrayList) {
            this.mOverlayList.remove(overlayID);
            this.postInvalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markerOnClick(String id) {
        Map<String, TMapOverlay> map = this.overlays;
        synchronized (map) {
            TMapMarkerItem2 markerItem2;
            if (this.overlays.size() > 0 && (markerItem2 = (TMapMarkerItem2)this.overlays.get(id)) != null) {
                this.onMarker2ClickListener.onCalloutMarker2ClickEvent(id, markerItem2);
            }
        }
    }

    public void setOnMarkerClickEvent(OnCalloutMarker2ClickCallback listener) {
        this.onMarker2ClickListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showCallOutViewWithMarkerItemID(String markerItemID) {
        Map<String, TMapOverlay> map = this.overlays;
        synchronized (map) {
            TMapMarkerItem2 markerItem2;
            if (this.overlays.size() > 0 && (markerItem2 = (TMapMarkerItem2)this.overlays.get(markerItemID)) != null) {
                this.removeMarkerItem2(markerItemID);
                markerItem2.setMarkerTouch(!markerItem2.getMarkerTouch());
                this.addMarkerItem2(markerItem2.getID(), markerItem2);
                this.postInvalidate();
            }
        }
    }

    protected void onMeasure(int widthMeasure, int heightMeasure) {
        super.onMeasure(widthMeasure, heightMeasure);
        int height = 0;
        int heightMode = View.MeasureSpec.getMode((int)heightMeasure);
        switch (heightMode) {
            case -2147483648: {
                if (this.mScreenHeight <= View.MeasureSpec.getSize((int)heightMeasure)) {
                    height = this.mScreenHeight = View.MeasureSpec.getSize((int)heightMeasure);
                    break;
                }
                height = this.mScreenHeight;
                break;
            }
            case 0x40000000: {
                height = View.MeasureSpec.getSize((int)heightMeasure);
                break;
            }
            case 0: {
                height = heightMeasure;
            }
        }
        int width = 0;
        int widthMode = View.MeasureSpec.getMode((int)widthMeasure);
        switch (widthMode) {
            case 0x40000000: {
                width = View.MeasureSpec.getSize((int)widthMeasure);
                break;
            }
            case 0: {
                width = widthMeasure;
                break;
            }
            case -2147483648: {
                width = View.MeasureSpec.getSize((int)widthMeasure);
            }
        }
        this.setMeasuredDimension(width, height);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        if (changed) {
            if (!this.isAddView) {
                this.isAddView = true;
                this.initMapView();
                this.setMinZoomLevel(r, b);
                this.postInvalidate();
            }
            if (r <= 0 || b <= 0) {
                return;
            }
            if (r < b) {
                if (this.mWidthV != r || this.mHeightV != b) {
                    this.mEmptyV = this.mEmptyV != null ? Bitmap.createScaledBitmap((Bitmap)this.mEmptyV, (int)r, (int)b, (boolean)true) : Bitmap.createBitmap((int)r, (int)b, (Bitmap.Config)Bitmap.Config.RGB_565);
                    this.mCanvasV = new Canvas(this.mEmptyV);
                }
                if (this.mEmptyV != null) {
                    this.mCanvasV.save();
                    this.mCanvas2 = this.mCanvasV;
                    this.mEmpty = this.mEmptyV;
                }
                this.mWidthV = r;
                this.mHeightV = b;
            } else {
                if (this.mWidthH != r || this.mHeightH != b) {
                    this.mEmptyH = this.mEmptyH != null ? Bitmap.createScaledBitmap((Bitmap)this.mEmptyH, (int)r, (int)b, (boolean)true) : Bitmap.createBitmap((int)r, (int)b, (Bitmap.Config)Bitmap.Config.RGB_565);
                    this.mCanvasH = new Canvas(this.mEmptyH);
                }
                if (this.mEmptyH != null) {
                    this.mCanvasH.save();
                    this.mCanvas2 = this.mCanvasH;
                    this.mEmpty = this.mEmptyH;
                }
                this.mWidthH = r;
                this.mHeightH = b;
            }
            this.postInvalidate();
        }
    }

    private static void recycleBitmap(ImageView iv) {
        Drawable d = iv.getDrawable();
        if (d instanceof BitmapDrawable) {
            Bitmap b = ((BitmapDrawable)d).getBitmap();
            b.recycle();
            d.setCallback(null);
        }
    }

    public void setZoomPosition(double longitude, double latitude) {
        this.zoomLongitude = MapUtils.boundaryInLongitude(this.getZoom(), longitude);
        this.zoomLatitude = MapUtils.boundaryInLatitude(this.getZoom(), latitude);
        if (this.chkZoomPosition()) {
            this.zoomPointX = this.getMapXForPoint(this.zoomLongitude, this.zoomLatitude);
            this.zoomPointY = this.getMapYForPoint(this.zoomLongitude, this.zoomLatitude);
            this.longitude = this.zoomLongitude;
            this.latitude = this.zoomLatitude;
            this.isFixZoomPosition = true;
        } else {
            this.isFixZoomPosition = false;
            Log.w((String)"SKT", (String)"setZoomPosition \ud568\uc218\uc758 \uc88c\ud45c\uac00 \ud654\uba74\uc5d0 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
        }
    }

    public void removeZoomPositon() {
        this.isFixZoomPosition = false;
    }

    private boolean chkZoomPosition() {
        if (this.zoomLongitude > 0.0 && this.zoomLatitude > 0.0) {
            TMapPoint leftTopPoint = this.getLeftTopPoint();
            TMapPoint rightBottomPoint = this.getRightBottomPoint();
            if (leftTopPoint.getLatitude() >= this.zoomLatitude && rightBottomPoint.getLatitude() <= this.zoomLatitude && leftTopPoint.getLongitude() <= this.zoomLongitude && rightBottomPoint.getLongitude() >= this.zoomLongitude) {
                return true;
            }
        }
        if (this.isFixZoomPosition) {
            TMapPoint screenCenterPoint = this.getTMapPointFromScreenPoint(this.getWidth() / 2, this.getHeight() / 2);
            this.longitude = screenCenterPoint.getLongitude();
            this.latitude = screenCenterPoint.getLatitude();
        }
        return false;
    }

    private void updateZoomPoint() {
        this.zoomPointX = this.getMapXForPoint(this.zoomLongitude, this.zoomLatitude);
        this.zoomPointY = this.getMapYForPoint(this.zoomLongitude, this.zoomLatitude);
        this.longitude = this.zoomLongitude;
        this.latitude = this.zoomLatitude;
        this.prevLongitude = this.longitude;
        this.prevLatitude = this.latitude;
        this.postInvalidate();
    }

    public void moveToZoomPosition(double LocationLongitude, double LocationLatitude) {
        if (this.isFixZoomPosition && (this.isFixZoomPosition = this.chkZoomPosition())) {
            double boundLongitude = MapUtils.boundaryInLongitude(this.getZoom(), LocationLongitude);
            double boundLatitude = MapUtils.boundaryInLatitude(this.getZoom(), LocationLatitude);
            double distX = this.getMapXForPoint(this.zoomLongitude, this.zoomLatitude) - this.getCenterPointX();
            double distY = this.getMapYForPoint(this.zoomLongitude, this.zoomLatitude) - this.getCenterPointY();
            TMapPoint movePoint = this.getTMapPointFromScreenPoint((float)((double)this.getMapXForPoint(boundLongitude, boundLatitude) - distX), (float)((double)this.getMapYForPoint(boundLongitude, boundLatitude) - distY));
            this.setCenterPoint(movePoint.getLongitude(), movePoint.getLatitude());
        }
    }

    public void setScrollAnimation(int sensitivity) {
        if (this.flingThread != null && this.flingThread.isAlive()) {
            this.isflingStop = true;
            this.flingThread.interrupt();
        }
        switch (sensitivity) {
            case 0: {
                this.isScrollAnimationActive = false;
                break;
            }
            case 1: {
                OFFSET_FLING_DISTANCE = 10;
                BASE_CNT_FLING_MOVE = 30;
                this.isScrollAnimationActive = true;
                break;
            }
            case 2: {
                OFFSET_FLING_DISTANCE = 8;
                BASE_CNT_FLING_MOVE = 40;
                this.isScrollAnimationActive = true;
                break;
            }
            case 3: {
                OFFSET_FLING_DISTANCE = 5;
                BASE_CNT_FLING_MOVE = 50;
                this.isScrollAnimationActive = true;
            }
        }
    }

    public TMapInfo getDisplayTMapInfo(ArrayList<TMapPoint> point, RectF rectForDraw) {
        if (rectForDraw.left >= rectForDraw.right || rectForDraw.top >= rectForDraw.bottom) {
            Log.w((String)"SKT", (String)"getDisplayTMapInfo \ud568\uc218\uc758 \ud30c\ub77c\ubbf8\ud130 rectForDraw \uc758 \uac12\uc774 \uc62c\ubc14\ub974\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
            return null;
        }
        if (rectForDraw.left > (float)this.getWidth() || rectForDraw.right > (float)this.getWidth() || rectForDraw.top > (float)this.getHeight() || rectForDraw.bottom > (float)this.getHeight()) {
            Log.w((String)"SKT", (String)"getDisplayTMapInfo \ud568\uc218\uc758 \ud30c\ub77c\ubbf8\ud130 rectForDraw \uc758 \uac12\uc740 \ud654\uba74 \uc0ac\uc774\uc988\ub97c \ub118\uc5b4\uac08 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
            return null;
        }
        double MinX = 9.9999999E7;
        double MaxX = 0.0;
        double MinY = 9.9999999E7;
        double MaxY = 0.0;
        double x = 0.0;
        double y = 0.0;
        for (int i = 0; i < point.size(); ++i) {
            x = point.get(i).getLatitude();
            y = point.get(i).getLongitude();
            MinY = Math.min(MinY, y);
            MaxY = Math.max(MaxY, y);
            MinX = Math.min(MinX, x);
            MaxX = Math.max(MaxX, x);
        }
        double CenterX = (MinX + MaxX) / 2.0;
        double CenterY = (MinY + MaxY) / 2.0;
        float margin = 5.0f * this.mDensity;
        double DisY = MapUtils.getDistance(MinX, MinY, MinX, MaxY) + (double)margin;
        double DisX = MapUtils.getDistance(MinX, MinY, MaxX, MinY) + (double)margin;
        int nZoomLevel = 12;
        float tileSize = 256.0f * this.mFullHDSizeUP;
        double wTile = Math.floor((rectForDraw.right - rectForDraw.left) / tileSize);
        double hTile = Math.floor((rectForDraw.bottom - rectForDraw.top) / tileSize);
        double meterOfTile = 30.0;
        double visibleWidth = meterOfTile * wTile;
        double visibleHeight = meterOfTile * hTile;
        int s = 0;
        for (int i = this.getMaximumShownMapZoom(); i >= this.getMinimumShownMapZoom(); --i) {
            double avableWidth = visibleWidth * Math.pow(2.0, s);
            double avableHeight = visibleHeight * Math.pow(2.0, s);
            ++s;
            nZoomLevel = i;
            if (DisX < avableHeight && DisY < avableWidth) break;
        }
        double backLatitude = this.latitude;
        double backLongitude = this.longitude;
        float backZoom = this.zoom;
        this.latitude = CenterX;
        this.longitude = CenterY;
        this.zoom = nZoomLevel;
        TMapPoint tempTMapPoint1 = this.getTMapPointFromScreenPoint(0.0f, rectForDraw.top);
        TMapPoint tempTMapPoint2 = this.getTMapPointFromScreenPoint(0.0f, 0.0f);
        double offsetTop = (tempTMapPoint2.getLatitude() - tempTMapPoint1.getLatitude()) / 2.0;
        tempTMapPoint1 = this.getTMapPointFromScreenPoint(0.0f, this.getHeight());
        tempTMapPoint2 = this.getTMapPointFromScreenPoint(0.0f, rectForDraw.bottom);
        double offsetBottom = (tempTMapPoint2.getLatitude() - tempTMapPoint1.getLatitude()) / 2.0;
        tempTMapPoint1 = this.getTMapPointFromScreenPoint(0.0f, 0.0f);
        tempTMapPoint2 = this.getTMapPointFromScreenPoint(rectForDraw.left, 0.0f);
        double offsetLeft = (tempTMapPoint2.getLongitude() - tempTMapPoint1.getLongitude()) / 2.0;
        tempTMapPoint1 = this.getTMapPointFromScreenPoint(rectForDraw.right, 0.0f);
        tempTMapPoint2 = this.getTMapPointFromScreenPoint(this.getWidth(), 0.0f);
        double offsetRight = (tempTMapPoint2.getLongitude() - tempTMapPoint1.getLongitude()) / 2.0;
        this.latitude = backLatitude;
        this.longitude = backLongitude;
        this.zoom = backZoom;
        CenterX = CenterX + offsetTop - offsetBottom;
        CenterY = CenterY - offsetLeft + offsetRight;
        return new TMapInfo(new TMapPoint(CenterX, CenterY), nZoomLevel);
    }

    public void setHttpsMode(boolean isActive) {
        this.isHttpsMode = isActive;
        if (Build.VERSION.SDK_INT >= 28 && !isActive) {
            Log.w((String)"SKT", (String)"Android API 28 \uc774\uc0c1 \ub2e8\ub9d0\uae30\uc5d0\uc11c Http \ud1b5\uc2e0\uc744 \uc0ac\uc6a9\ud558\uba74 \uc9c0\ub3c4\uac00 \ud45c\ucd9c\ub418\uc9c0 \uc54a\uc744 \uc218 \uc788\uc2b5\ub2c8\ub2e4.");
        }
        MapUtils.setTileType("anTileKoHd");
        this.TileType = 2;
        this.mResourceManager.resetNameInFS(2);
        this.mResourceManager.removeTileImageFromCache();
        this.setMap();
        this.postInvalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getProperties(Context context) {
        InputStream inputStream = null;
        try {
            AssetManager assetManager = context.getAssets();
            inputStream = assetManager.open("properties/config.properties");
            Properties props = new Properties();
            props.load(inputStream);
            Properties properties = props;
            return properties;
        }
        catch (IOException e) {
            Log.e((String)"IOException occur", (String)e.toString());
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    Log.e((String)"IOException occur", (String)e.toString());
                }
            }
        }
        return null;
    }

    public void setBufferStep(int nBufferStep) {
        this.mTMapRenderer.setBufferStep(nBufferStep);
    }

    public int getBufferStep() {
        return this.mTMapRenderer.getBufferStep();
    }

    public boolean getTrafficInfoActive() {
        return this.isTrafficInfoActive;
    }

    public void setTrafficInfoActive(boolean isActive) {
        this.isTrafficInfoActive = isActive;
        if (this.isTrafficInfoActive) {
            TMapPoint leftTop = this.getLeftTopPoint();
            TMapPoint rightBottom = this.getRightBottomPoint();
            this.mLeftTop = new TMapPoint(leftTop.getLatitude() + (leftTop.getLatitude() - rightBottom.getLatitude()) / 5.0, leftTop.getLongitude() - (rightBottom.getLongitude() - leftTop.getLongitude()) / 5.0);
            this.mRightBottom = new TMapPoint(rightBottom.getLatitude() - (leftTop.getLatitude() - rightBottom.getLatitude()) / 5.0, rightBottom.getLongitude() + (rightBottom.getLongitude() - leftTop.getLongitude()) / 5.0);
            this.findTraffic();
        } else {
            this.prevZoom = 0.0f;
            this.mLeftTop = null;
            this.mRightBottom = null;
            this.removeTrafficLine();
        }
    }

    private void findTraffic() {
        boolean drawTraffic = false;
        if (this.isTrafficInfoActive) {
            if (this.getZoom() > 6) {
                TMapData tmapData = new TMapData();
                TMapPoint leftTop = this.getLeftTopPoint();
                TMapPoint rightBottom = this.getRightBottomPoint();
                if (this.prevZoom != this.zoom) {
                    drawTraffic = true;
                    this.mLeftTop = new TMapPoint(leftTop.getLatitude() + (leftTop.getLatitude() - rightBottom.getLatitude()) / 5.0, leftTop.getLongitude() - (rightBottom.getLongitude() - leftTop.getLongitude()) / 5.0);
                    this.mRightBottom = new TMapPoint(rightBottom.getLatitude() - (leftTop.getLatitude() - rightBottom.getLatitude()) / 5.0, rightBottom.getLongitude() + (rightBottom.getLongitude() - leftTop.getLongitude()) / 5.0);
                    this.prevZoom = this.zoom;
                } else if (leftTop.getLatitude() <= this.mLeftTop.getLatitude() && leftTop.getLongitude() >= this.mLeftTop.getLongitude() && rightBottom.getLatitude() >= this.mRightBottom.getLatitude() && rightBottom.getLongitude() <= this.mRightBottom.getLongitude()) {
                    drawTraffic = false;
                } else {
                    drawTraffic = true;
                    this.mLeftTop = new TMapPoint(leftTop.getLatitude() + (leftTop.getLatitude() - rightBottom.getLatitude()) / 5.0, leftTop.getLongitude() - (rightBottom.getLongitude() - leftTop.getLongitude()) / 5.0);
                    this.mRightBottom = new TMapPoint(rightBottom.getLatitude() - (leftTop.getLatitude() - rightBottom.getLatitude()) / 5.0, rightBottom.getLongitude() + (rightBottom.getLongitude() - leftTop.getLongitude()) / 5.0);
                }
                if (drawTraffic) {
                    if (this.mRightBottom.getLatitude() < 33.18367780003911) {
                        this.mRightBottom.setLatitude(33.18367780003911);
                    }
                    if (this.mRightBottom.getLongitude() > 129.594863) {
                        this.mRightBottom.setLongitude(129.594863);
                    }
                    if (this.mLeftTop.getLatitude() > 38.245591) {
                        this.mLeftTop.setLatitude(38.245591);
                    }
                    if (this.mLeftTop.getLongitude() < 125.36728620529175) {
                        this.mLeftTop.setLongitude(125.36728620529175);
                    }
                    long startTime = System.currentTimeMillis();
                    try {
                        tmapData.findTrafficData(this.mRightBottom.getLatitude(), this.mLeftTop.getLongitude(), this.mLeftTop.getLatitude(), this.mRightBottom.getLongitude(), this.getZoom(), new TMapData.findTrafficDataCallBack(){

                            @Override
                            public void onTrafficDataCallBack(ArrayList<TMapPolyLine> tplList) {
                                long start = System.currentTimeMillis();
                                TMapView.this.removeTrafficLine();
                                if (tplList != null && tplList.size() > 0) {
                                    for (int i = 0; i < tplList.size(); ++i) {
                                        TMapView.this.addTMapPolyLine("_traffic_" + i, tplList.get(i));
                                    }
                                }
                                TMapView.this.mTrafficListSize = tplList.size();
                                tplList = null;
                            }
                        });
                    }
                    catch (Exception exception) {}
                }
            } else {
                this.removeTrafficLine();
            }
        }
    }

    private void removeTrafficLine() {
        for (int nIndex = 0; nIndex < 20000 && this.polyLineLayer.mPolyLines.get("_traffic_" + nIndex) != null; ++nIndex) {
            this.removeTMapPolyLine("_traffic_" + nIndex);
        }
    }

    private boolean isAppIsInBackground(Context context) {
        boolean isInBackground = true;
        try {
            ActivityManager am = (ActivityManager)context.getSystemService("activity");
            if (Build.VERSION.SDK_INT > 20) {
                List runningProcesses = am.getRunningAppProcesses();
                for (ActivityManager.RunningAppProcessInfo processInfo : runningProcesses) {
                    if (processInfo.importance != 100) continue;
                    for (String activeProcess : processInfo.pkgList) {
                        if (!activeProcess.equals(context.getPackageName())) continue;
                        isInBackground = false;
                    }
                }
            } else {
                List taskInfo = am.getRunningTasks(1);
                ComponentName componentInfo = ((ActivityManager.RunningTaskInfo)taskInfo.get((int)0)).topActivity;
                if (componentInfo.getPackageName().equals(context.getPackageName())) {
                    isInBackground = false;
                }
            }
        }
        catch (Exception e) {
            isInBackground = false;
            this.isScreenOff = false;
        }
        return isInBackground;
    }

    private boolean isScreenOff() {
        PowerManager pm = (PowerManager)this.mContext.getSystemService("power");
        boolean isScreenOn = pm.isScreenOn();
        return !isScreenOn;
    }

    private void setScreenOffEvent() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.SCREEN_OFF");
        intentFilter.addAction("android.intent.action.SCREEN_ON");
        BroadcastReceiver screenOnOff = new BroadcastReceiver(){
            public static final String ScreenOff = "android.intent.action.SCREEN_OFF";
            public static final String ScreenOn = "android.intent.action.SCREEN_ON";

            public void onReceive(Context contex, Intent intent) {
                if (intent.getAction().equals(ScreenOff)) {
                    TMapView.this.isScreenOff = true;
                } else if (intent.getAction().equals(ScreenOn)) {
                    TMapView.this.isScreenOff = false;
                }
            }
        };
    }

    private void hideNavigationBar() {
        View decorView = ((Activity)this.getContext()).getWindow().getDecorView();
        decorView.setSystemUiVisibility(2564);
    }

    public void setContinueCompassMode(boolean mode) {
        this.compassMode_2 = mode;
    }

    private float rotation(MotionEvent event) {
        double delta_x = event.getX(0) - event.getX(1);
        double delta_y = event.getY(0) - event.getY(1);
        double radians = Math.atan2(delta_y, delta_x);
        return (float)Math.toDegrees(radians);
    }

    public void setInitRotate() {
        this.lastRot = 0.0f;
        this.setRotate(0.0f);
    }

    public void setRotateEnable(boolean isEnable) {
        this.isRotateEnable = isEnable;
    }

    public void setCompassModeFix(boolean isEnable) {
        this.setContinueCompassMode(isEnable);
        if (isEnable) {
            this.setCompassMode(true);
        } else {
            this.mResourceManager.AddTileNum = this.mResourceManager.MaxTileNum;
            Sensor accelSensor = this.mSensorMgr.getDefaultSensor(1);
            Sensor magneticSensor = this.mSensorMgr.getDefaultSensor(2);
            if (accelSensor != null) {
                this.mSensorMgr.unregisterListener((SensorEventListener)this, accelSensor);
            }
            if (magneticSensor != null) {
                this.mSensorMgr.unregisterListener((SensorEventListener)this, magneticSensor);
            }
            this.compassMode = false;
        }
    }

    public void testHttps() {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String uri = "https://jre.kr/test.json";
                HttpURLConnection urlCon = null;
                InputStreamReader isr = null;
                try {
                    char[] buf;
                    URL url = new URL(uri);
                    urlCon = (HttpURLConnection)url.openConnection();
                    urlCon.setRequestMethod("GET");
                    if (urlCon.getResponseCode() == 200) {
                        Log.e((String)"httpsTest", (String)"success connect");
                        isr = new InputStreamReader(urlCon.getInputStream());
                        buf = new char[4096];
                        int size = isr.read(buf);
                        String data = new String(buf, 0, size);
                        TMapView.this.parseHttps(data);
                    } else {
                        isr = new InputStreamReader(urlCon.getErrorStream());
                        buf = new char[4096];
                        int size = isr.read(buf);
                        String data = new String(buf, 0, size);
                        Log.e((String)"httpsTest", (String)("fail connect + " + data));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    try {
                        isr.close();
                        urlCon.disconnect();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }.start();
    }

    private void parseHttps(String data) {
        try {
            JSONObject jo = new JSONObject(data);
            JSONObject parent = jo.getJSONObject("coordinateInfo");
            double lat = Double.parseDouble(parent.getString("lat"));
            double lon = Double.parseDouble(parent.getString("lon"));
            String city = parent.getString("city_do");
            String gu_gun = parent.getString("gu_gun");
            String dong = parent.getString("legalDong");
            String bunji = parent.getString("bunji");
            String address = city + " " + gu_gun + " " + dong + " " + bunji;
            this.removeAllMarkerItem();
            TMapMarkerItem marker = new TMapMarkerItem();
            marker.setPosition(0.5f, 1.0f);
            TMapPoint point = new TMapPoint(lat, lon);
            marker.setTMapPoint(point);
            marker.setName(address);
            this.addMarkerItem("httpsTest", marker);
            this.setCenterPoint(lon, lat);
            Log.e((String)"httpsTest", (String)address);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static interface MapCaptureImageListenerCallback {
        public void onMapCaptureImage(Bitmap var1);
    }

    public static interface OnApiKeyListenerCallback {
        public void SKTMapApikeySucceed();

        public void SKTMapApikeyFailed(String var1);
    }

    public static interface OnClickReverseLabelListenerCallback {
        public void onClickReverseLabelEvent(TMapLabelInfo var1);
    }

    public static interface OnCalloutMarker2ClickCallback {
        public void onCalloutMarker2ClickEvent(String var1, TMapMarkerItem2 var2);
    }

    public static interface OnDisableScrollWithZoomLevelCallback {
        public void onDisableScrollWithZoomLevelEvent(float var1, TMapPoint var2);
    }

    public static interface OnEnableScrollWithZoomLevelCallback {
        public void onEnableScrollWithZoomLevelEvent(float var1, TMapPoint var2);
    }

    public static interface OnCalloutRightButtonClickCallback {
        public void onCalloutRightButton(TMapMarkerItem var1);
    }

    public static interface OnClickListenerCallback {
        public boolean onPressEvent(ArrayList<TMapMarkerItem> var1, ArrayList<TMapPOIItem> var2, TMapPoint var3, PointF var4);

        public boolean onPressUpEvent(ArrayList<TMapMarkerItem> var1, ArrayList<TMapPOIItem> var2, TMapPoint var3, PointF var4);
    }

    public static interface OnLongClickListenerCallback {
        public void onLongPressEvent(ArrayList<TMapMarkerItem> var1, ArrayList<TMapPOIItem> var2, TMapPoint var3);
    }

    public static enum TMapLogoPositon {
        POSITION_BOTTOMLEFT,
        POSITION_BOTTOMMIDDLE,
        POSITION_BOTTOMRIGHT;

    }
}

