/*
 * Decompiled with CFR 0.152.
 */
package com.skt.Tmap.util;

import android.util.Log;
import com.skt.Tmap.MapUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.security.SecureRandom;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class HttpConnect {
    private static final String TAG = "HttpConnect";

    public static URLConnection getDownloadFromUrl(String serverUrl) {
        URLConnection connection;
        String strUrl = serverUrl;
        try {
            StringBuilder uri;
            if (MapUtils.mIsMapOp) {
                uri = new StringBuilder();
                uri.append(serverUrl);
                uri.append("&appKey=").append(MapUtils.mApiKey);
                strUrl = uri.toString();
            } else if (MapUtils.mIsMapPickat) {
                uri = new StringBuilder();
                uri.append(serverUrl);
                uri.append("&bizAppId=").append(MapUtils.mApiKey);
                strUrl = uri.toString();
            }
            URL url = new URL(strUrl);
            connection = url.openConnection();
            connection.setConnectTimeout(35000);
            connection.setReadTimeout(35000);
            if (MapUtils.mIsMapOp) {
                connection.setRequestProperty("appKey", MapUtils.mApiKey);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            return null;
        }
        return connection;
    }

    public static Document getDocument(URLConnection con) {
        InputStream is = null;
        InputStreamReader ir = null;
        Document doc = null;
        try {
            DocumentBuilder dom = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            is = con.getInputStream();
            ir = new InputStreamReader(is);
            doc = dom.parse(new InputSource(ir));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            return null;
        }
        if (is != null) {
            MapUtils.closeStream(is);
        }
        if (ir != null) {
            MapUtils.closeStream(ir);
        }
        return doc;
    }

    public static URLConnection getDownloadFromPostUrl(String serverUrl, String contents, boolean conTypeJason) {
        HttpURLConnection con = null;
        try {
            if (MapUtils.mIsMapOp) {
                StringBuilder uri = new StringBuilder();
                uri.append(serverUrl);
                uri.append("&appKey=").append(MapUtils.mApiKey);
                con = HttpConnect.postHttps(uri.toString(), contents, conTypeJason);
            } else if (MapUtils.mIsMapPickat) {
                StringBuilder uri = new StringBuilder();
                uri.append(serverUrl);
                uri.append("&bizAppId=").append(MapUtils.mApiKey);
                con = HttpConnect.postHttps(uri.toString(), contents, conTypeJason);
            } else {
                StringBuilder uri = new StringBuilder();
                uri.append(serverUrl);
                con = HttpConnect.postHttp(uri.toString(), contents, conTypeJason);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            return null;
        }
        return con;
    }

    public static HttpURLConnection getHttp(String url) {
        HttpURLConnection http = null;
        try {
            http = (HttpURLConnection)new URL(url).openConnection();
            http.setConnectTimeout(5000);
            http.setReadTimeout(5000);
        }
        catch (MalformedURLException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
        catch (Exception e) {
            return null;
        }
        return http;
    }

    public static HttpsURLConnection getHttps(String url) {
        HttpConnect.trustAllHosts();
        HttpsURLConnection https = null;
        try {
            https = (HttpsURLConnection)new URL(url).openConnection();
            https.setConnectTimeout(5000);
            https.setReadTimeout(5000);
            https.setRequestProperty("appKey", MapUtils.mApiKey);
        }
        catch (MalformedURLException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
        catch (Exception e) {
            Log.e((String)"SKT", (String)e.toString());
            return null;
        }
        return https;
    }

    public static HttpsURLConnection postHttps(String url, String contents, boolean conTypeJason) {
        HttpConnect.trustAllHosts();
        HttpsURLConnection https = null;
        try {
            https = (HttpsURLConnection)new URL(url).openConnection();
            https.setConnectTimeout(5000);
            https.setReadTimeout(5000);
            if (conTypeJason) {
                https.setRequestProperty("Content-Type", "application/json");
            }
            https.setRequestProperty("appKey", MapUtils.mApiKey);
            https.setRequestProperty("Accept", "application/xml");
            try {
                https.setRequestMethod("POST");
            }
            catch (ProtocolException protocolException) {
                // empty catch block
            }
            https.setDoInput(true);
            https.setDoOutput(true);
            try {
                OutputStream os = https.getOutputStream();
                os.write(contents.getBytes("UTF-8"));
                os.flush();
                os.close();
            }
            catch (IOException iOException) {}
        }
        catch (MalformedURLException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
        catch (Exception e) {
            Log.e((String)"SKT", (String)e.toString());
            return null;
        }
        return https;
    }

    public static HttpURLConnection postHttp(String url, String contents, boolean conTypeJason) {
        HttpURLConnection http = null;
        try {
            http = (HttpURLConnection)new URL(url).openConnection();
            http.setConnectTimeout(5000);
            http.setReadTimeout(5000);
            if (conTypeJason) {
                http.setRequestProperty("Content-Type", "application/json");
            }
            http.setRequestProperty("Accept", "application/xml");
            try {
                http.setRequestMethod("POST");
            }
            catch (ProtocolException protocolException) {
                // empty catch block
            }
            http.setDoInput(true);
            http.setDoOutput(true);
            try {
                OutputStream os = http.getOutputStream();
                os.write(contents.getBytes("UTF-8"));
                os.flush();
                os.close();
            }
            catch (IOException iOException) {}
        }
        catch (MalformedURLException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
        catch (Exception e) {
            return null;
        }
        return http;
    }

    private static void trustAllHosts() {
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, null, new SecureRandom());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getContentFromNode(Element item, String tagName) {
        NodeList list = item.getElementsByTagName(tagName);
        if (list.getLength() > 0 && list.item(0).getFirstChild() != null) {
            return list.item(0).getFirstChild().getNodeValue();
        }
        return null;
    }
}

