package kr.co.compcareworker.Activity;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;

import kr.co.compcareworker.Data.ArrayItem_;
import kr.co.compcareworker.Data.Company.CompanyData;
import kr.co.compcareworker.Data.Login.UserItem;
import kr.co.compcareworker.Data.MainViewList.WorkerListData;
import kr.co.compcareworker.MyApplication;
import kr.co.compcareworker.R;
import kr.co.compcareworker.Util.ExceptionHandler;

public abstract class ActivityBasic extends AppCompatActivity {

    public Context context;
    public Handler handler;
    private int layout;
    private String title;

    ImageView back;
    TextView topTitle;

    public static ArrayItem_<UserItem> userItem;
    public static ArrayItem_<CompanyData> enterpriseItem;
    public static ArrayItem_<WorkerListData> workItem;
    public static int machinePosition;

    public static int isSuccess = Activity.RESULT_CANCELED;

    protected abstract void init();

    protected abstract void init_Listener();

    protected abstract void getMessage(Message msg);

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(layout);
        MyApplication.myActivity = this;
        context = this;

        setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_SENSOR_PORTRAIT);

        View view = getWindow().getDecorView();
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            if (view != null) {
                //view.setSystemUiVisibility(View.SYSTEM_UI_FLAG_LIGHT_STATUS_BAR);
                getWindow().setStatusBarColor(Color.parseColor("#3a51da"));
            }
        } else if (Build.VERSION.SDK_INT >= 21) {
            // 21 버전 이상일 때
            getWindow().setStatusBarColor(Color.BLACK);
        }

        init();
        init_Listener();
        init_Handler();
        init_default();

    }

    protected void setContentView(int layout, String title) {
        this.layout = layout;
        this.title = title;
    }


    private void init_default() {
        Thread.setDefaultUncaughtExceptionHandler(new ExceptionHandler(this));
        if (!title.equals("인트로") && !title.equals("메인화면")) {
            back = findViewById(R.id.back);
            topTitle = findViewById(R.id.title);

            topTitle.setText(title);
            back.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    if (title.equals("설치장소 정보") || title.equals("서비스일정 상세") || title.equals(("장소정보 수정")) || title.equals("머신 등록")) {
                        startActivity(new Intent(context, MainActivity.class).addFlags(Intent.FLAG_ACTIVITY_NEW_TASK));
                    } else if (title.equals("거래명세표")) {
                        setResult(isSuccess);
                    }
                    finish();
                }
            });
        }
    }

    @SuppressLint("HandlerLeak")
    protected void init_Handler() {

        handler = new Handler() {
            @Override
            public void handleMessage(Message msg) {
                super.handleMessage(msg);

                if (msg.what == -1) {
                    Toast.makeText(context, msg.obj.toString().replace("\"", ""), Toast.LENGTH_SHORT).show();

                } else if (msg.what == 1) {
                    getMessage(msg);
                }
            }
        };
    }
}
