package kr.co.compcareworker.Activity;

import android.content.Intent;
import android.os.Bundle;
import android.os.Message;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.TextView;

import androidx.fragment.app.Fragment;

import java.net.URLEncoder;

import kr.co.compcareworker.Data.Company.Machine.Product.ProductData;
import kr.co.compcareworker.Fragment.Enterprise.BusinessCard.BusinessCard_Fragment;
import kr.co.compcareworker.Fragment.Enterprise.Deal_Est_List.DealList_Fragment;
import kr.co.compcareworker.Fragment.Enterprise.Deal_Est_List.EstList_Fragment;
import kr.co.compcareworker.Fragment.Enterprise.Deal_Est_List.WebImg_Fragment;
import kr.co.compcareworker.Fragment.Enterprise.Enterprise_Fragment;
import kr.co.compcareworker.Fragment.Enterprise.ImageCheckList.ImageCheckDetail_Fragment;
import kr.co.compcareworker.Fragment.Enterprise.ImageCheckList.ImageCheck_Fragment;
import kr.co.compcareworker.Fragment.Enterprise.Memo.Memo_Fragment;
import kr.co.compcareworker.Fragment.Enterprise.ServiceList.Estimate_Fragment;
import kr.co.compcareworker.Fragment.Enterprise.ServiceList.Place_Adjust_Fragment;
import kr.co.compcareworker.Fragment.Enterprise.ServiceList.Place_Registration_Fragment;
import kr.co.compcareworker.Fragment.Enterprise.ServiceList.Service_Detail_Fragment;
import kr.co.compcareworker.Fragment.Enterprise.ServiceList.Service_Fragment;
import kr.co.compcareworker.Fragment.Enterprise.ServiceList.Service_Image_Fragment;
import kr.co.compcareworker.Fragment.Enterprise.ServiceList.Service_Register_Fragment;
import kr.co.compcareworker.Fragment.Machine.Add_Airline_Fragment;
import kr.co.compcareworker.Fragment.Machine.Add_Iot_Fragment;
import kr.co.compcareworker.Fragment.Machine.Add_Machine_Fragment;
import kr.co.compcareworker.Fragment.Machine.Add_Machine_Fragment2;
import kr.co.compcareworker.Fragment.Machine.Add_Machine_Fragment3;
import kr.co.compcareworker.Fragment.Machine.Alarm_List_Fragment;
import kr.co.compcareworker.Fragment.Machine.Code_Management_Fragment;
import kr.co.compcareworker.Fragment.Machine.Invoice_List_Fragment;
import kr.co.compcareworker.Fragment.Machine.Machine_Fragment;
import kr.co.compcareworker.Fragment.Machine.Machine_Option_Fragment;
import kr.co.compcareworker.Fragment.Machine.Monitoring_Compare_Fragment;
import kr.co.compcareworker.Fragment.Machine.Monitoring_Report_Fragment;
import kr.co.compcareworker.Fragment.Machine.ProdQR.ProdQR_Fragment;
import kr.co.compcareworker.Fragment.Main_Menu_Fragment;
import kr.co.compcareworker.Fragment.Plan.Deal_Fragment;
import kr.co.compcareworker.Fragment.Plan.Img.BeforeImg_Fragment;
import kr.co.compcareworker.Fragment.Plan.Invoice_Fragment;
import kr.co.compcareworker.Fragment.Plan.Plan_Detail_Fragment;
import kr.co.compcareworker.Fragment.Search.Search_Fragment;
import kr.co.compcareworker.MyApplication;
import kr.co.compcareworker.R;

public class FragmentActivity extends ActivityBasic {

    String Title = "";

    Fragment fragment;
    String type;
    TextView ll_act_enterprise_work_register, rightText;

    FrameLayout frame;

    @Override
    protected void init() {
        ll_act_enterprise_work_register = findViewById(R.id.ll_act_enterprise_work_register);
        rightText = findViewById(R.id.rightText);
        Intent intent = getIntent();
        frame = findViewById(R.id.frame);

        switch (type) {
            /** 검색*/
            case "search":
                fragment = new Search_Fragment(handler);
                break;
            /** 설치장소정보*/
            case "enterprise":
//                ll_act_enterprise_work_register.setVisibility(View.VISIBLE);
                fragment = new Enterprise_Fragment(handler, intent.getStringExtra("value1"));
                break;
            /** 보유기종정보*/
            case "machine":
                fragment = new Machine_Fragment(handler, intent.getStringExtra("value1"));
                break;
            /**업체 >> 보유기종 qr코드 등록*/
            case "qr":
//                fragment = new ProdQR_Fragment(handler, intent.getStringExtra("value1"), intent.getStringExtra("value2"));
                fragment = new Add_Machine_Fragment2(handler, intent.getStringExtra("value1"), intent.getStringExtra("value2"), intent.getStringExtra("value3"));
                break;
            /**업체 퀵접속*/
            case "quick":
                fragment = new ProdQR_Fragment(handler);
                break;
            /** 작업전사진*/
            case "before":
                fragment = new BeforeImg_Fragment(handler, intent.getStringExtra("value1"), intent.getStringExtra("value2"));
                break;
            /** 서비스리스트*/
            case "service":
                fragment = new Service_Fragment(handler);
                break;
            /**장소정보 수정 > enterprise*/
            case "place_adjust1":
                fragment = new Place_Adjust_Fragment(handler);
                break;
            /**장소정보 수정 > search*/
            case "place_adjust2":
                fragment = new Place_Adjust_Fragment(handler, intent.getStringExtra("value1"), intent.getStringExtra("value2"), intent.getStringExtra("value3"));
                break;
            /**장소정보 수정 > plan*/
            case "place_adjust3":
                fragment = new Place_Adjust_Fragment(handler, intent.getStringExtra("value1"), intent.getStringExtra("value2"));
                break;
            /**서비스 등록*/
            case "service_register":
                fragment = new Service_Register_Fragment(handler, intent.getStringExtra("value1"));
                break;
            /** 서비스리스트 상세*/
            case "service_detail":
                fragment = new Service_Detail_Fragment(handler, intent.getStringExtra("value1"), intent.getStringExtra("value2"), intent.getStringExtra("value3"));
                break;
            /** 메모*/
            case "memo":
                rightText.setVisibility(View.VISIBLE);
                rightText.setText("수정");
                fragment = new Memo_Fragment(handler);
                break;
            /** 작업사진 리스트*/
            case "image_check_list":
                fragment = new ImageCheck_Fragment(handler);
                break;
            /** 작업사진 상세*/
            case "image_check_detail":
                fragment = new ImageCheckDetail_Fragment(handler, intent.getStringExtra("value1"), intent.getStringExtra("value2"));
                break;
            /** 작업일정*/
            case "plan_detail":
                fragment = new Plan_Detail_Fragment(handler, intent.getStringExtra("value1"), intent.getStringExtra("value2"), intent.getStringExtra("value3"));
                break;
            /** 작업사진촬영*/
            case "shooting":
                fragment = new Plan_Detail_Fragment(handler, intent.getStringExtra("value1"), intent.getStringExtra("value2"), intent.getStringExtra("value3"));
                break;
            /** 거래명세서 보기*/
            case "deal":
                fragment = new Deal_Fragment(handler, intent.getStringExtra("value1"), intent.getStringExtra("value2"));
                break;
            /** 거래명세서 리스트*/
            case "deal_list":
                fragment = new DealList_Fragment(handler);
                break;
            /** 거래명세서 상세*/
            case "deal_list_detail":
                fragment = new WebImg_Fragment(handler, type, intent.getStringExtra("value1"));
                break;
            /** 견적서 리스트*/
            case "est_list":
                fragment = new EstList_Fragment(handler);
                break;
            /** 견적서리스트 상세*/
            case "estimate_list_detail":
                fragment = new WebImg_Fragment(handler, type, intent.getStringExtra("value1"));
                break;
            /** 메뉴*/
            case "main_menu":
                fragment = new Main_Menu_Fragment(handler, intent.getStringExtra("value1"));
                break;
            /** 명함관리*/
            case "business_card_management":
                fragment = new BusinessCard_Fragment(handler, intent.getStringExtra("value1"));
                break;
            /** 거래명세표 관리(수정,등록)*/
            case "Invoice_management":
                fragment = new Invoice_Fragment(handler, intent.getStringExtra("value1"));
                break;
            /**장소추가*/
            case "place_registration":
                fragment = new Place_Registration_Fragment(handler, intent.getStringExtra("value1"));
                break;
            /**서비스 사진*/
            case "service_image":
                fragment = new Service_Image_Fragment(handler, intent.getStringExtra("value1"), intent.getStringExtra("value2"));
                break;
            /**Air-Line 추가*/
            case "add_airline":
                fragment = new Add_Airline_Fragment(handler, intent.getStringExtra("value1"), intent.getStringExtra("value2"), intent.getStringExtra("value3"));
                break;
            /**Machine 추가*/
            case "add_machine":
                fragment = new Add_Machine_Fragment(handler, intent.getStringExtra("value1"), intent.getStringExtra("value2"),
                        intent.getStringExtra("value3"), intent.getStringExtra("value4"), intent.getStringExtra("value5"));
                break;
            /**IoT 추가*/
            case "add_iot":
                fragment = new Add_Iot_Fragment(handler, intent.getStringExtra("value1"), intent.getStringExtra("value2"),
                        intent.getStringExtra("value3"), intent.getStringExtra("value4"), intent.getStringExtra("value5"),
                        intent.getStringExtra("value6"), intent.getStringExtra("value7"), intent.getStringArrayListExtra("value8"));
                break;
            /**코드관리*/
            case "code_management":
                Intent code_intent = getIntent();
                fragment = new Code_Management_Fragment(handler, (ProductData) code_intent.getSerializableExtra("value1"));
                break;
            /**견적서 관리*/
            case "estimate_list":
                fragment = new Estimate_Fragment(handler, intent.getStringExtra("value1"), intent.getStringExtra("value2"));
                break;

            /**기계 옵션*/
            case "machine_option":
                fragment = new Machine_Option_Fragment(handler, intent.getStringExtra("value1"));
                break;

            /**업체 >> 보유기종 qr코드 등록*/
            case "add_machine2":
//                fragment = new ProdQR_Fragment(handler, intent.getStringExtra("value1"), intent.getStringExtra("value2"));
                fragment = new Add_Machine_Fragment2(handler, intent.getStringExtra("value1"));
                break;

            /**알림내역*/
            case "alarm_list":
                fragment = new Alarm_List_Fragment(handler);
                break;

                /**거래내역**/
            case "invoice_list" :
                fragment = new Invoice_List_Fragment(handler, intent.getStringExtra("value1"));
                break;

            /**업체 >> 보유기종 > qr에 업체정보 및 머신등록**/
            case "add_machine3" :
                fragment = new Add_Machine_Fragment3(handler, intent.getStringExtra("value1"), intent.getStringExtra("value2"), intent.getStringExtra("value3"));
                break;
            /**데이터분석>단일분석>주간,월간**/
            case "monitoring_report":
                fragment = new Monitoring_Report_Fragment(handler, intent.getStringExtra("value1"), intent.getStringExtra("select_type"), intent.getStringExtra("year"),
                        intent.getStringExtra("month"), intent.getStringExtra("week"), intent.getStringExtra("cp_name"), intent.getStringExtra("pt_name"));
                break;
            /**데이터분석>단일분석>기간, 일간**/
            case "monitoring_report2":
                fragment = new Monitoring_Report_Fragment(handler, intent.getStringExtra("value1"), intent.getStringExtra("select_type"), intent.getStringExtra("start_date"),
                        intent.getStringExtra("end_date"), intent.getStringExtra("cp_name"), intent.getStringExtra("pt_name"));
                break;
            /**데이터분석>다중비교**/
            case "monitoring_compare":
                fragment = new Monitoring_Compare_Fragment(handler, intent.getStringArrayListExtra("value1"), intent.getStringExtra("value2"), intent.getStringExtra("value3"));
                break;
        }

        callFragment(fragment, frame);
    }

    @Override
    protected void init_Listener() {
        ll_act_enterprise_work_register.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                String incodeUrl = URLEncoder.encode("https://" + userItem.getArrayitem().getAgency().getMbId() + ".compcare.co.kr/work/write?pt_idx=" + enterpriseItem.getArrayitem().getPtIdx() + "&cp_idx=" + enterpriseItem.getArrayitem().getCpIdx());
                Intent intent = new Intent(context, WebviewAct.class);
                intent.putExtra("title", "서비스 등록");
                intent.putExtra("url", "https://" + userItem.getArrayitem().getAgency().getMbId() + ".compcare.co.kr/api/web/" + userItem.getArrayitem().getMbId() + "/?url=" + incodeUrl);
                startActivity(intent);
            }
        });

        rightText.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Memo_Fragment memo = (Memo_Fragment) getSupportFragmentManager().findFragmentById(R.id.frame);
                memo.Modify_Memo(rightText.getText().toString());
            }
        });
    }

    @Override
    protected void getMessage(Message msg) {

    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        Intent intent = getIntent();
        Title = intent.getStringExtra("title");
        type = intent.getStringExtra("type");
        setContentView(R.layout.activity_fragment, Title);
        MyApplication.myActivity = this;
        super.onCreate(savedInstanceState);
    }

    void callFragment(Fragment fragment, FrameLayout frame) {

        getSupportFragmentManager()
                .beginTransaction()
                .replace(frame.getId(), fragment)
                .commit();

    }

    public void Set_Text() {
        if (rightText.getText().toString().equals("수정")) {
            rightText.setText("완료");
        } else {
            rightText.setText("수정");
        }
    }

    @Override
    public void onBackPressed() {
        if (type.equals("enterprise") || type.equals("plan_detail") || type.equals("place_adjust2") || type.equals("add_machine3")) {
            startActivity(new Intent(context, MainActivity.class).addFlags(Intent.FLAG_ACTIVITY_NEW_TASK));
            finish();
            return;
        }
        super.onBackPressed();
    }
}
