package kr.co.compcareworker.Activity;

import android.app.NotificationManager;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.TextView;

import androidx.appcompat.app.AppCompatActivity;

import kr.co.compcareworker.MyApplication;
import kr.co.compcareworker.R;
import kr.co.compcareworker.Util.Firebase.MyFirebaseMessagingService;

public class PopupActivity extends AppCompatActivity {
    String type, message;

    TextView contents;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_popup);
        MyApplication.myActivity = this;
        contents = findViewById(R.id.contents);

        Intent i = getIntent();
        type = i.getStringExtra("type");
        message = i.getStringExtra("message");

        contents.setText(message);

        // 이 부분이 바로 화면을 깨우는 부분 되시겠다.
        // 화면이 잠겨있을 때 보여주기
        getWindow().addFlags(WindowManager.LayoutParams.FLAG_SHOW_WHEN_LOCKED
                // 키잠금 해제하기
                | WindowManager.LayoutParams.FLAG_DISMISS_KEYGUARD
                // 화면 켜기
                | WindowManager.LayoutParams.FLAG_TURN_SCREEN_ON);
        Button ok = findViewById(R.id.ok);

        MyApplication application = (MyApplication) getApplication();

        ok.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                if (i.getBooleanExtra("isMain", true)) {
                    finish();
                    if (MyFirebaseMessagingService.activity != null) MyFirebaseMessagingService.activity.refresh();
                    else if (MyFirebaseMessagingService.alarmListFragment != null) MyFirebaseMessagingService.alarmListFragment.refresh();

                } else {
                    startActivity(new Intent(PopupActivity.this, Intro.class).addFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TOP));
                    finishAffinity();
                }
            }
        });
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        NotificationManager notifiyMgr = (NotificationManager) getSystemService(Context.NOTIFICATION_SERVICE);
        notifiyMgr.cancelAll();
    }
}
