package kr.co.compcareworker.Fragment.Machine;

import android.annotation.SuppressLint;
import android.app.AlertDialog;
import android.app.DatePickerDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.Log;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.DatePicker;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.request.RequestOptions;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;

import java.security.cert.LDAPCertStoreParameters;
import java.util.ArrayList;
import java.util.HashMap;

import gun0912.tedimagepicker.builder.TedImagePicker;
import kr.co.compcareworker.Activity.FragmentActivity;
import kr.co.compcareworker.Data.ArrayItem;
import kr.co.compcareworker.Data.Company.Machine.Product.ProductData;
import kr.co.compcareworker.Data.Lately.LatelyData;
import kr.co.compcareworker.R;
import kr.co.compcareworker.Util.Adapter.LatelyRecyclerAdapter;
import kr.co.compcareworker.Util.Adapter.PlanImageRecyclerAdapter;
import kr.co.compcareworker.Util.Api.ApiClient;
import kr.co.compcareworker.Util.Common;
import kr.co.compcareworker.Util.CustomView.AddAirLineDialog;
import kr.co.compcareworker.Util.CustomView.AddProductDialog;
import kr.co.compcareworker.Util.CustomView.SearchMachineDialog;
import kr.co.compcareworker.Util.MyOnItemClick;

@SuppressLint("ValidFragment")
public class Add_Machine_Fragment2 extends Fragment implements LatelyRecyclerAdapter.OnLoadMoreListener, MyOnItemClick {

    Handler handler;
    FragmentActivity fa;

    TextView add_machine_pt_nameTV, add_machine_pt_ceoTV, add_machine_pt_codeTV, add_machine_cp_addrTV, add_machine_cp_addr_subTV,
            add_machine_add_lineTV, add_machine_add_productTV, add_machine_product_codeTV, add_machine_product_nameTV,
            add_machine_product_specTV, add_machine_make_dateTV, add_machine_saveTV, add_machine_product_typeTV, add_machine_cp_nameTV, add_machine_lotET;
    Spinner add_machine_select_lineSN, add_machine_product_typeSN;
    ImageView add_machine_search_productIV, add_machine_search_companyIV;
    EditText add_machine_running_totalET, add_machine_remain_timeET, add_machine_search_productET, add_machine_search_companyET;
    LinearLayout add_machine_add_photoLL, airlineLL, machineLL, company_infoLL, search_company_listLL;
    RecyclerView add_machine_photoRV;
    String ag_idx, pt_idx, cp_idx, air_line_str, airline, qr_code, mac, mc_ttype;
    String[] air_line_array, product_array;
    ArrayAdapter<String> place_adapter, air_line_adapter, product_adapter;
    ArrayItem<LatelyData> companyItems;
    ProductData productData;
    int select_position = 0;
    int air_position = 0;
    boolean add_iot = false;
    ArrayItem<ProductData> product_items;
    String product;
    RecyclerView search_company_listRV;
    LatelyRecyclerAdapter company_list_adapter;
    ArrayList<LatelyData> search_company_items;
    PlanImageRecyclerAdapter photo_adapter;
    private ArrayList<String> arr = new ArrayList<>();
    private DatePickerDialog.OnDateSetListener callbackMethod;
    int lastIndex, count, limitCount;

    @SuppressLint("ValidFragment")
    public Add_Machine_Fragment2(Handler handler, String ag_idx, String pt_idx, String cp_idx) {
        this.handler = handler;
        this.ag_idx = ag_idx;
        this.pt_idx = pt_idx;
        this.cp_idx = cp_idx;
    }

    @SuppressLint("ValidFragment")
    public Add_Machine_Fragment2(Handler handler, String ag_idx) {
        this.handler = handler;
        this.ag_idx = ag_idx;
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        fa = (FragmentActivity) getActivity();
    }

    @Override
    public void onDetach() {
        super.onDetach();
        fa = null;
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View v = inflater.inflate(R.layout.frag_add_machine2, container, false);

        add_machine_pt_nameTV = v.findViewById(R.id.add_machine_pt_nameTV);
        add_machine_pt_ceoTV = v.findViewById(R.id.add_machine_pt_ceoTV);
        add_machine_pt_codeTV = v.findViewById(R.id.add_machine_pt_codeTV);
        add_machine_cp_addrTV = v.findViewById(R.id.add_machine_cp_addrTV);
        add_machine_cp_addr_subTV = v.findViewById(R.id.add_machine_cp_addr_subTV);
        add_machine_add_lineTV = v.findViewById(R.id.add_machine_add_lineTV);
        add_machine_select_lineSN = v.findViewById(R.id.add_machine_select_lineSN);
        add_machine_add_productTV = v.findViewById(R.id.add_machine_add_productTV);
        add_machine_search_productET = v.findViewById(R.id.add_machine_search_productET);
        add_machine_search_productIV = v.findViewById(R.id.add_machine_search_productIV);
        add_machine_product_typeSN = v.findViewById(R.id.add_machine_product_typeSN);
        add_machine_product_codeTV = v.findViewById(R.id.add_machine_product_codeTV);
        add_machine_product_nameTV = v.findViewById(R.id.add_machine_product_nameTV);
        add_machine_product_specTV = v.findViewById(R.id.add_machine_product_specTV);
        add_machine_running_totalET = v.findViewById(R.id.add_machine_running_totalET);
        add_machine_remain_timeET = v.findViewById(R.id.add_machine_remain_timeET);
        add_machine_add_photoLL = v.findViewById(R.id.add_machine_add_photoLL);
        add_machine_photoRV = v.findViewById(R.id.add_machine_photoRV);
        add_machine_saveTV = v.findViewById(R.id.add_machine_saveTV);
        add_machine_product_typeTV = v.findViewById(R.id.add_machine_product_typeTV);
        add_machine_cp_nameTV = v.findViewById(R.id.add_machine_cp_nameTV);
        add_machine_lotET = v.findViewById(R.id.add_machine_lotET);
        add_machine_search_companyET = v.findViewById(R.id.add_machine_search_companyET);
        add_machine_search_companyIV = v.findViewById(R.id.add_machine_search_companyIV);
        airlineLL = v.findViewById(R.id.airlineLL);
        machineLL = v.findViewById(R.id.machineLL);
        company_infoLL = v.findViewById(R.id.company_infoLL);
        search_company_listRV = v.findViewById(R.id.search_company_listRV);
        search_company_listLL = v.findViewById(R.id.search_company_listLL);

        int px = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, 6f, getContext().getResources().getDisplayMetrics());
        int itemHeight = (Common.getInstance().getWidth(getActivity())) - (add_machine_photoRV.getPaddingLeft() + add_machine_photoRV.getPaddingRight() - px * 2) / 3;

        add_machine_photoRV.setLayoutManager(new GridLayoutManager(getContext(), 3));
        photo_adapter = new PlanImageRecyclerAdapter(getContext(), itemHeight);
        add_machine_photoRV.setAdapter(photo_adapter);

        init_Listener();
        init_Handler();
//        Get_partner();

        company_list_adapter = new LatelyRecyclerAdapter(getContext(), handler, this::onLoadMore, this::onClick);
        search_company_listRV.setAdapter(company_list_adapter);

        return v;
    }

    @Override
    public void onLoadMore() {

        company_list_adapter.setProgressMore(true);
        new Handler().postDelayed(new Runnable() {
            @Override
            public void run() {
                company_list_adapter.setProgressMore(false);

                if (count == limitCount) {
                    lastIndex += 20;
                    Get_partner();
                }
            }
        }, 500);
    }

    void Get_partner() {
        HashMap<String, String> data = new HashMap<>();
        data.put("ag_idx", fa.userItem.getArrayitem().getAgIdx());
        data.put("words", add_machine_search_companyET.getText().toString());
        data.put("per_page", limitCount + "");
        data.put("offset", lastIndex + "");
        new ApiClient(data, "proc_company_search", handler);
    }


    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);

        photo_adapter.setOnItemClickListener(new PlanImageRecyclerAdapter.OnItemClickListener() {
            @Override
            public void onItemClick(View v, int position) {
                photo_adapter.removeItem(position);
                arr.remove(position);
            }
        });
    }


    @Override
    public void onClick(Bundle value) {

        Log.d("정우야@@@@", value.toString());

        cp_idx = value.getString("cp_idx");
        pt_idx = value.getString("pt_idx");

        add_machine_search_companyET.clearFocus();
        company_list_adapter.clearItem();
        search_company_listLL.setVisibility(View.GONE);
        airlineLL.setVisibility(View.VISIBLE);
        machineLL.setVisibility(View.VISIBLE);
        company_infoLL.setVisibility(View.VISIBLE);
        add_machine_saveTV.setVisibility(View.VISIBLE);

        add_machine_pt_nameTV.setText(value.getString("pt_name"));
        add_machine_pt_ceoTV.setText(value.getString("pt_ceo"));
        add_machine_pt_codeTV.setText(value.getString("pt_code"));
        add_machine_cp_nameTV.setText(value.getString("cp_name"));
        add_machine_cp_addrTV.setText(value.getString("cp_addr"));
        add_machine_cp_addr_subTV.setText(value.getString("cp_addr_sub"));


        //에어라인 스피너 초기화
        air_line_adapter = new ArrayAdapter<>(getContext(), android.R.layout.simple_spinner_dropdown_item);

        if (value.getString("cp_airline") == null) {
            air_line_str = "기본값";

        } else {
            air_line_str = value.getString("cp_airline");
        }

        air_line_array = air_line_str.split(",");
        for (String s : air_line_array) {
            air_line_adapter.add(s);
        }
        add_machine_select_lineSN.setAdapter(air_line_adapter);
        add_machine_select_lineSN.setSelection(air_position);

        //기종추가 스피너 초기화
        product_adapter = new ArrayAdapter<>(getContext(), android.R.layout.simple_spinner_dropdown_item);

        product_array = new String[]{"Compressor", "Tank", "After Cooler", "Dryer", "Filter", "흡착식", "OIL MIST SEPERATOR", "AUTO TRAP"};
        for (String s : product_array) {
            product_adapter.add(s);
        }
        add_machine_product_typeSN.setAdapter(product_adapter);
    }

    void init_Listener() {

        add_machine_search_companyET.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int c) {

                search_company_listLL.setVisibility(View.VISIBLE);

                if (add_machine_search_companyET.length() > 1) {
                    lastIndex = 0;
                    count = 0;
                    Get_partner();

                } else {
                    search_company_listLL.setVisibility(View.GONE);
                    company_list_adapter.clearItem();
                    company_list_adapter.setMoreLoading(true);
                }

            }

            @Override
            public void afterTextChanged(Editable s) {

            }
        });

        add_machine_search_companyIV.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                lastIndex = 0;
                count = 0;
                Get_partner();
            }
        });

        //선택한 Air_Line
        add_machine_select_lineSN.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
                airline = add_machine_select_lineSN.getSelectedItem().toString();
            }

            @Override
            public void onNothingSelected(AdapterView<?> parent) {
            }
        });

        //라인추가 클릭 리스너
        add_machine_add_lineTV.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                AddAirLineDialog dialog = new AddAirLineDialog(getContext(), handler, cp_idx, air_line_array, new AddAirLineDialog.clickListener() {
                    @Override
                    public void clickBtn(HashMap<String, String> data) {
                        air_position = Integer.parseInt(data.get("air_position"));
                        Get_partner();
                    }
                });
                dialog.show();
            }
        });

        //기종검색 클릭 리스너
        add_machine_search_productIV.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                product = add_machine_search_productET.getText().toString();

                if (TextUtils.isEmpty(product)) {
                    Common.getInstance().toastShow(getContext(), "찾는 기종명을 입력해주세요.");
                    return;
                }

                HashMap<String, String> data = new HashMap<>();
                data.put("ag_idx", ag_idx);
                data.put("pd_name", product);
                data.put("type", "COMPANY");
                new ApiClient(data, "proc_admin_search_machine", handler);

            }
        });

        callbackMethod = new DatePickerDialog.OnDateSetListener() {
            @Override
            public void onDateSet(DatePicker view, int year, int monthOfYear, int dayOfMonth) {

                int month = monthOfYear + 1;
                String con_month = month + "";
                if (month < 10) {
                    con_month = "0" + con_month;
                }

                String con_day = dayOfMonth + "";
                if (dayOfMonth < 10) {
                    con_day = "0" + con_day;
                }
                add_machine_make_dateTV.setText(year + "-" + con_month + "-" + con_day);
            }
        };

        //기종추가 클릭 리스너
        add_machine_add_productTV.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                AddProductDialog dialog = new AddProductDialog(getContext(), handler, ag_idx, new AddProductDialog.clickListener() {
                    @Override
                    public void clickBtn(HashMap<String, ProductData> data) {
                        productData = data.get("product_data");

                        add_machine_product_typeSN.setVisibility(View.GONE);
                        add_machine_product_typeTV.setVisibility(View.VISIBLE);

                        switch (productData.getPdTtype()) {
                            case "COMP":
                                mc_ttype = "COMP";
                                add_machine_product_typeTV.setText("Compressor");
                                break;
                            case "TANK":
                                mc_ttype = "TANK";
                                add_machine_product_typeTV.setText("Tank");
                                break;
                            case "COOLER":
                                mc_ttype = "COOLER";
                                add_machine_product_typeTV.setText("After Cooler");
                                break;
                            case "DRYER":
                                mc_ttype = "DRYER";
                                add_machine_product_typeTV.setText("Dryer");
                                break;
                            case "FILTER":
                                mc_ttype = "FILTER";
                                add_machine_product_typeTV.setText("Filter");
                                break;
                            case "SUCTION":
                                mc_ttype = "SUCTION";
                                add_machine_product_typeTV.setText("흡착식");
                                break;
                            case "MIST":
                                mc_ttype = "MIST";
                                add_machine_product_typeTV.setText("OIL MIST SEPERATOR");
                                break;
                            case "TRAP":
                                mc_ttype = "TRAP";
                                add_machine_product_typeTV.setText("AUTO TRAP");
                                break;
                            default:
                                mc_ttype = null;
                                add_machine_product_typeSN.setVisibility(View.VISIBLE);
                                add_machine_product_typeTV.setVisibility(View.GONE);
                        }
                        add_machine_product_codeTV.setText(productData.getPdCode());
                        add_machine_product_nameTV.setText(productData.getPdShortName());
                        add_machine_product_specTV.setText(productData.getPdSpec());

                    }
                });
                dialog.show();
            }
        });

        //기종사진 추가 클릭 리스너
        add_machine_add_photoLL.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                int selectSize = photo_adapter.getItemCount();
                if (selectSize < 3) {
                    TedImagePicker.with(requireContext())
                            .startMultiImage(uriList -> {
                                for (int i = 0; i < uriList.size(); i++) {
                                    arr.add(uriList.get(i).toString());
                                }
                                photo_adapter.addItem(arr);
                            });

//                    TedBottomPicker tedBottomPicker = new TedBottomPicker.Builder(getContext()).setImageProvider(new TedBottomPicker.ImageProvider() {
//                        @Override
//                        public void onProvideImage(ImageView imageView, Uri imageUri) {
//                            Glide.with(getContext()).load(imageUri).apply(RequestOptions.centerCropTransform()).into(imageView);
//                        }
//                    }).setOnMultiImageSelectedListener(new TedBottomPicker.OnMultiImageSelectedListener() {
//                        @Override
//                        public void onImagesSelected(ArrayList<Uri> uriList) {
//
//                            for (int i = 0; i < uriList.size(); i++) {
//                                arr.add(uriList.get(i).toString());
//                            }
//                            photo_adapter.addItem(arr);
//                        }
//                    })
//                            .setCompleteButtonText("저장")
//                            .setPeekHeight(2400)
//                            .setPreviewMaxCount(1000).setSelectMaxCount(3 - selectSize).create();
//                    tedBottomPicker.show(getActivity().getSupportFragmentManager());

                } else {

                    AlertDialog.Builder dialogBuilder = new AlertDialog.Builder(getContext());
                    dialogBuilder.setTitle("콤프케어 작업자");
                    dialogBuilder.setMessage("사진은 최대 3장까지 등록가능합니다.");
                    dialogBuilder.setPositiveButton("확인", new DialogInterface.OnClickListener() {
                        @Override
                        public void onClick(DialogInterface dialog, int i) {
                            dialog.dismiss();
                        }
                    });
                    dialogBuilder.show();
                }

            }
        });

        //선택한 제품 구분
        add_machine_product_typeSN.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
                switch (add_machine_product_typeSN.getSelectedItem().toString()) {
                    case "Compressor":
                        mc_ttype = "COMP";
                        break;
                    case "Tank":
                        mc_ttype = "TANK";
                        break;
                    case "After Cooler":
                        mc_ttype = "COOLER";
                        break;
                    case "Dryer":
                        mc_ttype = "DRYER";
                        break;
                    case "Filter":
                        mc_ttype = "FILTER";
                        break;
                    case "흡착식":
                        mc_ttype = "SUCTION";
                        break;
                    case "OIL MIST SEPERATOR":
                        mc_ttype = "MIST";
                        break;
                    case "AUTO TRAP":
                        mc_ttype = "TRAP";
                        break;
                }
            }

            @Override
            public void onNothingSelected(AdapterView<?> parent) {

            }
        });

        //저장버튼 클릭 리스너
        add_machine_saveTV.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                String mc_runningtime_total = add_machine_running_totalET.getText().toString();
                String mc_cycle = add_machine_remain_timeET.getText().toString();
                String product_name = add_machine_product_nameTV.getText().toString();
                String mc_lot = add_machine_lotET.getText().toString();

                if (TextUtils.isEmpty(product_name)) {
                    Common.getInstance().toastShow(getContext(), "등록할 기종을 검색 또는 추가해주세요.");
                    return;
                }

                if (TextUtils.isEmpty(mc_cycle)) {
                    Common.getInstance().toastShow(getContext(), "기기 사용 만료시간을 입력해주세요.");
                    return;
                }

                if (TextUtils.isEmpty(mc_runningtime_total)) {
                    Common.getInstance().toastShow(getContext(), "기기 현재 사용시간을 입력해주세요.");
                    return;
                }

                HashMap<String, String> data = new HashMap<>();
                data.put("ag_idx", ag_idx);
                data.put("pt_idx", pt_idx);
                data.put("cp_idx", cp_idx);
                data.put("pd_idx", productData.getPdIdx());
                data.put("mc_airline", airline);
                data.put("mc_ttype", mc_ttype);
                data.put("mb_id", fa.userItem.getArrayitem().getMbId());
                data.put("mb_token", Common.getInstance().getPref(getContext(), "token"));

                if (!TextUtils.isEmpty(mc_lot) || !mc_lot.equals("")) {
                    data.put("mc_lot", mc_lot);
                }

                data.put("mc_runningtime_total", mc_runningtime_total);
                data.put("mc_cycle", mc_cycle + "");

                ArrayList<Uri> photo_uri = new ArrayList<>();
                for (int i = 0; i < arr.size(); i++) {
                    photo_uri.add(Uri.parse(arr.get(i)));
                }

                if (photo_uri.size() > 0) {
                    new ApiClient(data, "proc_machine_insert", photo_uri, handler);
                } else {
                    new ApiClient(data, "proc_machine_insert", handler);
                }
            }
        });
    }

    void init_Handler() {
        handler = new Handler() {
            @Override
            public void handleMessage(Message msg) {
                super.handleMessage(msg);
                if (msg.what == 1) {
                    String url = msg.getData().getString("url");

                    if (url.equals("proc_company_search")) {
                        JsonElement element = new JsonParser().parse(msg.obj.toString());
                        JsonObject result_item = element.getAsJsonObject();
                        companyItems = new Gson().fromJson(result_item, new TypeToken<ArrayItem<LatelyData>>() {
                        }.getType());

                        search_company_items = new ArrayList<>();
                        if (companyItems.isSuccess()) {
                            search_company_listLL.setVisibility(View.VISIBLE);
                            search_company_items.addAll(companyItems.getArrayitem());
                            count = companyItems.size();
                            if (lastIndex == 0) {
                                company_list_adapter.addAll(search_company_items);
                            } else {
                                company_list_adapter.addItemMore(search_company_items);
                            }

                            company_list_adapter.setMoreLoading(false);
                        } else {
                            company_list_adapter.setMoreLoading(true);
                        }

                    } else if (url.equals("proc_machine_insert")) {
                        JsonElement element = new JsonParser().parse(msg.obj.toString());
                        JsonObject result_item = element.getAsJsonObject();

                        if (result_item.get("resultItem").getAsJsonObject().get("result").getAsString().equals("Y")) {
                            Toast.makeText(getContext(), result_item.get("resultItem").getAsJsonObject().get("message").getAsString(), Toast.LENGTH_SHORT).show();
                            getActivity().finish();

                        } else {
                            Toast.makeText(getContext(), result_item.get("resultItem").getAsJsonObject().get("message").getAsString(), Toast.LENGTH_SHORT).show();
                        }

                    } else if (url.equals("proc_admin_search_machine")) {
                        JsonElement element = new JsonParser().parse(msg.obj.toString());
                        JsonObject result_item = element.getAsJsonObject();
                        product_items = new Gson().fromJson(result_item, new TypeToken<ArrayItem<ProductData>>() {
                        }.getType());

                        if (product_items.isSuccess()) {

                            //ag_idx, pd_name
                            SearchMachineDialog dialog = new SearchMachineDialog(getContext(), handler, ag_idx, product, product_items, new SearchMachineDialog.clickListener() {
                                @Override
                                public void clickBtn(HashMap<String, ProductData> data) {
                                    productData = data.get("productData");
                                    add_machine_product_codeTV.setText(productData.getPdCode());
                                    add_machine_product_nameTV.setText(productData.getPdShortName());
                                    add_machine_product_specTV.setText(productData.getPdSpec());
                                    add_machine_search_productET.setText(productData.getPdShortName());

                                    if (productData.getPdTtype() == null) {
                                        add_machine_product_typeSN.setVisibility(View.VISIBLE);
                                        add_machine_product_typeTV.setVisibility(View.GONE);

                                    } else {
                                        add_machine_product_typeSN.setVisibility(View.GONE);
                                        add_machine_product_typeTV.setVisibility(View.VISIBLE);

                                        switch (productData.getPdTtype()) {
                                            case "COMP":
                                                mc_ttype = "COMP";
                                                add_machine_product_typeTV.setText("Compressor");
                                                break;
                                            case "TANK":
                                                mc_ttype = "TANK";
                                                add_machine_product_typeTV.setText("Tank");
                                                break;
                                            case "COOLER":
                                                mc_ttype = "COOLER";
                                                add_machine_product_typeTV.setText("After Cooler");
                                                break;
                                            case "DRYER":
                                                mc_ttype = "DRYER";
                                                add_machine_product_typeTV.setText("Dryer");
                                                break;
                                            case "FILTER":
                                                mc_ttype = "FILTER";
                                                add_machine_product_typeTV.setText("Filter");
                                                break;
                                            case "SUCTION":
                                                mc_ttype = "SUCTION";
                                                add_machine_product_typeTV.setText("흡착식");
                                                break;
                                            case "MIST":
                                                mc_ttype = "MIST";
                                                add_machine_product_typeTV.setText("OIL MIST SEPERATOR");
                                                break;
                                            case "TRAP":
                                                mc_ttype = "TRAP";
                                                add_machine_product_typeTV.setText("AUTO TRAP");
                                                break;
                                            default:
                                                mc_ttype = null;
                                                add_machine_product_typeSN.setVisibility(View.VISIBLE);
                                                add_machine_product_typeTV.setVisibility(View.GONE);
                                        }
                                    }
                                }
                            });
                            dialog.show();

                        } else {
                            Common.getInstance().toastShow(getContext(), "일치하는 기종이 없습니다.");
                        }

                    }
                } else if (msg.what == -1) {
                    Toast.makeText(getContext(), msg.obj.toString(), Toast.LENGTH_SHORT).show();
                }
            }
        };
    }

}