package kr.co.compcareworker.Util.Adapter;

import android.content.Context;
import android.os.Handler;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import java.util.ArrayList;

import kr.co.compcareworker.Data.Company.Machine.MachineItem;
import kr.co.compcareworker.R;
import kr.co.compcareworker.Util.Common;

public class DlgMonitoringReportCompareAdapter extends RecyclerView.Adapter<DlgMonitoringReportCompareAdapter.ItemViewHolder> {

    Context context;
    Handler handler;
    int cnt = 0;

    private ArrayList<MachineItem> items = new ArrayList<>();

    private DlgMonitoringReportCompareAdapter.checkClickListener checkClickListener;

    public interface checkClickListener {
        void clickBtn(String mac, boolean is_checked);
    }

    public DlgMonitoringReportCompareAdapter(@NonNull Context context, DlgMonitoringReportCompareAdapter.checkClickListener checkClickListener) {
        this.context = context;
        this.checkClickListener = checkClickListener;
    }

    @NonNull
    @Override
    public ItemViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int position) {
        View v = LayoutInflater.from(viewGroup.getContext()).inflate(R.layout.item_dlg_monitoring_report_compare_list, viewGroup, false);

        return new ItemViewHolder(v);
    }

    @Override
    public void onBindViewHolder(@NonNull ItemViewHolder itemViewHolder, int position) {
        itemViewHolder.onBind(items.get(position));

        itemViewHolder.compare_checkCB.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if (itemViewHolder.compare_checkCB.isChecked()) {
                    if (cnt > 1) {
                        Common.getInstance().toastShow(context, "비교할 대상은 최대 2대까지 선택 할 수 있습니다.");
                        itemViewHolder.compare_checkCB.setChecked(false);
                        return;
                    }
                    checkClickListener.clickBtn(items.get(position).getMcIdx(), true);
                    cnt++;
                } else {
                    checkClickListener.clickBtn(items.get(position).getMcIdx(), false);
                    cnt--;
                }
            }
        });
    }

    @Override
    public int getItemViewType(int position) {
        return position;
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public int getItemCount() {
        return items.size();
    }

    public void addItem(ArrayList<MachineItem> data) {

        // 외부에서 item을 추가시킬 함수입니다.
        items.clear();
        items.addAll(data);
        notifyDataSetChanged();
    }

    public void clearItem() {
        items.clear();
        notifyDataSetChanged();
    }

    public static class ItemViewHolder extends RecyclerView.ViewHolder {

        TextView compare_cp_nameTV, compare_mc_airlineTV, compare_mc_lotTV, compare_mc_iot_macTV, compare_mc_nameTV;
        CheckBox compare_checkCB;

        ItemViewHolder(@NonNull View itemView) {
            super(itemView);

            compare_cp_nameTV = itemView.findViewById(R.id.compare_cp_nameTV);
            compare_mc_airlineTV = itemView.findViewById(R.id.compare_mc_airlineTV);
            compare_mc_lotTV = itemView.findViewById(R.id.compare_mc_lotTV);
            compare_mc_iot_macTV = itemView.findViewById(R.id.compare_mc_iot_macTV);
            compare_mc_nameTV = itemView.findViewById(R.id.compare_mc_nameTV);
            compare_checkCB = itemView.findViewById(R.id.compare_checkCB);
        }

        void onBind(MachineItem data) {

            compare_cp_nameTV.setText(data.getCpName());
            compare_mc_airlineTV.setText(data.getMcAirline());
            if (!TextUtils.isEmpty(data.getMcLot())) {
                compare_mc_lotTV.setText("제품번호 ( " + data.getMcLot() + " )");
            }
            if (!TextUtils.isEmpty(data.getMcIotMac())) {
                compare_mc_iot_macTV.setText("MAC ( " + data.getMcIotMac() + " )");
            }
            compare_mc_nameTV.setText(data.getPdName());

        }
    }
}
